
package jcm.core;

/*
 P3 popup error message seems to crash if called from setup!
 P2 Report dialog could have options: Details, Continue, Reset, Quit
P2 Report text improvements
Sometimes don't want all the log clogging up the error?
Could use html to distinguish types by color?
Could be useful if log/deb etc would recall the calling class
 */


import java.awt.Dimension;
import java.io.*;
import javax.swing.*;
import javax.swing.text.*;
import java.lang.reflect.*;
import jcm.core.par.param;

public class report extends JScrollPane {
    
    
    static JTextArea ta= new JTextArea();
    static StringBuffer sb=new StringBuffer("JCM Event Log:\n\n");
    
    static PrintStream orig=System.out;
    
    //log ps writes both to original and to the textarea
    static PrintStream logps = new PrintStream(new OutputStream() {	public void write(int b) {
	orig.write(b);
	//sb.append((char)b); //removed temporarily due to problems with script - also makes it terribly slow!
	//very inefficient - should use some kind of flushing mechanism!
	if (ta.isShowing()) { ta.append(new String(new char[]{	(char)	b})); }
    }}, true);
    
    
    static String secprob="\nCannot Capture System.out/err due to WebStart Security Restrictions\n ";
    
    public static void start() {
	try {     System.setOut(logps); } catch (SecurityException e) { log(secprob); }
//	 ep.setContentType("text/html;");
    }
    
    public static param debugmode=new param("Log Detail", false) { public void precalc() {
	try {     System.setErr(istrue() ? logps : orig); } catch (SecurityException e) { log(secprob); }
    }  };
    
    
    //*****************************************************
    //constructor
    public report() {
	setName("JCM Event Log");
	setViewportView(ta);
	Caret c=ta.getCaret(); ((DefaultCaret) c).setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
	setPreferredSize(new Dimension(300,400));
	getVerticalScrollBar().setValue(getVerticalScrollBar().getMaximum());
    }
    
    public void addNotify() { 	ta.setText(sb.toString()); super.addNotify();    }
    
    //************** REPORT PROBLEMS **************
    //                                                                                 LOG  DIA LINE
    //use msg when a dialog should always pop up
    public static void msg(String s) { report(null, s, true, true); }
    public static void msg(Exception e, String s) { report(e, s, false, true); }
    //use log for important output
    public static void logn(String s) { report(null, "\n"+s, true, false); }
    public static void log(String s) { report(null, s, true, false); }
    public static void log(Throwable e) { report(e, null, true, false); } 
    public static void log(Throwable e, String s) { report(e, s, true, false); } 
    //use for most debugging info, can always use debug mode to see within log
    public static void deb(Object o) { report(null, o.toString(),  false, false); }
    public static void deb(String s) { report(null, s,  false, false); }
    public static void deb(Throwable e) { report(e, null,  false, false); }
    public static void deb(Throwable e, String s) { report(e, s,  false, false); }
    
    public static void report(Throwable e, String s, boolean log, boolean dia) {
	
	log |=debugmode.istrue();
        log &=(logps!=orig); //so that only use one stream
	
	if (s!=null) {
	    s=(s.startsWith("-") ? "\t" : "\n") +s;
	    if (log) logps.print(s);
	    else orig.print(s);
	}
	if (e!=null) {
	    // use original e.printStackTrace in order to get the hyperlinks in netbeans
	    if (log) { logps.println("\n!\t"+e); e.printStackTrace(); } else orig.println("\n!\t"+e);
	}
	if (dia) {
	    String title= (s!=null ? s : "JCM Error Message"), message=(e!=null ? ""+e  : "");
	    if (e!=null && debugmode.istrue()) {
		for (StackTraceElement ss : e.getStackTrace()) message+="\n at  "+ss.toString();
	    }
            try {
	    JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
            } catch (Exception e2) { logps.print(message); e2.printStackTrace(); }
	}
	logps.flush();
	orig.flush();
    }
    
} // end class