 /*
module: superclass of all the main science calculation modules
 * belongs to a world, has a reference to it and other modules, will be recopied in a parallel world)
 * is an owner of params and qtsets
 * has loop methods (extends loopcalc - may also contain other loopcalcs)
 * key node of the interface tree / map
 * discovers what it contains and sets up interactions between above  
  */



package jcm.core.ob;

import jcm.core.ob.loopcalc;
import java.util.*;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curveset;

import jcm.core.itf.dataholder;
import jcm.gui.doc.autodoc;
import static jcm.core.report.*;
import jcm.core.tls.ref;
import jcm.gui.nav.filter;

public class module extends loopcalc {    
    
    //*********** FIELDS ***********
    public world world;
    public Vector<curveset> curvesets = new Vector();
    public Vector<param> allparam = new Vector(); //not used much - maybe should remove it? 

   
    //******************* GET MOD  ************
    //refer to other modules
    public <T extends module> T gm(Class<T> c) {
        return world.gm(c);
    }

    //****************** AFFECTS / FOLLOWS *************
    // shortcut extensions of interacob and  loopcalc that make use of the world
    public void follows(Class c) {
        follows(gm(c), true);
    }

    public void follows(Class c, boolean b) {
        follows(gm(c), b);
    }

    public void setaffectedby(Class c) {
        setaffectedby(gm(c));
    }

    public void setaffectedby(Class c, boolean b) {
        setaffectedby(gm(c), b);
    }


    //****************************
    //INITSETUP & REGISTER
    //world first creates all modules, then for each one calls first initsetup then register
    public void initsetup() {
    }

    public void register() {   registerobs(false); } 
    public void registerobs(boolean incprivate) {     //extends interacob register to find fields of qtsets, params etc.
        super.register();
        ref.getAnnotations(this);
 
        if (mycomplexity == null) mincomplexity();

        addAction(filter.filtertype.Doc);
        addAction(filter.filtertype.interacmap);
        addAction(filter.filtertype.Tree);
        addAction(filter.filtertype.Source);
        
        LinkedHashSet s = jcm.core.tls.ref.getallobs(this, incprivate);          
        linkobs(s);
    }
    
    public void linkobs(Set  s) {
    	for (Object o : s) {
            if (o instanceof infob) ((infob) o).owner = this;
            //if (o instanceof infob) deb ("reg: "+((infob) o).owner+ ":\t " +((infob) o).name+ ": \t priority="+((infob) o).priority);
            if (o instanceof interacob && o != this) {
                ((interacob) o).register();                 //note: params and qtsets now automatically register themselves within constructor => this is redundant?
                addOb((infob) o);
            }
            //most curvesets are affected by their module, but do not affect it
            if (o instanceof curveset) {
                curvesets.add((curveset) o);
                ((curveset) o).setaffectedby(this);
            }
            //most params just affect their module, are not affected by it
            if (o instanceof param) {
                allparam.add((param) o);
                ((param) o).setaffects(this);
            }
            //internal loopcalcs just affect their module, are not affected by it or its params unless specified in initsetup / setinteractions
            if (o instanceof loopcalc && o!=this) {
                ((loopcalc) o).setaffects(this);
                ((loopcalc) o).register();
            }
        }
    }

    // *********** NAME and AUTO DOC ****************
    String doccurves = "", docparams = "";

    public String getFullName() {
        return world.name + "&" + name;
    }

    public String getExtraDoc() {
        doccurves = "";
        for (curveset qq : curvesets) if (qq.checkcomplexity()) {
                doccurves += "<li> " + qq.docSummary();
            }
        if (doccurves.length() > 0) doccurves = "===@qtsets=== <ul> " + doccurves + " </ul>";
        docparams = "";
        for (param p : allparam) if (p.checkcomplexity()) {
                docparams += "<li> " + p.docSummary();
            }
        if (docparams.length() > 0) docparams = "===@Params=== </ul> " + docparams + " </ul>";

        return (doccurves.length() > 0 ? " ---- £^curves " : "") + (docparams.length() > 0 ? " ---- £^params " : "") + docNotes() + " ---- £^interacs ";
    }

    public String getSpecificDoc(Object... args) {
        if (args[0].equals("curves")) return doccurves;
        if (args[0].equals("params")) return docparams;
        if (args[0].equals("interacs")) return docInteracs() + " ---- " + autodoc.javacode(this);
        return "<p><b>!specific doc request " + args[0] + " for " + name + " no longer implemented!</b><p> ";
    }
} //end module
//******************************

/*
P1 (re-implement or remove) if contains both params and curves, make sub_infobs for tree
 This causes too much trouble with the documentation of intermediate infobs, and also with the hideenabledobs

if (allparam.size()>3 && qtsets.size()>0) {
infob params = new infob(name+"&Params");
for (param p : allparam) { removeOb(p); params.addOb(p); }
params.mincomplexity();
addOb(params);
}
if (qtsets.size()>3 && allparam.size()>2) {
infob  curves= new infob(name+"&Curves") ; //for trees and menus
for (qtset qq : qtsets) { removeOb(qq); curves.addOb(qq); }
curves.mincomplexity();
addOb(curves);
}
 */



