/*
Main calculation loop through iobs, modules, etc.
See notes at end
 */
package jcm.core;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jcm.core.par.param;
import jcm.core.cur.curveset;
import jcm.core.ob.loopcalc;
import jcm.core.ob.*;
import static jcm.core.register.*;
import static jcm.core.report.*;
import static jcm.core.ob.module.*;

public class loop {

    //***********************************
    public static boolean calcfutureonly = false, //affects both pans and mods -may be set true by controls
	     checkmemory = false;
    //************* CHECK PERFORM ********************************
    public static param checkperform = new param("loopinfo", false, complexity.expert);
    static long inttime = 0,  tottime = 0,  oldtime = 0,  newtime = 0,  timediff = 0,  timelastgc = 0;
    static String info, oldltname = "";
 
    //************* END YEAR *************
    public static int startyear = gsy,  endyear = gey;
    public static param modendyear = new param("Model End Year", "", loopcalc.gey, 2100, 3000, complexity.expert) {

	public void set(double d) { 
	   // before loop starts, for effect of setting changed
	    //extend curvesets before anything else like modules
	    for (interacob i : register.alliobs) if (i instanceof curveset) {
		i.changeendyear(gey, (int) d);
		i.changed = true;
	    }
	    for (interacob i : register.alliobs) if (!(i instanceof curveset)) {
		i.changeendyear(gey, (int) d);
		i.changed = true;
	    }

	    if (endyear == gey) {
		endyear = (int) d;
	    }
	    gey = (int) d;
	    super.set(d);
	}
    };
    //***************** STARTING LOOP  *********************
    //queuing system to avoid two loops running at the same time, but also don't accumulate loop calls
    //see notes in loopreg.todo
    private static boolean settogo = false,  swingbusy = true; //for queuing loop calls
    public static boolean changeTreeStruc = true;  //used by tree, to avoid replotting tree within an iteration
    //P2 STRUC tree and interacmap need to replot (slow) if interactions changed, but often they don't especially if call from calc loop - maybe separate loop call from setallinteractions?
    private static Object looplock = new Object(),  swinglock = new Object();
    private static Thread loopthread = null;
    private static JOptionPane jop = null;

    /*set loop to go as soon as possible, and wait for result before continuing this thread
    should use this from calculation scripts, iterations, plot setup etc.
    problem can arise during reset:
    setup thread calls resetall
    look and feel updated
    that triggers big work in AWT thread, presumable with invoke&Wait somewhere,
    but AWT thread is already blocked by the setup thread...
    P2 Note: was also a problem calling gonow from regcli run during setup sometimes caused deadlock - try to understand why?
     */
    public static void gonow() {
	gonow(true);
    } //by default, assume treestruc has changed

    public static void gonow(boolean cts) {
	settogo = true;
	boolean ok = waitUntilLoopDone(); //if already running, maybe started before recent changes set
	if (ok && settogo && loopthread == null) {
	    changeTreeStruc = cts;
	    runloop();
	} else {
	    //if another waiting thread got priority and restarted loop before this, wait before returning, but don't set to go again
	    waitUntilLoopDone();
	}
    }

    /*
    set loop to go once everything else has finished
    (e.g. after any other loop finished  AND after GUI ready (eg buttons respond)
    note this doesn't wait for result - will return immediately
    should use this from most actions responding to mouse events
    a background thread waits while loop is busy
    then queues the call to end of event dispatching thread (wait for any GUI response)
    then runs loop if it is still needed (might not be, if another thread cancelled settogo)
    note: the waiting has its own thread, but the loop itself is run in event dispatching thread, otherwise parameters can be changed in the middle of a loop
     */
    public static void golater() {
	golater("Run Later", true);
    }

    public static void golater(String name) {
	golater(name, true);
    }

    public static void golater(String name, final boolean cts) {
	changeTreeStruc = cts;
	if (settogo) {
	    return;
	}
	settogo = true;
	new Thread(name) {

	    public void run() {
		final boolean ok = waitUntilLoopDone();
		SwingUtilities.invokeLater(new Runnable() {

		    public void run() {
			if (ok && settogo && loopthread == null) {
			    changeTreeStruc = cts;
			    runloop();
			}
		    }
		});
	    //waitForSwing();
	    //if (ok && settogo && loopthread==null)  { changeTreeStruc=cts; runloop(); }
	    }
	}.start();
    }

    //not used
    public static void waitForSwing() {
	swingbusy = true;
	SwingUtilities.invokeLater(new Runnable() {

	    public void run() {
		swingbusy = false;
		synchronized (swinglock) {
		    swinglock.notifyAll();
		}
	    }
	});
	while (swingbusy) {
	    synchronized (swinglock) {
		try {
		    swinglock.wait();
		} catch (InterruptedException e) {
		}
	    }
	}
    }

    public static boolean waitUntilLoopDone() {
	if (loopthread == null) {
	    return true;
	}
	String ctname = Thread.currentThread().getName(), ltname = loopthread.getName();
	if (loopthread == Thread.currentThread()) {
	    deb("!\t" + ctname + " called waitUntilLoopDone from within own loop! ");
	    return false;
	}
	if (SwingUtilities.isEventDispatchThread()) {
	    deb("!\tEvent Dispatching Thread cannot wait for " + ltname + " ... loop skipped");
	    return false;
	}

	String threadinfo = "\t... ." + ctname + " is waiting for " + ltname + " which is busy doing: ";
	while (loopthread != null) {
	    deb(threadinfo + " " + info);
	    threadinfo = "-...(waiting)... ";
	    try {
		synchronized (looplock) {
		    looplock.wait(4000);
		} //will stop once notifyAll is called at end of runloop - note wait releases the lock, so several threads can call this in parallel
	    } catch (InterruptedException e) {
		deb("looplock wait interrupted");
	    }
	}
	deb("-... ok go now");
	return true;
    }

    private static void runloop() {
	if (loopthread != null) {
	    waitUntilLoopDone();
	} //note currently redundant as loopthread=null already checked in calling methods...
	loopthread = Thread.currentThread();
	String ltname = loopthread.getName();
        if (ltname.startsWith("AWT-Event")) ltname="GUI Response Thread";
	settogo = false;
        if (!ltname.equals(oldltname)) deb(" ~~~~ loop started by "+ltname+" ~~~~ "); else deb ("-loop-");
        oldltname=ltname;
//	startcheck(5000);
	try {
	    mainloop();
	} catch (Exception e) {
	    deb(e, "Exception caught by runloop from " + ltname + " doing " + info);
	}
//	deb("-finished loop OK");
	synchronized (looplock) {
	    loopthread = null;
	    looplock.notifyAll();
	}
    }

//***************** MAIN CALCULATION LOOP **********
    private static void mainloop() {
        
	info = "";
	boolean check = checkperform.istrue();

	if (check) {
	    oldtime = System.nanoTime(); 
	    tottime = oldtime;
	}

	//************* INTERACTIONS **************
	//if (repeat || scin) setchangedifneeded(itc, itn);
	info = "interactions";
	try {
	    setallinteractions();
            //should only reset interacmap if loop called by a param or plot change, not if just for gui update of tree
	    jcm.gui.gen.interacmap.reset(); 
	} catch (RuntimeException e) {
	    log(e, loopthread.getName() + ": Loop Interactions Problem");
	    e.printStackTrace();
	}

	if (check) {
	    for (interacob i : alliobs) {
		i.timespent = 0;
	    }
	    inttime = System.nanoTime() - oldtime;
	}

	//for (interacob i : alliobs) if ( (i instanceof param) && ((param)i).type==param.Type.Xscale && i.changed) deb(" "+i+" changed");
	//for (interacob i : alliobs) if ( (i instanceof param) && i.needed) deb(" "+i+" needed");

	//************ PRECALC PARAMS ***************
	for (interacob i : alliobs) {
	    if ((i instanceof param) && i.needed && i.changed && !i.skip) {
		try {
		    info = "precalc " + i.name;
		    //deb("loop called "+i.name+ "precalc");
		    ((param) i).precalc();
		    if (check) {
			checktimespent(i);
		    }
		} catch (RuntimeException e) {
		    catcher(e, 1, i, false);
		}
	    }
	}

	//************* MODLOOP **************
	//to check: is there a reason why calcorder is set after param precalcs (and not within setallinteractions)? 

	info = "calculation order";
	setcalcorder();

	/*
	calcfutureonly is only for efficiency, but not currently working correctly:
	currently only sres, shares and stabilisation set affectsfutureonly=true
	should check this between needed and changed loops? -ie should depend only on the trigger of the change, if needed
	 */
	calcfutureonly = true;
	for (loopcalc lc : calclist) {
	    calcfutureonly &= lc.affectsfutureonly;
	    lc.err = false;
	}
	startyear = (calcfutureonly ? 2000 : 1750);
	//if (calcfutureonly)	deb("calcfutureonly");

	//main loop of modules through timesteps
	for (loopcalc lc : calclist) {
	    try {
		info = "precalc " + lc.getName();
		lc.precalc();
		if (check) {
		    checktimespent(lc);
		}
	    } catch (RuntimeException e) {
		catcher(e, 2, lc, false);
	    }
	}


	for (int y = startyear; y <= endyear; y++) {
	    module.year = y;
//if (y%50==0) deb("\nyear "+y);
	    for (loopcalc lc : calclist) {
		try {
		    info = "calcstep " + lc.getName() + " " + y;
		    if (y == startyear) {
			lc.startstate(startyear);
		    }
		    lc.calcstep();
		    if (y == 1999) {
			lc.save99();
		    }
		    if (check) {
			checktimespent(lc);
		    }
		} catch (RuntimeException e) {
		    if (!lc.err) {
			lc.err = true;
			catcher(e, y, lc, false);
		    }
		}
		if (module.year != y) {
		    log("! module year=" + module.year + " loop y=" + y + " mod=" + lc.getName());
		} //check that module year not changed, except by this loop!
	    }
	}

	//********************* POSTCALC*************
	for (loopcalc lc : calclist) {
	    try {
		info = "postcalc " + lc.getName();
		lc.postcalc();
		if (check) {
		    checktimespent(lc);
		}
	    } catch (RuntimeException e) {
		catcher(e, 2, lc, false);
	    }
	}

	for (interacob i : alliobs) {
	    if ((i instanceof curveset) && i.needed && i.changed && !i.skip) {
		try {
		    info = "postcalc " + i.name;
		    ((curveset) i).postcalc();
		    if (check) {
			checktimespent(i);
		    }
		} catch (RuntimeException e) {
		    catcher(e, 1, i, false);
		}
	    }
	}

	//********************** PLOTS, RESET, CHECKS ************
	info = "doplots";
	try {
	    doplots(); //plot plotlinks -see register
	} catch (RuntimeException e) {
	    log(e, "Loop Doplots Problem");
	}

	info = "ending loop";
	//cancel iobs changed since all done
	for (interacob i : alliobs) {
	    if (i.needed && i.changed && !i.skip) {
		i.changed = false;
	    }
	}

	if (check) {
	    reporttimespent();
	}

	if (checkmemory) {
	    info = ("memory: free=" + (int) (100.0 * Runtime.getRuntime().freeMemory() / Runtime.getRuntime().totalMemory()) + "%");
	}

	//force garbage collect, but not too frequently (eg when dragging param)
	long time = System.nanoTime();
	if ((time - timelastgc) > 5000) {
	    System.gc();
	    timelastgc = time;
	}

	if (checkmemory) {
	    log(info + " after-gc= " + (int) (100.0 * Runtime.getRuntime().freeMemory() / Runtime.getRuntime().totalMemory()) + "%");
	}

	calcfutureonly = false;
	changeTreeStruc = true;

    } //mainloop

//********************** DEBUG **************
    static void catcher(RuntimeException e, int y, Object o, boolean owneff) {
	String problem = "runtime exception " + e + ", in loop called from " + loopthread.getName() + " in year " + y + ": ";
	if (o instanceof interacob) {
	    problem += ((interacob) o).owner.name + (owneff ? " effectof " : ".") + ((interacob) o).name;
	}
	log(e, problem);
    }

//		try {	deb("waiting for input"); System.in.read(); } catch (Exception e) {	}
//****************** PERFORMANCE *********************************
    static void checktimespent(interacob i) {
        if (i.timespent == 0)     i.timespent = 1;	 // so include report
	newtime = System.nanoTime();
	i.timespent += newtime - oldtime;
	oldtime = newtime;
    }

    static void reporttimespent() {
	tottime = System.nanoTime() - tottime;
	info = "LOOP (time /ms)  total: " + tottime + " interactions: " + inttime + " ";
	for (interacob i : alliobs) {
	    if (i.timespent != 0) {
		info += ((i.owner.getName() == i.name ? "" : i.owner.getName() + ".") + i.name + ": " + i.timespent + " ");
	    }
	}
	log(info);
    }
//************************************************
} //end loop class

