
package jcm.core.data;

import java.io.*;
import java.util.*;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import static jcm.core.report.*;

public class loadtable {
    
    public interface combiner {  float[] combine(float[] in);      }
    
    
    /*
    loaddata assumes that first two rows are information only, to be ignored
    transposed means that names go across third row, otherwise down first column
    convreg means convert names to regions, and combine as necessary:
    when more than one value is  found for one region (typically with different aliases in countrynames, eg for small islands) values are added together
    if a curveset is provided for weights, this will be used for combining - must have same original set of regions  
     to load several tables and combine the data, use the combiner interface
     */
    public static void loaddata(curveset qq, String filename, String separator, boolean transposed,  float scalar, int sy, int ey, int usefromy) 
    {  loaddata(qq, null, filename, separator, transposed, true, scalar, sy, ey, usefromy, 1); }
    public static void loaddata(curveset qq, String filename, String separator, boolean transposed, boolean convreg,  float scalar, int sy, int ey, int usefromy, int step) 
    {  loaddata(qq, null, filename, separator, transposed, convreg, scalar, sy, ey, usefromy, step); }  
    
    public static void loaddata(curveset qq, curveset weighter, String filename, String separator, boolean transposed, boolean convreg,  float scalar, int sy, int ey, int usefromy, int step) {    
	
	String[][] tab=fileio.loadtab(filename, separator); //row, column
	
	int nreg=transposed ? tab[2].length-1 : tab.length-3;
	Set<curve> gotfirst=new HashSet();
        
        //for weights
        boolean weighted=weighter!=null;
        int ny=(1+ey-usefromy)/step;
        Map<curve, float[][]> totw=new HashMap(); //nf items, 0 for w, 1 for q*w 
        
	
	regfor: for (int i=0; i<nreg; i++) {
        
        if (!transposed && tab[3+i].length==0) continue regfor; //note no check for transposed!
	    String regname=transposed ? tab[2][1+i] : tab[3+i][0];
        if (regname.startsWith("Other") || regname.startsWith("Total")) continue regfor;
	    curve q=qq.getOrAddCurve(convreg ? regman.allreg.findormakereg(regname, filename) : regname);
            
            if (weighted && !totw.containsKey(q)) {
                float[][] w = new float[ny][2]; for (int n=0; n<=(ey-usefromy)/step; n++) {w[n][0]=0; w[n][1]=0; }
                totw.put(q,w);
            }
            
	    boolean first=!gotfirst.contains(q);
            if (first) gotfirst.add(q);
            if (!first && !convreg) deb("warning: duplicate key name "+regname+":- values will be summed!");    
	                
            
	    for (int y=usefromy; y<=ey; y+=step) try {
		float f, a;
                
		try {
		    f=Float.parseFloat(transposed ?  tab[3+(y-sy)/step][1+i] : tab[3+i][1+(y-sy)/step]);
		    if (f==-999f) deb("warning: -999 in data input file no longer interpreted as dud! - use text eg NaN");
		} catch (RuntimeException e) { f=curve.dud;  } // ignore parser errors - dud => NaN
		
		if ( !Float.isNaN(f)){
		    f = scalar*f;
		    
                    if (weighted) {
                        int n=y-usefromy/step;   
                        float w=weighter.get(regname, y); 
                        if (!Float.isNaN(w)) {
                            totw.get(q)[n][0]+=w; 
                            totw.get(q)[n][1]+=w*f; 
                        }
                    }
                    else {
                    a= (first || !q.gotdata(y)) ? 0 :  q.get(y);  // old version prior to sep07 had extra condition f>0 - remove if seems ok:   a= first && f>0 ? 0 : q.get(y) == qt.dud ? 0 :  q.get(y);
                    if (f+a==0) q.set(y, q.dud);
                    else q.set(y, f + a);
                    }
		}
		//else if (first) q.set(y, curve.dud);
		//if first added sep07: idea is to keep some data even if dud for a small extra subregion
		//but this prevents blending two data sets (one with gaps) into one qtset
		
	    } catch (RuntimeException e) { deb(e, filename+" "+q.name +" "+y); } 
            //end timestep loop
	} //end region loop
        
        if (weighted) {
            for (curve q : totw.keySet()) {
                for (int y=usefromy; y<=ey; y+=step) {
                    int n=y-usefromy/step; 
                    float[] f=totw.get(q)[n];
                    if (Float.isNaN(f[0]) || f[0]==0)q.set(y,q.dud);
                    else q.set(y, f[1]/f[0]); 
                }
            }
        }
    } //loaddata
    
    
    public static void oldsplit(curveset qq, int lastyr) {
	//split emissions from former regions FSU, FYU, etc.
	
	for (region rs : regman.allreg.findreg("OLDSPLIT").reg) {
	    Set<region> sub=rs.subreg(qq);
	    //for (region r : sub) deb(r);
	    
	    //find y =last year of sr data, then calc frac of emissions y+1
	    Map<region, Float> frac=new HashMap(sub.size());
	    int y=lastyr; while (get(qq,rs,y)<=0 && y>qq.sy) y--;
        
	    float sum=0; for (region r : sub) sum+=get(qq,r,y+1);
        for (region r : sub) frac.put(r, get(qq,r,y+1)/sum);
	    //String info="Oldsplit "+ qq.name+": "+rs.name+ " from "+y+ " - "; for (region r : sub) info+=" " +r.name+":"+frac.get(r); deb(info);
	    float f; while ((f=get(qq,rs,y))>0) {
		for (region r : sub) if (frac.get(r)>0) qq.getOrAddCurve(r).set(y,  f * frac.get(r)); //beware fill not add, so other contributions won't be counted!
		y--;
	    }
	    qq.map.remove(rs);
	}
    }
    
   static float get(curveset qq, region r, int y) {
       float f=qq.getOrAddCurve(r).get(y);
       if (Float.isNaN(f)) return 0; else return f;
   }
    
    
    
} //end class

