/*
 no longer many array sources - most use qtsets
 => as the qtset constructor is simple, could put the source (and scalar) into the fill method, and have a separate array-source object?
 all it needs is a get (r,y) method (which qtset has anyway)
 avoids making objects...
 but leave restruc until finished with all old loaddata arrays
 */


package jcm.core.data;

import java.util.*;

import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresdata;
import static  jcm.core.report.*;
import static jcm.core.report.*;


public  class interpolator {
    
    List<region> sourcereg;
    Map<region, region> natmap=new HashMap<region, region>();
    Map<region, Float> natfrac=new HashMap<region, Float>();
    Map<region, Float> corrfac=new HashMap<region, Float>();
    Map<region, Set<region>> sourcesubreg=new  HashMap<region, Set<region>>();
    Map<region, Set<region>> destsubreg=new HashMap<region, Set<region>>();
    
    Object source;
    
    static Set<region> errormap=new HashSet<region>();
    
    int sy, step, scen; //only used for array sources
    float scalar=1;
    boolean transposed;
    
    public interpolator(Object ... args) {
	int i=0;
	for (Object o : args) {
	    if (o instanceof curveset) {
	    	sourcereg=new ArrayList<region>(); for (Object oo : ((curveset) o).map.keySet()) sourcereg.add((region)oo);
	    	source=(curveset)o;
	    }
	    if (o instanceof String) sourcereg=regman.allreg.findormakereg((String)o, "interpolator").reg;
	    if (o instanceof List) sourcereg= (List<region>)o; //be careful - could pick other types of list!
	    if (o instanceof double[] || o instanceof float[][] || o instanceof float[][][]) source=o;
	    if (o instanceof Float) scalar=(Float)o;
	    if (o instanceof Integer) {
	    	if (i==0) sy=(Integer)o;
	    	if (i==1) step=(Integer)o;
	    	if (i==2) scen=(Integer)o;
	    	i++;
	    }
	    if (o instanceof Boolean) transposed=(Boolean)o;
	}
    }
    
    
    public void fill(curveset dest, region destset, int sy, int ey, curveset weights) { fill(dest, destset, sy, ey, weights, (weights!=null ?  weights.ey : ey )); }
    public void fill(curveset dest, region destset, int sy, int ey, curveset weights, int wey) { fill(dest, destset, sy, ey, weights, wey, 100f); }
    public void fill(curveset dest, region destset, int sy, int ey, curveset weights, float convfac) {fill(dest, destset, sy, ey, weights, (weights!=null ?  weights.ey : ey ), convfac); }
    public void fill(curveset dest, region destset, int sy, int ey, curveset weights, int wey, float convfac) {
        errormap.clear();
        boolean converge= convfac<100f;
        float cf=(1f - convfac/100f), sum=0;
        Map<region, Float> prevyeardata=new HashMap<region, Float>(destset.reg.size());
        //note: convfac is the factor of convergence (%/year) by which the original scenario is approached. 
        
	for (region r : sourcereg)  sourcesubreg.put(r,  r.subreg(regman.nations));
	for (Object r : destset.reg)  destsubreg.put((region)r,  ((region)r).subreg(regman.nations));
	//for (region r : regman.nations.reg) corrfac.put(r, 1f);
	
	//below not working for larger region-sets
	for (region r : sourcereg) for (region sr : sourcesubreg.get(r)) natmap.put(sr, r);
	
        //note: if using convergence, need to calculate the data for the previous year 
	for (int y=(converge ? sy-1 : sy); y<=ey; y++) {
	    
	    //get fractions of source for each nation, using weights
	    if (natfrac.size()==0 || y<=wey) {
		for (region r : sourcereg) {
		    float frac, sumfrac=0;
		    for (region sr : sourcesubreg.get(r))  {
			if (weights==null ) natfrac.put(sr, 1f);
			else if (!weights.map.containsKey(sr) )  {
			    if (!errormap.contains(sr)) { errormap.add(sr); } //deb(weights+ " interpolator: no weight for "+ sr.name+ " in "+y); } 
			} else {
			    int yy=(sy > weights.sy ? (y<wey ? y : wey) : (y<weights.sy ? weights.sy : y));
			    float f=weights.get(sr, yy);
			    if (!Float.isNaN(f)) natfrac.put(sr, f);
			}
			if (!natfrac.containsKey(sr)) natfrac.put(sr, 0f);
			sumfrac+=natfrac.get(sr);
		    }
		    for (region sr : sourcesubreg.get(r))  natfrac.put(sr, natfrac.get(sr)/sumfrac);
		}
	    }
	    
	    //add up result in new regions, applying the natfracs
	    for (region r : destset.reg) {
		sum=0; 
		for (region sr : destsubreg.get(r)) {
		    region nat=natmap.get(sr);
		    if (nat==null) { errormap.add(sr); }// deb(sr.name+ " has no match, filling "+dest); }
		    else sum+= getdata(nat, y) * natfrac.get(sr);
		}//sr
                if (converge) {
                    if (y>=sy) dest.set(r,y, sum + cf * (dest.get(r, y-1) - prevyeardata.get(r)) );
                    prevyeardata.put(r, sum);
                }
                else dest.set(r,y, sum);
	    }//r
	}//y
	
	//report errors
	if (errormap.size()>0) {
	    String s="Interpolator errors dest="+dest.name +" weights="+weights.name+ " regions: ";
	    for (region r : errormap) s+=r.name+" ";
	    deb(s);
	}
    }//interp
    
    
    public float getdata(region r, int y) {
    	if (source instanceof curveset)	return scalar*((curveset)source).get(r,y);
		return getdata(sourcereg.indexOf(r), y);
    }
    
	public float getdata(int ri, int y ){
	
		int s=(y-sy)/step;
		float yf=(float) ((y-sy) % step)/step;


		if (source instanceof double[])  {
			return scalar*(float)((double[])source)[ri];
		}

		if (source instanceof float[][])  {
			float[][] f=(float[][]) source;
			if (transposed)  return scalar*( (1f-yf) * f[s][ri] +  (yf>0 ? yf * f[s+1][ri] : 0) );
			else return scalar*( (1f-yf) * f[ri][s] +  (yf>0 ? yf * f[ri][s+1] : 0) );
		}
		if (source instanceof float[][][])  {
			float[][][] f=(float[][][]) source;
			return  scalar*( (1f-yf) * f[ri][scen][s] +  (yf>0 ? yf * f[ri][scen][s+1] : 0) );
		}
		return curve.dud;
    }
    
    //****************************************************
    //STATIC METHOD
    /** sum data from small regions to make large ones, can also scale by a constant factor 
     changed winter 08 as the f apparently caused the jumps in emissions on reset+calc
     method called only from history.java - for popn, gdp, emitfos, emitluc
     checked - these seem ok for diff region sets
     may have been used to combine multiple sources of lucemit data in which case that would no longer work
     spring 2010:  also generalised to use for nat=>regset in pop_gdp and emitbase, and made more efficient
     */
    public static void fillregdata(curveset source, curveset dest, region regset,  int sy, int ey) {
        fillregdata(source, dest, regset, 1f, sy, ey);
    }
    public static void fillregdata(curveset source, curveset dest, region regset, float fac) {
        fillregdata(source, dest, regset, fac, source.sy, source.ey);
    }
    public static void fillregdata(curveset source, curveset dest, region regset, float fac, int sy, int ey) {
//        dest.map.clear(); causes problem with emitfosabate map
	for (region r : regset.reg)  {
	    Set<region>subregs=r.subreg(source);
	    for (int y =sy; y<=ey; y++) {
		/* removed winter 08 -get value before clearing -why was this useful? 
                 * // ok P1 CHRIS change the method fillregdata, to not sum numbers qt.dud
                 //float f = dest.get(r,y); 
                 */
        float sum=0;
		for (region sr: subregs) sum+= (Float.isNaN(source.get(sr, y)) ? 0 /** was f*/ : source.get(sr, y)*fac)  ;
        dest.set(r, y, sum);
	    }
	}
    }

    
    //simple linear interpolation over time
    public static void linearinterp(curveset qq, int sy, int ey) {
	for (curve q : qq.map.values()) {
	    for (int y=sy+1; y<=ey-1; y++) q.set(y, (q.get(sy)*(ey-y)+ q.get(ey)*(y-sy))/(ey-sy) );
	}
    }
    
    //this is only used for global HFCs (no longer for regions)
    public static float interphfc(float[][][] data, int reg, int sc, int year) {
	int bk=(year-2000) / 10, by=year % 10;
	int dl=data[0][0].length;
	if (dl==12) {	bk++; reg++; } //sres4 data start in 1990 and first region is world
	if (bk>=dl-1) {	bk=dl-1; by=0; } //after end, assume constant
	try {
	    return (1f-(float)by/10f)*data[reg][sc][bk]
		    + (by>0 ? ((float)by/10f)*data[reg][sc][bk+1] : 0);
	    //	return (float)((bk<10) ? ((double)(10-by)*data[reg][sc2][bk]+ (double)by*data[reg][sc2][bk+1]) /10f : data[reg][sc2][10] );
	} catch (Exception e) {	log(e, " sres interp error " +data+ " reg="+reg+ " sc="+sc+ " bk="+bk+ " by="+by); return 0; }
    }
    
  //****************************
    //OLD INTERPOLATION ROUTINE ex sres_data
    //linear interpolation between 10-year data
    //used by globco2emit, othgasemit, costs
    //copes with data beyond 2100, sc 7 was extended to 2300
    
    //for global data float[sc][bk]
    public static float sresinterp(float[][] data, int sc, int year) { 
    	int bk=(year-2000) / 10, by=year % 10;
        try {
            return (float)((bk<10 || (sc==7 && bk<30)) ? ((double)(10-by)*data[sc][bk]+ (double)by*data[sc][bk+1]) /10f : sc==7 ? data[sc][30]  : data[sc][10] );
        } catch (Exception e) { log(e, "sres interp error: "+data+ " sc="+sc+ " bk="+bk+ " by="+by) ; return 0; }
    }
    
    public static float simpinterp(float[] data, int year) { 
    	int bk=(year-2000) / 10, by=year % 10;
            return (float)( (bk<10) ? ((double)(10-by)*data[bk]+ (double)by*data[bk+1]) /10f :data[10] );
    }
    
    
} //end class




