
//COMPLEXITY-LEVEL (for plots, tables, params etc.)


package jcm.core;

import jcm.core.itf.hasComplexity;
import jcm.core.par.param;

public enum complexity {
    simplest, normal, expert, experimental;
    
    public static param<complexity> defaultcomplexity=getcomplexityparam();
    public static param getcomplexityparam() {	return new param("complexity", complexity.values(), complexity.normal, complexity.simplest);  }
    static {   register.setAlwaysOutput(defaultcomplexity); }
    
    public static boolean check(hasComplexity hc) {	return check(hc.getComplexity()); }
    public static boolean check(complexity c) {	return check(c, defaultcomplexity.chosen); }
    
    public static boolean check(complexity c, complexity level) { return level.compareTo(c)>=0; }
//        boolean b=false;
//        for (int i=0; i<=p.getchosenindex(); i++)  if (c.equals(p.menulist[i])) b=true;
//        return b;
//    }
    
}

