

package jcm.core.anno;

import java.lang.annotation.*;

/**
 General todo annotation
 */



public  @Documented @Retention(value=RetentionPolicy.RUNTIME) @interface todo {
    
    /** type of todo */
    enum type {
	/** essential to fix soon */	fix(5),
	/** doesn't work / misleading results */ bug(4),
	/** works but needs updating*/ update(3),
	/** needs documenting */ doc(2),
	/** probably works, needs re-check */ check(2),
	/** idea for feature / enhancement */ idea(2),
	/** potential restructuring */ struc(1),
	/** code needs tidying */ tidy(0),
	/** general todo - default */ gen(3)
	;
	int defp; //default base priority for this type
	type(int n) { defp=n; }
    }
    
    /** major task/project  related goal*/
    enum goal {
	/** before next public version  */ pub(4),
	/** for AR4 consistent version */ AR4(3),
	/** ABCI aviation project */ ABCI(2),
	/** MATCH attribution analysis */ MATCH(1),
	/** new brazilian project */  brazil(1),
	/** default */ none(0);
	int defp; //added priority for this type - note can add to type priority!
	goal(int n) { defp=n; }
    }
    
    
    /** what to do */    String w() default "";
    /** same as w, default if just a string */ String value() default ""; 
    type t() default type.gen;
    goal g() default goal.none;
    /** special priority typically  from 1(low)  to 5 (high):- if not set, assume dependent on the type+goal, or 3 if that is not specified */     int py() default 0;
    /** date added */ String da() default  "";
    /** date done */ String dd() default  "";
    /** set ok=true if done */  boolean ok() default false;
}



