     // =========== Java WebStart JNLP  =================
    /* These methods are included within JavaWebStart since Java 5, but only within core java since Java 6 
They should not cause problems for running JCM using Java 5  via JWS (i.e. starting from web-browser or javaws to run a jar) 
If you want to compile using Java5 you must include jnlp.jar separately somewhere in your classpath (set in project.properties) 
 */
package jcm;

import java.io.*;
import java.net.URL;
import javax.jnlp.*;
import jcm.core.tls.fileio;
import static jcm.core.report.*;

public class JNLP_methods {
    public static BasicService jwsbs() {
        try {
            return (BasicService) ServiceManager.lookup("javax.jnlp.BasicService");
        } catch (Exception e) {
            msg(e, "JNLP error: ");
            return null;
        }
    }

    public static PersistenceService jwsps() {
        try {
            return (PersistenceService) ServiceManager.lookup("javax.jnlp.PersistenceService");
        } catch (Exception e) {
            msg(e, "JNLP error: ");
            return null;
        }
    }

    public static FileSaveService jwsfss() {
        try {
            return (FileSaveService) ServiceManager.lookup("javax.jnlp.FileSaveService");
        } catch (Exception e) {
            msg(e, "JNLP error: ");
            return null;
        }
    }

    public static FileOpenService jwsfos() {
        try {
            return (FileOpenService) ServiceManager.lookup("javax.jnlp.FileOpenService");
        } catch (Exception e) {
            msg(e, "JNLP error: ");
            return null;
        }
    }
    //static ExtendedService jwses() { try { return (ExtendedService) ServiceManager.lookup("javax.jnlp.ExtendedService"); } catch (Exception e) { msg(e, "JNLP error: "); return null; }}
    public static InputStream JWS_fos_IS() {
        try {
            return jwsfos().openFileDialog(null, null).getInputStream();
        } catch (IOException e) {
            msg(e, "Problem with Open Dialog");
            return null;
        }
    }

    public static String JWS_sfd_getfilename(OutputStream os, String name, String extension) {
        try {
            //JWS FileSaveService wants an inputstream ready to save,so we first have to fill the outputstream (eg with ImageIO), then call this method
            InputStream is = new ByteArrayInputStream(((ByteArrayOutputStream) os).toByteArray());
            FileContents lfc = jwsfss().saveFileDialog(null, null, is, name + "." + extension); //subfolder, new String[]{extension}
            //note, using the subfolder as hint doesn't help, nor does the extensions, nor does the name - but at least with null it remembers the last folder
            return lfc.getName();
        } catch (IOException e) {
            msg(e, "Problem with Save Dialog");
            return ("... failed! ...");
        }
    }

    public static OutputStream JWS_PS_getOutputStream(String name) {
        try {
            URL u = new URL(jwsbs().getCodeBase(), name); //note don't use subfolder'
            PersistenceService ps = jwsps();
            try {
                ps.create(u, 10000);
            } catch (Exception e2) {
            } // msg (e2, "Problem Creating JNLP Persistence file");}
            return ps.get(u).getOutputStream(true);
        } catch (IOException e) {
            msg(e, "Problem Saving Setup");
            return null;
        }
    }

    public static void JWS_setdir() {
        try {
            FileContents lfc = jwsfos().openFileDialog(null, null);
        } catch (Exception e) {
            msg(e, "Can't Select Directory");
        }
    }

    public static String[][] JWS_loadtabfrompersist(String subfolder, String name, String separator) {
        try {
            try {
                File f = new File(fileio.getOutDir(subfolder), name);
                return fileio.loadtab(f, separator);
            } catch (SecurityException e) {
                URL u = new URL(jwsbs().getCodeBase(), name); //note don't use subfolder
                return fileio.loadtab(jwsps().get(u).getInputStream(), separator);
            }
        } catch (Exception e) {
            deb(e);
            return null;
        } //msg(e, "Can't Load Persistence File");
    }

}
