/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.report;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.histoplot;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.mod.socio.popgdp;
import jcm.script.calcscript;

public class swinf_pledges
extends calcscript {
    globco2emit gc = this.gm(globco2emit.class);
    carboncycle car = this.gm(carboncycle.class);
    glotemp tem = this.gm(glotemp.class);
    radfor rf = this.gm(radfor.class);
    stabilisation stab = this.gm(stabilisation.class);
    shares sha = this.gm(shares.class);
    pledges ple = this.gm(pledges.class);
    emitquota eq = this.gm(emitquota.class);

    void checkready() {
        try {
            while (this.stab.running) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkbutandsleep(500);
    }

    float ro(float f) {
        return (float)Math.round(f / 100.0f) / 10.0f;
    }

    public histoplot histoplot(curveset curveset2) {
        return (histoplot)showpan.makepan(histoplot.class, curveset2, new Object[0]);
    }

    @Override
    public void run() {
        lookandfeel.fontSize.set(18);
        this.link(this.eq.emitequiv);
        this.link(this.tem.temp);
        this.link(this.car.conc);
        this.checkready();
        loop.gonow(false);
        this.checkready();
        int[] nArray = new int[]{1990, 2005, 2010, 2020};
        curvar curvar2 = new curvar(curve.Type.ratio, this.eq.emitfos_unitsCO2, this.gm(popgdp.class).pop);
        curvar curvar3 = new curvar(curve.Type.ratio, this.eq.emitfos_unitsCO2, this.gm(popgdp.class).gdp_ppp);
        this.eq.emitfos_unitsCO2.addOb(curvar2);
        histoplot histoplot2 = this.histoplot(curvar2);
        histoplot2.highonleft = true;
        histoplot2.xscale.min = 0.0;
        histoplot2.xscale.max = 7800.0;
        histoplot2.yscale.min = 0.0;
        histoplot2.yscale.max = 20.0;
        histoplot2.xscale.changed = true;
        histoplot2.yscale.changed = true;
        histoplot2.hidechooser();
        histoplot2.legend.forcelong = true;
        histoplot2.labels = true;
        showpan.toFront(histoplot2);
        histoplot2.doplot();
        this.checkready();
        loop.gonow(false);
        histoplot2.yscale.changed = true;
        histoplot2.doplot();
        this.checkready();
        for (int n : nArray) {
            this.checkready();
            histoplot2.year.set(n);
            loop.gonow(false);
            this.checkready();
            imagesaver.saveimage((Component)histoplot2, "png", new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpercap_" + n + ".png"));
        }
        datable.savetable(new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpercap.dat"), (curveset)curvar2, "tab");
        this.checkready();
        Object object = this.histoplot(curvar3);
        ((histoplot)object).highonleft = true;
        ((histoplot)object).xscale.min = 0.0;
        ((histoplot)object).xscale.max = 9.0E7;
        ((histoplot)object).yscale.min = 0.0;
        ((histoplot)object).yscale.max = 0.0013;
        ((histoplot)object).xscale.changed = true;
        ((histoplot)object).yscale.changed = true;
        ((histoplot)object).hidechooser();
        ((histoplot)object).legend.forcelong = true;
        ((histoplot)object).labels = true;
        showpan.toFront((JComponent)object);
        ((histoplot)object).yscale.units.units = ((histoplot)object).yscale.units.units.replace("microton", "grams");
        ((histoplot)object).doplot();
        ((histoplot)object).yscale.units.scales = 0.001;
        ((histoplot)object).yscale.changed = true;
        ((histoplot)object).doplot();
        this.checkready();
        for (int n : nArray) {
            this.checkready();
            ((histoplot)object).year.set(n);
            loop.gonow(false);
            this.checkready();
            imagesaver.saveimage((Component)object, "png", new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpergdp_" + n + ".png"));
        }
        datable.savetable(new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpergdp.dat"), (curveset)curvar3, "tab");
        this.checkready();
        this.end();
        report.log("End of script swinf_pledges");
    }
}

