/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.par.param;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.script.calcscript;

public class swinf_global
extends calcscript {
    globco2emit gc = this.gm(globco2emit.class);
    carboncycle car = this.gm(carboncycle.class);
    glotemp tem = this.gm(glotemp.class);
    radfor rf = this.gm(radfor.class);
    stabilisation stab = this.gm(stabilisation.class);
    shares sha = this.gm(shares.class);
    pledges ple = this.gm(pledges.class);
    emitquota eq = this.gm(emitquota.class);
    sealevel sl = this.gm(sealevel.class);
    controller co = this.gm(controller.class);
    Map<curveset, Object> curvemap = new HashMap<curveset, Object>();
    param[] scenparam;
    String indics;
    String descriptions;

    public swinf_global() {
        this.scenparam = new param[]{this.stab.indicator};
        this.indics = " Scenario\t\t Emit CO2eq 2020 \t Emit CO2eq  2050 \t Emit CO2eq  2100  \t Emit CO2 2020 \t Emit CO2  2050 \t Emit CO2  2100  \t IntegCO2eq 2050 \t IntegCO2eq 2300  \t IntegCO2 2050 \t IntegCO2 2300  \t Decline_CO2eq \t Decline_CO2 \t Peak CO2eq-conc \t year \t CO2eq-conc 2300\t Peak CO2-conc \t year \t CO2-conc 2300\t Peak Temperature \t year \t Temperature 2300\t Sea-level-rise 2100 \t Sea-level-rise 2300 \n";
        this.descriptions = "Scenario Descriptions\n";
    }

    @Override
    public void run() {
        lookandfeel.fontSize.set(18);
        this.link(this.tem.temp);
        this.link(this.car.conc);
        this.link(this.sl.sealevel);
        curvar curvar2 = new curvar(curve.Type.integral, this.gc.co2eqcurves);
        this.link(curvar2);
        int n = 1950;
        int n2 = 2300;
        this.curvemap.put(new curveset("fossil_CO2_emissions", "mega&ton&carbon", n, n2, 1), this.gc.fossil);
        this.curvemap.put(new curveset("CO2eq_emissions", "mega&ton&co2eq", n, n2, 1), new curve[]{this.gc.co2eqtot, this.gc.co2fos});
        this.curvemap.put(new curveset("CO2eq_emissions_integral", "giga&ton&co2eq", n, n2, 1), curvar2.getcurve(this.gc.co2eqtot.name));
        this.curvemap.put(new curveset("CO2 concentration", "ppm&co2", n, n2, 1), this.car.co2atppm);
        this.curvemap.put(new curveset("CO2eq concn allgas+aeros", "ppm&co2eq", n, n2, 1), new curve[]{this.rf.co2eqghgaero, this.car.co2atppm});
        this.curvemap.put(new curveset("RF allgas+aeros", "w&per&m2", n, n2, 1), this.rf.totalrf);
        this.curvemap.put(new curveset("Temperature", "degc&above&1835-65", n, n2, 1), this.tem.avchangeby);
        this.curvemap.put(new curveset("Sea-Level", "metres", n, n2, 1), this.sl.total);
        this.co.botuptopdo.set(controller.butd.start_bottom_up);
        this.sha.distribution.set(shares.distriboptions.convergence);
        this.sha.rate_caps.set(true);
        this.ple.level.set(pledges.pledgelevel.conditional);
        for (scenarios scenarios2 : scenarios.values()) {
            this.checkready();
            this.stab.indicator.set(stabilisation.indicators.stabconc);
            loop.gonow(false);
            this.checkready();
            report.log("Setting parameters for " + scenarios2.name());
            switch (scenarios2) {
                case fiftypc2050_2C: {
                    this.stab.indicator.set(stabilisation.indicators.define_emit);
                    this.stab.stabemityear.set(2050);
                    this.stab.peaking.set(true);
                    this.stab.stabemitlevel.set(3500);
                    this.stab.stabemitendlevel.set(250);
                    this.stab.stabemitdeclinerate.set(1.1);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_constraint.set(6.5);
                    this.ple.usepledges.set(true);
                    scenarios2.info = "This scenario begins with a defined emissions trajectory to reach the key policy target of 50% of 1990 by 2050 (CO2eq emissions inc CH4, N2O+LUC), After 2050 the emissions curve continues along an trajectory in which total CO2 emissions decline exponentially at -1.25%/yr towards a minimum level of 0.25GtC. This trajectory is chosen to stabilise the temperature at 2\u00b0C with default model parameters. There is a marked relaxation in the emissions decline after 2050. As for other scenarios in this group, the scenario starts with  high pledges in 2020 and continues regionally by a increasing participation with convergence. A top-down constraint applies from 2020 onwards. As the decline from 2020 to 2050 is steep, the decline rate cap on individual countries cannot be set lower than 6.5%/year.";
                    break;
                }
                case fiftypc2050_15C: {
                    this.stab.indicator.set(stabilisation.indicators.define_emit);
                    this.stab.stabemityear.set(2050);
                    this.stab.stabemitlevel.set(3500);
                    this.stab.peaking.set(true);
                    this.stab.stabemitendlevel.set(0);
                    this.stab.stabemitdeclinerate.set(3.5);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_constraint.set(6.5);
                    scenarios2.info = " This scenario is similar to the fiftypercent_2C until 2050. Thereafter total CO2 emissions decline exponentially at -4%/yr towards zero. This steep decline is a smooth continuation of the earlier part of the curve. Temperature peaks at around 1.8C in 2060 (CHECK) and declines thereafter, falling to 1.5C in 2250 (CHECK). Such a scenario may be particularly interesting to low-lying states as it has a greater chance to avoid catastrophic melting of the Greenland and WAIS ice caps.";
                    break;
                }
                case stabtemp_225C_2C: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.stabyear.set(2100);
                    this.stab.stabtemplevel.set(2.25);
                    this.stab.peaking.set(true);
                    this.stab.stabtempend.set(2.0);
                    this.ple.usepledges.set(false);
                    this.co.startyear_topdown.set(2020);
                    this.sha.initgroup.set(shares.igroup.none);
                    this.sha.richjoin.set(false);
                    this.sha.rate_caps.set(false);
                    break;
                }
                case stabtemp_2C: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2125);
                    this.stab.stabtemplevel.set(2.0);
                    this.ple.usepledges.set(true);
                    this.co.startyear_topdown.set(2020);
                    this.sha.initgroup.set(shares.igroup.all_CA_pledges);
                    this.sha.rate_caps.set(true);
                    this.sha.richjoin.set(true);
                    this.sha.rate_constraint.set(4);
                    scenarios2.info = " ";
                    break;
                }
                case stabtemp_2C_175C: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(true);
                    this.stab.stabyear.set(2100);
                    this.stab.stabtemplevel.set(2.0);
                    this.stab.stabtempend.set(1.75);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_constraint.set(4);
                    scenarios2.info = " ";
                    break;
                }
                case stabtemp_15C: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2075);
                    this.stab.stabtemplevel.set(1.5);
                    this.ple.usepledges.set(false);
                    this.co.startyear_topdown.set(2015);
                    this.sha.initgroup.set(shares.igroup.Kyoto_Annex_B);
                    this.sha.rate_caps.set(false);
                    scenarios2.info = " ";
                    break;
                }
                case stabCO2eq500: {
                    this.stab.indicator.set(stabilisation.indicators.stabrf_allghgaero);
                    this.stab.stabrflevel.set(3.14);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2100);
                    this.stab.curveopt.set(stabilisation.curvetype.padequintic);
                    this.ple.usepledges.set(true);
                    this.sha.initgroup.set(shares.igroup.all_CA_pledges);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_caps.set(true);
                    this.sha.rate_constraint.set(6.5);
                    scenarios2.info = " This scenario follows a classic stabilise CO2equivalent concentration pathway. The stabilisation level is 3W/m2 (about 480ppm CO2eq )for all greenhouse gases and aerosols. The peak CO2eq concentration is a bit higher at around 490ppm. The temperature rises slowly towards 2C, reaching 1.9C only in 2125,  due to the gradual uptake of heat by the ocean. (which is not offset by declining forcing as in the other scenarios).  The eventual equilibrium temperature associated with this forcing will be higher than 2C (CALCULATE).  If the equilibrium would be 2C and the final CO2eq level may not be exceeded, the emissions decline would be even steeper.  It is this type of  scenario pathway that dominated the analyses of IPCC AR4 WG3.  Due to this pathway shape, the emissions are constrained in early years and are just below the 50% scenarios in 2050.  Therefore, the top-down constraint from 2020 and 6.5% decline rate cap also apply in this case. ";
                    break;
                }
                case stabCO2eq450: {
                    this.stab.indicator.set(stabilisation.indicators.stabrf_allghgaero);
                    this.stab.stabrflevel.set(2.58);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2060);
                    this.stab.curveopt.set(stabilisation.curvetype.padequintic);
                    this.ple.usepledges.set(false);
                    this.co.startyear_topdown.set(2015);
                    this.sha.initgroup.set(shares.igroup.Kyoto_Annex_B);
                    this.sha.rate_caps.set(false);
                    scenarios2.info = "";
                }
            }
            for (pledges.pledgelevel pledgelevel2 : EnumSet.of(pledges.pledgelevel.conditional, pledges.pledgelevel.unconditional)) {
                int n3;
                boolean bl = scenarios2 == scenarios.fiftypc2050_2C || scenarios2 == scenarios.stabtemp_2C;
                boolean bl2 = pledgelevel2 == pledges.pledgelevel.conditional || bl;
                if (!bl2) continue;
                this.checkready();
                this.ple.level.set(pledgelevel2);
                loop.gonow(false);
                this.checkready();
                Color color = pledgelevel2 == pledges.pledgelevel.conditional ? scenarios2.col : scenarios2.col.darker();
                String string = scenarios2.name() + " " + (bl ? pledgelevel2.name().replace("effort", "pledge") : "");
                for (curveset curveset2 : this.curvemap.keySet()) {
                    try {
                        if (this.curvemap.get(curveset2) instanceof curve) {
                            curveset2.addcurve(((curve)this.curvemap.get(curveset2)).cloneIndependent(n, n2, 1, string, color));
                        }
                        if (!(this.curvemap.get(curveset2) instanceof curve[])) continue;
                        curve[] curveArray = (curve[])this.curvemap.get(curveset2);
                        for (n3 = 0; n3 < curveArray.length; ++n3) {
                            curve curve2 = curveArray[n3].cloneIndependent(n, n2, 1, string + "_" + n3, color);
                            curve2.style = curve.linestyle.values()[n3 % curve.linestyle.values().length];
                            curveset2.addcurve(curve2);
                        }
                    }
                    catch (Exception exception) {
                        report.deb(exception);
                        exception.printStackTrace();
                    }
                }
                float f = 0.0f;
                for (int i = 2001; i <= 2050; ++i) {
                    f += this.gc.co2eqtot.get(i);
                }
                float f2 = f;
                for (int i = 2051; i <= 2300; ++i) {
                    f2 += this.gc.co2eqtot.get(i);
                }
                float f3 = 0.0f;
                for (n3 = 2001; n3 <= 2050; ++n3) {
                    f3 += this.gc.co2fos.get(n3);
                }
                float f4 = f3;
                for (int i = 2051; i <= 2300; ++i) {
                    f4 += this.gc.co2fos.get(i);
                }
                float f5 = 100.0f * (1.0f - (float)Math.pow(this.gc.co2eqtot.get(2045) / this.gc.co2eqtot.get(2025), 0.05f));
                float f6 = 100.0f * (1.0f - (float)Math.pow(this.gc.co2fos.get(2045) / this.gc.co2fos.get(2025), 0.05f));
                float f7 = 0.0f;
                float f8 = 0.0f;
                float f9 = 0.0f;
                float f10 = 0.0f;
                float f11 = 0.0f;
                float f12 = 0.0f;
                for (int i = 2040; i < 2300; ++i) {
                    if (this.car.co2atppm.get(i) > f7) {
                        f7 = this.car.co2atppm.get(i);
                        f8 = i;
                    }
                    if (this.rf.co2eqghgaero.get(i) > f9) {
                        f9 = this.rf.co2eqghgaero.get(i);
                        f10 = i;
                    }
                    if (!(this.tem.avchangeby.get(i) > f11)) continue;
                    f11 = this.tem.avchangeby.get(i);
                    f12 = i;
                }
                float[] fArray = new float[]{this.ro(this.gc.co2eqtot.get(2020)), this.ro(this.gc.co2eqtot.get(2050)), this.ro(this.gc.co2eqtot.get(2100)), this.ro(this.gc.co2fos.get(2020)), this.ro(this.gc.co2fos.get(2050)), this.ro(this.gc.co2fos.get(2100)), this.ro(f), this.ro(f2), this.ro(f3), this.ro(f4), f5, f6, f9, f10, this.rf.co2eqghgaero.get(2300), f7, f8, this.car.co2atppm.get(2300), f11, f12, this.tem.avchangeby.get(2300), this.sl.total.get(2100), this.sl.total.get(2300)};
                this.indics = this.indics + string + "\t";
                for (float f13 : fArray) {
                    this.indics = this.indics + " \t" + f13;
                }
                this.indics = this.indics + "\n";
                this.descriptions = this.descriptions + "\n======== " + scenarios2.name() + " ========\n" + scenarios2.info + "\n";
            }
        }
        for (curveset curveset3 : this.curvemap.keySet()) {
            lineplot lineplot2 = (lineplot)this.plot(curveset3);
            lineplot2.xscale.min = n;
            lineplot2.xscale.max = n2;
            lineplot2.xscale.units.scales = 100.0;
            lineplot2.xscale.changed = true;
            showpan.toFront(lineplot2);
            lineplot2.doplot();
            this.checkready();
            imagesaver.saveimage((Component)lineplot2, "png", new File("jcmout" + this.fs + "results" + this.fs + curveset3.name + ".png"));
            datable.savetable(new File("jcmout" + this.fs + "results" + this.fs + curveset3.name + ".dat"), curveset3, "tab");
            this.checkready();
        }
        fileio.savetextfile("jcmout" + this.fs + "results" + this.fs + "descriptions.txt", this.descriptions);
        fileio.savetextfile("jcmout" + this.fs + "results" + this.fs + "indicators.csv", this.indics);
        this.end();
        report.log("End of script swinf_global");
    }

    void checkready() {
        try {
            while (this.stab.running) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkbutandsleep(500);
    }

    float ro(float f) {
        return (float)Math.round(f / 100.0f) / 10.0f;
    }

    static enum scenarios {
        fiftypc2050_2C(colfont.blue, new Object[]{stabilisation.indicators.define_emit, "dummy", 12345}),
        fiftypc2050_15C(colfont.green, new Object[0]),
        stabtemp_225C_2C(colfont.red, new Object[0]),
        stabtemp_2C(colfont.purple, new Object[0]),
        stabtemp_2C_175C(colfont.cyan, new Object[0]),
        stabtemp_15C(colfont.dkgreen, new Object[0]),
        stabCO2eq500(colfont.brown, new Object[0]),
        stabCO2eq450(colfont.orange, new Object[0]);

        Color col;
        String info;
        Object[] params;

        private scenarios(Color color, Object ... objectArray) {
            this.col = color;
            for (Object object : this.params = objectArray) {
                report.deb(object.toString());
            }
        }
    }
}

