/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.par.param;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.script.calcscript;

public class oxf15_global
extends calcscript {
    globco2emit gc = this.gm(globco2emit.class);
    carboncycle car = this.gm(carboncycle.class);
    glotemp tem = this.gm(glotemp.class);
    radfor rf = this.gm(radfor.class);
    stabilisation stab = this.gm(stabilisation.class);
    shares sha = this.gm(shares.class);
    pledges ple = this.gm(pledges.class);
    emitquota eq = this.gm(emitquota.class);
    sealevel sl = this.gm(sealevel.class);
    controller con = this.gm(controller.class);
    Map<curveset, Object> curvemap = new HashMap<curveset, Object>();
    param[] scenparam;
    String indics;
    String descriptions;

    public oxf15_global() {
        this.scenparam = new param[]{this.stab.indicator};
        this.indics = " Scenario\t\t Emit CO2eq 2020 \t Emit CO2eq  2030 \t Emit CO2eq  2050 \t Emit CO2eq  2100  \t Emit CO2 2020 \t Emit CO2  2030 \t Emit CO2  2050 \t Emit CO2  2100  \t IntegCO2eq 2050 \t IntegCO2eq 2250  \t IntegCO2 2050 \t IntegCO2 2250  \t Decline_CO2eq \t Decline_CO2 \t Peak CO2eq-conc \t year \t CO2eq-conc 2250\t Peak CO2-conc \t year \t CO2-conc 2250\t Peak Temperature \t year \t Temperature 2250\t Sea-level-rise 2100 \t Sea-level-rise 2250 \n";
        this.descriptions = "Scenario Descriptions\n";
    }

    @Override
    public void run() {
        lookandfeel.fontSize.set(18);
        this.link(this.tem.temp);
        this.link(this.car.conc);
        this.link(this.sl.sealevel);
        curvar curvar2 = new curvar(curve.Type.integral, this.gc.co2eqcurves);
        this.link(curvar2);
        int n = 1950;
        int n2 = 2250;
        this.curvemap.put(new curveset("fossil_CO2_emissions", "mega&ton&carbon", n, n2, 1), this.gc.fossil);
        this.curvemap.put(new curveset("CO2eq_emissions", "mega&ton&co2eq", n, n2, 1), new curve[]{this.gc.co2eqtot, this.gc.co2fos});
        this.curvemap.put(new curveset("CO2eq_emissions_integral", "giga&ton&co2eq", n, n2, 1), curvar2.getcurve(this.gc.co2eqtot.name));
        this.curvemap.put(new curveset("CO2 concentration", "ppm&co2", n, n2, 1), this.car.co2atppm);
        this.curvemap.put(new curveset("CO2eq concentration all_gases+aerosols", "ppm&co2eq", n, n2, 1), new curve[]{this.rf.co2eqghgaero, this.car.co2atppm});
        this.curvemap.put(new curveset("RF allgas+aeros", "w&per&m2", n, n2, 1), this.rf.totalrf);
        this.curvemap.put(new curveset("Temperature", "Global Avg Temperature \u00baC&above&1835-65", n, n2, 1), this.tem.avchangeby);
        this.curvemap.put(new curveset("Sea-Level", "metres", n, n2, 1), this.sl.total);
        this.con.botuptopdo.set(controller.butd.start_bottom_up);
        this.sha.distribution.set(shares.distriboptions.convergence);
        this.ple.level.set(pledges.pledgelevel.mixed);
        for (scenarios scenarios2 : scenarios.values()) {
            int n3;
            this.checkready();
            this.stab.indicator.set(stabilisation.indicators.stabconc);
            loop.gonow(false);
            this.checkready();
            report.log("Setting parameters for " + scenarios2.name());
            switch (scenarios2) {
                case A_StabTemp15: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2075);
                    this.stab.stabtemplevel.set(1.5);
                    this.con.startyear_topdown.set(2016);
                    break;
                }
                case B_Peak175_Drop15: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(true);
                    this.stab.stabyear.set(2075);
                    this.stab.stabtemplevel.set(1.75);
                    this.stab.stabtempend.set(1.5);
                    this.con.startyear_topdown.set(2020);
                    break;
                }
                case C_StabTemp175: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2075);
                    this.stab.stabtemplevel.set(1.75);
                    this.con.startyear_topdown.set(2020);
                    break;
                }
                case D_Peak20_Drop15: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(true);
                    this.stab.stabyear.set(2075);
                    this.stab.stabtemplevel.set(2.0);
                    this.stab.stabtempend.set(1.5);
                    this.con.startyear_topdown.set(2030);
                    break;
                }
                case E_StabTemp20: {
                    this.stab.indicator.set(stabilisation.indicators.stabtemp);
                    this.stab.peaking.set(false);
                    this.stab.stabyear.set(2075);
                    this.stab.stabtemplevel.set(2.0);
                    this.con.startyear_topdown.set(2030);
                }
            }
            this.checkready();
            loop.gonow(false);
            this.checkready();
            Color color = scenarios2.col;
            String string = scenarios2.name();
            for (curveset curveset2 : this.curvemap.keySet()) {
                try {
                    if (this.curvemap.get(curveset2) instanceof curve) {
                        curveset2.addcurve(((curve)this.curvemap.get(curveset2)).cloneIndependent(n, n2, 1, string, color));
                    }
                    if (!(this.curvemap.get(curveset2) instanceof curve[])) continue;
                    curve[] curveArray = (curve[])this.curvemap.get(curveset2);
                    for (n3 = 0; n3 < curveArray.length; ++n3) {
                        curve curve2 = curveArray[n3].cloneIndependent(n, n2, 1, string + "_" + n3, color);
                        curve2.style = curve.linestyle.values()[n3 % curve.linestyle.values().length];
                        curveset2.addcurve(curve2);
                    }
                }
                catch (Exception exception) {
                    report.deb(exception);
                    exception.printStackTrace();
                }
            }
            float f = 0.0f;
            for (int i = 2001; i <= 2050; ++i) {
                f += this.gc.co2eqtot.get(i);
            }
            float f2 = f;
            for (int i = 2051; i <= 2250; ++i) {
                f2 += this.gc.co2eqtot.get(i);
            }
            float i = 0.0f;
            for (n3 = 2001; n3 <= 2050; ++n3) {
                i += this.gc.co2fos.get(n3);
            }
            float f3 = i;
            for (int j = 2051; j <= 2250; ++j) {
                f3 += this.gc.co2fos.get(j);
            }
            float f4 = 100.0f * (1.0f - (float)Math.pow(this.gc.co2eqtot.get(2045) / this.gc.co2eqtot.get(2025), 0.05f));
            float f5 = 100.0f * (1.0f - (float)Math.pow(this.gc.co2fos.get(2045) / this.gc.co2fos.get(2025), 0.05f));
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            for (int j = 2040; j < 2250; ++j) {
                if (this.car.co2atppm.get(j) > f6) {
                    f6 = this.car.co2atppm.get(j);
                    f7 = j;
                }
                if (this.rf.co2eqghgaero.get(j) > f8) {
                    f8 = this.rf.co2eqghgaero.get(j);
                    f9 = j;
                }
                if (!(this.tem.avchangeby.get(j) > f10)) continue;
                f10 = this.tem.avchangeby.get(j);
                f11 = j;
            }
            float[] fArray = new float[]{this.ro(this.gc.co2eqtot.get(2020)), this.ro(this.gc.co2eqtot.get(2030)), this.ro(this.gc.co2eqtot.get(2050)), this.ro(this.gc.co2eqtot.get(2100)), this.ro(this.gc.co2fos.get(2020)), this.ro(this.gc.co2eqtot.get(2030)), this.ro(this.gc.co2fos.get(2050)), this.ro(this.gc.co2fos.get(2100)), this.ro(f), this.ro(f2), this.ro(i), this.ro(f3), f4, f5, f8, f9, this.rf.co2eqghgaero.get(2250), f6, f7, this.car.co2atppm.get(2250), f10, f11, this.tem.avchangeby.get(2250), this.sl.total.get(2100), this.sl.total.get(2250)};
            this.indics = this.indics + string + "\t";
            for (float f12 : fArray) {
                this.indics = this.indics + " \t" + f12;
            }
            this.indics = this.indics + "\n";
            this.descriptions = this.descriptions + "\n======== " + scenarios2.name() + " ========\n" + scenarios2.info + "\n";
        }
        String string = "jcmout" + this.fs + "results" + this.fs + "oxford15" + this.fs;
        for (curveset curveset3 : this.curvemap.keySet()) {
            lineplot lineplot2 = (lineplot)this.plot(curveset3);
            lineplot2.xscale.min = n;
            lineplot2.xscale.max = n2;
            lineplot2.xscale.units.scales = 100.0;
            lineplot2.xscale.changed = true;
            if (curveset3.name.startsWith("Temp")) {
                lineplot2.yscale.max = 2.15;
                lineplot2.yscale.changed = true;
                lineplot2.yscale.units.allowfac = false;
            }
            showpan.toFront(lineplot2);
            lineplot2.doplot();
            this.checkready();
            imagesaver.saveimage((Component)lineplot2, "png-transparent", new File(string + curveset3.name + ".png"));
            datable.savetable(new File(string + curveset3.name + ".dat"), curveset3, "tab");
            this.checkready();
        }
        fileio.savetextfile(string + "descriptions.txt", this.descriptions);
        fileio.savetextfile(string + this.fs + "indicators.csv", this.indics);
        this.end();
        report.log("End of script oxf15_global");
    }

    void checkready() {
        try {
            while (this.stab.running) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkbutandsleep(500);
    }

    float ro(float f) {
        return (float)Math.round(f / 100.0f) / 10.0f;
    }

    static enum scenarios {
        A_StabTemp15(colfont.blue, new Object[0]),
        B_Peak175_Drop15(colfont.green, new Object[0]),
        C_StabTemp175(colfont.yellow, new Object[0]),
        D_Peak20_Drop15(colfont.orange, new Object[0]),
        E_StabTemp20(colfont.red, new Object[0]);

        Color col;
        String info;
        Object[] params;

        private scenarios(Color color, Object ... objectArray) {
            this.col = color;
            for (Object object : this.params = objectArray) {
                report.deb(object.toString());
            }
        }
    }
}

