/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.units;
import jcm.core.loop;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.obj.regset;
import jcm.mod.resp.attribTracer;
import jcm.script.calcscript;

public class contribtemp
extends calcscript {
    berncarbon bc = this.gm(berncarbon.class);
    carboncycle cc = this.gm(carboncycle.class);
    CalcLucEmit cl = this.gm(CalcLucEmit.class);
    attribTracer rs = this.gm(attribTracer.class);
    curveset curves1 = new curveset("Brazil. relative", 1850, 2005, 5);
    curveset curves2 = new curveset("USA relative", 1850, 2005, 5);
    curveset curves3 = new curveset("India relative", 1850, 2005, 5);
    curve tot = new curve("surftemp", "degcbase");
    curve r1 = new curve(new Object[0]);
    curve r2 = new curve(new Object[0]);
    curve r3 = new curve(new Object[0]);
    String p = "";
    region regset;

    @Override
    public void run() {
        this.link(this.rs.surftemp);
        this.gm(regset.class).regions.choose(regman.allreg.findreg("JCM25"));
        this.regset = (region)this.gm(regset.class).regions.chosen;
        for (String string : CalcLucEmit.lucsources) {
            this.cl.lucsource.set(string);
            if (this.cl.lucsource.chosen.equals("Houghton")) {
                for (double d = 1700.0; d <= 2500.0; d += 458.0) {
                    this.cl.landuseemit1990.set(d);
                    report.log("Houghton emission in 2000 " + d);
                    this.calc();
                }
                continue;
            }
            if (!this.cl.lucsource.chosen.equals("IVIGmodel")) continue;
            for (LUCdata.biomeclassification biomeclassification2 : LUCdata.biomeclassification.values()) {
                this.cl.biomeclass.set(biomeclassification2);
                report.log("IVIGmodel land use " + (Object)((Object)biomeclassification2));
                for (double d = 0.8; d <= 1.2; d += 0.2) {
                    this.cl.vegcerror.set(d);
                    report.log("-veg carbon error " + d);
                    for (double d2 = 0.1; d2 <= 0.3; d2 += 0.1) {
                        this.cl.soillossagric.set(d2);
                        report.log("-agric soil loss " + d2);
                        for (double d3 = 0.05; d3 <= 0.1; d3 += 0.025) {
                            this.cl.soillosspast.set(d3);
                            report.log(" past soil loss " + d3);
                            this.p = units.round(d, 1.0, 1) + " " + units.round(d2, 1.0, 1) + " " + units.round(d3, 1.0, 2) + "_";
                            this.calc();
                        }
                    }
                }
            }
        }
        this.plot(this.curves2);
        this.plot(this.curves3);
        this.end();
        report.log("End of script contribtemp");
        this.cl.lucsource.choose("IVIGmodel");
    }

    public void calc() {
        for (double d = 0.56; d >= 0.0; d -= 0.28) {
            this.bc.beta.set(d);
            for (double d2 = 1.0; d2 <= 1.6; d2 += 0.3) {
                this.bc.respq10.set(d2);
                for (double d3 = 1.75; d3 >= 0.5; d3 -= 0.5) {
                    this.bc.diffufac.set(d3);
                    this.checkbut();
                    loop.gonow(false);
                    String string = units.round(this.cc.error, 1.0, 0);
                    String string2 = " ";
                    string2 = this.cl.lucsource.chosen.equals("IVIGmodel") ? "-" + ((LUCdata.biomeclassification)((Object)this.cl.biomeclass.chosen)).name() + "_" + this.p : "_" + this.cl.landuseemit1990.getval() + "_";
                    String string3 = this.cl.lucsource.chosen + string2 + string + "_" + d + " " + d2 + " " + d3;
                    if (this.cc.error <= 700.0) {
                        this.report(string3);
                        for (int i = 1850; i <= 2005; ++i) {
                            this.tot.set(i, 0.0f);
                        }
                        for (region region2 : this.regset.reg) {
                            for (int i = 1850; i <= 2005; ++i) {
                                this.tot.set(i, this.tot.get(i) + this.rs.surftemp.get(region2, i));
                            }
                        }
                        for (int i = 1850; i <= 2005; ++i) {
                            this.r1.set(i, this.rs.surftemp.get(this.regset.findreg("Brazil."), i) * 100.0f / this.tot.get(i));
                            this.r2.set(i, this.rs.surftemp.get(this.regset.findreg("United States"), i) * 100.0f / this.tot.get(i));
                            this.r3.set(i, this.rs.surftemp.get(this.regset.findreg("India"), i) * 100.0f / this.tot.get(i));
                        }
                        Color color = Color.black;
                        try {
                            color = new Color(255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 0 : 1), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? 1 : 0), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? 0 : 1), (int)(5000.0 / (this.cc.error - 450.0)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.curves1.addcurve(this.r1.cloneIndependent(1850, 2005, 5, string3, color));
                        this.curves2.addcurve(this.r2.cloneIndependent(1850, 2005, 5, string3, color));
                        this.curves3.addcurve(this.r3.cloneIndependent(1850, 2005, 5, string3, color));
                        continue;
                    }
                    report.log(string3 + " Bypassed, error > 700!");
                }
            }
        }
    }
}

