/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.baseplot;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.berncarbon;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.cli.udebclimod;
import jcm.mod.energy.enerData;
import jcm.mod.energy.enerGeneral;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresimgdata;
import jcm.mod.socio.popgdp;
import jcm.script.calcscript;

public class brazil_sensanal
extends calcscript {
    globco2emit gc = this.gm(globco2emit.class);
    berncarbon carb = this.gm(berncarbon.class);
    udebclimod cli = this.gm(udebclimod.class);
    glotemp tem = this.gm(glotemp.class);
    radfor rf = this.gm(radfor.class);
    stabilisation stab = this.gm(stabilisation.class);
    shares sha = this.gm(shares.class);
    pledges ple = this.gm(pledges.class);
    emitquota eq = this.gm(emitquota.class);
    sealevel sl = this.gm(sealevel.class);
    controller co = this.gm(controller.class);
    sresBase bs = this.gm(sresBase.class);
    enerGeneral ea = this.gm(enerGeneral.class);
    int sy = 1990;
    int ey = 2070;
    List<region> regforplot = new ArrayList<region>();
    Map<curveset, Object> curvemap = new LinkedHashMap<curveset, Object>();
    Map<curveset, Float> curveymax = new LinkedHashMap<curveset, Float>();
    Map<curveset, curveset> avg = new LinkedHashMap<curveset, curveset>();
    Map<Object, Color[]> colormap = new LinkedHashMap<Object, Color[]>();
    String[] regplot = new String[0];
    int weightneeded = 7;
    scenario[] globscen = new scenario[]{scenario.stabtemp_2C, scenario.fiftypc2050_2C, scenario.stabconc450};
    scenario[] carbon = new scenario[]{scenario.carbdefault, scenario.highfb, scenario.lowfb, scenario.fastoc, scenario.slowoc};
    scenario[] climod = new scenario[]{scenario.AR4_average, scenario.HadGEM1, scenario.MIROC3_2_MED, scenario.ECHAM5_MPIOM, scenario.HadCM3, scenario.CSIRO_Mk3, scenario.GISS_EH};
    scenario[] pledgescen = new scenario[]{scenario.cond_pledge, scenario.uncond_pledge, scenario.nopledge};
    scenario[] basescen = new scenario[]{scenario.SRES_B2, scenario.WEO_NP_B2, scenario.SRES_A1B, scenario.WEO_NP_A1B};
    scenario[] gdp = new scenario[]{scenario.gdp_low, scenario.gdp_mid, scenario.gdp_high};
    scenario[] cvy = new scenario[]{scenario.cv_50, scenario.cv_65, scenario.cv_80};
    scenario[] cvg = new scenario[]{scenario.cv_partav, scenario.cv_globav};
    scenario[] cvi = new scenario[]{scenario.cv_percap, scenario.cv_pergdp};
    scenario[] rrb = new scenario[]{scenario.rrb_0, scenario.rrb_10, scenario.rrb_15, scenario.rrb_20, scenario.rrb_30};
    scenario[][] sets = new scenario[][]{this.globscen, this.carbon, this.climod, this.pledgescen, this.basescen, this.gdp, this.cvy, this.cvg, this.cvi, this.rrb};
    int globi = 0;
    int carbi = 1;
    int climi = 2;
    int focus = -1;
    int nsets = this.sets.length;
    int nscen = scenario.values().length;
    int[] ci = new int[this.nsets];
    int[] pi = new int[this.nsets];
    int nadd = 0;
    int nskip = 0;
    int nnosense = 0;
    EnumMap<scenario, Integer> ninc = new EnumMap(scenario.class);

    void setscen(scenario scenario2) {
        report.deb(" =>" + scenario2.name() + ": ");
        switch (scenario2) {
            case stabtemp_2C: {
                this.stab.indicator.set(stabilisation.indicators.stabtemp);
                this.stab.peaking.set(false);
                this.stab.stabyear.set(2125);
                this.stab.stabtemplevel.set(2.0);
                break;
            }
            case stabconc450: {
                this.stab.indicator.set(stabilisation.indicators.stabconc);
                this.stab.stabconclevel.set(450);
                this.stab.peaking.set(false);
                this.stab.stabyear.set(2100);
                this.stab.curveopt.set(stabilisation.curvetype.padequintic);
                break;
            }
            case fiftypc2050_2C: {
                this.stab.indicator.set(stabilisation.indicators.define_emit);
                this.stab.stabemityear.set(2050);
                this.stab.peaking.set(true);
                this.stab.stabemitlevel.set(3500);
                this.stab.stabemitendlevel.set(250);
                this.stab.stabemitdeclinerate.set(1.1);
                break;
            }
            case AR4_average: {
                this.cli.climod.set(udebclimod.gcm.AR4_average);
                break;
            }
            case HadGEM1: {
                this.cli.climod.set(udebclimod.gcm.HadGEM1);
                break;
            }
            case MIROC3_2_MED: {
                this.cli.climod.set(udebclimod.gcm.MIROC3_2_MED);
                break;
            }
            case ECHAM5_MPIOM: {
                this.cli.climod.set(udebclimod.gcm.ECHAM5_MPIOM);
                break;
            }
            case HadCM3: {
                this.cli.climod.set(udebclimod.gcm.HadCM3);
                break;
            }
            case CSIRO_Mk3: {
                this.cli.climod.set(udebclimod.gcm.CSIRO_Mk3);
                break;
            }
            case GISS_EH: {
                this.cli.climod.set(udebclimod.gcm.GISS_EH);
                break;
            }
            case carbdefault: {
                this.carb.beta.set(0.5);
                this.carb.respq10.set(1.4);
                this.carb.diffufac.set(1.0);
                break;
            }
            case highfb: {
                this.carb.beta.set(0.6);
                this.carb.respq10.set(2.0);
                this.carb.diffufac.set(1.0);
                break;
            }
            case lowfb: {
                this.carb.beta.set(0.4);
                this.carb.respq10.set(1.0);
                this.carb.diffufac.set(1.0);
                break;
            }
            case fastoc: {
                this.carb.beta.set(0.5);
                this.carb.respq10.set(1.4);
                this.carb.diffufac.set(1.25);
                break;
            }
            case slowoc: {
                this.carb.beta.set(0.5);
                this.carb.respq10.set(1.4);
                this.carb.diffufac.set(0.75);
                break;
            }
            case cond_pledge: {
                this.ple.usepledges.set(true);
                this.ple.level.set(pledges.pledgelevel.conditional);
                this.ple.kyoto.set(pledges.kyoto_opts.Kyoto_targets_excUSA_prolonged);
                this.co.botuptopdo.set(controller.butd.start_bottom_up);
                this.ea.WEOscenario.set(enerData.WEO_scenario.New_Policies);
                this.sha.smoothjumpbase.set(shares.smoothbaseopt.intensity_based);
                break;
            }
            case uncond_pledge: {
                this.ple.usepledges.set(true);
                this.ple.level.set(pledges.pledgelevel.unconditional);
                this.ple.kyoto.set(pledges.kyoto_opts.real_emissions);
                this.co.botuptopdo.set(controller.butd.start_bottom_up);
                this.ea.WEOscenario.set(enerData.WEO_scenario.New_Policies);
                this.sha.smoothjumpbase.set(shares.smoothbaseopt.intensity_based);
                break;
            }
            case nopledge: {
                this.ple.usepledges.set(false);
                this.ple.kyoto.set(pledges.kyoto_opts.real_emissions);
                this.co.botuptopdo.set(controller.butd.top_down_only);
                this.ea.WEOscenario.set(enerData.WEO_scenario.Current_Policies);
                this.sha.smoothjumpbase.set(shares.smoothbaseopt.no_smooth);
                break;
            }
            case WEO_NP_B2: {
                this.bs.useWEO.set(true);
                this.bs.scenario.set(sresimgdata.scen.B2);
                break;
            }
            case WEO_NP_A1B: {
                this.bs.useWEO.set(true);
                this.bs.scenario.set(sresimgdata.scen.A1B);
                break;
            }
            case SRES_B2: {
                this.bs.useWEO.set(false);
                this.bs.scenario.set(sresimgdata.scen.B2);
                break;
            }
            case SRES_A1B: {
                this.bs.useWEO.set(false);
                this.bs.scenario.set(sresimgdata.scen.A1B);
                break;
            }
            case rrb_0: {
                this.sha.dc_reduction.set(0);
                break;
            }
            case rrb_10: {
                this.sha.dc_reduction.set(0.7);
                break;
            }
            case rrb_15: {
                this.sha.dc_reduction.set(1.1);
                break;
            }
            case rrb_20: {
                this.sha.dc_reduction.set(1.5);
                break;
            }
            case rrb_30: {
                this.sha.dc_reduction.set(2.35);
                break;
            }
            case cv_50: {
                this.sha.convergey.set(2050);
                break;
            }
            case cv_65: {
                this.sha.convergey.set(2065);
                break;
            }
            case cv_80: {
                this.sha.convergey.set(2080);
                break;
            }
            case cv_globav: {
                this.sha.emitlim.set(shares.emitthreshold.worldemitpercap);
                break;
            }
            case cv_partav: {
                this.sha.emitlim.set(shares.emitthreshold.particip_emitpercap);
                break;
            }
            case cv_percap: {
                this.sha.conv_criteria.set(shares.convcrit.emissionspercapita);
                break;
            }
            case cv_pergdp: {
                this.sha.conv_criteria.set(shares.convcrit.emissionspergdp);
                break;
            }
            case gdp_low: {
                this.sha.axb_gdp_threshold.set(15000);
                break;
            }
            case gdp_mid: {
                this.sha.axb_gdp_threshold.set(20000);
                break;
            }
            case gdp_high: {
                this.sha.axb_gdp_threshold.set(25000);
            }
        }
    }

    @Override
    public void run() {
        int n;
        this.setup();
        for (n = 0; n < this.nsets; ++n) {
            this.ci[n] = 0;
            this.pi[n] = -1;
        }
        n = this.nsets - 1;
        block1: while (true) {
            this.setscen(n);
            int n2 = n = this.nsets - 1;
            this.ci[n2] = this.ci[n2] + 1;
            while (true) {
                if (this.ci[n] != this.sets[n].length) continue block1;
                this.ci[n] = 0;
                if (--n < 0) break block1;
                int n3 = n;
                this.ci[n3] = this.ci[n3] + 1;
            }
            break;
        }
        report.log("\n=========================================\nadded " + this.nadd + " skipped " + this.nskip + " no-sense " + this.nnosense + " \n");
        String string = "";
        for (scenario scenario2 : scenario.values()) {
            string = string + " " + (Object)((Object)scenario2) + ": " + this.ninc.get((Object)scenario2);
        }
        report.log(string);
        this.makeav();
        this.savefiles();
        this.end();
        report.log("End of script braz_sensanal");
    }

    void setscen(int n) {
        int n2;
        String string = "";
        int n3 = 0;
        Color[] colorArray = new Color[this.nsets];
        boolean bl = this.globscen[this.ci[this.globi]] == scenario.stabtemp_2C || this.globscen[this.ci[this.globi]] == scenario.stabconc450 && this.climod[this.ci[this.climi]] == scenario.AR4_average || this.climod[this.ci[this.climi]] == scenario.AR4_average && this.carbon[this.ci[this.carbi]] == scenario.carbdefault;
        for (n2 = 0; n2 < this.nsets; ++n2) {
            scenario scenario2 = this.sets[n2][this.ci[n2]];
            string = string + (n2 > 0 ? "_" : "") + scenario2.name();
            colorArray[n2] = scenario2.col;
            n3 = (int)((float)n3 + scenario2.weight);
        }
        int n4 = n2 = bl && n3 >= this.weightneeded ? 1 : 0;
        if (n2 != 0) {
            int n5;
            ++this.nadd;
            report.deb("\n === ADD " + this.nadd + ":  " + string + " ===\n");
            for (n5 = 0; n5 < this.nsets; ++n5) {
                if (this.ci[n5] == this.pi[n5]) continue;
                this.setscen(this.sets[n5][this.ci[n5]]);
            }
            for (n5 = 0; n5 < this.nsets; ++n5) {
                this.pi[n5] = this.ci[n5];
            }
            this.addcurves(string, colorArray);
            for (n5 = 0; n5 < this.nsets; ++n5) {
                this.ninc.put(this.sets[n5][this.ci[n5]], this.ninc.get((Object)this.sets[n5][this.ci[n5]]) + 1);
            }
        }
        if (n2 == 0 && bl) {
            ++this.nskip;
        }
        if (!bl) {
            ++this.nnosense;
        }
    }

    void setup() {
        loop.checkperform.set(true);
        lookandfeel.fontSize.set(18);
        this.gm(regset.class).regions.set(regman.allreg.findreg("JCM16"));
        loop.gonow(false);
        this.checkready(500);
        curvar curvar2 = new curvar(curve.Type.ratio, this.eq.emitfos_unitsCO2, this.gm(popgdp.class).pop);
        this.link(curvar2);
        lineplot lineplot2 = (lineplot)this.plot(curvar2);
        lineplot2.xscale.min = this.sy;
        lineplot2.xscale.max = this.ey;
        lineplot2.xscale.units.scales = 10.0;
        lineplot2.xscale.changed = true;
        showpan.toFront(lineplot2);
        lineplot2.doplot();
        this.checkready(500);
        this.link(this.tem.temp);
        this.link(this.eq.emitequiv);
        this.checkready(500);
        this.stab.indicator.set(stabilisation.indicators.stabconc);
        loop.gonow(false);
        this.checkready(500);
        for (String string : this.regplot) {
            this.regforplot.add(regman.allreg.findreg(string));
        }
        Object[] objectArray = new curveset[]{this.eq.emitfos_unitsCO2, this.eq.emitequiv, curvar2};
        report.deb("\n\n" + curvar2.name + " " + curvar2.units + "\n\n");
        for (Object object : objectArray) {
            this.curvemap.put(new curveset(((curveset)object).name, ((curveset)object).units, this.sy, this.ey, 1), object);
            for (region region2 : this.regforplot) {
                curve curve2 = ((curveset)object).getcurve(region2);
                this.curvemap.put(new curveset(region2.name + "_" + ((curveset)object).name, ((curveset)object).units, this.sy, this.ey, 1), curve2);
            }
            this.avg.put((curveset)object, new curveset(((curveset)object).name + "_average", ((curveset)object).units, this.sy, this.ey, 1));
        }
        this.curveymax.put(this.eq.emitfos_unitsCO2, Float.valueOf(12000.0f));
        this.curveymax.put(this.eq.emitequiv, Float.valueOf(14000.0f));
        this.curveymax.put(curvar2, Float.valueOf(21.0f));
        for (scenario scenario2 : scenario.values()) {
            this.ninc.put(scenario2, 0);
        }
    }

    void addcurves(String string, Color[] colorArray) {
        loop.gonow(false);
        this.checkready(200);
        report.log("start add curve");
        this.colormap.put(string, colorArray);
        for (curveset curveset2 : this.curvemap.keySet()) {
            try {
                infob infob2;
                Object object = this.curvemap.get(curveset2);
                if (object instanceof curve) {
                    infob2 = (curve)object;
                    curveset2.addcurve(((curve)infob2).cloneIndependent(this.sy, this.ey, 1, string, this.palecol(this.mixcol(colorArray), 32)));
                }
                if (!(object instanceof curveset)) continue;
                infob2 = (curveset)object;
                curveset curveset3 = this.avg.get(infob2);
                for (Object object2 : ((curveset)infob2).map.keySet()) {
                    curve curve2 = ((curveset)infob2).getcurve(object2);
                    curveset2.addcurve(curve2.cloneIndependent(this.sy, this.ey, 1, curve2.name + "_" + string, this.palecol(curve2.color, 16)));
                    if (!curveset3.map.containsKey(object2)) {
                        curveset3.addNewCurve(object2);
                        for (int i = this.sy; i < this.ey; ++i) {
                            curveset3.set(object2, i, 0.0f);
                        }
                    }
                    float[] fArray = curveset3.getcurve(object2).geta();
                    for (int i = this.sy; i <= this.ey; ++i) {
                        int n = i - this.sy;
                        fArray[n] = fArray[n] + curve2.get(i);
                    }
                }
            }
            catch (Exception exception) {
                report.deb(exception);
                exception.printStackTrace();
            }
        }
    }

    void makeav() {
        for (curveset curveset2 : this.avg.keySet()) {
            Object object;
            curveset curveset3 = this.avg.get(curveset2);
            for (Object object2 : curveset2.map.keySet()) {
                object = curveset3.getcurve(object2).geta();
                for (int i = this.sy; i <= this.ey; ++i) {
                    int n = i - this.sy;
                    object[n] = object[n] / (float)this.nadd;
                }
            }
            for (curveset curveset4 : this.curvemap.keySet()) {
                if (this.curvemap.get(curveset4) != curveset2) continue;
                object = curveset3.map.keySet().iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    curve curve2 = curveset3.getcurve(e);
                    curveset4.addcurve(curve2);
                }
            }
            this.curvemap.put(curveset3, curveset2);
        }
    }

    void savefiles() {
        baseplot.hidelegend = true;
        for (curveset curveset2 : this.curvemap.keySet()) {
            try {
                lineplot lineplot2 = (lineplot)this.plot(curveset2);
                lineplot2.xscale.min = this.sy;
                lineplot2.xscale.max = this.ey;
                lineplot2.xscale.units.scales = 10.0;
                lineplot2.xscale.changed = true;
                lineplot2.yscale.min = 0.0;
                if (this.curveymax.containsKey(this.curvemap.get(curveset2))) {
                    lineplot2.yscale.max = this.curveymax.get(this.curvemap.get(curveset2)).floatValue();
                }
                lineplot2.yscale.changed = true;
                if (this.curvemap.get(curveset2) instanceof curve) {
                    for (int i = 0; i < this.nsets; ++i) {
                        for (Object object : this.colormap.keySet()) {
                            curveset2.getcurve((Object)object).color = this.palecol(this.colormap.get(object)[i], 32);
                        }
                        this.save(lineplot2, curveset2.name + "_" + i);
                    }
                    for (Object object : this.colormap.keySet()) {
                        curveset2.getcurve((Object)object).color = this.palecol(this.mixcol(this.colormap.get(object)), 32);
                    }
                }
                this.save(lineplot2, curveset2.name);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void save(lineplot lineplot2, String string) {
        this.checkready(500);
        showpan.toFront(lineplot2);
        this.checkready(1000);
        lineplot2.doplot();
        this.checkready(500);
        String string2 = "jcmout" + this.fs + "results" + this.fs + "brazil" + this.fs;
        imagesaver.saveimage((Component)lineplot2, "png", new File(string2 + string + ".png"));
        this.checkready(500);
    }

    void checkready(int n) {
        try {
            while (this.stab.running) {
                Thread.currentThread();
                Thread.sleep(n);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkbutandsleep(n);
    }

    float ro(float f) {
        return (float)Math.round(f / 100.0f) / 10.0f;
    }

    Color mixcol(Color ... colorArray) {
        int n = colorArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += colorArray[i].getRed();
            n3 += colorArray[i].getGreen();
            n4 += colorArray[i].getBlue();
        }
        return new Color(n2 / n, n3 / n, n4 / n);
    }

    Color palecol(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    static enum scenario {
        stabtemp_2C(colfont.blue),
        fiftypc2050_2C(colfont.green, 2.0f),
        stabconc450(colfont.yellow, 1.0f),
        carbdefault(colfont.black),
        highfb(colfont.brown),
        lowfb(colfont.green),
        fastoc(colfont.blue),
        slowoc(colfont.purple),
        AR4_average(colfont.black),
        HadGEM1(colfont.red),
        MIROC3_2_MED(colfont.orange),
        ECHAM5_MPIOM(colfont.yellow),
        HadCM3(colfont.green),
        CSIRO_Mk3(colfont.cyan),
        GISS_EH(colfont.blue),
        cond_pledge(colfont.blue),
        uncond_pledge(colfont.green),
        nopledge(colfont.red),
        SRES_B2(colfont.yellow, 1.0f),
        WEO_NP_B2(colfont.green),
        SRES_A1B(colfont.red),
        WEO_NP_A1B(colfont.blue, 1.0f),
        gdp_low(colfont.green),
        gdp_mid(colfont.yellow, 1.0f),
        gdp_high(colfont.red),
        cv_50(colfont.blue),
        cv_65(colfont.yellow, 1.0f),
        cv_80(colfont.red, -1.0f),
        cv_partav(colfont.blue, 1.0f),
        cv_globav(colfont.magenta),
        cv_percap(colfont.cyan, 1.0f),
        cv_pergdp(colfont.yellow),
        rrb_0(colfont.red),
        rrb_10(colfont.orange, 1.0f),
        rrb_15(colfont.yellow, 2.0f),
        rrb_20(colfont.green, 1.0f),
        rrb_30(colfont.cyan);

        Color col;
        String info;
        float weight;

        private scenario(Color color) {
            this(color, 0.0f);
        }

        private scenario(Color color, float f) {
            this.col = color;
            this.weight = f;
        }
    }
}

