/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.mod.socio.demog;

public class migration
extends module {
    static String[] periods = new String[]{"1960s", "1970s", "1980s", "1990s", "1990_95", "1995_00", "2000_05", "2005_10"};
    boolean gotdata = false;
    static Map<Integer, String> tabcode = new HashMap<Integer, String>();
    static Map<String, region> codereg = new HashMap<String, region>();
    static Map<region, Integer> regref = new TreeMap<region, Integer>();
    static int[][][] mfd;
    int migsy = 1963;
    int migey = 2203;
    int migstep = 5;
    public curveset migflow = new curveset("Migration Flows", "people moved in 5yrs", this.migsy, this.migey, 5);
    public curveset netmig = new curveset("net mign by country ", "kilo&person&per&year", this.migsy, this.migey, 5);
    public param csy = new param("start converge mign", "year", 2050, 2010, 2100, 5);
    public param cey = new param("end converge mign", "year", 2150, 2010, this.migey, 5);
    public param<region> countryview;
    public param<migopts> migopt = new param(new Object[]{"fut mign type", migopts.values(), migopts.constrate});
    public param<miglevs> miglev = new param(new Object[]{"fut mign level", miglevs.values(), miglevs.med});
    demog pop;

    @Override
    public void initsetup() {
        if (!this.gotdata) {
            migration.loadhistdata();
            this.gotdata = true;
        }
        this.countryview = new param("Country for migration plot", regref.keySet(), regman.nations.findreg("Belgium"));
        this.pop = this.gm(demog.class);
    }

    @Override
    public void setinteractions() {
        this.setaffectedby(this.pop);
    }

    @Override
    public void precalc() {
        this.curveshist();
    }

    @Override
    public void calcstep() {
        int n = year + 10;
        if (n > this.migsy && n <= this.migey && (n - 3) % this.migstep == 0) {
            this.calcnetmig(n);
        }
    }

    void curveshist() {
        this.migflow.map.clear();
        region region2 = (region)this.countryview.chosen;
        int n = regref.get(region2);
        for (region region3 : regref.keySet()) {
            if (region3.equals(region2) || region3.equals(regman.world)) continue;
            String string = "from " + region3.getName();
            String string2 = "to " + region3.getName();
            int n2 = regref.get(region3);
            for (int i = 1965; i <= 2010; i += 5) {
                int n3 = this.mfpi(i);
                float f = i < 1995 ? 2.0f : 1.0f;
                try {
                    this.migflow.set(string, i - 2, (float)mfd[n3][n2][n] / f);
                    this.migflow.set(string2, i - 2, (float)(-mfd[n3][n][n2]) / f);
                    continue;
                }
                catch (Exception exception) {
                    report.deb("migration data problem " + region2 + " - " + region3 + " in " + i);
                }
            }
            this.migflow.getcurve((Object)string).color = region3.color;
            this.migflow.getcurve((Object)string2).color = region3.color;
        }
    }

    void calcnetmig(int n) {
        int n2 = this.mfpi(n);
        int n3 = (int)this.csy.getval();
        int n4 = (int)this.cey.getval();
        n3 -= (n3 + 2) % this.migstep;
        n4 -= (n4 + 2) % this.migstep;
        curveset curveset2 = this.pop.modpop_nat;
        for (region region2 : regref.keySet()) {
            float f;
            float f2 = 0.0f;
            float f3 = curveset2.get(region2, n - 10) / curveset2.get(region2, 2003);
            if (n <= n3) {
                for (region region3 : regref.keySet()) {
                    if (region2.equals(region3) || region3.equals(regman.world)) continue;
                    int n5 = regref.get(region2);
                    int n6 = regref.get(region3);
                    if (n <= 2008) {
                        float f4 = n < 1995 ? 2.0f : 1.0f;
                        f2 += (float)(mfd[n2][n6][n5] - mfd[n2][n5][n6]) / f4;
                        continue;
                    }
                    if (this.migopt.chosen == migopts.constrate) {
                        f2 += (float)mfd[7][n6][n5] * curveset2.get(region3, n - 10) / curveset2.get(region3, 2003) - (float)mfd[7][n5][n6] * f3;
                    }
                    if (this.migopt.chosen != migopts.constabs) continue;
                    f2 += (float)(mfd[7][n6][n5] - mfd[7][n5][n6]);
                }
                if (n > 2008) {
                    float f5 = this.miglev.chosen == miglevs.high ? 2.0f : (this.miglev.chosen == miglevs.med ? 1.0f : 0.0f);
                    f = 0.67f * (n > 2025 ? f5 : (f5 * (float)(n - 2013) + (float)(2028 - n)) / 15.0f);
                } else {
                    f = 1.0f;
                }
                this.netmig.set(region2, n, f2 * f / 5000.0f);
                continue;
            }
            f = (float)(n4 - n) / (float)(n4 - n3);
            this.netmig.set(region2, n, n < n4 ? this.netmig.get(region2, n3) * f : 0.0f);
        }
    }

    int mfpi(int n) {
        return n < 1995 ? (n - 1965) / 10 : 4 + (n - 1995) / 5;
    }

    static void loadhistdata() {
        int n;
        region region2;
        String[][] stringArrayArray;
        String string = "data/pop/MigFlow_";
        String string2 = "";
        String string3 = "";
        int n2 = 1;
        mfd = new int[10][200][200];
        region region3 = regman.world;
        regref.put(region3, 0);
        tabcode.put(0, "TOTAL");
        codereg.put("TOTAL", region3);
        for (Object object : stringArrayArray = new String[][]{{"TWN", "Taiwan"}, {"ANT", "Netherlands Antilles"}, {"SCG", "Serbia & Montenegro"}}) {
            region2 = regman.nations.findreg(object[1]);
            codereg.put(object[0], region2);
            regref.put(region2, n2);
            ++n2;
        }
        String[][] stringArrayArray2 = fileio.loadtab(string + periods[7] + ".dat", "\t");
        for (n = 3; n < stringArrayArray2.length - 1; ++n) {
            Object object;
            String string4 = stringArrayArray2[n][0].trim();
            object = stringArrayArray2[n][1].trim();
            region2 = regman.nations.findreg(string4);
            if (region2 == null) {
                report.deb("migration " + string4 + " no JCM region - made new!");
                region2 = regman.allreg.findormakereg(string4);
            }
            codereg.put((String)object, region2);
            if (regref.keySet().contains(region2)) continue;
            regref.put(region2, n2);
            ++n2;
        }
        n = -1;
        for (String string5 : periods) {
            ++n;
            try {
                int n3;
                stringArrayArray2 = fileio.loadtab(string + string5 + ".dat", "\t");
                for (n3 = 0; n3 < stringArrayArray2[2].length; ++n3) {
                    string3 = stringArrayArray2[2][n3].trim();
                    tabcode.put(n3, string3);
                }
                for (n3 = 3; n3 < stringArrayArray2.length; ++n3) {
                    int n4 = n < 4 || n3 == stringArrayArray2.length - 1 ? 0 : 1;
                    string2 = stringArrayArray2[n3][n4].trim();
                    int n5 = regref.get(codereg.get(string2));
                    if (!codereg.containsKey(string2)) {
                        report.deb("migration - code " + string2 + " unrecognised! ");
                        continue;
                    }
                    for (int i = 1 + n4; i < stringArrayArray2[n3].length; ++i) {
                        string3 = tabcode.get(i - (1 + n4));
                        int n6 = regref.get(codereg.get(string3));
                        int n7 = Integer.valueOf(stringArrayArray2[n3][i].trim());
                        migration.mfd[n][n5][n6] = n7 + (mfd[n][n5][n6] > 0 ? mfd[n][n5][n6] : 0);
                    }
                }
            }
            catch (Exception exception) {
                report.deb("problem in " + string5 + " from " + string2 + " to " + string3);
                exception.printStackTrace();
            }
        }
        report.deb("loaded migration data OK");
    }

    static enum miglevs {
        high,
        med,
        low;

    }

    static enum migopts {
        constrate,
        constabs;

    }
}

