/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.mod.math.regress;
import jcm.mod.obj.regset;
import jcm.mod.socio.demog;
import jcm.mod.socio.histsocdata;
import jcm.mod.socio.popgdp;

public class economy
extends module {
    int eey = gey;
    public curveset gdp_mod = new curveset("gdp model", "mega&dollar&PPP(05)", 1950, this.eey, 1);
    public curveset gdp_percap;
    public curveset captot = new curveset("capital", "mega&dollar&PPP(05)", 1950, this.eey, 1);
    public curveset capstruc = new curveset("capital: infrastructure", "mega&dollar", 1950, this.eey, 1);
    public curveset capmach = new curveset("capital: machines", "mega&dollar", 1950, this.eey, 1);
    public curveset caphitec = new curveset("capital: hitech", "mega&dollar", 1950, this.eey, 1);
    public curveset humcap = new curveset("human capital", " factor", 1950, this.eey, 1);
    public curveset laborshare = new curveset("labour share", "", 1950, this.eey, 1);
    public curveset savings = new curveset("savings ratio", "", 1950, this.eey, 1);
    public curveset tfp = new curveset("total factor productivity", "", 1950, this.eey, 1);
    public param forcehist = new param(new Object[]{"force model fit history", true, complexity.expert});
    public param constantalpha = new param("constant alpha (cap/lab share)", true);
    public param dr_sav_fb = new param("dependency ratio affects savings?", true);
    public param fracinv_inf = new param("investment infrastructure", "fraction", Float.valueOf(0.4f), 0.2, Float.valueOf(0.6f));
    public param fracinv_hitec = new param("investment hitec", "fraction", Float.valueOf(0.2f), Float.valueOf(0.0f), Float.valueOf(0.5f));
    public param tfp_lim2300 = new param("tfp limit 2300", "", Float.valueOf(5.5f), Float.valueOf(5.0f), Float.valueOf(6.0f));
    public param humcap_lim = new param("humcap limit ", "", Float.valueOf(4.0f), Float.valueOf(3.5f), Float.valueOf(5.0f));
    public param savings_lim = new param("savings limit ", "", Float.valueOf(0.25f), Float.valueOf(0.1f), Float.valueOf(0.5f));
    List<region> regs;
    curveset datagdp;
    curveset datapop;
    curveset workpop;
    curveset deprat;
    int nc = 3;
    curveset[] cap = new curveset[]{this.capstruc, this.capmach, this.caphitec};
    float[] capinit = new float[]{2.2f, 0.4f, 0.0f};
    float[] deprec = new float[]{0.02f, 0.12f, 0.3f};
    float[] fracinv = new float[]{0.4f, 0.4f, 0.2f};
    Map<region, regdat> rd = new HashMap<region, regdat>();

    @Override
    public void initsetup() {
        this.setaffectedby(this.gm(regset.class).regions);
        this.follows(demog.class);
        this.follows(this.gm(popgdp.class).history);
        this.datagdp = this.gm(popgdp.class).gdp_ppp;
        this.workpop = this.gm(demog.class).workpop;
        this.deprat = this.gm(demog.class).deprat;
        this.gdp_percap = new curvar(curve.Type.ratio, this.gdp_mod, this.gm(demog.class).modpop);
    }

    @Override
    public void setinteractions() {
    }

    @Override
    public void precalc() {
        this.regs = ((region)this.gm(regset.class).regions.chosen).reg;
        this.gm(regset.class).clearoldregions(this);
        for (region region2 : this.regs) {
            this.rd.put(region2, new regdat());
        }
        this.fracinv[0] = (float)this.fracinv_inf.val;
        this.fracinv[2] = (float)this.fracinv_hitec.val;
        this.fracinv[1] = 1.0f - (this.fracinv[2] + this.fracinv[0]);
    }

    @Override
    public void calcstep() {
        for (region region2 : this.regs) {
            if (!this.rd.get((Object)region2).started) {
                if (!this.datagdp.gotdata(region2, year) || this.datagdp.get(region2, year) == 0.0f) continue;
                this.rd.get((Object)region2).started = true;
                this.capinit(region2, year);
            } else {
                this.capital(region2);
            }
            this.product(region2);
        }
    }

    void capinit(region region2, int n) {
        float f = this.datagdp.get(region2, n);
        float f2 = 0.0f;
        for (int i = 0; i < this.nc; ++i) {
            this.cap[i].set(region2, n, f * this.capinit[i]);
            f2 += this.cap[i].get(region2, n);
        }
        this.captot.set(region2, n, f2);
    }

    void capital(region region2) {
        float f;
        regdat regdat2 = this.rd.get(region2);
        if (year <= 2021) {
            regdat2.sav = year <= 2011 ? this.sumreg(histsocdata.PWT_inv, histsocdata.PWT_RGDPO, region2, year) : this.sumreg(histsocdata.WEOinvest, histsocdata.WEOGDP_PPP, region2, year) / 100.0f;
            if (Float.isNaN(regdat2.sav) || regdat2.sav == 0.0f) {
                regdat2.sav = 0.4f;
            }
        } else {
            f = this.dr_sav_fb.istrue() ? 0.5f - 0.4f * this.deprat.get(region2) : (float)this.savings_lim.val;
            regdat2.sav += 0.1f * (f - regdat2.sav);
        }
        this.savings.set(region2, regdat2.sav);
        f = this.gdp_mod.get(region2, year - 1) * regdat2.sav;
        float f2 = 0.0f;
        for (int i = 0; i < this.nc; ++i) {
            this.cap[i].set(region2, year, this.cap[i].get(region2, year - 1) * (1.0f - this.deprec[i]) + f * this.fracinv[i]);
            f2 += this.cap[i].get(region2, year);
        }
        this.captot.set(region2, year, f2);
    }

    void product(region region2) {
        regdat regdat2 = this.rd.get(region2);
        float f = 20.0f;
        if (year == 2011) {
            regdat2.lab_reg = regress.reglin(this.laborshare, region2, 2011 - (int)f, 2011);
        }
        regdat2.labsh = year <= 2011 ? this.sumreg(histsocdata.PWT_labsh, histsocdata.PWT_pop, region2, year) : ((float)year <= 2011.0f + f ? (regdat2.labsh += regdat2.lab_reg[0] * (f + 2011.0f - (float)year) / f + 0.02f * (0.6f - regdat2.labsh) * (float)(year - 2011) / f) : (regdat2.labsh += 0.02f * (0.6f - regdat2.labsh)));
        if (Float.isNaN(regdat2.labsh) || regdat2.labsh == 0.0f) {
            regdat2.labsh = 0.6f;
        }
        if (this.constantalpha.istrue()) {
            regdat2.labsh = 0.6f;
        }
        this.laborshare.set(region2, regdat2.labsh);
        float f2 = 20.0f;
        if (year == 2011) {
            regdat2.hum_reg = regress.reglin(this.humcap, region2, 2011 - (int)f, 2011);
        }
        regdat2.humc = year <= 2011 ? this.sumreg(histsocdata.PWT_hc, histsocdata.PWT_pop, region2, year) : ((float)year <= 2011.0f + f2 ? (regdat2.humc += regdat2.hum_reg[0] * (f2 + 2011.0f - (float)year) / f2 + 0.01f * ((float)this.humcap_lim.val - regdat2.humc) * (float)(year - 2011) / f2) : (regdat2.humc += 0.01f * ((float)this.humcap_lim.val - regdat2.humc)));
        if (Float.isNaN(regdat2.humc) || regdat2.humc == 0.0f) {
            regdat2.humc = 2.5f;
        }
        this.humcap.set(region2, regdat2.humc);
        float f3 = this.workpop.get(region2);
        float f4 = (float)(Math.pow(regdat2.humc * f3, regdat2.labsh) * Math.pow(this.captot.get(region2), 1.0f - regdat2.labsh));
        float f5 = 25.0f;
        if (year == 2021) {
            regdat2.tfp_reg = regress.reglin(this.tfp, region2, 2021 - (int)f5, 2021);
        }
        float f6 = 1.125f * (float)this.tfp_lim2300.val * (float)(year - 1900) / (float)(year - 1850);
        regdat2.tfp_mod = this.forcehist.istrue() ? (year <= 2011 ? this.datagdp.get(region2) / f4 : (year <= 2021 ? this.datagdp.get(region2) / f4 : ((float)year <= 2021.0f + f5 ? (regdat2.tfp_mod += regdat2.tfp_reg[0] * (f5 + 2021.0f - (float)year) / f5 + 0.015f * (f6 - regdat2.tfp_mod) * (float)(year - 2021) / f5) : (regdat2.tfp_mod += 0.015f * (f6 - regdat2.tfp_mod))))) : f6;
        this.tfp.set(region2, regdat2.tfp_mod);
        this.gdp_mod.set(region2, f4 * regdat2.tfp_mod);
    }

    float sumreg(curveset curveset2, curveset curveset3, region region2, int n) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (region region3 : region2.subreg(curveset2)) {
            if (!curveset3.gotdata(region3, n)) continue;
            f3 = curveset3.get(region3, n);
            if (!curveset2.gotdata(region3, n)) continue;
            f4 = curveset2.get(region3, n);
            f += f4 * f3;
            f2 += f3;
        }
        if (Float.isNaN(f) || Float.isNaN(f2) || f2 == 0.0f) {
            return Float.NaN;
        }
        return f / f2;
    }

    class regdat {
        boolean started = false;
        float sav;
        float labsh;
        float labshold;
        float humc;
        float humcold;
        float tfp_mod;
        float[] tfp_reg;
        float[] hum_reg;
        float[] lab_reg;

        regdat() {
        }
    }
}

