/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.infob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.mod.math.regress;
import jcm.mod.obj.regset;
import jcm.mod.socio.economy;
import jcm.mod.socio.migration;

public class demog
extends module {
    public curveset wppmed = new curveset("wpp_med_pop", "kilo&person", 1950, 2100, 5);
    public curveset modpop = new curveset("model_pop", "kilo&person", 1950, gey, 5);
    public curveset modpop_nat = new curveset("model_pop_nat", "kilo&person", 1950, gey, 5);
    public curveset enpop = new curveset("energy_pop", "kilo&person", 1950, gey, 5);
    public curveset netmig = new curveset("net migration", "kilo&person&per&year", 1953, 2098, 5);
    public curveset tfr = new curveset("total fertility rate", "births&per&woman", 1953, gey, 5);
    public curveset workpop = new curveset("workage_pop", "kilo&person", 1950, gey, 5);
    public curveset deprat = new curveset("dependency ratio", "", 1950, gey, 5);
    public curveset ov60survrate = new curveset("over-60 survival rate", "", 1950, gey, 5);
    public curveset pyramid = new curveset("pyramid", "kilo&person", 0, 100, 5);
    public param fertility = new param("fertility factor", "%", 100, 75, 125);
    public param<fertopts> future_fertility = new param(new Object[]{"fertility", fertopts.values(), fertopts.gdppercap_by2100, complexity.normal});
    public param<migsources> migsource = new param(new Object[]{"source migration", migsources.values(), migsources.migflows});
    public param normpy = new param("normalise pyramid", false);
    public param pyramidyear = new param("year for pyramid", "%", 2010, 1950, gey);
    Map<region, float[][]> snappy = new HashMap<region, float[][]>();
    static Map<region, float[][][]> datapy = new HashMap<region, float[][][]>();
    static Map<region, float[][]> bir = new HashMap<region, float[][]>();
    static Map<region, float[]> mig = new HashMap<region, float[]>();
    static float[][] migfrac = new float[][]{{6.0f, 4.0f, 2.0f, 10.0f, 16.0f, 20.0f, 16.0f, 10.0f, 6.0f, 6.0f, 5.0f, 5.0f, 4.0f, 3.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {6.0f, 4.0f, 2.0f, 8.0f, 12.0f, 16.0f, 14.0f, 9.0f, 5.0f, 5.0f, 5.0f, 5.0f, 4.0f, 3.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
    static float[] enfac = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 5.0f, 6.0f, 6.0f, 7.0f, 7.0f, 8.0f, 8.0f, 7.0f, 6.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 3.0f, 3.0f};
    static float totmig = 0.0f;
    static float totef = 0.0f;
    boolean done = false;
    List<region> natset = new ArrayList<region>();
    List<region> regset;
    Map<region, List<region>> regmap = new HashMap<region, List<region>>();
    float[] fertreg_gdp = null;
    Map<region, float[]> fertreg = new HashMap<region, float[]>();
    Map<region, Float> fertfacadj = new HashMap<region, Float>();

    @Override
    public void initsetup() {
        if (!this.done) {
            demog.fillhistdata();
        }
        this.done = true;
        this.setregs();
        this.setaffectedby(this.gm(regset.class).regions);
        this.setaffectedby(this.gm(economy.class));
        this.follows(this.gm(migration.class));
    }

    @Override
    public void setinteractions() {
    }

    @Override
    public void precalc() {
        this.regset = ((region)this.gm(regset.class).regions.chosen).reg;
        this.gm(regset.class).clearoldregions(this);
        for (region region2 : this.regset) {
            ArrayList<region> arrayList = new ArrayList<region>();
            for (region region3 : this.natset) {
                if (!region2.contains(region3)) continue;
                arrayList.add(region3);
            }
            this.regmap.put(region2, arrayList);
        }
        this.fillwpp();
        this.initsnap();
        for (region region2 : this.regset) {
            this.fertfacadj.put(region2, Float.valueOf(1.0f));
        }
    }

    @Override
    public void calcstep() {
        if (year == 1950) {
            this.shiftmod(1950);
        }
        if (year == 2013) {
            this.regressfertility();
        }
        if (year % 5 == 0) {
            this.shiftmod(year + 5);
        }
        if (year % 5 == 0 && year > 2013) {
            this.adjustfertility(year + 5);
        }
        if (year + 5 == (int)this.pyramidyear.val) {
            this.fillpyramid();
        }
    }

    void setregs() {
        for (region region2 : regman.nations.reg) {
            if (!datapy.keySet().contains(region2)) continue;
            this.natset.add(region2);
        }
    }

    void fillwpp() {
        totef = 0.0f;
        for (int i = 0; i < 21; ++i) {
            totef += enfac[i];
        }
        for (region region2 : this.regset) {
            for (int i = 0; i < 31; ++i) {
                int n = 1950 + i * 5;
                float f = 0.0f;
                for (region region3 : this.regmap.get(region2)) {
                    float[][] fArray = datapy.get(region3)[i];
                    float f2 = 0.0f;
                    for (int j = 0; j < 21; ++j) {
                        f2 += fArray[0][j] + fArray[1][j];
                    }
                    f += f2;
                }
                this.wppmed.set(region2, n, f);
            }
        }
    }

    void initsnap() {
        for (region region2 : this.natset) {
            float[][] fArray = this.snappy.get(region2);
            if (fArray == null) {
                fArray = new float[2][21];
                this.snappy.put(region2, fArray);
            }
            for (int i = 0; i < 21; ++i) {
                fArray[0][i] = datapy.get(region2)[0][0][i];
                fArray[1][i] = datapy.get(region2)[0][1][i];
            }
        }
        totmig = 0.0f;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 21; ++j) {
                totmig += migfrac[i][j];
            }
        }
    }

    void shiftmod(int n) {
        int n2 = (n - 1950) / 5;
        if (n2 > 30) {
            n2 = 30;
        }
        float[] fArray = new float[7];
        float[] fArray2 = new float[7];
        float f = (float)(n > 2010 ? this.fertility.getval() / 100.0 : 1.0);
        boolean bl = this.migsource.chosen != migsources.no_migration || n < 2010;
        for (region region2 : this.regset) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = this.ov60survrate.get(region2, 2100);
            float f11 = n <= 2100 ? 1.0f : (n < 2200 ? ((float)(n - 2100) * 0.9f + (float)(2200 - n) * f10) / (100.0f * f10) : 0.9f / f10);
            for (int i = 0; i < 7; ++i) {
                fArray[i] = 0.0f;
                fArray2[i] = 0.0f;
            }
            for (region region3 : this.regmap.get(region2)) {
                float f12;
                float[][] fArray3 = this.snappy.get(region3);
                if (n2 > 0) {
                    int n3;
                    float[][] fArray4 = datapy.get(region3)[n2];
                    float[][] fArray5 = datapy.get(region3)[n2 - 1];
                    float[] fArray6 = bir.get(region3)[n2 - 1];
                    if (this.migsource.chosen == migsources.migflows) {
                        f3 = this.gm(migration.class).netmig.get(region3, n) * 5.0f;
                    }
                    if (this.migsource.chosen == migsources.no_migration) {
                        f3 = 0.0f;
                    }
                    if (this.migsource.chosen == migsources.wpp || n < 2010) {
                        f3 = mig.get(region3)[n2 - 1];
                    }
                    f12 = 0.0f;
                    float f13 = 0.0f;
                    float f14 = 0.0f;
                    int n4 = 0;
                    while (n4 < 7) {
                        f14 += fArray6[n4];
                        float f15 = fArray6[n4] / fArray5[1][n4 + 3];
                        float f16 = fArray3[1][n4 + 3];
                        f12 = f15 * f16 * f * this.fertfacadj.get(region2).floatValue();
                        f13 += f12;
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + f12;
                        int n6 = n4++;
                        fArray2[n6] = fArray2[n6] + f16;
                    }
                    for (n4 = 0; n4 < 2; ++n4) {
                        for (n3 = 20; n3 > 0; --n3) {
                            float f17;
                            float f18 = f3 * migfrac[n4][n3] / totmig;
                            float f19 = n3 < 18 || n2 > 8 ? (fArray4[n4][n3] - f18) / fArray5[n4][n3 - 1] : (f17 = n2 == 8 && n3 > 17 ? (fArray4[n4][n3] - f18) / fArray4[n4][n3 - 1] : 0.0f);
                            if (Float.isNaN(f17)) {
                                f17 = 0.0f;
                            }
                            if ((f17 *= f11) > 1.0f) {
                                f17 = 1.0f;
                            }
                            if (n3 >= 12) {
                                f8 += fArray3[n4][n3 - 1] * f17;
                                f9 += fArray3[n4][n3 - 1];
                            }
                            fArray3[n4][n3] = fArray3[n4][n3 - 1] * f17;
                        }
                        fArray3[n4][0] = f13 * fArray4[n4][0] / f14;
                    }
                    if (bl) {
                        for (n4 = 0; n4 < 2; ++n4) {
                            for (n3 = 0; n3 < 21; ++n3) {
                                float[] fArray7 = fArray3[n4];
                                int n7 = n3;
                                fArray7[n7] = fArray7[n7] + f3 * migfrac[n4][n3] / totmig;
                            }
                        }
                    }
                }
                float f20 = 0.0f;
                float f21 = 0.0f;
                float f22 = 0.0f;
                f12 = 0.0f;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 21; ++j) {
                        f20 += fArray3[i][j];
                        f21 += fArray3[i][j] * enfac[j];
                        if (j < 3 || j > 12) {
                            f22 += fArray3[i][j];
                            continue;
                        }
                        f12 += fArray3[i][j];
                    }
                }
                f2 += f20;
                f4 += f21 * 21.0f / totef;
                f6 += f22;
                f7 += f12;
                f5 += f3 / 5.0f;
                this.modpop_nat.set(region3, n, f20);
            }
            this.ov60survrate.set(region2, n, f8 / f9);
            this.modpop.set(region2, n, f2);
            this.enpop.set(region2, n, f4);
            this.workpop.set(region2, n, f7);
            this.deprat.set(region2, n, f6 / f7);
            if (n2 <= 0) continue;
            this.netmig.set(region2, n - 2, f5);
            float f23 = 0.0f;
            for (int i = 0; i < 7; ++i) {
                f23 += fArray[i] / fArray2[i];
            }
            this.tfr.set(region2, n - 2, f23);
        }
    }

    void fillpyramid() {
        float[][] fArray = new float[2][21];
        for (region region2 : this.regset) {
            infob infob2 = new infob(region2.name + " Wom", region2.color);
            infob infob3 = new infob(region2.name + " Men", region2.color);
            float f = 0.0f;
            for (int i = 0; i < 21; ++i) {
                fArray[0][i] = 0.0f;
                fArray[1][i] = 0.0f;
            }
            for (region region3 : this.regmap.get(region2)) {
                float[][] fArray2 = this.snappy.get(region3);
                for (int i = 0; i < 21; ++i) {
                    float[] fArray3 = fArray[0];
                    int n = i;
                    fArray3[n] = fArray3[n] + fArray2[0][i];
                    float[] fArray4 = fArray[1];
                    int n2 = i;
                    fArray4[n2] = fArray4[n2] + fArray2[1][i];
                    f += fArray2[0][i] + fArray2[1][i];
                }
            }
            float f2 = this.normpy.istrue() ? 1.0E7f / f : 1.0f;
            for (int i = 0; i < 21; ++i) {
                this.pyramid.set(infob2, i * 5, fArray[1][i] * f2 / 5.0f);
                this.pyramid.set(infob3, i * 5, -fArray[0][i] * f2 / 5.0f);
            }
        }
    }

    void regressfertility() {
        this.fertreg_gdp = regress.reglin(this.gm(economy.class).gdp_percap, this.tfr, null, 1970, 2010, true, true);
        for (region region2 : this.regset) {
            this.fertreg.put(region2, regress.reglin(this.tfr, region2, 2000, 2010));
            this.fertfacadj.put(region2, Float.valueOf(1.0f));
        }
    }

    void adjustfertility(int n) {
        for (region region2 : this.regset) {
            float f = (float)Math.exp(this.fertreg_gdp[0] * (float)Math.log(this.gm(economy.class).gdp_percap.get(region2, n - 6)) + this.fertreg_gdp[1]);
            float f2 = this.tfr.get(region2, n - 2);
            float f3 = this.fertfacadj.get(region2).floatValue();
            float f4 = f2 / f3;
            if (this.future_fertility.chosen == fertopts.WPP_only) {
                if (n <= 2100) {
                    f3 = 1.0f;
                }
                if (n > 2100 && n < 2150) {
                    f3 = (float)(n - 2100) / 50.0f * 1.95f / f4 + (float)(2150 - n) / 50.0f;
                }
                if (n > 2150) {
                    f3 = 1.95f / f4;
                }
            }
            if (this.future_fertility.chosen == fertopts.gdppercap_by2100) {
                float f5 = n < 2100 ? (float)(n - 2010) / 90.0f : 1.0f;
                f3 = f5 * f / f4 + (1.0f - f5);
            }
            if (this.future_fertility.chosen == fertopts.gdppercap_instant) {
                f3 = f / f4;
            }
            this.fertfacadj.put(region2, Float.valueOf(f3));
        }
    }

    static void fillhistdata() {
        try {
            String string = "data/pop/wpp12_popquin.csv";
            String[][] stringArray = fileio.loadtab(string, ",");
            int n = (stringArray.length - 2) / 31;
            int n2 = 2;
            for (int i = 0; i < n; ++i) {
                region region2 = regman.allreg.findreg(stringArray[n2][0]);
                float[][][] fArray = new float[31][2][21];
                float[][] fArray2 = new float[31][7];
                float[] fArray3 = new float[31];
                datapy.put(region2, fArray);
                bir.put(region2, fArray2);
                mig.put(region2, fArray3);
                for (int j = 0; j < 31; ++j) {
                    int n3;
                    int n4 = n2 + j;
                    for (n3 = 0; n3 < 21; ++n3) {
                        fArray[j][0][n3] = Float.valueOf(stringArray[n4][n3 + 3]).floatValue() / 10.0f;
                        fArray[j][1][n3] = Float.valueOf(stringArray[n4][n3 + 25]).floatValue() / 10.0f;
                    }
                    for (n3 = 0; n3 < 7; ++n3) {
                        fArray2[j][n3] = Float.valueOf(stringArray[n4][n3 + 47]).floatValue() / 10.0f;
                    }
                    fArray3[j] = Float.valueOf(stringArray[n4][55]).floatValue() / 10.0f;
                }
                n2 += 31;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static enum migsources {
        no_migration,
        migflows,
        wpp;

    }

    public static enum fertopts {
        WPP_only,
        gdppercap_by2100,
        gdppercap_instant;

    }
}

