/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.emitquota;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresdata;
import jcm.mod.socio.histsocdata;
import jcm.mod.socio.popgdp;

public class costs
extends module {
    public curveset abatecost = new curveset("abatecost", "mega&dollar&per&year");
    public curveset damagecost = new curveset("damagecost", "mega&dollar&per&year");
    public curveset totalcost = new curveset("totalcost", "mega&dollar&per&year");
    public curveset abatewelch = new curveset("abatewelch", "mega&dollar&per&year");
    public curveset damagewelch = new curveset("damagewelch", "mega&dollar&per&year");
    public curveset totalwelch = new curveset("totalwelch", "mega&dollar&per&year");
    public curveset reducedgdp = new curveset("reducedgdp", "mega&dollar&per&year");
    public curveset origwelf = new curveset(new Object[]{"welfare no-cli", complexity.expert});
    public param prtp = new param("pure rate time pref", "%", 1.5, 0, 6);
    public param ineqav = new param("inequality-aversion", "", 1.0, 0, 2);
    public param effdisc2000 = new param("effdisc2000", "%", 2.78, 0, 6);
    public param constdisc = new param("fix-effdisc2000", false);
    public param useprtp = new param(new Object[]{"useprtp", true, complexity.expert});
    public param abatefunc = new param(new Object[]{"abatefunc", new String[]{"macgem", "rice99"}, "macgem", complexity.expert});
    public param impfunc = new param(new Object[]{"impfunc", new String[]{"cws", "rice99"}, "rice99", complexity.expert});
    public param incch4 = new param(new Object[]{"incch4", false, complexity.experimental});
    public param dyngdp = new param(new Object[]{"dyngdp", true, complexity.expert});
    public param usebackstop = new param(new Object[]{"usebackstop", false, complexity.expert});
    public param backstop = new param(new Object[]{"backstop", "$&per&ton", 500, 0, 1000, complexity.expert});
    public param scaleabate = new param(new Object[]{"scaledown abatement", "", 1.0, 0, 1, complexity.expert});
    public param abatepow = new param(new Object[]{"abatepow", "", 2.887, 0, 6, complexity.expert});
    public param abatelin = new param(new Object[]{"abatelin", "", 1, 0, 3, complexity.expert});
    public param damagepow = new param(new Object[]{"damagecostpow", "", 1.5, 0, 6, complexity.expert});
    public param damagelin = new param(new Object[]{"damagelin", "", 1, 0, 3, complexity.expert});
    public float base;
    public float idw;
    public float iaw;
    public float iac;
    public float itw;
    public float iow;
    public float cumprtp;
    public float gtc;
    public float igwp;
    public float scaledownfac;
    boolean firsttime = true;
    List<region> regions;
    Map<region, Float> a1;
    Map<region, Float> b1;
    Map<region, Float> th1;
    Map<region, Float> th2;
    Map<region, Float> macgema;
    Map<region, Float> macgemb;
    emitquota eq;
    popgdp soc;
    static double[] b1_jcm12 = new double[]{0.07, 0.07, 0.05, 0.05, 0.1, 0.15, 0.1, 0.15, 0.1, 0.1, 0.1, 0.1};
    static double[] a1_jcm12 = new double[]{0.01102, 0.01102, 0.01174, 0.01174, 0.01, 0.00857, 0.02093, 0.01523, 0.02903, 0.02903, 0.02903, 0.02903};
    static double[] th1_jcm12 = new double[]{-0.0026, -0.007, -0.007, -0.001, -0.0076, -0.0076, 0.0039, -0.0041, 0.0022, 0.0039, 0.01, 0.01};
    static double[] th2_jcm12 = new double[]{0.0017, 0.003, 0.003, 0.0049, 0.0025, 0.0025, 0.0013, 0.002, 0.0026, 0.0013, 0.0027, 0.0027};
    static double[] macgema_jcm12 = new double[]{373.612, 337.0, 290.224, 241.278, 694.559, 694.559, 269.217, 199.02, 523.793, 496.158, 500.0, 235.499};
    static double[] macgemb_jcm12 = new double[]{1.22, 1.372, 1.251, 1.426, 1.1, 1.1, 1.279, 1.634, 1.209, 1.18, 1.2, 1.846};

    @Override
    public void initsetup() {
        this.eq = this.gm(emitquota.class);
        this.follows(this.eq.regfuture);
        this.follows(this.gm(glotemp.class));
        this.affectsfutureonly = true;
    }

    @Override
    public void setinteractions() {
        this.setaffects((interacob)this.prtp, this.constdisc.istrue());
        this.setaffects((interacob)this.effdisc2000, !this.constdisc.istrue());
        this.setaffectedby((interacob)this.prtp, this.useprtp.istrue());
        this.setaffectedby((interacob)this.backstop, this.usebackstop.istrue());
        this.setaffectedby((interacob)this.scaleabate, this.abatefunc.chosen.equals("macgem"));
        this.setaffectedby((interacob)this.abatepow, this.abatefunc.chosen.equals("rice99"));
        this.setaffectedby((interacob)this.damagepow, this.impfunc.chosen.equals("cws"));
    }

    @Override
    public void precalc() {
        this.soc = this.gm(popgdp.class);
        if (!this.firsttime) {
            this.adjdisc();
        }
        for (curveset curveset2 : this.curvesets) {
            this.gm(regset.class).clearoldregions(curveset2);
        }
        this.regions = ((region)this.gm(regset.class).regions.chosen).reg;
        curveset curveset3 = histsocdata.histpop;
        this.a1 = this.interpolatefac(a1_jcm12, "JCM12", curveset3);
        this.b1 = this.interpolatefac(b1_jcm12, "JCM12", curveset3);
        this.th1 = this.interpolatefac(th1_jcm12, "JCM12", curveset3);
        this.th2 = this.interpolatefac(th2_jcm12, "JCM12", curveset3);
        this.macgema = this.interpolatefac(macgema_jcm12, "JCM12", curveset3);
        this.macgemb = this.interpolatefac(macgemb_jcm12, "JCM12", curveset3);
    }

    @Override
    public void postcalc() {
        if (this.firsttime) {
            this.adjdisc();
        }
    }

    public void reportcosts() {
        report.log("emit2050fos, emit2050tot, conc, temp2150, iaw, idw,  =" + this.gm(carboncycle.class).fossil.get(2050) + "\t" + this.gm(carboncycle.class).totemit.get(2050) + "\t" + this.gm(carboncycle.class).co2atppm.get(2200) + "\t" + this.gm(glotemp.class).avchangeby.get(2150) + "\t" + this.iaw + "\t" + this.idw);
    }

    void adjdisc() {
        float f = (this.soc.gdp_ppp.get(regman.world, 2000) / this.soc.pop.get(regman.world, 2000) / (this.soc.gdp_ppp.get(regman.world, 1990) / this.soc.pop.get(regman.world, 1990)) - 1.0f) / 10.0f;
        this.firsttime = false;
        if (this.constdisc.istrue()) {
            this.prtp.putval(this.effdisc2000.getval() - (double)(100.0f * f) * this.ineqav.getval());
            this.prtp.changed = true;
        } else {
            this.effdisc2000.putval(this.prtp.getval() + (double)(100.0f * f) * this.ineqav.getval());
            this.effdisc2000.changed = true;
        }
    }

    @Override
    public void calcstep() {
        if (year >= fsyfos) {
            if (year == fsyfos) {
                this.ewbase();
            }
            if (year == fsyfos) {
                this.cumprtp = 1.0f;
                this.iaw = 0.0f;
                this.idw = 0.0f;
                this.itw = 0.0f;
                this.iow = 0.0f;
                this.gtc = 0.0f;
                this.iac = 0.0f;
                this.igwp = 0.0f;
            }
            if (year > fsyfos && this.useprtp.istrue()) {
                this.cumprtp = (float)((double)this.cumprtp * (1.0 - this.prtp.getval() / 100.0));
            }
            for (region infob2 : this.regions) {
                float f = this.ew(infob2);
                this.damagecost.set(infob2, this.dc(infob2));
                this.abatecost.set(infob2, this.ac(infob2));
                this.totalcost.set(infob2, this.damagecost.get(infob2) + this.abatecost.get(infob2));
                this.reducedgdp.set(infob2, this.soc.gdp_ppp.get(infob2) - this.totalcost.get(infob2));
                this.origwelf.set(infob2, this.soc.gdp_ppp.get(infob2) * f * this.cumprtp);
                this.damagewelch.set(infob2, this.damagecost.get(infob2) * f * this.cumprtp);
                this.abatewelch.set(infob2, this.abatecost.get(infob2) * f * this.cumprtp);
                this.totalwelch.set(infob2, this.abatewelch.get(infob2) + this.damagewelch.get(infob2));
                this.iaw += this.abatewelch.get(infob2);
                this.idw += this.damagewelch.get(infob2);
                this.itw += this.totalwelch.get(infob2);
                this.iow += this.origwelf.get(infob2);
                this.iac += this.abatecost.get(infob2) * this.cumprtp;
                this.igwp += this.soc.gdp_ppp.get(infob2) * this.cumprtp;
                if (year > 2100) continue;
                this.gtc += this.eq.emitfosabate.get(infob2) * 0.001f;
            }
            for (curveset curveset2 : this.curvesets) {
                curveset2.calctot();
            }
            if (year == 2100) {
                this.scaledownfac = 7.0E-4f * this.gtc / (100.0f * this.iaw / this.iow);
            }
        }
    }

    public void scaledown() {
        this.scaledownfac = 7.0E-4f * this.gtc / (100.0f * this.iaw / this.iow);
        report.deb(" gtc=" + this.gtc + " \t\t gwploss= " + 100.0f * this.iaw / this.iow + "% /t/t scaledown= " + this.scaledownfac);
        this.iaw *= this.scaledownfac;
        this.itw = this.iaw + this.idw;
        for (int i = fsyfos; i <= gey; ++i) {
            for (region region2 : this.regions) {
                this.abatecost.set(region2, i, this.abatecost.get(region2, i) * this.scaledownfac);
                this.abatewelch.set(region2, i, this.abatewelch.get(region2, i) * this.scaledownfac);
                this.totalcost.set(region2, i, this.damagecost.get(region2, i) + this.abatecost.get(region2, i));
                this.reducedgdp.set(region2, i, this.soc.gdp_ppp.get(region2, i) - this.totalcost.get(region2, i));
                this.totalwelch.set(region2, i, this.abatewelch.get(region2, i) + this.damagewelch.get(region2, i));
            }
        }
    }

    public int nr(region region2) {
        return this.regions.indexOf(region2);
    }

    public float beta(region region2) {
        return (float)(this.abatefunc.chosen.equals("macgem") ? 1.0 + this.scaleabate.getval() * (double)(this.macgemb.get(region2).floatValue() - 1.0f) : this.abatepow.getval());
    }

    public float gdp(region region2) {
        if (this.dyngdp.istrue() && year > fsyfos) {
            return this.soc.gdp_ppp.get(region2) * this.reducedgdp.get(region2, year - 1) / this.soc.gdp_ppp.get(region2, year - 1);
        }
        return this.soc.gdp_ppp.get(region2);
    }

    public float alpha(region region2) {
        return (float)(this.abatelin.getval() * (this.abatefunc.chosen.equals("macgem") ? (double)(1000.0f * this.macgema.get(region2).floatValue()) * this.scaleabate.getval() / Math.pow(1000.0, this.beta(region2)) : (double)(this.gdp(region2) * this.b1.get(region2).floatValue()) / Math.pow(this.gm(emitbase.class).emitfosbase.get(region2), this.beta(region2))));
    }

    public float ac(region region2) {
        float f;
        if (this.eq.emitfos.get(region2) < 0.0f) {
            return Float.MAX_VALUE;
        }
        float f2 = f = this.eq.emitfosabate.get(region2) > 0.0f ? (float)((double)this.alpha(region2) * Math.pow(this.eq.emitfosabate.get(region2), this.beta(region2))) : 0.0f;
        if (this.usebackstop.istrue() && f / this.eq.emitfosabate.get(region2) > (float)this.backstop.getval()) {
            f = (float)this.backstop.getval() * this.eq.emitfosabate.get(region2);
        }
        if (this.incch4.istrue()) {
            float f3 = this.gm(carboncycle.class).fossil.get(year) / (1000.0f * interpolator.sresinterp(sresdata.fosemit, this.gm(sresBase.class).sci, year));
            float f4 = interpolator.sresinterp(sresdata.ch4emit, this.gm(sresBase.class).sci, year) * (1.0f - f3) - 22.0f;
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            float f5 = 0.003f * f4 * f4 + 2.0E-4f * f4 * f4 * f4;
            f += f5 * this.eq.emitch4.get(region2, 1990) / this.eq.emitch4.calctot(1990);
        }
        return f;
    }

    public float mac(region region2) {
        return this.mac(region2, module.year);
    }

    public float mac(region region2, int n) {
        return (float)((double)(this.beta(region2) * this.alpha(region2)) * Math.pow(this.eq.emitfosabate.get(region2, n - 1), this.beta(region2) - 1.0f));
    }

    public float dc(region region2) {
        if (this.impfunc.chosen == "cws") {
            return (float)((double)this.gdp(region2) * this.damagelin.getval() * (double)this.a1.get(region2).floatValue() * Math.pow((double)this.gm(glotemp.class).avchange.get(year) / 2.5, this.damagepow.getval()));
        }
        if (this.impfunc.chosen == "rice99") {
            float f = this.gm(glotemp.class).avchange.get(year) - this.gm(glotemp.class).avchange.get(1990);
            float f2 = this.th1.get(region2).floatValue() * f + this.th2.get(region2).floatValue() * f * f;
            return this.gdp(region2) * (float)this.damagelin.getval() * (f2 / 1.0f + f2);
        }
        return 0.0f;
    }

    public float ew(region region2) {
        return this.ew(region2, module.year);
    }

    public float ew(region region2, int n) {
        return (float)Math.pow(this.soc.pop.get(region2) / this.gdp(region2) * this.base, this.ineqav.getval());
    }

    void ewbase() {
        if (this.dyngdp.istrue()) {
            this.base = 0.0f;
            for (region region2 : this.regions) {
                this.base += this.gdp(region2);
            }
            this.base /= this.soc.pop.get(regman.world);
        } else {
            this.base = this.soc.gdp_ppp.get(regman.world) / this.soc.pop.get(regman.world);
        }
    }

    Map<region, Float> interpolatefac(double[] dArray, String string, curveset curveset2) {
        int n = 2002;
        HashMap<region, Float> hashMap = new HashMap<region, Float>();
        List<region> list = regman.allreg.findreg((String)string).reg;
        for (region region2 : this.regions) {
            float f = 0.0f;
            float f2 = 0.0f;
            Set<region> set = region2.subreg(regman.nations);
            for (region region3 : list) {
                int n2 = list.indexOf(region3);
                for (region region4 : region3.subreg(regman.nations)) {
                    if (!set.contains(region4)) continue;
                    f = (float)((double)f + dArray[n2] * (double)curveset2.get(region4, n));
                    f2 += curveset2.get(region4, n);
                }
            }
            hashMap.put(region2, Float.valueOf(f / f2));
        }
        return hashMap;
    }
}

