/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.scen;

import java.util.EnumSet;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.report;
import jcm.mod.scen.sspData;

public class sspChooser
extends module {
    public param<sspData.plots> chooplot = new param(new Object[]{"applyto", sspData.plots.values(), sspData.plots.plot1});
    public param<sspData.types> compare = new param(new Object[]{"compare", sspData.types.values(), sspData.types.regions});
    public param<sspData.models> choomod = new param(new Object[]{"iam_model", sspData.models.values(), sspData.models.IMAGE});
    public param<sspData.ssps> choossp = new param(new Object[]{"ssp", sspData.ssps.values(), sspData.ssps.SSP2});
    public param<sspData.rcps> choorcp = new param(new Object[]{"rcp", sspData.rcps.values(), sspData.rcps.Ref});
    public param<sspData.gases> choogas = new param(new Object[]{"gas", sspData.gases.values(), sspData.gases.CO2_TOT});
    public param<sspData.regions> chooreg = new param(new Object[]{"region", sspData.regions.values(), sspData.regions.World});
    param[] pp = new param[]{this.choomod, this.choossp, this.choorcp, this.choogas, this.chooreg};
    sspData.types lastvary = null;
    public sspData.run chosenSSPrun;
    sspData.gases gas;
    sspData.regions reg;
    sspData.models mod;
    sspData.ssps ssp;
    sspData.rcps rcp;

    @Override
    public void initsetup() {
        this.makecurves();
        this.chooplot.chosen = sspData.plots.plot1;
    }

    @Override
    public void setinteractions() {
    }

    @Override
    public void precalc() {
        this.setchoices();
        this.setcurve((curveset)this.curvesets.get(((sspData.plots)((Object)this.chooplot.chosen)).ordinal()));
    }

    void setchoices() {
        this.gas = (sspData.gases)((Object)this.choogas.chosen);
        this.reg = (sspData.regions)((Object)this.chooreg.chosen);
        this.mod = (sspData.models)((Object)this.choomod.chosen);
        this.ssp = (sspData.ssps)((Object)this.choossp.chosen);
        this.rcp = (sspData.rcps)((Object)this.choorcp.chosen);
        sspData.run run2 = sspData.find(this.mod, this.ssp, this.rcp);
        if (run2 == null) {
            report.deb("No SSP data for " + (Object)((Object)this.mod) + " " + (Object)((Object)this.ssp) + " " + (Object)((Object)this.rcp) + ", continue using old run!");
        } else {
            this.chosenSSPrun = run2;
        }
    }

    void makecurves() {
        for (sspData.plots plots2 : sspData.plots.values()) {
            curveset curveset2 = new curveset(new Object[]{plots2.name(), "units_to_fix", 2010, 2100, 10, complexity.expert});
            this.curvesets.add(curveset2);
            this.addOb(curveset2);
            curveset2.owner = this;
            curveset2.setaffectedby(this);
        }
    }

    public String getunits(sspData.gases gases2) {
        String string;
        String string2 = string = EnumSet.of(sspData.gases.N2O_TOT, sspData.gases.N2O_LUC).contains((Object)gases2) ? "kilo&ton&" : "mega&ton&";
        String string3 = gases2 == sspData.gases.Fgas ? "CO2eq" : (gases2 == sspData.gases.Sulfur ? "SO2" : (gases2 == sspData.gases.NOx ? "NO2" : (EnumSet.of(sspData.gases.CO, sspData.gases.VOC, sspData.gases.BC, sspData.gases.OC).contains((Object)gases2) ? gases2.name() : gases2.name().substring(0, 3))));
        return string + string3 + "&per&year";
    }

    void setcurve(curveset curveset2) {
        try {
            Enum[] enumArray = new Enum[]{this.mod, this.ssp, this.rcp, this.gas, this.reg};
            sspData.types types2 = (sspData.types)((Object)this.compare.chosen);
            String string = "";
            Enum[] enumArray2 = null;
            for (Enum enum_ : enumArray) {
                if (types2.name().equals(enum_.getClass().getSimpleName())) {
                    enumArray2 = (Enum[])enum_.getClass().getEnumConstants();
                    continue;
                }
                string = string + "_" + enum_.name();
            }
            curveset2.name = string = string + ": " + types2.name();
            curveset2.map.clear();
            curveset2.units = this.getunits(this.gas);
            for (Enum enum_ : enumArray2) {
                for (int i = 0; i < enumArray.length; ++i) {
                    if (!enumArray[i].getClass().equals(enum_.getClass())) continue;
                    enumArray[i] = enum_;
                }
                sspData.run run2 = sspData.find((sspData.models)enumArray[0], (sspData.ssps)enumArray[1], (sspData.rcps)enumArray[2]);
                if (run2 == null) {
                    report.deb("-no data");
                    continue;
                }
                float[] fArray = run2.get((sspData.gases)enumArray[3], (sspData.regions)enumArray[4]);
                for (int i = 1; i < 11; ++i) {
                    curveset2.set(enum_, 2000 + i * 10, fArray[i]);
                }
            }
            this.lastvary = types2;
            report.deb("ssp_data made curveset: " + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

