/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.resp;

import java.util.EnumMap;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.dataholder;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresimgdata;

public class matchdata
extends module
implements dataholder {
    public EnumMap<gas, EnumMap<sector, EnumMap<lbu, curveset>>> emitmap;

    @Override
    public void initsetup() {
        try {
            this.makemap();
            this.loaddata(sresimgdata.scen.none);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setaffectedby(this.gm(sresBase.class).scenario);
    }

    @Override
    public void precalc() {
        this.loaddata();
    }

    public curveset emit(Object ... objectArray) {
        gas gas2 = gas.CO2;
        sector sector2 = sector.enin;
        lbu lbu2 = lbu.best;
        for (Object object : objectArray) {
            if (object instanceof gas) {
                gas2 = (gas)((Object)object);
            }
            if (object instanceof sector) {
                sector2 = (sector)((Object)object);
            }
            if (!(object instanceof lbu)) continue;
            lbu2 = (lbu)((Object)object);
        }
        Object object = this.emitmap.get((Object)gas2).get((Object)sector2).get((Object)lbu2);
        if (object != null) {
            return object;
        }
        object = new curveset("" + (Object)((Object)gas2) + "_" + (Object)((Object)sector2) + "_" + (Object)((Object)lbu2), "kilo&ton&" + (Object)((Object)gas2), 1750, 2100);
        ((curveset)object).owner = this;
        ((interacob)object).setaffectedby(this);
        this.curvesets.add(object);
        this.addOb((infob)object);
        ((interacob)object).register();
        this.emitmap.get((Object)gas2).get((Object)sector2).put(lbu2, (curveset)object);
        return object;
    }

    void makemap() {
        this.emitmap = new EnumMap(gas.class);
        for (gas gas2 : gas.values()) {
            this.emitmap.put(gas2, new EnumMap(sector.class));
            for (sector sector2 : sector.values()) {
                this.emitmap.get((Object)gas2).put(sector2, new EnumMap(lbu.class));
            }
        }
    }

    public static int sy(sresimgdata.scen scen2) {
        return scen2 == sresimgdata.scen.none ? 1750 : 2000;
    }

    public static int ey(sresimgdata.scen scen2) {
        return scen2 == sresimgdata.scen.none ? 2005 : 2100;
    }

    void loaddata() {
        sresimgdata.scen scen2 = (sresimgdata.scen)((Object)this.gm(sresBase.class).scenario.chosen);
        if (scen2 == null) {
            report.deb("no matchdata for scenario !");
            return;
        }
        this.loaddata(scen2);
    }

    void loaddata(sresimgdata.scen scen2) {
        for (gas gas2 : gas.values()) {
            for (lbu lbu2 : lbu.values()) {
                for (sector sector2 : sector.values()) {
                    if (sector2 == sector.lucf && (gas2 != gas.CO2 || scen2 != sresimgdata.scen.A1B && scen2 != sresimgdata.scen.B2 && scen2 != sresimgdata.scen.none)) continue;
                    String string = (Object)((Object)gas2) + "_" + (Object)((Object)sector2) + "_" + (Object)((Object)lbu2) + "_" + (Object)((Object)scen2) + ".tab";
                    try {
                        String[][] stringArray = fileio.loadtab("match-emitdata/" + string, "\t");
                        curveset curveset2 = this.emit(new Object[]{gas2, lbu2, sector2});
                        for (int i = 1; i < stringArray.length; ++i) {
                            string = stringArray[i][0];
                            region region2 = regman.allreg.findormakereg(string, "matchdata: ");
                            if (region2 == null) {
                                report.deb("matchdata " + string + " not in countrynames");
                            }
                            curve curve2 = curveset2.getOrAddCurve(region2 != null ? region2 : string);
                            for (int j = 1; j < stringArray[i].length; ++j) {
                                curve2.set(j + matchdata.sy(scen2) - 1, Float.parseFloat(stringArray[i][j]));
                            }
                        }
                    }
                    catch (Exception exception) {
                        report.deb(exception + "\ntrying to load " + string);
                    }
                }
            }
        }
    }

    public static enum sector {
        enin,
        agwa,
        lucf;

    }

    public static enum lbu {
        lower,
        best,
        upper;

    }

    public static enum gas {
        CO2,
        CH4,
        N2O;

    }
}

