/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.resp;

import java.util.List;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.register;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carbonatechemistry;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.udebclimod;
import jcm.mod.obj.regset;
import jcm.mod.ogas.aerosol;
import jcm.mod.ogas.atchem;
import jcm.mod.ogas.fgas;
import jcm.mod.resp.responsibility;

public class attribTracer
extends module {
    public curveset atco2 = new curveset("atco2", "ppm");
    public curveset atch4 = new curveset("atch4", "ppb");
    public curveset atn2o = new curveset("atn2o", "ppb");
    public curveset rfco2 = new curveset("rfco2", "w&per&m2");
    public curveset rfch4 = new curveset("rfch4", "w&per&m2");
    public curveset rfn2o = new curveset("rfn2o", "w&per&m2");
    public curveset rftot = new curveset("rftot", "w&per&m2");
    public curveset surftemp = new curveset("surftemp", "degrees&C");
    public curveset surftemprel = new curveset("surftemp&relative", "%");
    public curveset sealevte = new curveset("sealevte", "metres");
    static final int ncb = 43;
    static final int nhb = 40;
    float[] ls;
    float[] hs;
    float[] so;
    float[] hu;
    float[][] ciq;
    float[][][] hiq;
    float[][] acccbox;
    int nregs;
    int oldnregs = 0;
    int nrf;
    int nemit;
    int oth;
    List<region> reg;
    responsibility resp;
    carboncycle carbon;
    regset socreg;
    region bestafen;
    region othgasreg;
    region aerosolreg;
    region solvolreg;
    float sink;
    float atinc;
    float lsinc;
    float hsinc;
    float fracco2rise;
    float fracls;
    float frachs;
    float totls;
    float toths;
    float totat;
    float npinc;
    float dls;
    float dhs;
    float dnp;
    float dat;
    float soinc;
    float huinc;
    float totso;
    float tothu;
    float dso;
    float dhu;
    float glotemprise;
    float gloco2rise;
    float fraccarbfb;
    float fractemprise;
    float extrach4;
    float extran2o;
    float fracn2o;
    float dc;
    float qin;
    float qinold;
    float dqin;
    float[] rff = new float[2];
    float[] sf = new float[2];
    float[] mlt = new float[2];
    float[] boxtemp = new float[4];

    @Override
    public void initsetup() {
        this.resp = this.gm(responsibility.class);
        this.carbon = this.gm(carboncycle.class);
        this.socreg = this.gm(regset.class);
        this.bestafen = this.resp.bestafen;
        this.othgasreg = this.resp.othgasreg;
        this.aerosolreg = this.resp.aerosolreg;
        this.solvolreg = this.resp.solvolreg;
        this.follows(this.resp);
        register.requires(this, this.carbon, true);
        register.requires(this, this.gm(glotemp.class), true);
        register.requires(this, this.gm(berncarbon.class), true);
        register.requires(this, this.gm(udebclimod.class), true);
    }

    @Override
    public void precalc() {
        this.makeboxes();
        loop.calcfutureonly = false;
        for (curveset curveset2 : this.curvesets) {
            this.gm(regset.class).clearoldregions(curveset2);
        }
        for (curveset curveset2 : this.curvesets) {
            curveset2.associate(this.resp.startyear, this.resp.endyear);
        }
    }

    @Override
    public void calcstep() {
        if (year > 2100 && (double)year > this.resp.endyear.getval()) {
            return;
        }
        this.carbonstep();
        this.atchemstep();
        this.rfstep();
        this.glotempstep();
        this.tottemp();
    }

    @Override
    public void postcalc() {
        if (this.resp.removeextrareg.istrue()) {
            for (curveset curveset2 : this.curvesets) {
                curveset2.map.remove(this.bestafen);
                curveset2.map.remove(this.aerosolreg);
                curveset2.map.remove(this.othgasreg);
                curveset2.map.remove(this.solvolreg);
            }
        }
    }

    void tottemp() {
        float f = 0.0f;
        for (region region2 : this.reg) {
            f += this.surftemp.get(region2);
        }
        for (region region2 : this.reg) {
            this.surftemprel.set(region2, 100.0f * this.surftemp.get(region2) / f);
        }
    }

    region reg(int n) {
        return this.resp.reg(n);
    }

    public void makeboxes() {
        this.reg = ((region)this.gm(regset.class).regions.chosen).reg;
        this.nregs = this.resp.nregs;
        if (this.nregs != this.oldnregs) {
            this.oldnregs = this.nregs;
            this.nemit = this.nregs + 1;
            this.nrf = this.nregs + 4;
            this.oth = this.nregs;
        }
        this.ciq = new float[this.nrf][43];
        this.ls = new float[this.nrf];
        this.hs = new float[this.nrf];
        this.so = new float[this.nrf];
        this.hu = new float[this.nrf];
        this.acccbox = new float[this.nrf][4];
        this.hiq = new float[this.nrf][2][40];
    }

    void carbonstep() {
        int n;
        if (this.carbon.accccarbon.istrue()) {
            int n2;
            if (year == gsy) {
                for (n2 = 0; n2 < 4; ++n2) {
                    this.acccbox[this.oth][n2] = this.carbon.acccbox[n2];
                    for (int i = 0; i < this.nregs; ++i) {
                        this.acccbox[i][n2] = 0.0f;
                    }
                }
            }
            for (n2 = 0; n2 < this.nrf; ++n2) {
                this.atco2.set(this.reg(n2), this.carbon.acccmod(this.acccbox[n2], this.resp.totco2emit(this.reg(n2), year)));
            }
            return;
        }
        berncarbon berncarbon2 = this.gm(berncarbon.class);
        carboncycle carboncycle2 = this.carbon;
        boolean bl = this.gm(carbonatechemistry.class).chemfeedback.istrue();
        this.gloco2rise = carboncycle2.co2atppm.get(year - 1) - 278.0f;
        this.glotemprise = this.gm(glotemp.class).avchange.get(year - 1);
        if (!bl || (double)Math.abs(this.glotemprise) < 0.02) {
            this.fraccarbfb = 1.0f;
        } else {
            this.fraccarbfb = Math.abs(0.008f * this.gloco2rise / this.glotemprise);
            if (this.fraccarbfb > 1.0f) {
                this.fraccarbfb = 1.0f;
            }
        }
        for (n = 0; n < this.nrf; ++n) {
            int n3;
            region region2 = this.reg(n);
            if (year == gsy) {
                for (n3 = 0; n3 < 43; ++n3) {
                    this.ciq[n][n3] = n == this.oth ? (float)berncarbon2.ciq[n3] : 0.0f;
                }
            }
            if ((double)year < this.resp.startyear.getval() && n < this.nregs) {
                this.atco2.set(region2, 0.0f);
                continue;
            }
            this.fracco2rise = year > gsy ? this.atco2.get(region2, year - 1) / this.gloco2rise : 0.0f;
            float f = this.fractemprise = year > gsy ? this.surftemp.get(region2, year - 1) / this.glotemprise : 0.0f;
            if (Math.abs(this.gloco2rise) < 10.0f) {
                this.fracco2rise = 0.0f;
            }
            if ((double)Math.abs(this.glotemprise) < 0.1) {
                this.fractemprise = 0.0f;
            }
            this.fracls = year > gsy ? this.fraccarbfb * this.ls[n] / this.totls + (1.0f - this.fraccarbfb) * this.fractemprise : 0.0f;
            this.frachs = year > gsy ? this.fraccarbfb * this.hs[n] / this.toths + (1.0f - this.fraccarbfb) * this.fractemprise : 0.0f;
            this.atco2.set(region2, 0.0f);
            this.ls[n] = 0.0f;
            this.hs[n] = 0.0f;
            this.so[n] = 0.0f;
            this.hu[n] = 0.0f;
            this.lsinc = (float)berncarbon2.oldlsinc * this.fracls;
            this.hsinc = (float)berncarbon2.oldhsinc * this.frachs;
            this.npinc = (float)berncarbon2.oldnpinc * this.fracco2rise;
            this.soinc = (float)berncarbon2.oldsoinc * this.fractemprise;
            this.huinc = (float)berncarbon2.oldhuinc * this.fractemprise;
            this.atinc = this.resp.totco2emit(region2, year - 1) - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
            this.dls = (float)berncarbon2.dls * this.fracls;
            this.dhs = (float)berncarbon2.dhs * this.frachs;
            this.dnp = (float)berncarbon2.dnp * this.fracco2rise;
            this.dso = (float)berncarbon2.dso * this.fractemprise;
            this.dhu = (float)berncarbon2.dhu * this.fractemprise;
            this.dat = this.resp.totco2emit(region2, year) - this.resp.totco2emit(region2, year - 1) - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
            for (n3 = 0; n3 < 43; ++n3) {
                this.ciq[n][n3] = (float)((double)this.ciq[n][n3] * berncarbon2.cpropf[n3] + berncarbon2.scicAT[n3] * (double)this.atinc + berncarbon2.scicLS[n3] * (double)this.lsinc + berncarbon2.scicHS[n3] * (double)this.hsinc + berncarbon2.scicNP[n3] * (double)this.npinc + berncarbon2.rcicAT[n3] * (double)this.dat + berncarbon2.rcicLS[n3] * (double)this.dls + berncarbon2.rcicHS[n3] * (double)this.dhs + berncarbon2.rcicNP[n3] * (double)this.dnp + berncarbon2.scicSO[n3] * (double)this.soinc + berncarbon2.rcicSO[n3] * (double)this.dso + berncarbon2.scicHU[n3] * (double)this.huinc + berncarbon2.rcicHU[n3] * (double)this.dhu);
                this.atco2.set(region2, this.atco2.get(region2) + (float)berncarbon2.crAT[n3] * this.ciq[n][n3]);
                int n4 = n;
                this.ls[n4] = this.ls[n4] + (float)berncarbon2.crLS[n3] * this.ciq[n][n3];
                int n5 = n;
                this.hs[n5] = this.hs[n5] + (float)berncarbon2.crHS[n3] * this.ciq[n][n3];
                int n6 = n;
                this.so[n6] = this.so[n6] + (float)berncarbon2.crSO[n3] * this.ciq[n][n3];
                int n7 = n;
                this.hu[n7] = this.hu[n7] + (float)berncarbon2.crHU[n3] * this.ciq[n][n3];
            }
            this.atco2.set(region2, this.atco2.get(region2) * 4.71E-4f);
        }
        this.totls = 0.0f;
        this.toths = 0.0f;
        this.totat = 0.0f;
        this.totso = 0.0f;
        this.tothu = 0.0f;
        for (n = 0; n < this.nrf; ++n) {
            this.totls += this.ls[n];
            this.toths += this.hs[n];
            this.totat += this.atco2.get(this.reg(n));
            this.totso += this.so[n];
            this.tothu += this.hu[n];
        }
    }

    void atchemstep() {
        if (year == gsy) {
            for (int i = 0; i < this.nregs; ++i) {
                this.atch4.set(this.reg(i), 0.0f);
                this.atn2o.set(this.reg(i), 0.0f);
            }
            float f = this.gm(atchem.class).ch4conc.get();
            this.gm(atchem.class);
            this.atch4.set(this.bestafen, f - atchem.ch4prein);
            this.atch4.set(this.othgasreg, 0.0f);
            this.atn2o.set(this.bestafen, this.gm(atchem.class).n2oconc.get() - this.gm(atchem.class).n2oprein);
            this.atn2o.set(this.othgasreg, 0.0f);
        } else {
            for (int i = 0; i < this.nemit; ++i) {
                region region2 = this.reg(i);
                float f = this.atch4.get(region2, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).ch4life(year));
                this.gm(atchem.class);
                this.atch4.set(region2, f + atchem.ppbpmtch4 * this.resp.ch4emit(region2, year));
                this.atn2o.set(region2, this.atn2o.get(region2, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).n2olife(year)) + this.gm(atchem.class).ppbpmtn2o * this.resp.n2oemit(region2, year));
            }
            this.gm(atchem.class);
            float f = atchem.ppbpmtch4 * this.gm(atchem.class).ch4emitnat();
            this.gm(atchem.class);
            this.extrach4 = f - atchem.ch4prein / this.gm(atchem.class).ch4life(year);
            this.atch4.set(this.othgasreg, this.atch4.get(this.othgasreg, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).ch4life(year)) + this.extrach4);
            this.extran2o = this.gm(atchem.class).ppbpmtn2o * this.gm(atchem.class).n2oemitnat() - this.gm(atchem.class).n2oprein / this.gm(atchem.class).n2olife(year);
            this.atn2o.set(this.othgasreg, this.atn2o.get(this.othgasreg, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).n2olife(year)) + this.extran2o);
        }
    }

    void rfstep() {
        int n;
        atchem atchem2 = this.gm(atchem.class);
        for (n = 0; n < this.nrf; ++n) {
            region region2 = this.reg(n);
            if (this.resp.method.equals("tracer+differentialRF") && (double)year > this.resp.startyear.getval() + 1.0) {
                int n2 = year > gsy ? year - 1 : gsy;
                this.dc = this.carbon.co2atppm.get() - this.carbon.co2atppm.get(n2);
                this.rfco2.set(region2, n2, this.rfco2.get(region2, n2) + ((double)Math.abs(this.dc) > 1.0E-4 ? (this.carbon.co2rf.get() - this.carbon.co2rf.get(n2)) * (this.atco2.get(region2) - this.atco2.get(region2, n2)) / this.dc : 0.0f));
                if (n >= this.nemit + 1) continue;
                this.dc = atchem2.n2oconc.get() - atchem2.n2oconc.get(n2);
                this.rfn2o.set(region2, this.rfn2o.get(region2, n2) + ((double)Math.abs(this.dc) > 1.0E-4 ? (atchem2.n2orf.get() - atchem2.n2orf.get(n2)) * (this.atn2o.get(region2) - this.atn2o.get(region2, n2)) / this.dc : 0.0f));
                this.dc = atchem2.ch4conc.get() - atchem2.ch4conc.get(n2);
                this.rfch4.set(region2, this.rfch4.get(region2, n2) + ((double)Math.abs(this.dc) > 1.0E-4 ? (atchem2.ch4rf.get() - atchem2.ch4rf.get(n2)) * (this.atch4.get(region2) - this.atch4.get(region2, n2)) / this.dc : 0.0f));
                continue;
            }
            this.dc = this.carbon.co2atppm.get() - 278.0f;
            this.rfco2.set(region2, this.atco2.get(region2) * ((double)Math.abs(this.dc) > 1.0E-4 ? this.carbon.co2rf.get() / this.dc : 0.0f));
            if (n >= this.nemit + 1) continue;
            this.dc = atchem2.n2oconc.get() - atchem2.n2oprein;
            this.rfn2o.set(region2, this.atn2o.get(region2) * ((double)Math.abs(this.dc) > 1.0E-4 ? atchem2.n2orf.get() / this.dc : 0.0f));
            this.dc = atchem2.ch4conc.get() - atchem.ch4prein;
            this.rfch4.set(region2, this.atch4.get(region2) * ((double)Math.abs(this.dc) > 1.0E-4 ? atchem2.ch4rf.get() / this.dc : 0.0f));
        }
        for (n = 0; n < this.nemit; ++n) {
            this.rftot.set(this.reg(n), this.rfco2.get(this.reg(n)) + (this.resp.includeCH4N2O.istrue() ? this.rfch4.get(this.reg(n)) + this.rfn2o.get(this.reg(n)) : 0.0f));
        }
        this.rftot.set(this.othgasreg, this.rfco2.get(this.othgasreg) + this.rfch4.get(this.othgasreg) + this.rfn2o.get(this.othgasreg) + this.gm(fgas.class).cfcrf.get() + this.gm(fgas.class).hfcrf.get() + atchem2.strath2orf.get() + atchem2.tropo3rf.get() + this.gm(fgas.class).strato3rf.get());
        if (!this.resp.includeCH4N2O.istrue()) {
            for (n = 0; n < this.nemit; ++n) {
                this.rftot.set(this.othgasreg, this.rftot.get(this.othgasreg) + this.rfch4.get(this.reg(n)) + this.rfn2o.get(this.reg(n)));
            }
        }
        this.rftot.set(this.aerosolreg, this.rfco2.get(this.aerosolreg) + this.gm(aerosol.class).aerorf.get());
        this.rftot.set(this.solvolreg, this.rfco2.get(this.solvolreg) + this.gm(aerosol.class).natvrf.get());
    }

    void udebclimodsetup() {
        udebclimod udebclimod2 = this.gm(udebclimod.class);
        for (int i = 0; i < 2; ++i) {
            this.rff[i] = (float)(1.0 + udebclimod2.frac[i * 3] / udebclimod2.frac[i + 1] * udebclimod2.klo / (udebclimod2.kls * udebclimod2.frac[i * 3] + udebclimod2.klo));
            this.sf[i] = (float)(udebclimod2.spaceflux[i] * udebclimod2.qpt * udebclimod2.tstart);
            for (int j = 0; j < 40; ++j) {
                for (int k = 0; k < this.nrf; ++k) {
                    this.hiq[k][i][j] = (float)(k == this.oth ? udebclimod2.hiq[i][j] : udebclimod2.hiqstart[i][j]);
                }
            }
        }
    }

    void glotempstep() {
        if (year == gsy) {
            this.udebclimodsetup();
        }
        udebclimod udebclimod2 = this.gm(udebclimod.class);
        for (int i = 0; i < this.nrf; ++i) {
            int n;
            region region2 = this.reg(i);
            this.surftemp.set(region2, 0.0f);
            this.sealevte.set(region2, 0.0f);
            if ((double)year < this.resp.startyear.getval() && i < this.nregs || year == gsy && region2 == this.resp.othgasreg) continue;
            for (n = 0; n < 2; ++n) {
                this.mlt[n] = 0.0f;
                this.qinold = this.sf[n] + (year > gsy ? this.rftot.get(region2, year - 1) : 0.0f) * this.rff[n];
                this.qin = this.sf[n] + this.rftot.get(region2) * this.rff[n];
                this.dqin = this.qin - this.qinold;
                for (int j = 0; j < 40; ++j) {
                    this.hiq[i][n][j] = (float)(udebclimod2.hpropf[n][j] * (double)this.hiq[i][n][j] + udebclimod2.shicML[n][j] * (double)this.qinold + udebclimod2.rhicML[n][j] * (double)this.dqin);
                    int n2 = n;
                    this.mlt[n2] = this.mlt[n2] + (float)udebclimod2.hrML[n][j] * this.hiq[i][n][j];
                    this.sealevte.set(region2, this.sealevte.get(region2) + (float)udebclimod2.hrsl[n][j] * this.hiq[i][n][j]);
                }
                this.mlt[n] = (float)((double)this.mlt[n] / udebclimod2.qpt - udebclimod2.tstart);
            }
            this.sealevte.set(region2, this.sealevte.get(region2) - (float)udebclimod2.sealevteinit);
            this.boxtemp[0] = (float)(((double)this.mlt[0] * udebclimod2.cice * udebclimod2.klo + udebclimod2.frac[0] * (double)this.rftot.get(region2)) / (udebclimod2.kls * udebclimod2.frac[0] + udebclimod2.klo));
            this.boxtemp[3] = (float)(((double)this.mlt[1] * udebclimod2.cice * udebclimod2.klo + udebclimod2.frac[3] * (double)this.rftot.get(region2)) / (udebclimod2.kls * udebclimod2.frac[3] + udebclimod2.klo));
            this.boxtemp[1] = (float)((double)this.mlt[0] * udebclimod2.cice);
            this.boxtemp[2] = (float)((double)this.mlt[1] * udebclimod2.cice);
            for (n = 0; n < 4; ++n) {
                this.surftemp.set(region2, this.surftemp.get(region2) + (float)((double)this.boxtemp[n] * udebclimod2.frac[n]));
            }
        }
    }
}

