/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regimp;

import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.EOFException;
import jcm.core.reg.region;
import jcm.core.reg.regpoly;
import jcm.core.report;
import jcm.core.tls.fileio;

public class mapdata {
    public byte[][] o;
    public float[] r;
    public int nmon;
    public int nlon;
    public int nlat;
    public int tot;
    public double max;
    public double min;
    public double range;
    public double fac = 1.0;
    public double av;
    public double sd;
    public double sum;
    public double sumsq;
    public double area;
    public boolean gettingdata = false;

    public boolean getdata(String string, String string2) {
        if (!this.gettingdata) {
            this.gettingdata = true;
            boolean bl = string.equals("baseline");
            String string3 = string + "." + string2 + ".dat";
            try {
                String string4 = string3.equals("had3_A2_80.tmp.dat") ? "data/" : "";
                DataInputStream dataInputStream = fileio.getDIS(string4 + "gcmdata/" + string3);
                this.nmon = dataInputStream.readShort();
                this.nlat = dataInputStream.readShort();
                this.nlon = dataInputStream.readShort();
                this.min = dataInputStream.readFloat();
                this.max = dataInputStream.readFloat();
                this.tot = this.nlon * this.nlat;
                this.range = this.max - this.min;
                this.o = new byte[this.nmon][this.tot + 1];
                this.r = new float[this.tot + 1];
                if (bl) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    try {
                        int n4 = 0;
                        boolean bl2 = false;
                        do {
                            if (bl2 && n3 < n4) {
                                this.o[n2][n] = -1;
                                ++n;
                                ++n3;
                            } else if (n4 == 255) {
                                bl2 = true;
                                n3 = 0;
                                n4 = dataInputStream.readUnsignedByte();
                            } else {
                                if (bl2) {
                                    bl2 = false;
                                } else {
                                    this.o[n2][n] = (byte)n4;
                                    ++n;
                                }
                                n4 = dataInputStream.readUnsignedByte();
                            }
                            if (n != this.nlat * this.nlon) continue;
                            n = 0;
                            ++n2;
                        } while (n2 < this.nmon);
                    }
                    catch (EOFException eOFException) {
                        report.deb("EOF m:" + n2 + " i:" + n);
                    }
                } else {
                    for (int i = 0; i < this.nmon; ++i) {
                        int n = 0;
                        while ((n += dataInputStream.read(this.o[i], n, this.tot - n)) < this.tot) {
                        }
                    }
                }
                dataInputStream.close();
                this.stats();
                report.log("loaded " + string3 + " av=" + this.av + " sd=" + this.sd + " min=" + this.min + " max=" + this.max);
                this.gettingdata = false;
                return true;
            }
            catch (Exception exception) {
                report.log("Mapdata Loading Problem: " + string3 + exception.getMessage());
                report.log("Mapdata Loading Problem" + string3);
                for (int i = 0; i < this.tot; ++i) {
                    for (int j = 0; j < this.nmon; ++j) {
                        this.o[j][i] = -1;
                    }
                }
                this.gettingdata = false;
                return false;
            }
        }
        return false;
    }

    public void restore(int n) {
        double d = this.range / 254.0;
        for (int i = 0; i < this.tot; ++i) {
            this.r[i] = this.o[n][i] == -1 ? Float.NaN : (float)(this.min + d * (double)(this.o[n][i] >= 0 ? this.o[n][i] : 256 + this.o[n][i]));
        }
        this.fac = 1.0;
    }

    public void stats() {
        this.sum = 0.0;
        this.sumsq = 0.0;
        this.area = 0.0;
        for (int i = 0; i < this.nmon; ++i) {
            this.restore(i);
            for (int j = 0; j < this.nlat; ++j) {
                double d = Math.sin((0.5 + (double)j) * Math.PI / (double)this.nlat);
                for (int k = 0; k < this.nlon; ++k) {
                    int n = this.nlon * j + k;
                    if (!mapdata.notdud(this.r[n])) continue;
                    this.area += d;
                    this.sum += d * (double)this.r[n];
                    this.sumsq += d * (double)this.r[n] * (double)this.r[n];
                }
            }
        }
        this.av = this.sum / this.area;
        this.sd = Math.pow(this.sumsq / this.area - this.av * this.av, 0.5);
    }

    public void scaledata(double d) {
        double d2 = d / this.fac;
        this.fac = d;
        for (int i = 0; i < this.tot; ++i) {
            if (!mapdata.notdud(this.r[i])) continue;
            int n = i;
            this.r[n] = (float)((double)this.r[n] * d2);
        }
    }

    public static boolean notdud(float f) {
        return f >= -999.0f && !Float.isNaN(f);
    }

    public static boolean dud(float f) {
        return f <= -999.0f || Float.isNaN(f);
    }

    public float avg(region region2) {
        if (region2.name.startsWith("PAC_") && region2.name.length() == 6) {
            return Float.NaN;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (regpoly regpoly2 : region2.polyset) {
            Rectangle rectangle = regpoly2.getBoundingBox();
            int n = 5;
            for (int i = rectangle.x; i < rectangle.x + rectangle.width; i += n) {
                int n2 = Math.min(rectangle.x + rectangle.width - i, n);
                for (int j = rectangle.y; j < rectangle.y + rectangle.height; j += n) {
                    int n3 = Math.min(rectangle.y + rectangle.height - j, n);
                    if (!regpoly2.intersects(i, j, n2, n3)) continue;
                    boolean bl = regpoly2.contains(i, j, n2, n3);
                    for (int k = j; k < j + n3; ++k) {
                        d = Math.cos(Math.PI * (double)k / 180.0);
                        for (int i2 = i; i2 < i + n2; ++i2) {
                            if (!bl && !regpoly2.contains(i2, k)) continue;
                            int n4 = this.findcell(i2, k);
                            try {
                                if (mapdata.notdud(this.r[n4])) {
                                    d2 += (double)this.r[n4] * d;
                                    d3 += d;
                                    continue;
                                }
                                d4 += d;
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                d4 += d;
                            }
                        }
                    }
                }
            }
        }
        if (d3 > d4) {
            return (float)(d2 / d3);
        }
        return Float.NaN;
    }

    int findcell(int n, int n2) {
        int n3 = (int)(0.5 + (double)(this.nlon * ((n + 360) % 360)) / 360.0);
        int n4 = (int)(0.5 + (double)(this.nlat * (90 - n2)) / 180.0);
        return n4 * this.nlon + n3;
    }
}

