/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regimp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.mod.cli.sealevel;
import jcm.mod.math.interp1D;
import jcm.mod.math.runAverage;
import jcm.mod.obj.regset;
import jcm.mod.socio.popgdp;

public class SLRimpacts
extends module {
    public curveset slrimpact_phz = new curveset("slrimpact_phz", "people at risk");
    public curveset slrimpact_pc = new curveset("slrimpact_pc", "protection class");
    public curveset slrimpact_aapf = new curveset("slrimpact_aapf", "person&per&year");
    public static String[] listadapt = new String[]{"none", "mini", "average", "full"};
    public static param typeadapt = new param(new Object[]{"adaptmenu", listadapt, "none", complexity.simplest});
    List<region> regset;
    Map<region, Set<region>> subregs = new HashMap<region, Set<region>>();
    static int nslr;
    sealevel sealevel;
    popgdp socio;
    regset socreg;
    static float[][] ppm;
    static boolean reportederror;
    static String[] regnameslr;
    static String[] regnamejcm;
    static float[][] ppermeter;
    static Object[] slreg;
    static int[][] redproslr;
    static int[] isdeltaic;
    static float[] retuper;
    static interp1D[] gdptopro;
    static interp1D[] hiwatlev;
    static runAverage[] gdprunav;

    @Override
    public void initsetup() {
        this.mycomplexity = complexity.experimental;
        this.sealevel = this.gm(sealevel.class);
        this.socreg = this.gm(regset.class);
        this.socio = this.gm(popgdp.class);
        this.follows(this.sealevel);
        this.follows(this.socio);
        SLRimpacts.importdata();
    }

    @Override
    public void precalc() {
        this.regset = ((region)this.socreg.regions.chosen).reg;
        this.socreg.clearoldregions(this.slrimpact_phz);
        this.socreg.clearoldregions(this.slrimpact_pc);
        this.socreg.clearoldregions(this.slrimpact_aapf);
        for (int i = 0; i < nslr; ++i) {
            region region2 = regman.allreg.find(regnamejcm[i]);
            for (region region3 : this.regset) {
                if (!region3.contains(region2)) continue;
                SLRimpacts.slreg[i] = region3;
            }
            if (slreg[i] == null) {
                SLRimpacts.slreg[i] = regman.world;
            }
            gdprunav[i].reset();
        }
        reportederror = false;
    }

    @Override
    public void calcstep() {
        try {
            int n;
            float f = this.sealevel.total.get() - 0.1f;
            String string = typeadapt.chosenname();
            for (n = 0; n < nslr; ++n) {
                this.slrimpact_phz.set(slreg[n], 0.0f);
                this.slrimpact_pc.set(slreg[n], 0.0f);
                this.slrimpact_aapf.set(slreg[n], 0.0f);
            }
            float f2 = 0.0f;
            boolean bl = false;
            if (year > 1950 && year < 2200) {
                for (n = 0; n < nslr; ++n) {
                    region region2 = (region)slreg[n];
                    float f3 = hiwatlev[n].getLin(3.0f) + f;
                    int n2 = (int)Math.floor(f3);
                    float f4 = f3 - (float)n2;
                    float f5 = n2 >= 0 ? (1.0f - f4) * ppermeter[n][n2] + f4 * ppermeter[n][n2 + 1] : ppermeter[n][0];
                    float f6 = this.slrimpact_phz.get(region2);
                    this.slrimpact_phz.set(region2, f6 + f5);
                    float f7 = this.socio.pop.get(region2);
                    float f8 = f7 > 0.0f ? this.socio.gdp_mer.get(region2) / f7 : 1.0f;
                    f8 = gdprunav[n].average(f8);
                    float f9 = gdptopro[isdeltaic[n]].getLin(f8);
                    f9 = string.equals("none") ? Math.min(3.0f, f9) : Math.min(10.0f, f9);
                    float f10 = hiwatlev[n].getLin(f9) - f;
                    f9 = hiwatlev[n].getInvLin(f10);
                    f9 = Math.max(0.3f, f9);
                    if (f5 > 0.0f) {
                        this.slrimpact_pc.set(region2, (this.slrimpact_pc.get(region2) * f6 + f9 * f5) / (f5 + f6));
                    }
                    if (this.socio.pop.get(region2, 2000) > 0.0f) {
                        f2 = this.socio.pop.get(region2) / this.socio.pop.get(region2, 2000);
                    }
                    float f11 = 0.0f;
                    float f12 = 0.1f;
                    float f13 = f12 / 2.0f;
                    for (float f14 = f9 + f13; f14 < 3.0f; f14 += f12) {
                        f3 = hiwatlev[n].getLin(f14) + f;
                        n2 = (int)Math.floor(f3);
                        f4 = f3 - (float)n2;
                        f5 = n2 >= 0 ? (1.0f - f4) * ppermeter[n][n2] + f4 * ppermeter[n][n2 + 1] : ppermeter[n][0];
                        float f15 = (float)(Math.pow(10.0, f14 + f13) - Math.pow(10.0, f14 - f13));
                        f11 += f15 * f2 * f5 / (float)Math.pow(Math.pow(10.0, f14), 2.0);
                    }
                    this.slrimpact_aapf.set(region2, this.slrimpact_aapf.get(region2) + f11);
                }
            }
        }
        catch (Exception exception) {
            if (!reportederror) {
                exception.printStackTrace();
            }
            reportederror = true;
        }
    }

    @Override
    public void postcalc() {
    }

    static void importdata() {
        String[][] stringArray = fileio.loadtab("data/slr_popcntry.csv", "\t");
        nslr = stringArray.length - 3;
        float[] fArray = new float[4];
        float[] fArray2 = new float[]{0.0f, 1.0f, 2.0f, 3.0f};
        regnamejcm = new String[nslr];
        regnameslr = new String[nslr];
        ppermeter = new float[nslr][13];
        hiwatlev = new interp1D[nslr];
        isdeltaic = new int[nslr];
        slreg = new region[nslr];
        gdprunav = new runAverage[nslr];
        for (int i = 0; i < nslr; ++i) {
            int n;
            SLRimpacts.gdprunav[i] = new runAverage(30);
            SLRimpacts.regnamejcm[i] = stringArray[i + 3][0];
            SLRimpacts.regnameslr[i] = stringArray[i + 3][1];
            SLRimpacts.isdeltaic[i] = (int)Float.parseFloat(stringArray[i + 3][2]);
            for (n = 0; n < 13; ++n) {
                SLRimpacts.ppermeter[i][n] = Float.parseFloat(stringArray[i + 3][n + 3]);
            }
            for (n = 0; n < 4; ++n) {
                fArray[n] = Float.parseFloat(stringArray[i + 3][n + 16]);
            }
            SLRimpacts.hiwatlev[i] = new interp1D(fArray2, fArray);
        }
        redproslr = new int[][]{{0, 1, 2, 3, 3}, {0, 0, 1, 2, 3}, {0, 0, 0, 1, 2}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}};
        float[] fArray3 = new float[]{0.0f, 300.0f, 600.0f, 2400.0f, 6000.0f};
        float[] fArray4 = new float[]{0.0f, 1200.0f, 2400.0f, 5000.0f, 9000.0f};
        float[] fArray5 = new float[]{1.0f, 1.0f, 1.5f, 2.5f, 3.5f};
        SLRimpacts.gdptopro[0] = new interp1D(fArray3, fArray5);
        SLRimpacts.gdptopro[1] = new interp1D(fArray4, fArray5);
        retuper = new float[]{10.0f, 100.0f, 1000.0f, 1000.0f};
    }

    static {
        reportederror = false;
        gdptopro = new interp1D[2];
    }
}

