/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.histemitdata;
import jcm.mod.regemit.shares;
import jcm.mod.socio.popgdp;

public class pledges
extends module {
    public param usepledges = new param("apply pledges", true);
    public param beyond2030 = new param(new Object[]{"apply 2050", false, complexity.expert});
    public param EU2050 = new param(new Object[]{"EU targets 2050", false, complexity.expert});
    public param<pledgelevel> level = new param(new Object[]{"pledge level", pledgelevel.values(), pledgelevel.mixed});
    public param<kyoto_opts> kyoto = new param(new Object[]{"Kyoto Protocol", kyoto_opts.values(), kyoto_opts.real_emissions});
    public param sephotair = new param("Separate AAUsurplus", true);
    public param Ax1only = new param("AAUsurplus only Ax1", false);
    public param AAUfrac = new param("fraction surplus AAUs used", 0, 0, 100, "percent");
    public param<gdpopts> choosegdp = new param(new Object[]{"gdp for intensity", gdpopts.values(), gdpopts.GDP_PPP, complexity.expert});
    public param UNEPbase = new param(new Object[]{"use UNEP Gap baselines", false, complexity.expert});
    public param sepLUC = new param("separate LUC", true);
    public Map<region, Integer> endtarget = new HashMap<region, Integer>(50);
    public Set<region> notarget = new LinkedHashSet<region>(50);
    Set<region> EU = new LinkedHashSet<region>(27);
    public Map<region, List<target>> targets = new LinkedHashMap<region, List<target>>();
    emitquota eq;
    emitbase eb;
    boolean fixedEU = false;
    curveset efb;
    curveset efq;
    curveset hfos;
    curveset gdp_mer;
    curveset gdp_ppp;

    @Override
    public void initsetup() {
        this.eq = this.gm(emitquota.class);
        this.eb = this.gm(emitbase.class);
        this.follows(this.gm(emitbase.class));
        this.follows(this.gm(AviaShipEmit.class).emitbase);
        this.setaffectedby(this.gm(shares.class));
        this.EU = regman.allreg.findreg("EU28").subreg(regman.nations);
        this.settargets();
    }

    @Override
    public void setinteractions() {
        this.setaffectedby(this.level, this.usepledges.istrue());
        this.setaffectedby(this.choosegdp, this.usepledges.istrue());
        this.setaffectedby((interacob)this.beyond2030, this.usepledges.istrue());
        this.setaffectedby((interacob)this.sephotair, this.usepledges.istrue() || this.kyoto.chosen != kyoto_opts.real_emissions);
        this.setaffectedby((interacob)this.Ax1only, this.sephotair.istrue() && (this.usepledges.istrue() || this.kyoto.chosen != kyoto_opts.real_emissions));
        this.setaffectedby((interacob)this.AAUfrac, (this.usepledges.istrue() || this.kyoto.chosen != kyoto_opts.real_emissions) && this.sephotair.istrue());
        this.setaffectedby((interacob)this.EU2050, this.beyond2030.istrue() && this.usepledges.istrue());
        this.setaffectedby((interacob)this.UNEPbase, this.usepledges.istrue());
        this.setaffectedby((interacob)this.sepLUC, this.usepledges.istrue());
    }

    @Override
    public void precalc() {
        this.efb = this.eb.emitfosbase_nat;
        this.efq = this.eq.emitfos_nat;
        this.gdp_mer = this.gm(popgdp.class).gdp_mer_nat;
        this.gdp_ppp = this.gm(popgdp.class).gdp_ppp_nat;
        this.hfos = histemitdata.fosCO2;
        if (!this.fixedEU) {
            this.fixEU();
        }
        for (region region2 : this.EU) {
            this.endtarget.put(region2, this.EU2050.istrue() ? 2050 : 2030);
        }
        this.applytargets();
        this.fillhistory();
    }

    void st(String string, Object ... objectArray) {
        region region2 = regman.allreg.findreg(string);
        if (region2 == null) {
            report.deb("Targets error: no region " + string);
            return;
        }
        this.st(region2, objectArray);
    }

    void st(region region2, Object ... objectArray) {
        List<Object> list = !this.targets.containsKey(region2) ? new ArrayList(4) : this.targets.get(region2);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        targettype targettype2 = targettype.absreduc;
        sectorinc sectorinc2 = sectorinc.allsec;
        gasinc gasinc2 = gasinc.K6gas;
        for (Object object : objectArray) {
            if (!(n3 <= 0 || object instanceof Number && ((Number)object).intValue() < 1000)) {
                list.add(new target(region2, targettype2, sectorinc2, gasinc2, n, n2, f, f2, f3));
                n3 = 0;
                bl = false;
            }
            if (object instanceof targettype) {
                targettype2 = (targettype)((Object)object);
            }
            if (object instanceof sectorinc) {
                sectorinc2 = (sectorinc)((Object)object);
            }
            if (object instanceof gasinc) {
                gasinc2 = (gasinc)((Object)object);
            }
            if (!(object instanceof Number)) continue;
            Number number = (Number)object;
            if (number.intValue() > 1000) {
                if (bl) {
                    n = n2;
                }
                n2 = number.intValue();
                bl = true;
                continue;
            }
            bl = false;
            if (++n3 == 1) {
                f2 = f = number.floatValue();
                f3 = f;
            }
            if (n3 == 2) {
                f2 = number.floatValue();
                f3 = (f + f2) / 2.0f;
            }
            if (n3 != 3) continue;
            f3 = number.floatValue();
        }
        list.add(new target(region2, targettype2, sectorinc2, gasinc2, n, n2, f, f2, f3));
        this.endtarget.put(region2, n2);
        if (regman.nations.contains(region2)) {
            this.targets.put(region2, list);
            return;
        }
        for (region region3 : region2.subreg(regman.nations)) {
            this.targets.put(region3, list);
        }
    }

    void settargets() {
        this.st("USA", 1990, 2010, -7, 2005, 2020, -17, 2025, -26, -28, -28, 2050, -80, -85);
        this.st("Australia", 1990, 2010, 8, 2000, 2020, -5, -25, -15, 2005, 2030, -26, -28);
        this.st("New Zealand", 1990, 2010, 0, 2020, -10, -20, 2005, 2030, -30);
        this.st("Canada", 1990, 2010, -6, 2005, 2020, -17, 2030, -30, 2006, 2050, -60, -70);
        this.st("Japan", 1990, 2010, -6, 2020, -15, -25, 2013, 2030, -26);
        this.st("Russia", 1990, 2010, 0, 2020, -15, -25, 2030, -25, -30);
        this.st("Ukraine", 1990, 2010, 0, 2020, -15, -25, 2030, -40);
        this.st("Belarus", 1990, 2010, -8, 2020, -5, -10, 2030, -28);
        this.st("Kazakhstan", 1992, 2020, -15, 1990, 2030, -15, -25);
        this.st("Switzerland", 1990, 2010, -8, 2020, -20, -30, 2025, -35, 2030, -50);
        this.st("Norway", 1990, 2010, 1, 2020, -30, -40, 2030, -40);
        this.st("Iceland", 1990, 2010, 10, 2020, -30, 2030, -40);
        this.st("Austria", 1990, 2010, -13, 2005, 2020, -16);
        this.st("Belgium", 1990, 2010, -7.5, 2005, 2020, -15);
        this.st("Bulgaria", 1988, 2010, -8, 2005, 2020, 20);
        this.st("Cyprus", 2005, 2020, -5);
        this.st("Czech Republic", 1990, 2010, -8, 2005, 2020, 9);
        this.st("Denmark", 1990, 2010, -21, 2005, 2020, -20);
        this.st("Estonia", 1990, 2010, -8, 2005, 2020, 11);
        this.st("Finland", 1990, 2010, 0, 2005, 2020, -16);
        this.st("France", 1990, 2010, 0, 2005, 2020, -14);
        this.st("Germany", 1990, 2010, -21, 2005, 2020, -14);
        this.st("Greece", 1990, 2010, 25, 2005, 2020, -4);
        this.st("Hungary", 1986, 2010, -6, 2005, 2020, 10);
        this.st("Ireland", 1990, 2010, 13, 2005, 2020, -20);
        this.st("Italy", 1990, 2010, -6.5, 2005, 2020, -13);
        this.st("Latvia", 1990, 2010, -8, 2005, 2020, 17);
        this.st("Lithuania", 1990, 2010, -8, 2005, 2020, 15);
        this.st("Luxembourg", 1990, 2010, -28, 2005, 2020, -20);
        this.st("Malta", 2005, 2020, 5);
        this.st("Netherlands", 1990, 2010, -6, 2005, 2020, -16);
        this.st("Poland", 1988, 2010, -6, 2005, 2020, 14);
        this.st("Portugal", 1990, 2010, 27, 2005, 2020, 1);
        this.st("Romania", 1989, 2010, -8, 2005, 2020, 19);
        this.st("Slovenia", 1986, 2010, -8, 2005, 2020, 4);
        this.st("Slovakia", 1990, 2010, -8, 2005, 2020, 13);
        this.st("Spain", 1990, 2010, 15, 2005, 2020, -10);
        this.st("Sweden", 1990, 2010, 4, 2005, 2020, -17);
        this.st("United Kingdom", 1990, 2010, -12.5, 2005, 2020, -16);
        this.st("Croatia", 1990, 2010, -5, 2005, 2020, -5);
        this.st("China", new Object[]{targettype.intensity, 2005, 2020, -40, -45, 2030, -60, -65});
        this.st("India", new Object[]{targettype.intensity, 2005, 2020, -20, -25, 2030, -33, -35});
        this.st("Malaysia", new Object[]{targettype.intensity, 2005, 2030, -35, -45});
        this.st("Brazil", new Object[]{targettype.baseline, 2020, -36.1, -38.9, targettype.absreduc, 2012, 2025, 6, 2030, -4});
        this.st("Indonesia", new Object[]{targettype.baseline, 2020, -26, -41, 2030, -29, -41});
        this.st("Mexico", new Object[]{targettype.baseline, 2020, -30, 2030, -22, -36, targettype.absreduc, 2000, 2050, -50});
        this.st("South Korea", new Object[]{targettype.baseline, 2020, -21, -30, 2030, -37});
        this.st("Singapore", new Object[]{targettype.baseline, 2020, -16, targettype.intensity, 2005, 2030, -36});
        this.st("Thailand", new Object[]{targettype.baseline, 2030, -20, -25});
        this.st("Vietnam", new Object[]{targettype.baseline, 2030, -33});
        this.st("Bangladesh", new Object[]{targettype.baseline, 2030, -5, -15});
        this.st("Iran", new Object[]{targettype.baseline, 2030, -4, -12});
        this.st("Turkey", new Object[]{targettype.baseline, 2030, -21});
        this.st("South Africa", new Object[]{targettype.baseline, 2020, -34, 2025, -42, targettype.absreduc, 2020, 2030, 0});
        this.st("Nigeria", new Object[]{targettype.baseline, 2030, -20, -45});
        this.st("Congo Democratic Republic", new Object[]{targettype.baseline, 2000, 2030, -17});
        this.st("Angola", new Object[]{targettype.baseline, 2030, -35, -50});
        this.st("Argentina", new Object[]{targettype.baseline, 2030, -15, -30});
        this.st("Venezuela", new Object[]{targettype.baseline, 2030, -20});
        this.st("Colombia", new Object[]{targettype.baseline, 2030, -20, -30});
        this.notarget.addAll(regman.nations.reg);
        this.notarget.removeAll(this.targets.keySet());
        for (region region2 : this.notarget) {
            this.st(region2, new Object[]{targettype.baseline, 2020, -5, 2030, -10, -20});
        }
        this.notarget.clear();
    }

    public void applytargets() {
        curveset curveset2 = this.choosegdp.chosen == gdpopts.GDP_PPP ? this.gdp_ppp : this.gdp_mer;
        for (int i = 1990; i <= 2030; ++i) {
            this.efq.set("AAUsurplus", i, 0.0f);
        }
        for (region region2 : this.targets.keySet()) {
            int n = 1990;
            float f = 0.0f;
            for (target target2 : this.targets.get(region2)) {
                float f2;
                float f3;
                float f4;
                float f5;
                if (target2.targetyear == 2020 && this.sepLUC.istrue() && LUCpledge.find(region2) != null) {
                    f5 = this.level.chosen == pledgelevel.conditional ? LUCpledge.find(region2).get(lucinfo.luc20CP) : LUCpledge.find(region2).get(lucinfo.luc20UP);
                    f4 = this.level.chosen == pledgelevel.conditional ? UNEPpledge.find(region2).get(UNEPinfo.te20CP) : UNEPpledge.find(region2).get(UNEPinfo.te20UP);
                    f3 = (f4 - f5) * this.efb.get(region2, 2005) / (float)(UNEPpledge.find(region2).get(UNEPinfo.te05) - LUCpledge.find(region2).get(lucinfo.luc05));
                    float f6 = this.gm(CalcLucEmit.class).lucemit.get(region2, 2009) / 1000.0f;
                    float f7 = this.gm(CalcLucEmit.class).lucemit.get(region2, 2005) / 1000.0f;
                    float f8 = f5 * f7 / (float)LUCpledge.find(region2).get(lucinfo.luc05);
                    for (int i = 2010; i <= 2020; ++i) {
                        this.eq.emitluc.set(region2, i, (f6 * (float)(2020 - i) + f8 * (float)(i - 2009)) / 11.0f);
                    }
                } else {
                    float f9;
                    f5 = this.hfos.get(region2, target2.baseyear) / 1000.0f;
                    f4 = (100.0f + (this.level.chosen == pledgelevel.conditional ? target2.high : (this.level.chosen == pledgelevel.unconditional ? target2.low : target2.likely))) / 100.0f;
                    if (target2.targetyear == 2020 && target2.type == targettype.baseline && this.UNEPbase.istrue() && UNEPpledge.find(region2) != null) {
                        int n2 = target2.targetyear;
                        f9 = (float)(UNEPpledge.find(region2).get(UNEPinfo.te20BAU) / UNEPpledge.find(region2).get(UNEPinfo.te05)) * this.efb.get(region2, 2005);
                    } else {
                        f9 = target2.type == targettype.baseline ? this.efb.get(region2, target2.targetyear) : f5 * (target2.type == targettype.intensity ? curveset2.get(region2, target2.targetyear) / curveset2.get(region2, target2.baseyear) : 1.0f);
                    }
                    f3 = f4 * f9;
                }
                while (n <= 2007) {
                    this.efq.set(region2, n, this.hfos.get(region2, n) / 1000.0f);
                    ++n;
                }
                if (!(target2.targetyear != 2010 || this.kyoto.chosen == kyoto_opts.real_emissions || this.kyoto.chosen != kyoto_opts.Kyoto_targets_incUSA && region2.name.equals("USA"))) {
                    while (n <= 2012) {
                        f2 = this.hfos.get(region2, n) / 1000.0f;
                        if (f3 > f2 && this.sephotair.istrue() && n <= 2030) {
                            this.efq.set("AAUsurplus", n, this.efq.get("AAUsurplus", n) + (f3 - f2) * (float)this.AAUfrac.getval() / 100.0f);
                            this.efq.set(region2, n, f2);
                        } else {
                            this.efq.set(region2, n, f3);
                        }
                        ++n;
                    }
                    f = this.kyoto.chosen == kyoto_opts.Kyoto_targets_excUSA_prolonged ? f3 : this.hfos.get(region2, 2012) / 1000.0f;
                } else {
                    while (n <= 2015) {
                        this.efq.set(region2, n, this.hfos.get(region2, n) / 1000.0f);
                        if (n == 2015) {
                            f = this.hfos.get(region2, n) / 1000.0f;
                        }
                        ++n;
                    }
                }
                while (n <= target2.targetyear) {
                    f2 = this.efb.get(region2, n);
                    if ((f = (f * (float)(target2.targetyear - n) + f3) / (float)(1 + target2.targetyear - n)) > f2 && this.sephotair.istrue() && n <= 2030 && (!this.Ax1only.istrue() || regman.allreg.findreg("AXB").contains(region2))) {
                        this.efq.set("AAUsurplus", n, this.efq.get("AAUsurplus", n) + (f - f2) * (float)this.AAUfrac.getval() / 100.0f);
                        this.efq.set(region2, n, f2);
                    } else {
                        this.efq.set(region2, n, f);
                    }
                    if (Float.isNaN(this.efq.get(region2, n))) {
                        this.efq.set(region2, n, 0.0f);
                    }
                    ++n;
                }
            }
        }
        for (int i = 1990; i <= 2030; ++i) {
            float f = this.efq.get("AAUsurplus", i);
            this.eq.emitfos.set("AAUsurplus", i, f);
            this.eq.emitfos_unitsCO2.set("AAUsurplus", i, f * 44.0f / 12.0f);
            this.eq.emitequiv.set("AAUsurplus", i, f * 44.0f / 12.0f);
            this.eq.emitequiv_nat.set("AAUsurplus", i, f * 44.0f / 12.0f);
        }
    }

    void fixEU() {
        Object object;
        float f = 0.0f;
        float f2 = 0.0f;
        for (region object2 : this.EU) {
            List<target> list = this.targets.get(object2);
            object = list.get(list.size() - 1);
            f += this.hfos.get(object2, ((target)object).baseyear) * (100.0f + ((target)object).low) / 100.0f;
            f2 += this.hfos.get(object2, 1990);
        }
        float f3 = f2 / f;
        for (region region2 : this.EU) {
            object = this.targets.get(region2);
            target target2 = (target)object.get(object.size() - 1);
            float f4 = 100.0f + target2.low;
            float f5 = 100.0f + target2.high;
            target2.low = f4 * 0.8f * f3 - 100.0f;
            target2.high = f5 * 0.7f * f3 - 100.0f;
            target2.likely = (target2.low + target2.high) / 2.0f;
            float f6 = f4 * 0.6f * f3 - 100.0f;
            object.add(new target(region2, targettype.absreduc, sectorinc.allsec, gasinc.K7gas, 1990, 2030, f6, f6, f6));
            float f7 = f4 * 0.2f * f3 - 100.0f;
            float f8 = f5 * 0.05f * f3 - 100.0f;
            float f9 = (f7 + f8) / 2.0f;
            object.add(new target(region2, targettype.absreduc, sectorinc.allsec, gasinc.K7gas, 1990, 2050, f7, f8, f9));
            this.endtarget.put(region2, 2050);
        }
        this.fixedEU = true;
    }

    public void fillhistory() {
        int n;
        for (region region2 : this.notarget) {
            int n2;
            for (n2 = 1990; n2 <= this.hfos.ey; ++n2) {
                this.eq.emitfos_nat.set(region2, n2, this.hfos.get(region2, n2) / 1000.0f);
            }
            n2 = this.hfos.ey + 1;
            while (year <= 2050) {
                this.eq.emitfos_nat.set(region2, n2, Float.NaN);
                ++n2;
            }
        }
        for (n = 1990; n <= this.hfos.ey; ++n) {
            this.eq.emitfos_nat.set("bunker", n, this.eb.emitfosbase.get("bunker", n));
        }
        for (n = 1990; n <= this.hfos.ey; ++n) {
            this.eq.emitfos_nat.calctot(n);
        }
    }

    public static enum LUCpledge {
        Brazil(1187, 1540, 1711, 909, 876),
        Indonesia(0, 1610, 1620, 1074, 759);

        Map<lucinfo, Integer> info = new EnumMap<lucinfo, Integer>(lucinfo.class);

        private LUCpledge(int ... nArray) {
            int n2 = 0;
            for (int n3 : nArray) {
                this.info.put(lucinfo.values()[n2], n3);
                ++n2;
            }
        }

        public int get(lucinfo lucinfo2) {
            return this.info.get((Object)lucinfo2);
        }

        public static LUCpledge find(region region2) {
            try {
                return LUCpledge.valueOf(region2.getName().replace(" ", "_"));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static enum lucinfo {
        lucbase,
        luc05,
        luc20BAU,
        luc20UP,
        luc20CP;

    }

    public static enum UNEPpledge {
        Australia(415, 525, 645, 470, 370),
        Brazil(1400, 1942, 2703, 1728, 1651),
        Canada(595, 725, 805, 805, 605),
        China(3700, 7200, 12600, 12300, 11500),
        EU27(5550, 5100, 5450, 4475, 3400),
        India(1250, 2050, 3450, 3550, 3550),
        Indonesia(700, 2100, 2800, 2000, 1700),
        Japan(1270, 1360, 1305, 1305, 950),
        Mexico(500, 720, 885, 825, 620),
        Russia(3375, 2100, 2500, 2850, 2500),
        South_Africa(325, 490, 750, 665, 500),
        South_Korea(300, 595, 810, 570, 570),
        USA(6075, 7100, 7325, 7325, 5900);

        Map<UNEPinfo, Integer> info = new EnumMap<UNEPinfo, Integer>(UNEPinfo.class);

        private UNEPpledge(int ... nArray) {
            int n2 = 0;
            for (int n3 : nArray) {
                this.info.put(UNEPinfo.values()[n2], n3);
                ++n2;
            }
        }

        public int get(UNEPinfo uNEPinfo) {
            return this.info.get((Object)uNEPinfo);
        }

        public static UNEPpledge find(region region2) {
            try {
                return UNEPpledge.valueOf(region2.getName().replace(" ", "_"));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static enum UNEPinfo {
        te90,
        te05,
        te20BAU,
        te20UP,
        te20CP;

    }

    public class target {
        public region reg;
        public int baseyear;
        public int targetyear;
        public targettype type;
        public sectorinc sec;
        public gasinc gases;
        public float low;
        public float high;
        public float likely;
        public float baseemit;

        target(region region2, targettype targettype2, sectorinc sectorinc2, gasinc gasinc2, int n, int n2, float f, float f2, float f3) {
            this.reg = region2;
            this.type = targettype2;
            this.sec = sectorinc2;
            this.gases = gasinc2;
            this.baseyear = n;
            this.targetyear = n2;
            this.low = f;
            this.high = f2;
            this.likely = f3;
        }
    }

    public static enum gasinc {
        K7gas,
        K6gas,
        co2;

    }

    public static enum sectorinc {
        allsec,
        industry,
        LUC;

    }

    public static enum targettype {
        absreduc,
        intensity,
        baseline,
        fixnum;

    }

    public static enum pledgeopts {
        all_inc_Kyoto,
        all_future_pledges,
        all_future_belowbase;

    }

    public static enum gdpopts {
        GDP_PPP,
        GDP_MER;

    }

    public static enum kyoto_opts {
        real_emissions,
        Kyoto_targets_excUSA,
        Kyoto_targets_excUSA_prolonged,
        Kyoto_targets_incUSA;

    }

    public static enum pledgelevel {
        unconditional,
        conditional,
        mixed;

    }
}

