/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.HashMap;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.socio.histsocdata;

public class histemitdata
extends module
implements dataholder {
    boolean done = false;
    static int cdiacey = 2013;
    static int fosey = 2021;
    public static curveset fosCO2 = new curveset(new Object[]{"fosCO2", "kilo&ton&carbon", 1750, fosey, complexity.expert});
    public static curveset fosCO2BP = new curveset(new Object[]{"fosCO2BP", "mega&ton&carbon", 1965, 2010, complexity.expert});
    public static curveset epaCH4 = new curveset(new Object[]{"epaCH4", "mega&ton&CH4", 1990, 2020, 5, complexity.expert});
    public static curveset epaN2O = new curveset(new Object[]{"epaN2O", "mega&ton&N2O", 1990, 2020, 5, complexity.expert});
    static Map<region, Integer> lastdata = new HashMap<region, Integer>();

    @Override
    public void initsetup() {
        if (!this.done) {
            histsocdata.fillhistdata();
            histemitdata.fillhistdata();
            this.gm(AviaShipEmit.class).aviashiphistory();
            this.done = true;
        }
    }

    public static void fillhistdata() {
        loadtable.loaddata(fosCO2, "data/hist/cdiacrows.csv", ",", false, 1.0f, 1750, cdiacey, 1750);
        for (Object object : histemitdata.fosCO2.map.keySet()) {
            for (int i = 1750; i <= cdiacey; ++i) {
                if (!(fosCO2.get(object, i) < 0.0f)) continue;
                fosCO2.set(object, i, 0.0f);
            }
        }
        loadtable.oldsplit(fosCO2, 2000);
        histemitdata.extendfos(2014, 2016);
        histemitdata.extrapfosecon(cdiacey + 1, fosey, 4);
        for (int i = 1750; i <= fosey; ++i) {
            fosCO2.calctot(i);
        }
        loadtable.loaddata(epaCH4, "data/hist/EPA_CH4.csv", "\t", false, true, 0.04761905f, 1990, 2020, 1990, 5);
        loadtable.loaddata(epaN2O, "data/hist/EPA_N2O.csv", "\t", false, true, 0.0032258064f, 1990, 2020, 1990, 5);
    }

    static void extendfos(int n, int n2) {
        String[][] stringArray = fileio.loadtab("data/hist/CO2_2014_2016.tab", "\t");
        for (int i = 4; i < stringArray.length; ++i) {
            curve curve2;
            region region2;
            String string;
            if (stringArray[i].length == 0 || (string = stringArray[i][0]).equals("") || string.startsWith("Total") || string.startsWith("Other") || string.startsWith("China Hong Kong") || (region2 = regman.nations.findreg(string)) == null || (curve2 = fosCO2.getcurve(region2)) == null) continue;
            int n3 = n - 1;
            float f = curve2.get(n3);
            for (int j = 1; j < 2 + n2 - n; ++j) {
                if (stringArray[i].length <= j || stringArray[i][j].length() == 0) continue;
                n3 = n - 1 + j;
                curve2.set(n3, f *= 1.0f + 0.01f * Float.parseFloat(stringArray[i][j].replace("%", "").replace(",", ".")));
                lastdata.put(region2, n3);
            }
        }
    }

    static void extrapfosecon(int n, int n2, int n3) {
        String string = "";
        curveset curveset2 = histsocdata.GDP_PPP;
        for (region region2 : regman.nations.reg) {
            int n4 = lastdata.containsKey(region2) ? lastdata.get(region2) : n - 1;
            float f = curveset2.get(region2, n4 - n3);
            float f2 = 0.0f;
            boolean bl = true;
            for (int i = n4 + 1; i <= n2; ++i) {
                float f3 = curveset2.get(region2, i - 1);
                if (!(!bl || f3 > 0.0f && f > 0.0f)) {
                    bl = false;
                    string = string + region2.name + " ";
                }
                if (!bl) {
                    fosCO2.set(region2, i, fosCO2.get(region2, i - 1));
                    continue;
                }
                float f4 = fosCO2.get(region2, i - 1) / f3;
                if (f2 == 0.0f) {
                    f2 = (float)Math.pow(f4 / (fosCO2.get(region2, i - 1 - n3) / f), 1.0f / (float)n3);
                }
                if (f2 > 1.02f) {
                    f2 = 1.02f;
                } else if (f2 < 0.94f) {
                    f2 = 0.94f;
                }
                fosCO2.set(region2, i, (f4 *= f2) * curveset2.get(region2, i));
            }
        }
        if (string.length() > 0) {
            report.deb("Lacking GDP data to extrapolate to " + n2 + " for: " + string);
        }
    }
}

