/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.List;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.interacob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.gui.gen.colfont;
import jcm.indata.matchdataOld;
import jcm.mod.carbon.carboncycle;
import jcm.mod.energy.enerGeneral;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.ogas.othgasemit;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.regemit.histemitdata;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresimgdata;
import jcm.mod.scen.sspChooser;
import jcm.mod.scen.sspData;
import jcm.mod.socio.economy;
import jcm.mod.socio.popgdp;

public class emitbase
extends module {
    public curveset emitfosbase = new curveset("emitfos&base", "mega&ton&carbon");
    public curveset emitfosbase_nat = new curveset(new Object[]{"emitfos&base&national", "mega&ton&carbon", 1990, 2050, complexity.expert});
    public curveset emitlucbase = new curveset("emitluc&base", "mega&ton&carbon");
    public curveset emitch4base = new curveset("emitch4&base", "mega&ton&CH4");
    public curveset emitch4base_nat = new curveset(new Object[]{"emitch4&base&national", "mega&ton&CH4", 1990, 2050, complexity.expert});
    public curveset emitn2obase = new curveset("emitn2o&base", "mega&ton&N2O");
    public curveset emitn2obase_nat = new curveset(new Object[]{"emitn2o&base&national", "mega&ton&N2O", 1990, 2050, complexity.expert});
    public param usemod = new param("scale to model gdp", true);
    sresBase srb;
    CalcLucEmit CLE;
    region regset;
    public loopcalc history = new loopcalc("emitbase-history"){

        @Override
        public void precalc() {
            emitbase.this.regset = (region)emitbase.this.gm(regset.class).regions.chosen;
            List<region> list = emitbase.this.regset.reg;
            emitbase.this.gm(regset.class).clearoldregions(this);
            for (region region2 : list) {
                emitbase.this.emitfosbase.getOrAddCurve(region2);
            }
            interpolator.fillregdata(histemitdata.fosCO2, emitbase.this.emitfosbase, emitbase.this.regset, 0.001f);
            interpolator.fillregdata(histemitdata.fosCO2, emitbase.this.emitfosbase_nat, regman.nations, 0.001f);
            emitbase.this.fillhistluc();
            emitbase.this.fillhistch4n2o();
            emitbase.this.emitfosbase.getOrAddCurve((Object)"bunker").color = colfont.grey;
        }

        @Override
        public void calcstep() {
            if (year < fsyfos) {
                float f = year > 1900 ? emitbase.this.gm(AviaShipEmit.class).seb.get((Object)AviaShipEmit.sec.tot_int) : 0.0f;
                emitbase.this.emitfosbase.set("bunker", f);
                emitbase.this.gm(globco2emit.class).fossil.set(emitbase.this.emitfosbase.calctot());
            }
            if (year < fsyog) {
                emitbase.this.emitch4base.calctot();
                emitbase.this.emitn2obase.calctot();
            }
        }
    };
    public loopcalc future = new loopcalc("emitbase-future"){

        @Override
        public void precalc() {
            emitbase.this.regset = (region)emitbase.this.gm(regset.class).regions.chosen;
            emitbase.this.regemitfosbase();
            emitbase.this.regch4n2o();
        }

        @Override
        public void calcstep() {
            if (emitbase.this.usemod.istrue() && year > fsyfos) {
                emitbase.this.scalefosmod();
            }
            emitbase.this.emitch4base.calctot();
            emitbase.this.emitn2obase.calctot();
        }
    };

    @Override
    public void initsetup() {
        this.srb = this.gm(sresBase.class);
        this.CLE = this.gm(CalcLucEmit.class);
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.history.follows(this.gm(CalcLucEmit.class));
        this.history.setaffectedby((interacob)this.gm(carboncycle.class), this.CLE.lucsource.chosen.equals("Inverse") || this.CLE.lucsource.chosen.equals("Houghton"));
        this.future.follows(this.history);
        this.future.follows(this.gm(sspChooser.class));
        this.future.setaffectedby(this.srb);
        this.future.setaffectedby(this.usemod);
        this.future.follows(this.gm(AviaShipEmit.class).emitbase);
        this.follows(this.future);
        this.follows(this.srb.sresext);
        this.setaffectedby(this.gm(futureLUC.class).base);
        this.emitfosbase.addOb(new curvar(curve.Type.ratio, this.emitfosbase, this.gm(popgdp.class).pop, this.emitlucbase));
    }

    @Override
    public void setinteractions() {
        this.future.follows(this.gm(enerGeneral.class), this.gm(sresBase.class).useWEO.istrue());
        this.setaffectedby(economy.class, this.usemod.istrue());
    }

    void regemitfosbase() {
        interpolator interpolator2 = new interpolator(sresimgdata.sres_image_fos.get((Object)this.srb.scemit), Float.valueOf(1000.0f));
        if (this.srb.useWEO.istrue()) {
            curveset curveset2 = this.emitfosbase_nat;
            curveset curveset3 = this.gm(popgdp.class).gdp_ppp_nat;
            int n = 10;
            interpolator interpolator3 = new interpolator(this.gm(enerGeneral.class).IEAtotCO2);
            interpolator3.fill(curveset2, regman.nations, fsyfos, 2035, histemitdata.fosCO2, (float)this.srb.fosconv_WEO.getval());
            interpolator2.fill(curveset2, regman.nations, 2036, 2050, curveset2, 2035, 100.0f);
            for (region region2 : regman.nations.reg) {
                float f = curveset2.get(region2, 2035) / curveset3.get(region2, 2035);
                float f2 = curveset2.get(region2, 2035 - n) / curveset3.get(region2, 2035 - n);
                float f3 = (float)Math.log(f / f2) / (float)n;
                for (int i = 2036; i < 2051; ++i) {
                    float f4 = Float.isNaN(f3) ? curveset2.get(region2, 2035) : curveset3.get(region2, i) * f * (float)Math.exp(f3 * (float)(i - 2035));
                    float f5 = (1.0f + (float)Math.sin(Math.PI * (double)(0.5f + (float)(i - 2035) / 65.0f))) / 2.0f;
                    curveset2.set(region2, i, f5 * f4 + (1.0f - f5) * curveset2.get(region2, i));
                }
            }
        } else {
            interpolator2.fill(this.emitfosbase_nat, regman.nations, fsyfos, 2050, histemitdata.fosCO2, (float)this.srb.fosconv.getval());
        }
        interpolator.fillregdata(this.emitfosbase_nat, this.emitfosbase, this.regset, fsyfos, 2050);
        interpolator2.fill(this.emitfosbase, this.regset, 2051, 2100, this.emitfosbase_nat, (float)this.srb.fosconv.getval());
    }

    void scalefosmod() {
        for (region region2 : this.regset.reg) {
            float f = this.gm(popgdp.class).gdp_msr.get(region2);
            this.emitfosbase.set(region2, this.emitfosbase.get(region2) * f);
            for (region region3 : region2.subreg(regman.nations)) {
                this.emitfosbase_nat.set(region2, this.emitfosbase_nat.get(region2) * f);
            }
        }
    }

    void regch4n2o() {
        sspData.run run2 = this.gm(sspChooser.class).chosenSSPrun;
        interpolator interpolator2 = new interpolator(new Object[]{run2.get(sspData.gases.CH4_TOT), sspData.scenreg, 2000, 10, Float.valueOf(1.0f)});
        interpolator2.fill(this.emitch4base_nat, regman.nations, 2001, 2050, histemitdata.epaCH4, 2020);
        interpolator.fillregdata(this.emitch4base_nat, this.emitch4base, this.regset, 2001, 2050);
        interpolator2.fill(this.emitch4base, this.regset, 2051, 2100, this.emitch4base_nat);
        interpolator interpolator3 = new interpolator(new Object[]{run2.get(sspData.gases.N2O_TOT), sspData.scenreg, 2000, 10, Float.valueOf(0.001f)});
        interpolator3.fill(this.emitn2obase_nat, regman.nations, 2001, 2050, histemitdata.epaN2O, 2020);
        interpolator.fillregdata(this.emitn2obase_nat, this.emitn2obase, this.regset, 2001, 2050);
        interpolator3.fill(this.emitn2obase, this.regset, 2051, 2100, this.emitn2obase_nat);
    }

    float equiv(region region2, int n) {
        othgasemit.gwp gwp2 = (othgasemit.gwp)((Object)this.gm(othgasemit.class).gwp_source.chosen);
        curve curve2 = n < fsyluc ? this.gm(CalcLucEmit.class).lucemit.getcurve(region2) : this.emitlucbase.getcurve(region2);
        return (this.emitfosbase_nat.get(region2, n) + curve2.get(n)) * 44.0f / 12.0f + this.emitch4base_nat.get(region2, n) * gwp2.ch4 + this.emitn2obase_nat.get(region2, n) * gwp2.n2o;
    }

    void fillhistluc() {
        if (this.CLE.lucsource.chosen.equals("Houghton")) {
            float f = (float)this.gm(CalcLucEmit.class).landuseemit1990.getval() / 2158.09f;
            new interpolator(LUCdata.lucCO2Houghton, 1950, Float.valueOf(1.0f), Float.valueOf(f)).fill(this.emitlucbase, this.regset, 1750, 2000, LUCdata.lucCO2CAIT);
        }
        if (this.CLE.lucsource.chosen.equals("EDGAR")) {
            interpolator.fillregdata(LUCdata.edgarluc, this.emitlucbase, this.regset, 1.0f);
        }
        if (this.CLE.lucsource.chosen.equals("IVIGmodel")) {
            interpolator.fillregdata(this.CLE.lucemit, this.emitlucbase, this.regset, 0.001f);
        }
        if (this.CLE.LULUCF_UNFCCC_on.istrue()) {
            interpolator.fillregdata(LUCdata.lucCO2UNFCCC, this.emitlucbase, this.regset, 1.0f);
        }
    }

    void fillhistch4n2o() {
        new interpolator(new Object[]{matchdataOld.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true}).fill(this.emitch4base, this.regset, 1890, 1970, histemitdata.epaCH4);
        new interpolator(new Object[]{matchdataOld.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true}).fill(this.emitch4base, this.regset, 1971, 2000, histemitdata.epaCH4);
        for (int i = 1890; i < 2000; ++i) {
            this.gm(othgasemit.class).ch4emit.set(i, this.emitch4base.calctot(i));
        }
        new interpolator(new Object[]{matchdataOld.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true}).fill(this.emitch4base_nat, regman.nations, 1990, 2000, histemitdata.epaCH4);
        float f = 1.4142857f;
        new interpolator(new Object[]{matchdataOld.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true, Float.valueOf(f)}).fill(this.emitn2obase, this.regset, 1890, 1970, histemitdata.epaN2O);
        new interpolator(new Object[]{matchdataOld.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true, Float.valueOf(f)}).fill(this.emitn2obase, this.regset, 1971, 2000, histemitdata.epaN2O);
        for (int i = 1890; i < 2000; ++i) {
            this.gm(othgasemit.class).n2oemit.set(i, this.emitn2obase.calctot(i));
        }
        new interpolator(new Object[]{matchdataOld.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true, Float.valueOf(f)}).fill(this.emitn2obase_nat, regman.nations, 1990, 2000, histemitdata.epaN2O);
    }
}

