/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.ogas;

import java.util.EnumMap;
import java.util.EnumSet;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.radfor;
import jcm.mod.obj.globco2emit;
import jcm.mod.ogas.gas;
import jcm.mod.regemit.AviaShipEmit;

public class AviationForcing
extends module {
    static int sy = AviaShipEmit.sy;
    AviaShipEmit ase;
    public curve rfi = new curve("Radiative Forcing Index", sy, colfont.black);
    public curve rfnonco2 = new curve("Aviation_Non-CO2", colfont.olive);
    public curve noxemit = new curve("nox-emit", "mega&ton&no2", sy);
    public curveset gasrf = new curveset("Aviation Radiative Forcing", "watt&per&m2", sy);
    public curveset rfis = new curveset("Radiative Forcing Index", this.rfi, sy);
    public param horizon = new param(new Object[]{"RFI time-horizon", "yr", 50, 1, 100, complexity.expert, colfont.red});
    public param tradeoff = new param(new Object[]{"Update_TRADEOFF03", true, complexity.expert, colfont.dkgreen});
    public param inccirrus = new param(new Object[]{"Include Cirrus", true, complexity.expert, colfont.dkblue});
    static final EnumSet<gas> aviagas = EnumSet.of(gas.co2, new gas[]{gas.o3avia, gas.ch4avia, gas.h2oavia, gas.sulphate, gas.bc, gas.contrails, gas.cirrus});
    static final EnumSet<gas> scalebynox = EnumSet.of(gas.o3avia, gas.ch4avia);
    static final EnumSet<gas> scalebyco2 = EnumSet.of(gas.contrails, gas.h2oavia, gas.bc, gas.sulphate);
    static final EnumMap<gas, float[]> rf_fa1 = new EnumMap(gas.class);
    static final EnumMap<gas, Float> tof = new EnumMap(gas.class);
    float cumco2 = 0.0f;
    float[] acccbox = new float[4];
    float[] fa1_co2conc = new float[]{0.9f, 1.5f, 2.5f, 3.5f, 6.0f};
    float scaledown;

    @Override
    public void initsetup() {
        this.ase = this.gm(AviaShipEmit.class);
        this.follows(this.ase);
        this.follows(this.gm(carboncycle.class));
        this.setaffectedby(this.gm(radfor.class).excavia);
        this.setaffectedby(this.gm(radfor.class).applyefficacy);
        for (gas gas2 : aviagas) {
            this.gasrf.getOrAddCurve((Object)((Object)gas2)).color = gas2.col;
            if (!gas2.name().startsWith("tot")) continue;
            this.gasrf.getOrAddCurve((Object)((Object)gas2)).type = curve.Type.total;
        }
    }

    @Override
    public void calcstep() {
        if (year >= sy) {
            this.radfor();
        }
    }

    @Override
    public void postcalc() {
        this.rfi();
    }

    @Override
    public void changeendyear(int n, int n2) {
        this.noxemit.changeendyear(n, n2);
        super.changeendyear(n, n2);
    }

    void radfor() {
        float f;
        int n;
        int n2;
        carboncycle carboncycle2 = this.gm(carboncycle.class);
        float f2 = this.ase.sem.get((Object)AviaShipEmit.sec.tot_Avia);
        this.scaledown = this.ase.tranlongterm.chosen == AviaShipEmit.longterm.mitigate_for_stabilisation && year >= fsyfos ? carboncycle2.fossil.get(year) / this.gm(globco2emit.class).fossilbase.get() : 1.0f;
        if (year == sy) {
            this.cumco2 = 0.0f;
            for (n2 = 0; n2 < 4; ++n2) {
                this.acccbox[n2] = 0.0f;
            }
        }
        this.cumco2 = 1.25f * carboncycle2.acccmod(this.acccbox, f2);
        this.gasrf.set((Object)gas.co2, carboncycle2.co2rf.get(year - 1) * this.cumco2 / (carboncycle2.co2atppm.get(year - 1) - 278.0f));
        n2 = year;
        for (n = 1; n2 > AviaShipEmit.scen.y[n] && n < AviaShipEmit.scen.y.length - 1; ++n) {
        }
        AviaShipEmit.scen scen2 = (AviaShipEmit.scen)((Object)this.ase.aviascen.chosen);
        int n3 = n2 < (int)this.ase.endgrowth.getval() ? n2 : (int)this.ase.endgrowth.getval();
        float f3 = ((float)(n3 - AviaShipEmit.scen.y[n - 1]) * scen2.nox[n] + (float)(AviaShipEmit.scen.y[n] - n3) * scen2.nox[n - 1]) / (float)(AviaShipEmit.scen.y[n] - AviaShipEmit.scen.y[n - 1]);
        if (n2 > 1990) {
            this.noxemit.set(this.scaledown * f3);
        } else {
            this.noxemit.set(scen2.nox[0] * f2 / this.ase.sem.get((Object)AviaShipEmit.sec.tot_Avia, 1990));
        }
        for (Object object : scalebyco2) {
            f = n2 > 1990 ? ((float)(n2 - AviaShipEmit.scen.y[n - 1]) * rf_fa1.get(object)[n] / AviaShipEmit.scen.Fa1.co2[n] + (float)(AviaShipEmit.scen.y[n] - n2) * rf_fa1.get(object)[n - 1] / AviaShipEmit.scen.Fa1.co2[n - 1]) / (float)(AviaShipEmit.scen.y[n] - AviaShipEmit.scen.y[n - 1]) : rf_fa1.get(object)[0] / AviaShipEmit.scen.Fa1.co2[0];
            this.gasrf.set(object, f2 * (f / 1000.0f) * this.gm(radfor.class).getefficacy((gas)((Object)object)));
        }
        for (Object object : scalebynox) {
            f = n2 > 1990 ? ((float)(n3 - AviaShipEmit.scen.y[n - 1]) * rf_fa1.get(object)[n] / AviaShipEmit.scen.Fa1.nox[n] + (float)(AviaShipEmit.scen.y[n] - n3) * rf_fa1.get(object)[n - 1] / AviaShipEmit.scen.Fa1.nox[n - 1]) / (float)(AviaShipEmit.scen.y[n] - AviaShipEmit.scen.y[n - 1]) : rf_fa1.get(object)[0] / AviaShipEmit.scen.Fa1.nox[0];
            this.gasrf.set(object, this.noxemit.get() * f * this.gm(radfor.class).getefficacy((gas)((Object)object)));
        }
        this.gasrf.set((Object)gas.cirrus, this.inccirrus.istrue() ? this.gasrf.get((Object)gas.contrails) : 0.0f);
        if (this.tradeoff.istrue()) {
            for (Object object : aviagas) {
                this.gasrf.set(object, this.gasrf.get(object) * tof.get(object).floatValue());
            }
        }
        float f4 = 0.0f;
        for (gas gas2 : aviagas) {
            if (gas2 == gas.co2) continue;
            f4 += this.gasrf.get((Object)gas2);
        }
        if (f4 >= 0.0f) {
            this.rfnonco2.set(this.gm(radfor.class).excavia.istrue() ? 0.0f : f4);
        }
    }

    void rfi() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = sy; i < gey; ++i) {
            if ((double)i > (double)gey - this.horizon.val) {
                this.rfi.set(i, Float.NaN);
            }
            int n = i + (int)this.horizon.val;
            if (i == sy) {
                for (int j = i; j <= n; ++j) {
                    f2 += this.gasrf.get((Object)gas.co2, j);
                    for (gas gas2 : aviagas) {
                        f += this.gasrf.get((Object)gas2, j);
                    }
                }
            } else {
                f2 += this.gasrf.get((Object)gas.co2, n) - this.gasrf.get((Object)gas.co2, i - 1);
                for (gas gas3 : aviagas) {
                    f += this.gasrf.get((Object)gas3, n) - this.gasrf.get((Object)gas3, i - 1);
                }
            }
            this.rfi.set(i, f / f2);
        }
    }

    static {
        rf_fa1.put(gas.co2, new float[]{0.016f, 0.025f, 0.038f, 0.048f, 0.074f});
        tof.put(gas.co2, Float.valueOf(1.0f));
        rf_fa1.put(gas.o3avia, new float[]{0.024f, 0.029f, 0.04f, 0.046f, 0.06f});
        tof.put(gas.o3avia, Float.valueOf(0.79310346f));
        rf_fa1.put(gas.ch4avia, new float[]{-0.015f, -0.018f, -0.027f, -0.032f, -0.045f});
        tof.put(gas.ch4avia, Float.valueOf(0.47368422f));
        rf_fa1.put(gas.h2oavia, new float[]{0.002f, 0.002f, 0.003f, 0.003f, 0.004f});
        tof.put(gas.h2oavia, Float.valueOf(1.0f));
        rf_fa1.put(gas.sulphate, new float[]{-0.003f, -0.004f, -0.006f, -0.007f, -0.009f});
        tof.put(gas.sulphate, Float.valueOf(0.8f));
        rf_fa1.put(gas.bc, new float[]{0.003f, 0.004f, 0.006f, 0.007f, 0.009f});
        tof.put(gas.bc, Float.valueOf(0.6f));
        rf_fa1.put(gas.contrails, new float[]{0.021f, 0.034f, 0.06f, 0.071f, 0.1f});
        tof.put(gas.contrails, Float.valueOf(0.25f));
        tof.put(gas.cirrus, Float.valueOf(1.8571428f));
    }
}

