/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.cli.udebclimod;
import jcm.mod.math.mathcurve;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.stabtempfuzzy;
import jcm.mod.regemit.shares;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresimgdata;

public class stabilisation
extends module
implements Runnable {
    indicators ic;
    complexity[] indiccomplex = new complexity[]{complexity.normal, complexity.simplest, complexity.expert, complexity.normal, complexity.normal, complexity.experimental, complexity.expert, complexity.experimental};
    public param<indicators> indicator = new param(new Object[]{"indicator", indicators.values(), indicators.stabconc, this.indiccomplex}){

        @Override
        public void precalc() {
            stabilisation.this.resetguess();
        }
    };
    int[] concscenlevel = new int[]{400, 450, 500, 550, 600, 650, 750, 850, 1000};
    String[] concscenname = new String[]{"400ppm", "450ppm", "500ppm", "550ppm", "600ppm", "650ppm", "750ppm", "850ppm", "1000ppm", "user"};
    public param concscenmenu = new param(new Object[]{"stabconcmenu", this.concscenname, "user"}){

        @Override
        public void precalc() {
            if (this.chosen != "user") {
                stabilisation.this.stabconclevel.putval(stabilisation.this.concscenlevel[this.getchosenindex()]);
                stabilisation.this.stabyear.putval(2100.0 + (double)(stabilisation.this.concscenlevel[this.getchosenindex()] - 450) / 2.0);
            }
        }
    };
    public param stabyear = new param(new Object[]{"stabyear", "year", 2100, 2030, gey - 20, colfont.grey, complexity.simplest});
    public param stabconclevel = new param(new Object[]{"stabconc&atlevel", "ppm", 450, 300, 1000, this.stabyear, colfont.black, complexity.simplest});
    public param stabconcinitslope = new param(new Object[]{"stabconcinitslope", "ppm&per&year&squared", 0, -0.15, 0.15, complexity.expert, colfont.black});
    public param stabconcendlevel = new param(new Object[]{"stabconc&endlevel", "ppm", 475, 300, 1000, this.stabyear, colfont.black, complexity.expert});
    public param stabrflevel = new param("stabrf&atlevel", "w&per&m2", 3.1, 1.5, 8.0, this.stabyear, colfont.green);
    public param stabtemplevel = new param("stabtemp&atlevel", "degcbase", 2.0, 1.0, 7.0, this.stabyear, colfont.brown);
    public param stabtempend = new param("temp_end&level", "degcbase", 2.0, 1.0, 7.0, this.stabyear, colfont.brown);
    public param stabrfend = new param("stabrf_end&level", "w&per&m2", 3.1, 1.5, 8.0, this.stabyear, colfont.dkgreen);
    public param peaking = new param(new Object[]{"peaking", false, complexity.expert});
    public param wre = new param(new Object[]{"wreopt", false, complexity.expert});
    public param stabconcstartyear = new param(new Object[]{"stabconcstartyear", "", 2020, 1990, 2050, complexity.expert});
    public param stabemityear = new param("stabemityear", "year", 2080, 2010, gey - 20, colfont.red);
    public param stabemitlevel = new param("stabemit&atlevel", "mega&ton&carbon&per&yr", 2000, 0, 30000, this.stabemityear, colfont.red);
    public param stabemitendlevel = new param(new Object[]{"stabemit&minlevel", "mega&ton&carbon&per&yr", 500, -2000, 12000, colfont.dkred, complexity.expert});
    public param stabemitdeclinerate = new param(new Object[]{"stabemit&declinerate", "percent&per&yr", 2, 0, 5, colfont.brown, complexity.expert});
    public param sygrowth = new param(new Object[]{"initgrow", "percent&per&yr", 1.5, -3.5, 3.5, complexity.expert, colfont.orange});
    public param quartic = new param(new Object[]{"integralopt", false, complexity.expert});
    public param integralgt = new param(new Object[]{"integralgt", "giga&ton&carbon", 500, 150, 6000, complexity.expert});
    public param stabseayear = new param(new Object[]{"stabseayear", "year", 2250, 2030, gey - 20, complexity.expert});
    public param stabsealevel = new param(new Object[]{"stabsea&atlevel", "metres", 0.75, 0.5, 3.0, this.stabseayear, complexity.expert});
    public param damp = new param(new Object[]{"dampopt", false, complexity.expert});
    public param<curvetype> curveopt = new param(new Object[]{"curveopt", curvetype.values(), curvetype.padequintic, complexity.expert});
    public float[] target = new float[gey - gsy + 2];
    curve curvetocheck;
    public int x0;
    public int sy = fsyfos;
    public int scy;
    float y0;
    float dy0;
    float d2y0;
    double targetlevel = 0.0;
    double endtargetlevel = 0.0;
    double co2stab = 0.0;
    double co2staborig = 0.0;
    double stabcor = 1.0;
    double oldstabcor = 1.0;
    double co2stabslope = 0.0;
    double co2stabslopeorig = 0.0;
    double stabslopecor = 1.0;
    double oldstabslopecor = 0.0;
    double co2end = 0.0;
    double co2endorig = 0.0;
    double endcor = 1.0;
    double oldendcor = 1.0;
    double olditw = 3.4028234663852886E38;
    double oldco2stab;
    public boolean goodenough = false;
    public boolean running = false;
    public int stit = 0;

    @Override
    public void initsetup() {
        this.indicator.priority = 1.1;
    }

    @Override
    public void setinteractions() {
        this.affectsfutureonly = true;
        controller controller2 = this.gm(controller.class);
        this.follows(shares.class, controller2.botuptopdo.chosen != controller.butd.top_down_only);
        this.setaffectedby(controller2.botuptopdo);
        this.ic = (indicators)((Object)this.indicator.chosen);
        this.setaffectedby(this.ic == indicators.constant, this.gm(globco2emit.class));
        this.setaffectedby(this.ic == indicators.define_emit, this.gm(globco2emit.class), this.stabemitlevel, this.stabemityear, this.stabemitendlevel, this.stabemitdeclinerate, this.sygrowth, this.quartic);
        this.setaffectedby(this.ic == indicators.define_emit && this.quartic.istrue(), this.integralgt);
        this.setaffectedby(this.ic == indicators.stabconc, this.gm(carboncycle.class), this.stabconclevel, this.concscenmenu);
        this.setaffectedby(this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg, this.gm(radfor.class), this.stabrflevel);
        boolean bl = this.ic == indicators.stabtemp || this.ic == indicators.stfuzzy;
        interacob[] interacobArray = new interacob[4];
        interacobArray[0] = this.gm(glotemp.class);
        this.gm(glotemp.class);
        interacobArray[1] = glotemp.baseyear;
        this.gm(glotemp.class);
        interacobArray[2] = glotemp.baserange;
        interacobArray[3] = this.stabtemplevel;
        this.setaffectedby(bl, interacobArray);
        this.setaffectedby(this.ic == indicators.stabconc && this.peaking.istrue(), this.stabconcendlevel);
        this.setaffectedby((this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg) && this.peaking.istrue(), this.stabrfend);
        this.setaffectedby(this.ic == indicators.stabtemp && this.peaking.istrue(), this.stabtempend);
        this.setaffectedby(this.ic == indicators.stabsea, this.gm(sealevel.class), this.stabsealevel, this.stabseayear);
        this.setaffectedby(this.ic == indicators.stabconc || this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg || this.ic == indicators.stabtemp || this.ic == indicators.stfuzzy, this.stabyear, this.stabconcinitslope, this.curveopt);
        this.setaffectedby(this.ic == indicators.stabtemp || this.ic == indicators.stabconc || this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg, this.peaking);
        this.setaffectedby(controller2.botuptopdo.chosen == controller.butd.top_down_only, this.wre);
        this.setaffectedby((interacob)this.wre, this.ic != indicators.constant);
        this.setaffectedby(this.wre.istrue(), this.stabconcstartyear);
        this.setaffectedby(this.ic == indicators.stfuzzy, this.gm(stabtempfuzzy.class), this.damp);
        this.setaffects(this.ic == indicators.stfuzzy, this.gm(stabtempfuzzy.class));
        this.gm(carboncycle.class).conc.associate(this.stabconclevel);
        this.gm(radfor.class).allrf.associate(this.stabrflevel);
        this.gm(radfor.class).allrf2.associate(this.stabrflevel);
        this.gm(glotemp.class).temp.associate(this.stabtemplevel);
        this.gm(sealevel.class).sealevel.associate(this.stabsealevel);
    }

    @Override
    public void precalc() {
        this.ic = (indicators)((Object)this.indicator.chosen);
        if (!this.running) {
            this.setstartyear();
        }
    }

    @Override
    public void calcstep() {
        carboncycle carboncycle2 = this.gm(carboncycle.class);
        if (year == this.sy) {
            if (this.ic == indicators.define_emit) {
                this.emittarget((int)this.stabemityear.getval(), this.stabemitlevel.getval(), this.stabemitendlevel.getval(), this.stabemitdeclinerate.getval());
            }
            if (this.ic == indicators.stabconc) {
                if (this.peaking.istrue()) {
                    this.conctarget((int)this.stabyear.getval(), this.stabconclevel.getval(), this.stabconcendlevel.getval());
                } else {
                    this.conctarget((int)this.stabyear.getval(), this.stabconclevel.getval());
                }
            }
            if (this.ic == indicators.stabtemp || this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg || this.ic == indicators.stabsea) {
                this.setlevel();
                if (!this.running) {
                    this.initialguess();
                    new Thread((Runnable)this, "Stabilisation").start();
                }
                this.conctarget(this.scy, this.co2stab, this.co2stabslope, this.co2end);
            }
        }
        if (year >= this.sy) {
            if (this.ic == indicators.define_emit) {
                carboncycle2.totemit.set(year, this.target[year - gsy]);
            } else if (this.ic.name().startsWith("stab")) {
                carboncycle2.totemit.set(year, carboncycle2.inverseco2(this.target[year - gsy]));
            }
            if (this.ic == indicators.constant) {
                carboncycle2.totemit.set(year, carboncycle2.totemit.get(year - 1));
            }
            if (this.ic == indicators.stfuzzy) {
                this.gm(stabtempfuzzy.class).calcstep();
            }
        }
    }

    @Override
    public void postcalc() {
        if (this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg || this.ic == indicators.stabtemp || this.ic == indicators.stabsea) {
            this.applycorrection();
        }
    }

    @Override
    public void changeendyear(int n, int n2) {
        this.target = new float[n2 - gsy + 2];
    }

    void setstartyear() {
        controller controller2 = this.gm(controller.class);
        if (controller2.botuptopdo.chosen == controller.butd.start_bottom_up) {
            this.sy = (int)controller2.startyear_topdown.getval();
            return;
        }
        if (controller2.botuptopdo.chosen == controller.butd.bottom_up_only) {
            this.sy = 999999999;
            return;
        }
        this.sy = fsyfos;
        if (this.wre.istrue()) {
            this.delaystart();
        }
    }

    float[] gradient(curve curve2, int n) {
        float f = curve2.get(n);
        float f2 = f - 2.0f * curve2.get(n - 1) + curve2.get(n - 2);
        float f3 = n < fsyfos + 10 ? (float)this.stabconcinitslope.getval() : f2;
        float f4 = 3.5f * f2 + (curve2.get(n) - curve2.get(n - 5)) / 5.0f;
        return new float[]{f, f4, f3};
    }

    void delaystart() {
        this.delaystart(this.sy, (int)this.stabconcstartyear.getval());
        this.sy = (int)this.stabconcstartyear.getval();
    }

    void delaystart(int n, int n2) {
        param<sresimgdata.scen> param2 = this.gm(sresBase.class).scenario;
        int n3 = param2.getchosenindex();
        param2.choose(6);
        for (int i = n; i <= n2; ++i) {
            this.gm(carboncycle.class).fossil.set(this.gm(globco2emit.class).fossilbase.get(i));
        }
        param2.choose(n3);
    }

    void emittarget(int n, double d) {
        this.emittarget(n, gey, d, d);
    }

    void emittarget(int n, double d, double d2, double d3) {
        double d4 = (double)this.y0 * this.sygrowth.getval() / 100.0;
        double d5 = (double)this.gm(carboncycle.class).totemit.get(this.sy - 1) + d4;
        double d6 = -(d - d2) * d3 / 100.0;
        if (this.quartic.istrue()) {
            mathcurve.quarticend(this.target, this.sy, n, d5, d4, d, d6, this.integralgt.getval() * 1000.0);
        } else {
            mathcurve.cubicend(this.target, this.sy, n, d5, d4, d, d6);
        }
        for (int i = n + 1; i <= gey; ++i) {
            this.target[i - stabilisation.gsy] = (float)(d2 + ((double)this.target[i - gsy - 1] - d2) * (100.0 - d3) / 100.0);
        }
    }

    void conctarget(int n, double d) {
        this.conctarget(n, d, 0.0, d);
    }

    void conctarget(int n, double d, double d2) {
        this.conctarget(n, d, 0.0, d2);
    }

    void conctarget(int n, double d, double d2, double d3) {
        float[] fArray = this.gradient(this.gm(carboncycle.class).co2atppm, this.sy - 1);
        if (this.curveopt.chosen == curvetype.padequartic) {
            mathcurve.padequartic(this.target, this.sy - 1, n, fArray[0], fArray[1], fArray[2], d, d2);
        }
        if (this.curveopt.chosen == curvetype.padequintic) {
            mathcurve.padequintic(this.target, this.sy - 1, n, fArray[0], fArray[1], fArray[2], d, d2, 0.0);
        }
        if (n < gey) {
            try {
                if (d == d3 || gey - n < 20) {
                    for (int i = n; i <= gey; ++i) {
                        this.target[i - stabilisation.gsy] = (float)d3;
                    }
                } else {
                    mathcurve.flatquadratic(this.target, n, gey, d, d2, d3);
                }
            }
            catch (Exception exception) {
                report.deb("conctarget last-part problem: xs=" + n);
                exception.printStackTrace();
            }
        }
    }

    void setlevel() {
        if (this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg) {
            this.curvetocheck = this.ic == indicators.stabrf_allghgaero ? this.gm(radfor.class).anthrorf : this.gm(radfor.class).ghgrf;
            this.targetlevel = this.stabrflevel.getval();
            this.endtargetlevel = this.peaking.istrue() ? this.stabrfend.getval() : this.targetlevel;
            this.setstabconcyear(this.stabyear.getval());
        }
        if (this.ic == indicators.stabtemp) {
            this.curvetocheck = this.gm(glotemp.class).avchange;
            this.targetlevel = this.stabtemplevel.getval() + this.gm(glotemp.class).offset;
            this.endtargetlevel = this.peaking.istrue() ? this.stabtempend.getval() + this.gm(glotemp.class).offset : this.targetlevel;
            this.setstabconcyear(this.stabyear.getval());
        }
        if (this.ic == indicators.stabsea) {
            this.curvetocheck = this.gm(sealevel.class).total;
            this.endtargetlevel = this.targetlevel = this.stabsealevel.getval();
            this.setstabconcyear(this.stabseayear.getval());
        }
    }

    void setstabconcyear(double d) {
        this.scy = (int)d;
    }

    void initialguess() {
        if (this.ic == indicators.stabrf_allghgaero || this.ic == indicators.stabrf_allghg) {
            this.guessconcfromrf(this.targetlevel * (double)this.gm(radfor.class).totalrf.get(this.scy) / (double)(this.ic == indicators.stabrf_allghgaero ? this.gm(radfor.class).anthrorf.get(this.scy) : this.gm(radfor.class).ghgrf.get(this.scy)));
        }
        if (this.ic == indicators.stabtemp) {
            this.guessconcfromrf(this.guessrffromtemp(this.targetlevel));
        }
        if (this.ic == indicators.stabsea) {
            this.guessconcfromrf(this.guessrffromtemp(this.guesstempfromsealevel(this.targetlevel)));
        }
    }

    double guesstempfromsealevel(double d) {
        return this.gm(sealevel.class).total.get(this.scy) > 0.0f ? (double)this.gm(glotemp.class).avchange.get(this.scy) * d / (double)this.gm(sealevel.class).total.get(this.scy) : 2.0;
    }

    double guessrffromtemp(double d) {
        return d * (this.gm(glotemp.class).avchange.get(this.scy) > 0.0f ? (double)(this.gm(radfor.class).totalrf.get(this.scy) / this.gm(glotemp.class).avchange.get(this.scy)) : this.gm(udebclimod.class).val(udebclimod.cp.rfco2double) / this.gm(udebclimod.class).val(udebclimod.cp.climsens));
    }

    void guessconcfromrf(double d) {
        double d2 = d * (this.gm(radfor.class).totalrf.get(this.scy) > 0.0f ? (double)(this.gm(carboncycle.class).co2rf.get(this.scy) / this.gm(radfor.class).totalrf.get(this.scy)) : 0.85);
        this.gm(carboncycle.class);
        this.co2staborig = 278.0 * Math.exp(Math.log(2.0) * d2 / this.gm(udebclimod.class).val(udebclimod.cp.rfco2double));
        this.co2stab = this.co2staborig * this.oldstabcor;
        this.co2stabslopeorig = 0.0;
        this.co2stabslope = this.oldstabslopecor;
        this.co2endorig = this.co2stab;
        this.co2end = this.co2endorig * this.oldendcor;
    }

    void applycorrection() {
        this.stabcor = this.targetlevel / (double)this.curvetocheck.get(this.scy);
        this.stabslopecor = -0.05 * (double)(this.curvetocheck.get(this.scy + 10) - this.curvetocheck.get(this.scy - 10)) / (double)this.curvetocheck.get(this.scy - 1);
        this.endcor = (double)(this.curvetocheck.get(this.scy) / this.curvetocheck.get(gey - 1)) * (this.endtargetlevel / this.targetlevel);
        this.co2stab = 278.0 + (this.co2stab - 278.0) * this.stabcor;
        if (this.co2stab < 300.0) {
            this.co2stab = 300.0;
        }
        if (this.stit <= 6 || this.stabslopecor / this.oldstabslopecor < 1.0) {
            this.co2stabslope += this.stabslopecor * (this.co2stab - 278.0);
        }
        this.co2end = 278.0 + (this.co2end - 278.0) * this.endcor;
        if (this.co2end < 300.0) {
            this.co2end = 300.0;
        }
        boolean bl = Double.isInfinite(this.co2stab) || Double.isInfinite(this.co2end) || Double.isNaN(this.co2stab) || Double.isNaN(this.co2end) || this.co2stab < 300.0 || this.co2end < 300.0;
        this.goodenough = bl || this.stabcor < 1.001 && this.stabcor > 0.999 && this.stabslopecor < 0.001 && this.stabslopecor > -0.001 && this.endcor < 1.001 && this.endcor > 0.999;
        ++this.stit;
        this.savecorrect();
    }

    void savecorrect() {
        this.oldstabcor = this.co2stab / this.co2staborig;
        this.oldstabslopecor = (this.co2stabslope - this.co2stabslopeorig) / (this.co2stab - 278.0);
        this.oldendcor = this.co2end / this.co2endorig;
    }

    void resetcorrect() {
        this.oldstabcor = 1.0;
        this.oldstabslopecor = 0.0;
        this.oldendcor = 1.0;
    }

    void resetguess() {
        this.resetcorrect();
        this.goodenough = false;
    }

    @Override
    public void run() {
        this.running = true;
        report.log("Stabilisation iteratation starting");
        Thread.currentThread();
        Thread.yield();
        loop.waitUntilLoopDone();
        while (!this.goodenough && this.stit < 20) {
            this.changed = true;
            loop.gonow(false);
        }
        report.log("Stabilisation iteratated " + this.stit + " times");
        this.stit = 0;
        this.running = false;
    }

    public static enum curvetype {
        padequartic,
        padequintic;

    }

    public static enum indicators {
        define_emit,
        stabconc,
        stabrf_allghg,
        stabrf_allghgaero,
        stabtemp,
        stabsea,
        constant,
        stfuzzy;

    }
}

