/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.controller;
import jcm.mod.obj.optimisation;
import jcm.mod.obj.stabilisation;
import jcm.mod.ogas.fgas;
import jcm.mod.ogas.othgasemit;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.shares;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresdata;
import jcm.mod.scen.sspChooser;
import jcm.mod.scen.sspData;

public class globco2emit
extends module {
    public param fixedfrac = new param(new Object[]{"fix luc fossil ratio", false, complexity.experimental});
    public param pulse = new param(new Object[]{"one year pulse", 0, 0, 1000, "MtC", complexity.experimental});
    public curve fossil;
    public curve lucquota;
    public curve totemit;
    public curve potlucbase = new curve(new Object[]{"globpotlucbase", colfont.ltgreen, fsyluc, gey, complexity.expert});
    public curve potlucquota = new curve(new Object[]{"globpotlucquota", colfont.dkgreen, complexity.expert});
    public curve fossilbase = new curve("fossilemitbase", colfont.dkred, fsyfos, gey);
    public curve lucfbase = new curve("lucemitbase", colfont.dkorange, 2000, gey);
    public curve co2eqtot = new curve(new Object[]{"CO2eq_Kyoto_gas", colfont.dkgrey, gsy, gey, curve.Type.total});
    public curve co2fos = new curve("CO fossil", colfont.black, gsy, gey);
    public curve co2tot = new curve("CO2tot: fossil+LUC", colfont.grey, gsy, gey);
    public curve ch4_CO2eq = new curve("CH4_CO2eq ", colfont.green, gsy, gey);
    public curve n2o_CO2eq = new curve("N2O_CO2eq ", colfont.brown, gsy, gey);
    public curve hfc_CO2eq = new curve("HFC_CO2eq ", colfont.pink, gsy, gey);
    public curve cfc_CO2eq = new curve("CFC_CO2eq ", colfont.purple, gsy, gey);
    public curveset globco2curves;
    public curveset co2eqcurves;
    carboncycle carb;
    curveset emitfosbase;
    curveset emitlucbase;
    othgasemit og;
    fgas fg;
    shares sh;
    emitbase eb;
    private float alpha;
    public float plf;
    int sci;
    public boolean houghton;
    interpolator scenlucinterpolator;
    public loopcalc calcco2eq = new loopcalc("co2eq_global"){

        @Override
        public void calcstep() {
            globco2emit.this.co2fos.set(globco2emit.this.fossil.get() * 44.0f / 12.0f);
            globco2emit.this.co2tot.set((globco2emit.this.fossil.get() + globco2emit.this.lucquota.get()) * 44.0f / 12.0f);
            othgasemit.gwp gwp2 = (othgasemit.gwp)((Object)globco2emit.this.gm(othgasemit.class).gwp_source.chosen);
            globco2emit.this.ch4_CO2eq.set(globco2emit.this.og.ch4emit.get() * gwp2.ch4);
            globco2emit.this.n2o_CO2eq.set(globco2emit.this.og.n2oemit.get() * gwp2.n2o);
            globco2emit.this.hfc_CO2eq.set(globco2emit.this.fg.hfc_CO2eq.get());
            globco2emit.this.cfc_CO2eq.set(globco2emit.this.fg.cfc_CO2eq.get());
            globco2emit.this.co2eqtot.set(globco2emit.this.co2tot.get() + globco2emit.this.ch4_CO2eq.get() + globco2emit.this.n2o_CO2eq.get() + globco2emit.this.hfc_CO2eq.get());
        }
    };

    @Override
    public void initsetup() {
        this.og = this.gm(othgasemit.class);
        this.sh = this.gm(shares.class);
        this.fg = this.gm(fgas.class);
        this.eb = this.gm(emitbase.class);
        this.follows(this.eb.history);
        this.follows(this.eb.future);
        this.follows(this.gm(sresBase.class).sresext);
        this.follows(this.gm(sspChooser.class));
        this.setaffectedby(this.gm(controller.class).objective);
        this.setaffectedby(this.gm(futureLUC.class).lucconv);
        this.setaffectedby(this.gm(sresBase.class).fosconv);
        this.setaffectedby(this.gm(futureLUC.class).potlucfrac);
        this.setaffectedby(this.gm(futureLUC.class).potlucconvergence);
        this.calcco2eq.follows(this);
        this.calcco2eq.follows(this.og);
        this.calcco2eq.follows(this.fg);
        this.carb = this.gm(carboncycle.class);
        this.fossil = this.carb.fossil;
        this.lucquota = this.carb.lucf;
        this.totemit = this.carb.totemit;
        this.globco2curves = new curveset("globco2curves", "mega&ton&carbon&per&year", this.fossilbase, this.lucfbase, this.fossil, this.lucquota, this.totemit, this.potlucbase, this.potlucquota);
        this.co2eqcurves = new curveset("co2eqcurves", "mega&ton&co2&eq&per&year", this.co2tot, this.ch4_CO2eq, this.n2o_CO2eq, this.hfc_CO2eq, this.cfc_CO2eq, this.co2eqtot);
        this.potlucquota.set(gsy, 0.0f);
        this.emitfosbase = this.eb.emitfosbase;
        this.emitlucbase = this.eb.emitlucbase;
        this.affectsfutureonly = true;
    }

    @Override
    public void setinteractions() {
        param<controller.objopt> param2 = this.gm(controller.class).objective;
        this.follows(stabilisation.class, param2.chosen == controller.objopt.stabilisation);
        this.follows(optimisation.class, param2.chosen == controller.objopt.optimisation);
    }

    @Override
    public void precalc() {
        this.plf = -((float)(this.gm(futureLUC.class).potlucfrac.getval() / 100.0));
        this.sci = this.gm(sresBase.class).scenario.getchosenindex();
        this.houghton = this.gm(CalcLucEmit.class).lucsource.chosen.equals("Houghton");
        fsyluc = this.houghton ? 2001 : 2010;
        this.scenlucinterpolator = new interpolator(new Object[]{this.gm(sspChooser.class).chosenSSPrun.get(sspData.gases.CO2_LUC), sspData.scenreg, 2000, 10, Float.valueOf(0.27272728f)});
    }

    @Override
    public void calcstep() {
        float f;
        int n;
        if (year > 1755 && this.gm(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year < fsyluc) {
            this.gm(carboncycle.class).inverseluc();
        } else if (year < fsyluc) {
            this.lucquota.set(this.gm(emitbase.class).emitlucbase.calctot());
        }
        if (year < fsyluc) {
            this.totemit.set(this.fossil.get() + this.lucquota.get());
        }
        if (year > gsy) {
            this.potlucquota.set(this.potlucquota.get(year - 1) + this.lucquota.get(year - 1) * this.plf);
        }
        if (year >= fsyfos && year <= 2100) {
            if (this.eb.usemod.istrue()) {
                this.fossilbase.set(this.emitfosbase.calctot());
                if (year <= 2050) {
                    this.eb.emitfosbase_nat.set("bunker", this.emitfosbase.get("bunker"));
                    this.eb.emitfosbase_nat.calctot();
                }
            } else if (this.gm(sresBase.class).useWEO.istrue() && year <= 2050) {
                this.fossilbase.set(this.emitfosbase.calctot());
                if (year <= 2050) {
                    this.eb.emitfosbase_nat.set("bunker", this.emitfosbase.get("bunker"));
                }
            } else {
                this.fossilbase.set((float)((double)(1000.0f * interpolator.sresinterp(sresdata.fosemit, this.sci, year)) + (1.0 - this.gm(sresBase.class).fosconv.getval() / 100.0) * (double)((year == fsyfos ? this.emitfosbase.calctot(year - 1) : this.fossilbase.get(year - 1)) - 1000.0f * interpolator.sresinterp(sresdata.fosemit, this.sci, year - 1))));
                this.emitfosbase.topdownscale(this.fossilbase.get(), true);
                if (year <= 2050) {
                    this.eb.emitfosbase_nat.set("bunker", this.emitfosbase.get("bunker"));
                    this.eb.emitfosbase_nat.topdownscale(this.fossilbase.get(), true);
                }
            }
        }
        if (year >= 2000 && year < fsyluc) {
            if (this.houghton) {
                float f2 = 0.0f;
                for (n = -5; n < 0; ++n) {
                    f2 += this.lucquota.get(year + n);
                }
                this.lucfbase.set(f2 / 5.0f);
            } else {
                this.lucfbase.set(this.lucquota.get());
            }
        }
        if (year >= fsyluc && year <= 2100) {
            this.lucfbase.set((float)((double)this.scenlucinterpolator.getdata(5, year) + (1.0 - this.gm(futureLUC.class).lucconv.getval() / 100.0) * (double)(this.lucfbase.get(year - 1) - this.scenlucinterpolator.getdata(5, year - 1))));
        }
        controller controller2 = this.gm(controller.class);
        int n2 = controller2.objective.chosen == controller.objopt.nopolicy ? fsyfos : (controller2.botuptopdo.chosen == controller.butd.start_bottom_up ? (int)controller2.startyear_topdown.getval() : (n = controller2.botuptopdo.chosen == controller.butd.bottom_up_only ? 999999999 : fsyfos));
        if (year >= fsyluc && year < fsyfos) {
            this.lucquota.set(this.lucfbase.get());
            this.totemit.set(this.fossil.get() + this.lucquota.get());
        }
        if (year > 2100) {
            this.fossilbase.set(this.emitfosbase.calctot());
            f = this.lucfbase.get(year - 1) < this.potlucbase.get(year - 1) ? 1.0f : (float)this.gm(futureLUC.class).potlucconvergence.getval() / 100.0f;
            this.lucfbase.set(f * this.potlucbase.get(year - 1) + (1.0f - f) * this.lucfbase.get(year - 1));
        }
        if (year >= fsyluc) {
            this.potlucbase.set(year == fsyluc ? this.potlucquota.get() : this.potlucbase.get(year - 1) + this.lucfbase.get() * this.plf);
        }
        if (year >= fsyfos) {
            f = this.lucfbase.get() - this.potlucbase.get();
            if (f < 100.0f) {
                f = 100.0f;
            }
            this.alpha = f / this.fossilbase.get();
            if (this.gm(controller.class).objective.chosen == controller.objopt.nopolicy) {
                this.fossil.set(this.fossilbase.get());
                this.lucquota.set(this.lucfbase.get());
                this.totemit.set(this.fossilbase.get() + this.lucfbase.get());
            } else {
                if (year < n) {
                    this.lucquota.set(this.fixedfrac.istrue() ? this.fossil.get() * this.lucquota.get(n - 1) / this.fossil.get(n - 1) : this.fossil.get() * this.alpha + this.potlucquota.get());
                    this.totemit.set(this.fossil.get() + this.lucquota.get());
                } else {
                    this.lucquota.set(this.fixedfrac.istrue() ? this.totemit.get() * this.lucquota.get(fsyfos - 1) / this.totemit.get(fsyfos - 1) : (this.totemit.get() * this.alpha + this.potlucquota.get()) / (1.0f + this.alpha));
                    this.fossil.set(this.totemit.get() - this.lucquota.get());
                }
                if (this.fossil.get() < 0.0f) {
                    this.fossil.set(0.0f);
                    this.lucquota.set(this.totemit.get());
                }
                if (this.lucquota.get() < this.potlucquota.get()) {
                    this.lucquota.set(this.potlucquota.get());
                    this.totemit.set(this.lucquota.get() + this.fossil.get());
                }
            }
        }
        if (year == 2010) {
            this.totemit.set(this.totemit.get() + (float)this.pulse.getval());
        }
    }
}

