/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.math;

import jcm.core.report;

public class optimiser {
    int nd;
    int np;
    int cp;
    int ni;
    int ni2;
    float[][] sx;
    float[] cen;
    float[] hip;
    float[] lop;
    float[] rfp;
    float[] newp;
    float[] initguess;
    float[] perturb;
    float[] max;
    float[] min;
    float of;
    float tol;
    float tol2;
    float nsd;
    optimcaller oc;
    public String report;
    public int step = 0;
    static int reset = 0;
    static int fill = 1;
    static int reflect = 2;
    static int compare = 3;
    static int checkcontract = 4;
    static int checkexpand = 5;
    static int checkopt = 6;
    static String[] stepname = new String[]{"reset", "fill", "reflect", "compare", "chkcon", "chkexp", "chkopt"};
    public boolean goodenough = false;
    public boolean oktocheckvar = false;
    public static boolean showreport = true;

    public optimiser(optimcaller optimcaller2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.oc = optimcaller2;
        this.initguess = fArray;
        this.perturb = fArray2;
        this.max = fArray4;
        this.min = fArray3;
        this.nd = fArray.length;
        this.np = this.nd + 1;
        this.step = reset;
        this.tol = 1.0E-4f;
        this.tol2 = 0.05f;
        this.sx = new float[this.np][this.np];
        this.rfp = new float[this.np];
        this.newp = new float[this.np];
        this.cen = new float[this.nd];
    }

    public void reset() {
        this.ni = 0;
        this.ni2 = 0;
        this.step = reset;
        this.initguess = this.cen;
        this.goodenough = false;
    }

    public float[] nextpoint() {
        if (this.step == reset) {
            this.cp = 0;
            this.init(this.initguess, 1.0f);
            this.step = fill;
            this.nsd = Float.NaN;
        } else {
            this.getobjfunc();
        }
        if (showreport || this.ni % 50 == 0) {
            this.report();
        }
        ++this.ni;
        if (this.step == fill) {
            if (this.cp < this.np) {
                this.newp = this.sx[this.cp];
                ++this.cp;
                return this.newp;
            }
            this.step = reflect;
        }
        if (this.step == checkopt) {
            if (this.cp < this.np) {
                this.newp = this.sx[this.cp];
                ++this.cp;
                return this.newp;
            }
            this.findhighlow();
            if (this.lop == this.sx[0]) {
                this.goodenough = true;
                this.report = this.report + " end-opt ";
                this.report();
                return this.lop;
            }
            this.ni2 = 0;
            this.step = reflect;
        }
        if (this.step == checkexpand) {
            if (this.of < this.rfp[this.nd]) {
                this.copy(this.newp, this.sx[this.cp]);
            } else {
                this.copy(this.rfp, this.sx[this.cp]);
            }
            this.step = reflect;
        }
        if (this.step == checkcontract) {
            if (this.of < this.rfp[this.nd]) {
                this.copy(this.newp, this.sx[this.cp]);
                this.step = reflect;
            } else {
                this.cp = 0;
                this.totalcon();
                this.step = fill;
                this.oktocheckvar = true;
                return this.nextpoint();
            }
        }
        if (this.step == compare) {
            this.copy(this.newp, this.rfp);
            if (this.of < this.lop[this.nd]) {
                this.expcon(2.0f);
                this.step = checkexpand;
                return this.newp;
            }
            if (this.of >= this.hip[this.nd]) {
                this.copy(this.hip, this.rfp);
                this.expcon(-0.5f);
                this.step = checkcontract;
                this.oktocheckvar = true;
                return this.newp;
            }
            if (this.sechigh()) {
                this.expcon(0.5f);
                this.step = checkcontract;
                return this.newp;
            }
            this.copy(this.newp, this.sx[this.cp]);
            this.step = reflect;
        }
        if (this.step == reflect) {
            if (this.oktocheckvar) {
                this.oktocheckvar = false;
                if (this.checkvar()) {
                    this.findhighlow();
                    this.cp = 0;
                    this.init(this.lop, this.tol2);
                    this.step = checkopt;
                    return this.nextpoint();
                }
                ++this.ni2;
                this.step = reflect;
            }
            this.findhighlow();
            this.findcentre(true);
            this.expcon(1.0f);
            this.step = compare;
            return this.newp;
        }
        return null;
    }

    void copy(float[] fArray, float[] fArray2) {
        for (int i = 0; i < this.np; ++i) {
            fArray2[i] = fArray[i];
        }
    }

    void getobjfunc() {
        this.of = this.oc.getobjfunc();
        if (Float.isNaN(this.of)) {
            this.of = Float.MAX_VALUE;
        }
        for (int i = 0; i < this.nd; ++i) {
            if (!(this.newp[i] > this.max[i]) && !(this.newp[i] < this.min[i])) continue;
            this.of = Float.MAX_VALUE;
            this.report = this.report + "hit limits! ";
        }
        this.newp[this.nd] = this.of;
    }

    void report() {
        this.report = "it=" + this.ni + "\t " + stepname[this.step] + "\t ";
        for (int i = 0; i < this.nd + 1; ++i) {
            this.report = this.report + (float)((int)(this.newp[i] * 1000.0f)) / 1000.0f + "\t ";
        }
        jcm.core.report.log(this.report);
    }

    void findhighlow() {
        this.hip = this.sx[0];
        this.lop = this.sx[0];
        this.cp = 0;
        for (int i = 1; i < this.np; ++i) {
            if (this.sx[i][this.nd] > this.hip[this.nd]) {
                this.hip = this.sx[i];
                this.cp = i;
            }
            if (!(this.sx[i][this.nd] < this.lop[this.nd])) continue;
            this.lop = this.sx[i];
        }
    }

    boolean sechigh() {
        for (int i = 0; i < this.np; ++i) {
            if (!(this.sx[i][this.nd] > this.newp[this.nd]) || this.sx[i] == this.hip) continue;
            return false;
        }
        return true;
    }

    void findcentre(boolean bl) {
        int n;
        for (n = 0; n < this.nd; ++n) {
            this.cen[n] = 0.0f;
        }
        for (n = 0; n < this.np; ++n) {
            if (bl && this.sx[n] == this.hip) continue;
            for (int i = 0; i < this.nd; ++i) {
                int n2 = i;
                this.cen[n2] = this.cen[n2] + this.sx[n][i];
            }
        }
        for (n = 0; n < this.nd; ++n) {
            int n3 = n;
            this.cen[n3] = this.cen[n3] / (float)(bl ? this.np - 1 : this.np);
        }
    }

    void expcon(float f) {
        this.newp = new float[this.np];
        for (int i = 0; i < this.nd; ++i) {
            this.newp[i] = (1.0f + f) * this.cen[i] - f * this.hip[i];
        }
    }

    void totalcon() {
        for (int i = 0; i < this.np; ++i) {
            for (int j = 0; j < this.nd; ++j) {
                this.sx[i][j] = (this.sx[i][j] + this.lop[j]) / 2.0f;
            }
        }
    }

    void init(float[] fArray, float f) {
        for (int i = 0; i < this.np; ++i) {
            for (int j = 0; j < this.nd; ++j) {
                this.sx[i][j] = fArray[j] + (i == j + 1 ? this.perturb[j] * f : 0.0f);
            }
        }
    }

    boolean checkvar() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.np; ++i) {
            d += (double)this.sx[i][this.nd];
            d2 += (double)(this.sx[i][this.nd] * this.sx[i][this.nd]);
        }
        double d3 = d / (double)this.np;
        double d4 = d2 / (double)this.np - d3 * d3;
        double d5 = Math.pow(d4, 0.5);
        this.nsd = (float)(d5 / d3);
        if (Float.isNaN(this.nsd) && showreport) {
            jcm.core.report.log("optstatprob: " + d3 + " " + d + " " + d2 + " " + d4 + " " + this.nsd);
        }
        return this.ni > 1000 || this.ni > this.np + 5 && this.nsd < this.tol && this.nsd > -this.tol;
    }

    public static interface optimcaller {
        public float getobjfunc();
    }
}

