/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.math;

public class interp1D {
    private float[] xs;
    private float[] ys;

    public interp1D(float[] fArray, float[] fArray2) {
        this.xs = new float[fArray.length];
        this.ys = new float[fArray2.length];
        System.arraycopy(fArray, 0, this.xs, 0, fArray.length);
        System.arraycopy(fArray2, 0, this.ys, 0, fArray2.length);
    }

    public int search1D(float f, float[] fArray) {
        for (int i = 0; i < fArray.length - 2; ++i) {
            if (!(fArray[i] <= f) || !(fArray[i + 1] >= f)) continue;
            return i;
        }
        if (f < this.xs[0]) {
            return 0;
        }
        return this.xs.length - 2;
    }

    public float getLin(float f) {
        int n = this.search1D(f, this.xs);
        float f2 = this.ys[n] + (this.ys[n + 1] - this.ys[n]) * (f - this.xs[n]) / (this.xs[n + 1] - this.xs[n]);
        return f2;
    }

    public float getInvLin(float f) {
        int n = this.search1D(f, this.ys);
        float f2 = this.xs[n] + (this.xs[n + 1] - this.xs[n]) * (f - this.ys[n]) / (this.ys[n + 1] - this.ys[n]);
        return f2;
    }
}

