/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sspChooser;
import jcm.mod.scen.sspData;

public class futureLUC
extends module {
    public param potlucfrac = new param(new Object[]{"potlucfrac", "", colfont.green, 0.75, 0, 2, complexity.expert});
    public param potlucconvergence = new param(new Object[]{"potlucfracConverg", "", colfont.green, 0.5, 0, 2, complexity.expert});
    public param lucconv = new param(new Object[]{"luchistscenconv", "percent&per&year", colfont.dkgreen, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), complexity.expert});
    public curveset potlucregquotacurves = new curveset(new Object[]{"regpotlucquota", "mega&ton&carbon", fsyluc, gey, complexity.expert});
    public curveset potlucregbasecurves = new curveset(new Object[]{"regpotlucbase", "mega&ton&carbon", fsyluc, gey, complexity.expert});
    public curveset lucscenario = new curveset(new Object[]{"LUC scenario", "mega&ton&carbon", 2010, 2100, complexity.experimental});
    List<region> regsetreg;
    interpolator scenlucinterpolator;
    CalcLucEmit cle;
    globco2emit gc;
    Map<region, Float> potlucregbase = new HashMap<region, Float>();
    Map<region, Float> scenpotluc = new HashMap<region, Float>();
    Map<region, Float> srb4conv = new HashMap<region, Float>();
    Map<region, Float> srinitial = new HashMap<region, Float>();
    Map<region, Float> scenlucemit = new HashMap<region, Float>();
    Map<region, Float> potlucregquota = new HashMap<region, Float>();
    Map<region, Float> potlucregquota_init = new HashMap<region, Float>();
    Map<region, Float> potluchist = new HashMap<region, Float>();
    Map<region, Map<region, Float>> weight = new HashMap<region, Map<region, Float>>();
    boolean nopolicy;
    float corrfac = 1.0f;
    float fu;
    float plf;
    curveset emitlucbase;
    curveset emitlucquota;
    curveset histluc;
    curveset trend = new curveset("sres-trend", "", 2000, gey);
    region REF = regman.allreg.findreg("REFSSP");
    region OECD = regman.allreg.findreg("OECDSSP");
    public loopcalc history = new loopcalc("futluc-setup"){

        @Override
        public void precalc() {
            futureLUC.this.regsetreg = ((region)futureLUC.this.gm(regset.class).regions.chosen).reg;
            for (curveset curveset2 : futureLUC.this.curvesets) {
                futureLUC.this.gm(regset.class).clearoldregions(curveset2);
            }
            futureLUC.this.histluc = futureLUC.this.cle.lucsource.chosen.equals("Houghton") ? LUCdata.lucCO2CAIT1 : futureLUC.this.cle.lucemit;
            futureLUC.this.fu = futureLUC.this.cle.lucsource.chosen.equals("Houghton") ? 1.0f : 1000.0f;
        }

        @Override
        public void calcstep() {
            if (year < fsyluc) {
                for (region region2 : futureLUC.this.regsetreg) {
                    futureLUC.this.emitlucquota.set(region2, futureLUC.this.emitlucbase.get(region2));
                }
                futureLUC.this.emitlucbase.calctot();
                futureLUC.this.emitlucquota.calctot();
            }
            if (year == fsyluc - 1) {
                futureLUC.this.histpotluc();
                futureLUC.this.setupweights();
            }
        }
    };
    public loopcalc base = new loopcalc("futluc-base"){

        @Override
        public void precalc() {
            futureLUC.this.scenlucinterpolator = new interpolator(new Object[]{futureLUC.this.gm(sspChooser.class).chosenSSPrun.get(sspData.gases.CO2_LUC), sspData.scenreg, 2000, 10, Float.valueOf(0.27272728f)});
            futureLUC.this.nopolicy = futureLUC.this.gm(controller.class).objective.chosen == controller.objopt.nopolicy;
            futureLUC.this.plf = -((float)(futureLUC.this.gm(futureLUC.class).potlucfrac.getval() / 100.0));
        }

        @Override
        public void calcstep() {
            if (year == fsyluc - 1) {
                futureLUC.this.initfut();
            }
            if (year >= fsyluc) {
                for (region iterator : futureLUC.this.regsetreg) {
                    futureLUC.this.potlucregbase.put(iterator, Float.valueOf(futureLUC.this.potlucregbase.get(iterator).floatValue() + futureLUC.this.emitlucbase.get(iterator, year - 1) * futureLUC.this.plf));
                    futureLUC.this.potlucregbasecurves.set(iterator, futureLUC.this.potlucregbase.get(iterator).floatValue());
                    futureLUC.this.emitlucbase.set(iterator, futureLUC.this.potlucregbase.get(iterator).floatValue());
                }
                futureLUC.this.potlucregbasecurves.calctot();
                float f = 0.0f;
                for (region region2 : sspData.scenreg) {
                    if (year <= 2100) {
                        futureLUC.this.lucscenario.set(region2, futureLUC.this.scenlucinterpolator.getdata(region2, year));
                        int n = year == fsyluc ? year : year - 1;
                        futureLUC.this.scenlucemit.put(region2, Float.valueOf((float)((double)futureLUC.this.lucscenario.get(region2) + (1.0 - futureLUC.this.lucconv.getval() / 100.0) * (double)(futureLUC.this.scenlucemit.get(region2).floatValue() - futureLUC.this.lucscenario.get(region2, n)))));
                    } else {
                        float f2 = futureLUC.this.scenlucemit.get(region2).floatValue() < futureLUC.this.scenpotluc.get(region2).floatValue() ? 1.0f : (float)futureLUC.this.potlucconvergence.getval() / 100.0f;
                        futureLUC.this.scenlucemit.put(region2, Float.valueOf(f2 * futureLUC.this.scenpotluc.get(region2).floatValue() + (1.0f - f2) * futureLUC.this.scenlucemit.get(region2).floatValue()));
                    }
                    f += futureLUC.this.scenlucemit.get(region2).floatValue();
                }
                if (f > 10.0f || f < -10.0f) {
                    futureLUC.this.corrfac = futureLUC.this.gc.lucfbase.get() / f;
                }
                for (region region2 : sspData.scenreg) {
                    futureLUC.this.scenlucemit.put(region2, Float.valueOf(futureLUC.this.scenlucemit.get(region2).floatValue() * futureLUC.this.corrfac));
                    if ((region2 == futureLUC.this.REF || region2 == futureLUC.this.OECD) && futureLUC.this.scenlucemit.get(region2).floatValue() > -100.0f) {
                        futureLUC.this.scenlucemit.put(region2, Float.valueOf(-100.0f));
                    }
                    futureLUC.this.scenpotluc.put(region2, Float.valueOf(futureLUC.this.scenpotluc.get(region2).floatValue() + futureLUC.this.scenlucemit.get(region2).floatValue() * futureLUC.this.plf));
                    futureLUC.this.trend.set(region2, (futureLUC.this.scenlucemit.get(region2).floatValue() - futureLUC.this.scenpotluc.get(region2).floatValue()) / futureLUC.this.srinitial.get(region2).floatValue());
                    for (region region3 : futureLUC.this.regsetreg) {
                        futureLUC.this.emitlucbase.set(region3, futureLUC.this.emitlucbase.get(region3) + futureLUC.this.weight.get(region3).get(region2).floatValue() * futureLUC.this.trend.get(region2));
                    }
                }
                for (region region2 : futureLUC.this.regsetreg) {
                    if (!region2.name.equals("BRA") || year > 2010 || !futureLUC.this.gm(CalcLucEmit.class).usePRODES.istrue()) continue;
                    futureLUC.this.emitlucbase.set(region2, futureLUC.this.emitlucbase.get(region2, 2002) * (float)CalcLucEmit.desmat_inpe_prodes[year - 1988] / (float)CalcLucEmit.desmat_inpe_prodes[14]);
                }
                futureLUC.this.emitlucbase.calctot();
            }
        }
    };
    public loopcalc quota = new loopcalc("futluc-quota"){

        @Override
        public void calcstep() {
            if (year == fsyluc - 1) {
                for (region region2 : futureLUC.this.regsetreg) {
                    futureLUC.this.potlucregquota.put(region2, futureLUC.this.potlucregquota_init.get(region2));
                }
            }
            if (year >= fsyluc) {
                float f;
                for (region region2 : futureLUC.this.regsetreg) {
                    futureLUC.this.potlucregquota.put(region2, Float.valueOf(futureLUC.this.potlucregquota.get(region2).floatValue() + futureLUC.this.emitlucquota.get(region2, year - 1) * futureLUC.this.plf));
                    futureLUC.this.potlucregquotacurves.set(region2, futureLUC.this.potlucregquota.get(region2).floatValue());
                    if (futureLUC.this.skip(region2)) continue;
                    futureLUC.this.emitlucquota.set(region2, futureLUC.this.potlucregquota.get(region2).floatValue());
                }
                float f2 = f = year <= fsyluc ? futureLUC.this.gc.lucquota.get(year - 1) - futureLUC.this.gc.potlucquota.get(year - 1) : futureLUC.this.gc.lucfbase.get(year - 1) - futureLUC.this.gc.potlucbase.get(year - 1);
                if (year > fsyluc && f < 100.0f) {
                    f = 100.0f;
                }
                float f3 = (futureLUC.this.gm(carboncycle.class).lucf.get(year - 1) - futureLUC.this.gc.potlucquota.get(year - 1)) / f;
                if (year == fsyluc) {
                    f3 = 1.0f;
                }
                for (region region3 : sspData.scenreg) {
                    for (region region4 : futureLUC.this.regsetreg) {
                        if (futureLUC.this.skip(region4)) continue;
                        futureLUC.this.emitlucquota.set(region4, futureLUC.this.emitlucquota.get(region4) + futureLUC.this.weight.get(region4).get(region3).floatValue() * f3 * futureLUC.this.trend.get(region3));
                    }
                }
                for (region region3 : futureLUC.this.regsetreg) {
                    if (!region3.name.equals("BRA") || year > 2010 || !futureLUC.this.gm(CalcLucEmit.class).usePRODES.istrue()) continue;
                    futureLUC.this.emitlucquota.set(region3, futureLUC.this.emitlucquota.get(region3, 2002) * (float)CalcLucEmit.desmat_inpe_prodes[year - 1988] / (float)CalcLucEmit.desmat_inpe_prodes[14]);
                }
                futureLUC.this.emitlucquota.calctot();
            }
        }
    };

    @Override
    public void initsetup() {
        this.cle = this.gm(CalcLucEmit.class);
        this.gc = this.gm(globco2emit.class);
        this.emitlucbase = this.gm(emitbase.class).emitlucbase;
        this.emitlucquota = this.gm(emitquota.class).emitluc;
        this.history.follows(this.cle);
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.base.follows(this.history);
        this.base.follows(this.gm(sspChooser.class));
        this.base.setaffectedby(this.lucconv, this.potlucconvergence, this.potlucfrac);
        this.base.setaffectedby(this.gm(sresBase.class).sresext);
        this.quota.follows(this.base);
        this.quota.follows(this.gc);
        this.quota.setaffectedby(this.gm(pledges.class));
    }

    boolean skip(region region2) {
        pledges pledges2 = this.gm(pledges.class);
        return year >= 2010 && year <= 2020 && pledges2.usepledges.istrue() && pledges2.sepLUC.istrue() && pledges.LUCpledge.find(region2) != null;
    }

    void initfut() {
        for (region region2 : sspData.scenreg) {
            Set<region> set = region2.subreg(regman.nations);
            this.scenpotluc.put(region2, Float.valueOf(0.0f));
            float f = 0.0f;
            Iterator<region> iterator = set.iterator();
            while (iterator.hasNext()) {
                region region3 = iterator.next();
                this.scenpotluc.put(region2, Float.valueOf(this.scenpotluc.get(region2).floatValue() + this.potluchist.get(region3).floatValue() * this.plf));
                for (int i = -5; i < 0; ++i) {
                    f += this.histluc.get(region3, fsyluc + i) / (this.fu * 5.0f);
                }
            }
            this.scenlucemit.put(region2, Float.valueOf(f));
            this.srinitial.put(region2, Float.valueOf(f - this.scenpotluc.get(region2).floatValue()));
        }
        for (region region2 : this.regsetreg) {
            this.potlucregbase.put(region2, Float.valueOf(0.0f));
            for (region region4 : region2.subreg(regman.nations)) {
                this.potlucregbase.put(region2, Float.valueOf(this.potlucregbase.get(region2).floatValue() + this.potluchist.get(region4).floatValue() * this.plf));
            }
            this.potlucregquota_init.put(region2, this.potlucregbase.get(region2));
        }
    }

    void setupweights() {
        for (region region2 : this.regsetreg) {
            this.weight.put(region2, new HashMap());
            for (region region3 : sspData.scenreg) {
                this.weight.get(region2).put(region3, Float.valueOf(0.0f));
            }
            for (region region3 : region2.subreg(regman.nations)) {
                for (region region4 : sspData.scenreg) {
                    if (!region4.contains(region3)) continue;
                    float f = this.weight.get(region2).get(region4).floatValue();
                    float f2 = -this.potluchist.get(region3).floatValue() * this.plf;
                    for (int i = -5; i < 0; ++i) {
                        f2 += this.histluc.get(region3, fsyluc + i) / (this.fu * 5.0f);
                    }
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    this.weight.get(region2).put(region4, Float.valueOf(f + f2));
                }
            }
        }
    }

    void histpotluc() {
        for (region region2 : regman.nations.reg) {
            int n;
            this.potluchist.put(region2, Float.valueOf(0.0f));
            if (this.cle.lucsource.chosen.equals("IVIGmodel")) {
                for (n = 1750; n < fsyluc; ++n) {
                    this.potluchist.put(region2, Float.valueOf(this.potluchist.get(region2).floatValue() + this.cle.lucemit.get(region2, n) / 1000.0f));
                }
                if (this.REF.contains(region2)) {
                    this.potluchist.put(region2, Float.valueOf(this.potluchist.get(region2).floatValue() * 1.5f));
                }
                if (this.OECD.contains(region2)) {
                    this.potluchist.put(region2, Float.valueOf(this.potluchist.get(region2).floatValue() * 1.5f));
                }
            }
            if (!this.cle.lucsource.chosen.equals("Houghton")) continue;
            for (n = 1850; n < fsyluc; ++n) {
                this.potluchist.put(region2, Float.valueOf(this.potluchist.get(region2).floatValue() + LUCdata.lucCO2CAIT1.get(region2, n)));
            }
        }
    }
}

