/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.data.loadtable;
import jcm.core.data.pngdata;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;

public class LUCdata
extends module
implements dataholder {
    public static curveset lucCO2Houghton = new curveset("Houghton LUC emit", "mega&ton&carbon", 1750, 2002);
    public static curveset lucCO2UNFCCC = new curveset("UNFCCC LUC emit", "mega&ton&carbon", 1990, 2002);
    public static curveset lucCO2CAIT = new curveset("CAIT LUC emit", "mega&ton&carbon", 1950, 2000);
    public static curveset lucCO2CAIT1 = new curveset("CAIT/Houghton LUC emit", "mega&ton&carbon", 1850, 2000);
    public static curveset faoagr = new curveset("FAO Agriculture Area", "mega&m2", 1961, 2009);
    public static curveset faopast = new curveset("FAO Pasture Area", "mega&m2", 1961, 2009);
    public static curveset edgarff = new curveset(new Object[]{"EDGAR fossil", "mega&ton&carbon", 1890, 2000, complexity.experimental});
    public static curveset edgarluc = new curveset(new Object[]{"EDGAR LUC", "mega&ton&carbon", 1890, 2000, complexity.experimental});
    static boolean loadeddata = false;
    static boolean loadingdata = false;
    static Map<region, Float> countryArcviewAreas = new HashMap<region, Float>();
    static int[] periods = new int[]{1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990, 2009};
    static byte[][][][] luTables = new byte[2][periods.length - 1][][];
    public static biomeclassification defaultBC = biomeclassification.B;

    @Override
    public void initsetup() {
        if (!loadeddata) {
            LUCdata.getdata();
        }
    }

    public static void getdata() {
        if (loadingdata) {
            while (!loadeddata) {
                Thread.yield();
            }
        }
        if (loadeddata) {
            return;
        }
        loadingdata = true;
        LUCdata.reporttime("begin make region polygons");
        for (region region2 : regman.nations.reg) {
            region2.makepolys();
        }
        LUCdata.reporttime("loading static LUCdata curve sets");
        LUCdata.loadStaticData();
        LUCdata.reporttime("Loading LUC Biome Data");
        LUCdata.loadHYDEdata(defaultBC);
        LUCdata.reporttime("end CLE loaddata");
        loadeddata = true;
        loadingdata = false;
    }

    static void loadStaticData() {
        try {
            loadtable.loaddata(faopast, "data/lucnew/FAO11_Past.txt", "\t", false, 10.0f, 1961, 2009, 1961);
            loadtable.oldsplit(faopast, 2009);
            loadtable.loaddata(faoagr, "data/lucnew/FAO11_AraPC.txt", "\t", false, 10.0f, 1961, 2009, 1961);
            loadtable.oldsplit(faoagr, 2009);
            loadtable.loaddata(lucCO2Houghton, "lucdata/houghtondata2000.csv", ";", true, 1.0f, 1850, 2000, 1850);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        fileio.use_UTF_16 = false;
        String[][] stringArray = fileio.loadtab("lucdata/Country_areas.csv", "\t");
        for (int i = 3; i < stringArray.length; ++i) {
            region region2 = regman.allreg.findormakereg(stringArray[i][0], "LUC countryareas ");
            float f = Float.parseFloat(stringArray[i][1]);
            countryArcviewAreas.put(region2, Float.valueOf(!countryArcviewAreas.containsKey(region2) ? f : countryArcviewAreas.get(region2).floatValue() + f));
        }
        loadtable.loaddata(lucCO2UNFCCC, "lucdata/UNFCCC_LUC_emit_v1.tab", "\t", true, 1.0f, 1990, 2002, 1990);
        loadtable.loaddata(lucCO2CAIT, "lucdata/CAIT_LUC_emit.tab", "\t", true, 0.001f, 1950, 2000, 1950);
        for (region region2 : regman.allreg.findormakereg((String)"HOUGHTON").reg) {
            for (int i = 1750; i < 1850; ++i) {
                lucCO2Houghton.set(region2, i, lucCO2Houghton.get(region2, 1850) * (float)(i - 1700) / 150.0f);
            }
        }
        new interpolator(lucCO2Houghton, "HOUGHTON", 1950, Float.valueOf(1.0f)).fill(lucCO2CAIT1, regman.nations, 1850, 2000, lucCO2CAIT);
    }

    static void loadHYDEdata(biomeclassification biomeclassification2) {
        for (int i = 0; i < periods.length - 1; ++i) {
            String string = "lu_" + (Object)((Object)biomeclassification2) + "_" + periods[i];
            LUCdata.luTables[biomeclassification2.ordinal()][i] = pngdata.load("lucdata/" + string + ".png", biomeclassification2.colors);
        }
        biomeclassification2.loaded = true;
    }

    public static enum biomeclassification {
        A(new String[]{"Ocean", "Cultivated land", "Pasture", "X", "X", "Ice", "Tundra", "Wooded tundra", "Boreal forest", "Cool conifer forest", "Temperate mixed forest", "Temperate deciduous forest", "Warm mixed forest", "Grassland/Steppe", "Hot desert", "Scrubland", "Savanna", "Tropical woodland", "Tropical forest"}, new Color[]{colfont.black, colfont.red, colfont.pink, colfont.black, colfont.black, colfont.white, colfont.cyan, colfont.dkcyan, colfont.browngreen, colfont.dkredgreen, colfont.dkyellowgreen, colfont.yellowgreen, colfont.olive, colfont.orange, colfont.yellow, colfont.brown, colfont.ltgreen, colfont.green, colfont.dkgreen}),
        B(new String[]{"Ocean", "Cultivated land", "Pasture", "Tropical Evergreen Forest/Woodland", "Tropical Deciduous Forest/Woodland", "Temperate Broadleafed Evergreen Forest/Woodland", "Temperate Needleleafed Evergreen Forest/Woodland", "Temperate Decidous Forest/Woodland", "Boreal Evergreen Forest/Woodland", "Boreal Deciduous Forest/Woodland", "Evergreen/Deciduous Mixed Forest/Woodland", "Savanna", "Grassland/Steppe", "Dense Shrubland", "Open Shrubland", "Tundra", "Hot Desert", "Polar Deser/Rock/Ice"}, new Color[]{colfont.black, colfont.red, colfont.pink, colfont.dkgreen, colfont.green, colfont.dkgrey, colfont.olive, colfont.yellowgreen, colfont.dkredgreen, colfont.dkyellowgreen, colfont.browngreen, colfont.ltgreen, colfont.orange, colfont.brown, colfont.dkbrown, colfont.cyan, colfont.yellow, colfont.white, colfont.black});

        public String[] names;
        public Color[] colors;
        boolean loaded = false;

        private biomeclassification(String[] stringArray, Color[] colorArray) {
            this.names = stringArray;
            this.colors = colorArray;
        }
    }
}

