/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.reg.regpoly;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.mod.luc.LUCdata;
import jcm.mod.luc.biomestock;
import jcm.mod.luc.cell;

public class CalcLucEmit
extends module {
    public static String[] lucsources = new String[]{"IVIGmodel", "Houghton", "Inverse"};
    public param lucsource = new param(new Object[]{"LUC emit dataset", lucsources, "IVIGmodel", complexity.simplest});
    public param LULUCF_UNFCCC_on = new param(new Object[]{"UNFCCC LULUCF data", false, complexity.experimental});
    public param<LUCdata.biomeclassification> biomeclass = new param<LUCdata.biomeclassification>(new Object[]{"Biome classification", LUCdata.biomeclassification.values(), LUCdata.defaultBC}){

        @Override
        public void precalc() {
            CalcLucEmit.this.biomeList.setlist(((LUCdata.biomeclassification)((Object)this.chosen)).names);
            CalcLucEmit.this.biomeList.choose("Cultivated land");
            CalcLucEmit.this.countryChosenBiomes.map.clear();
            if (!((LUCdata.biomeclassification)((Object)this.chosen)).loaded) {
                LUCdata.loadHYDEdata((LUCdata.biomeclassification)((Object)this.chosen));
            }
        }
    };
    public param biomeList;
    public param countryList;
    public param useFAO;
    public param vegcerror;
    public param isam;
    public param soildecayrate;
    public param soillossagric;
    public param soillosspast;
    public param landuseemit1990;
    public param simplemethod;
    public param grassyon;
    public param shiftcultivation;
    public param shiftcultfrac;
    public param agricfacerr;
    public param usePRODES;
    public param scaleIndonesia;
    public param frac_rainforest;
    public curveset lucemit;
    public curveset carbonstock;
    public curveset biomeChosenCountries;
    public curveset countryChosenBiomes;
    public curveset countryChosenAP;
    public curveset countryChosenEmission;
    Map<Integer, biomestock> biomestocks;
    Map<Integer, Map<Integer, Float>> bcm;
    Set<cell> cellset;
    float oldstock;
    float newstock;
    float countryModelArea;
    float correcAFAO1970;
    float correcPFAO1970;
    public int ccontentset;
    public static int[] desmat_inpe_prodes = new int[]{21050, 17770, 13730, 11030, 13786, 14896, 14896, 29059, 18161, 13227, 17383, 17259, 18226, 18165, 21651, 25396, 27772, 19014, 14286, 11651, 12911, 7464, 6451};

    public CalcLucEmit() {
        this.biomeList = new param(new Object[]{"Biome chosen for plot", ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names, "Cultivated land", complexity.expert});
        this.countryList = new param(new Object[]{"Country chosen for plot", regman.nations.reg.toArray(new region[0]), regman.nations.findormakereg("Brazil", null), complexity.expert});
        this.useFAO = new param(new Object[]{"use FAO agric/past rates of change", true, complexity.expert});
        this.vegcerror = new param(new Object[]{"Vegetation Carbon uncertainty factor", "", 1, 0.8, 1.2, complexity.expert});
        this.isam = new param(new Object[]{"Biome B/ISAM carbon content", true, complexity.expert});
        this.soildecayrate = new param(new Object[]{"95% soil decay time", "", 20, 0.1, 30, complexity.expert});
        this.soillossagric = new param(new Object[]{"LUC agriculture carbon loss from soil (%)", "", 20, 0, 30, complexity.expert});
        this.soillosspast = new param(new Object[]{"LUC pasture carbon loss from soil (%)", "", 5, 0, 20, complexity.expert});
        this.landuseemit1990 = new param(new Object[]{"lucfemit1990", "mega&ton&carbon&per&yr", 2158.09, 0, 3000, complexity.expert});
        this.simplemethod = new param(new Object[]{"Simple soil emissions (IVIG31)", false, complexity.experimental});
        this.grassyon = new param(new Object[]{"Grassy soil carbon", false, complexity.experimental});
        this.shiftcultivation = new param(new Object[]{"Shifting cultivation", false, complexity.experimental});
        this.shiftcultfrac = new param(new Object[]{"Shifting cultivation fraction", "", 0.05, 0.01, 0.1, complexity.experimental});
        this.agricfacerr = new param(new Object[]{"Agric/Past error factor for selected country", "", 1, 0.5, 5, complexity.experimental});
        this.usePRODES = new param(new Object[]{"use INPE-PRODES data for Brazil", true, complexity.expert});
        this.scaleIndonesia = new param(new Object[]{"scale-up-Indonesia", "", 2, 0, 4, complexity.expert});
        this.frac_rainforest = new param(new Object[]{"frac PRODES deforestation from rainforest", 0.67, 0, 1.0, "", complexity.expert});
        this.lucemit = new curveset("IVIG32 model LUC emission", "kilo&ton&carbon", 1700, 2009, 1);
        this.carbonstock = new curveset("IVIG32 model Carbon Stocks", "kilo&ton&carbon", 1700, 2009, 1);
        this.biomeChosenCountries = new curveset(new Object[]{"1 Biome area all countries plot", "mega&m2", 1700, 2009, complexity.expert});
        this.countryChosenBiomes = new curveset(new Object[]{"1 Country all biomes areas plot ", "mega&m2", 1700, 2009, complexity.expert});
        this.countryChosenAP = new curveset(new Object[]{"1 Country FAOxModel areas plot", "mega&m2", 1961, 2009, complexity.expert});
        this.countryChosenEmission = new curveset(new Object[]{"1 Country all emissions datasets", "mega&ton&carbon", 1700, 2009, complexity.expert});
        this.biomestocks = new HashMap<Integer, biomestock>();
        this.bcm = new HashMap<Integer, Map<Integer, Float>>();
        this.cellset = new HashSet<cell>();
    }

    @Override
    public void setinteractions() {
        for (param param2 : this.allparam) {
            if (param2 == this.lucsource) continue;
            this.setaffectedby((interacob)param2, this.lucsource.chosen.equals("IVIGmodel"));
        }
        this.setaffectedby((interacob)this.landuseemit1990, this.lucsource.chosen.equals("Houghton"));
        this.setaffectedby((interacob)this.isam, this.biomeclass.chosen == LUCdata.biomeclassification.B);
        this.setaffectedby((interacob)this.frac_rainforest, this.usePRODES.istrue());
    }

    public static void main(String[] stringArray) {
        for (region region2 : regman.nations.reg) {
            region2.makepolys();
        }
        new LUCdata().initsetup();
        new CalcLucEmit().precalc();
    }

    @Override
    public void precalc() {
        switch (this.biomeclass.getchosenindex()) {
            case 0: {
                this.ccontentset = 0;
                break;
            }
            case 1: {
                int n = this.ccontentset = !this.isam.istrue() ? 1 : 2;
            }
        }
        if (this.lucsource.chosen.equals("IVIGmodel")) {
            this.runmodel();
        }
        if (this.scaleIndonesia.getval() > 0.0) {
            region region2 = regman.nations.findreg("IDN");
            for (int i = this.lucemit.sy; i <= this.lucemit.ey; ++i) {
                float f = (float)this.scaleIndonesia.getval();
                this.lucemit.set(region2, i, this.lucemit.get(region2, i) * f);
            }
        }
    }

    public void runmodel() {
        CalcLucEmit.reporttime("begin CLE runmodel");
        this.countryChosenBiomes.map.clear();
        this.countryChosenAP.map.clear();
        for (region region2 : regman.nations.reg) {
            this.findCells(region2);
            this.calcInitialStock(region2);
            this.setqtcolors(region2);
            for (int i = 0; i < LUCdata.periods.length; ++i) {
                if (i == 0) continue;
                if (i < 8) {
                    this.calcBiomeChangeMap(i, i - 1, region2);
                }
                for (int j = LUCdata.periods[i - 1] + 1; j <= LUCdata.periods[i]; j += this.lucemit.xstep) {
                    this.calcAreaChange(i, region2, j);
                    this.calcEmit(i, region2, j);
                }
            }
        }
        CalcLucEmit.reporttime("end CLE runmodel");
    }

    void calcAreaChange(int n, region region2, int n2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (n2 > 1961 && this.useFAO.istrue()) {
            float f6;
            int n3;
            float f7 = LUCdata.faoagr.get(region2, n2) - LUCdata.faoagr.get(region2, n2 - 1);
            float f8 = LUCdata.faopast.get(region2, n2) - LUCdata.faopast.get(region2, n2 - 1);
            float f9 = 0.0f;
            int n4 = 2;
            int n5 = this.biomeclass.chosen == LUCdata.biomeclassification.B ? 11 : 16;
            int n6 = n3 = this.biomeclass.chosen == LUCdata.biomeclassification.B ? 3 : 17;
            if (this.usePRODES.istrue() && region2.name.equals("BRA") && n2 >= 1977) {
                f9 = (float)desmat_inpe_prodes[n2 > 1988 ? n2 - 1988 : 0] * (float)this.frac_rainforest.getval();
                this.transfer(f9, n3, n4);
            }
            f3 = 0.0f;
            f4 = 0.0f;
            for (Integer n7 : this.bcm.keySet()) {
                for (Integer n8 : this.bcm.get(n7).keySet()) {
                    if (n7 <= 0 || n8 <= 0) continue;
                    f6 = this.bcm.get(n7).get(n8).floatValue();
                    if (n8 == 1) {
                        f3 += f6;
                    }
                    if (n7 != 1) continue;
                    f3 -= f6;
                }
            }
            if (f3 == 0.0f) {
                float f10 = 10.0f;
                if (!this.bcm.containsKey(1)) {
                    this.bcm.put(1, new HashMap());
                }
                if (!this.bcm.get(1).containsKey(2)) {
                    this.bcm.get(1).put(2, Float.valueOf(f10));
                }
                f3 -= f10;
            }
            float f11 = f7 / f3;
            for (Integer n7 : this.bcm.keySet()) {
                for (Integer n8 : this.bcm.get(n7).keySet()) {
                    if (n7 <= 0 || n8 <= 0) continue;
                    f6 = this.bcm.get(n7).get(n8).floatValue();
                    if (n8 == 1 && n7 == 2) {
                        f5 -= f6 * f11;
                    }
                    if (n7 != 1 || n8 != 2) continue;
                    f5 += f6 * f11;
                }
            }
            for (Integer n7 : this.bcm.keySet()) {
                for (Integer n8 : this.bcm.get(n7).keySet()) {
                    if (n7 <= 1 || n8 <= 1) continue;
                    f6 = this.bcm.get(n7).get(n8).floatValue();
                    if (n7 == 2) {
                        f4 += f6;
                    }
                    if (n8 != 2) continue;
                    f4 += f6;
                }
            }
            if (f4 == 0.0f) {
                int n9 = 0;
                float f12 = 0.0f;
                for (int i = 3; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
                    if (!this.biomestocks.containsKey(i) || !(f12 < this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea)) continue;
                    f12 = this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea;
                    n9 = i;
                }
                float f13 = 10.0f;
                if (!this.bcm.containsKey(n9)) {
                    this.bcm.put(n9, new HashMap());
                }
                if (!this.bcm.get(n9).containsKey(2)) {
                    this.bcm.get(n9).put(2, Float.valueOf(f13));
                }
                f3 -= f13;
            }
            float f14 = f4 != 0.0f ? (f8 - f5) / f4 : 1.0f;
            for (Integer n10 : this.bcm.keySet()) {
                for (Integer n8 : this.bcm.get(n10).keySet()) {
                    float f15;
                    if (n10 <= 0 || n8 <= 0) continue;
                    f6 = this.bcm.get(n10).get(n8).floatValue();
                    if (n10 == 1 || n8 == 1) {
                        f6 *= f11;
                    }
                    if (n10 == 2 && n8 != 1) {
                        f6 *= -f14;
                    }
                    if (n10 != 1 && n8 == 2) {
                        f6 *= f14;
                    }
                    float f16 = f15 = f6 >= 0.0f ? this.biomestocks.get((Object)n10).totarea : this.biomestocks.get((Object)n8).totarea;
                    if (f15 < Math.abs(f6)) {
                        int n11 = 0;
                        float f17 = 0.0f;
                        for (Integer n12 : this.bcm.keySet()) {
                            for (Integer n13 : this.bcm.get(n12).keySet()) {
                                if (n12 > 2 && f17 < this.biomestocks.get((Object)n12).totarea && this.biomestocks.get((Object)n12).totarea > f6) {
                                    n11 = n12;
                                    f17 = this.biomestocks.get((Object)n12).totarea;
                                }
                                if (n13 <= 2 || !(f17 < this.biomestocks.get((Object)n13).totarea) || !(this.biomestocks.get((Object)n13).totarea > f6)) continue;
                                n11 = n13;
                                f17 = this.biomestocks.get((Object)n13).totarea;
                            }
                        }
                        if (n11 == 0) {
                            for (int i = 3; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
                                if (!this.biomestocks.containsKey(i) || !(f17 < this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea)) continue;
                                f17 = this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea;
                                n11 = i;
                            }
                        }
                        if (f6 > 0.0f && n11 > 2) {
                            n10 = n11;
                        }
                        if (f6 < 0.0f && n11 > 2) {
                            n8 = n11;
                        }
                    }
                    if (n8 == n4 && n10 == n5) {
                        if (this.usePRODES.istrue() && region2.name.equals("BRA") && n2 > 1970 && n2 < 1977) {
                            f9 = f6 * (float)this.frac_rainforest.getval() * (float)(n2 - 1970) / 7.0f;
                            this.transfer(f9, n3, n4);
                        }
                        if (f9 > 0.0f) {
                            f6 -= f9;
                            f9 = 0.0f;
                        }
                    }
                    if (!(f6 > 1.0f) && !(f6 < -1.0f)) continue;
                    this.transfer(f6, n10, n8);
                }
            }
            this.shiftcultivation();
        } else {
            for (Integer n14 : this.bcm.keySet()) {
                for (Integer n15 : this.bcm.get(n14).keySet()) {
                    float f18;
                    if (n14 <= 0 || n15 <= 0) continue;
                    float f19 = this.bcm.get(n14).get(n15).floatValue();
                    float f20 = f18 = f19 >= 0.0f ? this.biomestocks.get((Object)n14).totarea : this.biomestocks.get((Object)n15).totarea;
                    if (f18 < Math.abs(f19)) {
                        int n16 = 0;
                        float f21 = 0.0f;
                        for (Integer n17 : this.bcm.keySet()) {
                            for (Integer n18 : this.bcm.get(n17).keySet()) {
                                if (n17 > 2 && f21 < this.biomestocks.get((Object)n17).totarea && this.biomestocks.get((Object)n17).totarea > f19) {
                                    n16 = n17;
                                    f21 = this.biomestocks.get((Object)n17).totarea;
                                }
                                if (n18 <= 2 || !(f21 < this.biomestocks.get((Object)n18).totarea) || !(this.biomestocks.get((Object)n18).totarea > f19)) continue;
                                n16 = n18;
                                f21 = this.biomestocks.get((Object)n18).totarea;
                            }
                        }
                        if (n16 == 0) {
                            for (int i = 3; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
                                if (!this.biomestocks.containsKey(i) || !(f21 < this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea)) continue;
                                f21 = this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea;
                                n16 = i;
                            }
                        }
                        if (f19 > 0.0f && n16 > 2) {
                            n14 = n16;
                        }
                        if (f19 < 0.0f && n16 > 2) {
                            n15 = n16;
                        }
                    }
                    this.transfer(f19, n14, n15);
                    this.shiftcultivation();
                }
            }
        }
    }

    void calcEmit(int n, region region2, int n2) {
        this.newstock = 0.0f;
        for (biomestock biomestock2 : this.biomestocks.values()) {
            biomestock2.decayregrow(this.lucemit.xstep);
            this.newstock += biomestock2.totstock();
        }
        float f = (this.oldstock - this.newstock) / (float)this.lucemit.xstep;
        if (Float.isNaN(f) || Float.isInfinite(f)) {
            f = 0.0f;
        }
        this.oldstock = Float.isNaN(this.newstock) ? this.oldstock : this.newstock;
        this.lucemit.set(region2, n2, f);
        this.carbonstock.set(region2, n2, this.oldstock);
        this.setcountryqts(region2, n2);
    }

    void transfer(float f, int n, int n2) {
        if (f < 0.0f) {
            int n3 = n;
            n = n2;
            n2 = n3;
            f = -f;
        }
        this.biomestocks.get(n).cutdown(f, this.biomestocks.get(n2));
        this.biomestocks.get(n2).setregrow(f, this.biomestocks.get(n));
    }

    void calcInitialStock(region region2) {
        this.biomestocks.clear();
        this.biomestocks.put(1, new biomestock(1, 0.0f, this));
        this.biomestocks.put(2, new biomestock(2, 0.0f, this));
        int n = ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).ordinal();
        for (cell object : this.cellset) {
            int n2 = (int)((double)(object.lon * 2.0f) + 359.5);
            int n3 = (int)((double)(-object.lat * 2.0f) + 180.5);
            try {
                byte by = LUCdata.luTables[n][0][n2][n3];
                if (by == 0) continue;
                if (!this.biomestocks.containsKey(by)) {
                    this.biomestocks.put(Integer.valueOf(by), new biomestock(by, 0.0f, this));
                }
                this.biomestocks.get(by).addarea(object.area);
            }
            catch (Exception exception) {
                report.deb(exception, n2 + " " + n3);
            }
        }
        this.setcountryqts(region2, 1700);
        this.countryAreasCorrection(region2);
        this.oldstock = 0.0f;
        for (biomestock biomestock2 : this.biomestocks.values()) {
            this.oldstock += biomestock2.totstock();
            biomestock2.potvegstock = biomestock2.vegstock;
            biomestock2.potsoilstock = biomestock2.soilstock;
        }
    }

    void calcBiomeChangeMap(int n, int n2, region region2) {
        int n3 = (LUCdata.periods[n] - LUCdata.periods[n2]) / this.lucemit.xstep;
        int n4 = ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).ordinal();
        this.bcm.clear();
        for (cell cell2 : this.cellset) {
            int n5 = (int)((double)(cell2.lon * 2.0f) + 359.5);
            int n6 = (int)((double)(-cell2.lat * 2.0f) + 180.5);
            byte by = LUCdata.luTables[n4][n][n5][n6];
            byte by2 = LUCdata.luTables[n4][n2][n5][n6];
            if (by == by2) continue;
            if (!this.bcm.containsKey(by2)) {
                this.bcm.put(Integer.valueOf(by2), new HashMap());
            }
            if (!this.bcm.get(by2).containsKey(by)) {
                this.bcm.get(by2).put(Integer.valueOf(by), Float.valueOf(0.0f));
            }
            this.bcm.get(by2).put(Integer.valueOf(by), Float.valueOf(this.bcm.get(by2).get(by).floatValue() + cell2.area / (float)n3));
        }
    }

    void shiftcultivation() {
        if (this.shiftcultivation.istrue() && this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea > 100000.0f) {
            float f = 0.0f;
            int n = 0;
            for (int i = 3; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
                if (!this.biomestocks.containsKey(i) || !(f < this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea)) continue;
                n = i;
            }
            this.transfer(this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea * (float)this.shiftcultfrac.getval() / 100.0f, 1, n);
            this.transfer(this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea * (float)this.shiftcultfrac.getval() / 100.0f, n, 1);
        }
    }

    void countryAreasCorrection(region region2) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (LUCdata.countryArcviewAreas.containsKey(region2) && this.countryModelArea != 0.0f) {
            float f3 = LUCdata.countryArcviewAreas.get(region2).floatValue() / this.countryModelArea - 1.0f;
            for (int i = 1; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
                if (!this.biomestocks.containsKey(i)) continue;
                this.biomestocks.get(i).addarea(f3 * this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea);
            }
        }
    }

    void setcountryqts(region region2, int n) {
        float f = 0.0f;
        this.biomeChosenCountries.set(region2, n, this.biomestocks.containsKey(this.biomeList.getchosenindex()) ? this.biomestocks.get((Object)Integer.valueOf((int)this.biomeList.getchosenindex())).totarea : 0.0f);
        if (region2 == this.countryList.getchosen()) {
            this.countryChosenAP.set("Model Agric", n, this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea);
            this.countryChosenAP.set("FAO Agric", n, LUCdata.faoagr.get(region2, n));
            this.countryChosenAP.set("Model Past", n, this.biomestocks.get((Object)Integer.valueOf((int)2)).totarea);
            this.countryChosenAP.set("FAO Past", n, LUCdata.faopast.get(region2, n));
            if (n < 2003) {
                this.countryChosenEmission.set("IVIG32 model", n, this.lucemit.get(region2, n) * 0.001f);
            }
            if (n > 1989 && n < 2003) {
                this.countryChosenEmission.set("UNFCCC", n, LUCdata.lucCO2UNFCCC.get(region2, n));
            }
            if (n > 1850 && n < 2001) {
                this.countryChosenEmission.set("CAIT/Houghton", n, LUCdata.lucCO2CAIT1.get(region2, n));
            }
        }
        for (int i = 1; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
            if (!this.biomestocks.containsKey(i)) continue;
            f += this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea;
            if (region2 != this.countryList.getchosen() || !this.biomestocks.containsKey(i)) continue;
            this.countryChosenBiomes.set(this.biomeList.getname(i), n, this.biomestocks.get((Object)Integer.valueOf((int)i)).totarea);
        }
        this.countryModelArea = f;
    }

    void setqtcolors(region region2) {
        if (region2 == this.countryList.getchosen()) {
            this.countryChosenAP.addcurve(new curve("Model Agric", colfont.red, 1962, 2009));
            this.countryChosenAP.addcurve(new curve("FAO Agric", colfont.dkred, 1962, 2009));
            this.countryChosenAP.addcurve(new curve("Model Past", colfont.pink, 1962, 2009));
            this.countryChosenAP.addcurve(new curve("FAO Past", colfont.magenta, 1962, 2009));
            this.countryChosenEmission.addcurve(new curve("IVIG32 model", colfont.red, 1700, 2009));
            this.countryChosenEmission.addcurve(new curve("UNFCCC", colfont.blue, 1990, 2009));
            this.countryChosenEmission.addcurve(new curve("CAIT/Houghton", colfont.yellow, 1850, 2000));
            for (int i = 1; i < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++i) {
                if (!this.biomestocks.containsKey(i)) continue;
                this.countryChosenBiomes.addcurve(new curve(this.biomeList.getname(i), ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).colors[i], 1700, 2009));
            }
        }
    }

    void findCells(region region2) {
        this.cellset.clear();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (regpoly regpoly2 : region2.polyset) {
            Area area = new Area(regpoly2);
            Rectangle rectangle = area.getBounds();
            int n = 5;
            for (int i = rectangle.x; i < rectangle.x + rectangle.width; i += n) {
                int n2 = Math.min(rectangle.x + rectangle.width - i, n);
                for (int j = rectangle.y; j < rectangle.y + rectangle.height; j += n) {
                    int n3 = Math.min(rectangle.y + rectangle.height - j, n);
                    if (!area.intersects(i, j, n2, n3)) continue;
                    boolean bl = area.contains(i, j, n2, n3);
                    float f = -0.25f + (float)j;
                    while (f < -0.25f + (float)j + (float)n3) {
                        d = Math.cos(Math.PI * (double)f / 180.0);
                        float f2 = 0.25f + (float)i;
                        while (f2 < 0.25f + (float)i + (float)n2) {
                            if (bl || area.contains(f2, f)) {
                                cell cell2 = new cell();
                                cell2.lon = f2;
                                cell2.lat = f;
                                cell2.area = (float)(d * Math.pow(55.563, 2.0));
                                this.cellset.add(cell2);
                            }
                            f2 = (float)((double)f2 + 0.5);
                        }
                        f = (float)((double)f + 0.5);
                    }
                }
            }
        }
    }
}

