/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.energy;

import java.util.EnumMap;
import java.util.Map;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.energy.buildings;
import jcm.mod.energy.electricity;
import jcm.mod.energy.enerData;
import jcm.mod.energy.fuels;
import jcm.mod.energy.industry;
import jcm.mod.energy.transport;
import jcm.mod.socio.popgdp;

public class enerGeneral
extends module {
    public curveset total_energy_use = new curveset("total_energy_use", "tera&Watt_hours", 2010, 2050);
    public curveset total_CO2 = new curveset("CO2_energy_total", "mega&ton&CO2", 2010, 2050);
    public curveset totcostplot = new curveset("costs_energy_total", "mega&dollar", 2010, 2050);
    public curveset IEAtotCO2 = new curveset("IEA_TotalCO2", "mega&ton&carbon", 1990, 2035);
    public param<enerData.eregion> ch_reg = new param("Region", enerData.modelregions, enerData.eregion.World);
    public param<enerData.WEO_scenario> WEOscenario = new param("WEOscenario", enerData.futscen, enerData.WEO_scenario.New_Policies);
    public param regdisco = new param("regional discount rates", true);
    public param discount = new param("discount rate", "%", 6, 0, 15);
    public param carbonprice = new param("carbon_price", "dollar&per&ton&CO2", 50, 0, 200);
    public param demelasticity = new param("demand elasticity", "", 0.5, 0, 2);
    popgdp pg;
    electricity el;
    transport tr;
    fuels fu;
    buildings bu;
    industry in;
    public Map<enerData.eregion, ensec> enmap = new EnumMap<enerData.eregion, ensec>(enerData.eregion.class);
    enerData.eregion last_reg;
    enerData.info_type last_type;
    enerData.sub_sector last_sec;
    enerData.source last_source;
    enerData.WEO_scenario last_scen;
    int last_year;

    @Override
    public void initsetup() {
        this.fu = this.gm(fuels.class);
        this.el = this.gm(electricity.class);
        this.pg = this.gm(popgdp.class);
        this.tr = this.gm(transport.class);
        this.in = this.gm(industry.class);
        this.bu = this.gm(buildings.class);
        this.follows(this.pg);
        this.setaffectedby(this.fu);
        this.setaffectedby(this.el);
        this.setaffectedby(this.tr);
        this.setaffectedby(this.in);
        this.setaffectedby(this.bu);
        for (enerData.eregion eregion2 : enerData.modelregions) {
            this.enmap.put(eregion2, new ensec(eregion2));
        }
    }

    @Override
    public void setinteractions() {
        this.setaffectedby((interacob)this.discount, !this.regdisco.istrue());
    }

    @Override
    public void precalc() {
        for (enerData.eregion eregion2 : enerData.modelregions) {
            if (eregion2 == enerData.eregion.World) continue;
            this.data(eregion2, this.WEOscenario.chosen, 2010);
            this.el.rmap.get(eregion2).init();
            this.el.rmap.get(eregion2).gettp(eregion2);
        }
        this.fillIEAplot();
    }

    @Override
    public void calcstep() {
        if (year < 2010 || year > 2050) {
            return;
        }
        for (enerData.eregion eregion2 : enerData.modelregions) {
            if (eregion2 == enerData.eregion.World) continue;
            if (year <= 2035) {
                this.data(eregion2, this.WEOscenario.chosen, year);
            }
            this.enmap.get(eregion2).getgdppop();
            this.el.rmap.get(eregion2).adjust();
        }
        this.el.calcworld();
        this.el.fillplots();
    }

    void normaldisco() {
    }

    void fillIEAplot() {
        for (enerData.eregion eregion2 : enerData.worldregions) {
            if (eregion2 == enerData.eregion.International_Bunkers) continue;
            for (int i = 1990; i <= 2035; ++i) {
                this.IEAtotCO2.set(eregion2.jcmreg, i, enerData.getf(eregion2, enerData.info_type.CO2_emissions, enerData.sub_sector.Total_CO2, enerData.source.Total, (enerData.WEO_scenario)this.WEOscenario.chosen, i) * 12.0f / 44.0f);
            }
        }
    }

    int data(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object instanceof enerData.eregion) {
                this.last_reg = (enerData.eregion)object;
            }
            if (object instanceof enerData.info_type) {
                this.last_type = (enerData.info_type)((Object)object);
            }
            if (object instanceof enerData.sub_sector) {
                this.last_sec = (enerData.sub_sector)object;
            }
            if (object instanceof enerData.source) {
                this.last_source = (enerData.source)object;
            }
            if (object instanceof enerData.WEO_scenario) {
                this.last_scen = (enerData.WEO_scenario)object;
            }
            if (!(object instanceof Integer)) continue;
            this.last_year = (Integer)object;
        }
        return enerData.get(this.last_reg, this.last_type, this.last_sec, this.last_source, this.last_scen, this.last_year);
    }

    class ensec {
        float gdp;
        float pop;
        float disco;
        float gdpold;
        float gdporig;
        enerData.eregion myreg;

        ensec(enerData.eregion eregion2) {
            this.myreg = eregion2;
        }

        void getgdppop() {
            if (this.myreg.jcmreg == null) {
                return;
            }
            this.gdpold = this.gdp;
            this.gdp = 0.0f;
            this.pop = 0.0f;
            for (region region2 : this.myreg.jcmreg.subreg(regman.nations)) {
                if (!Float.isNaN(enerGeneral.this.pg.gdp_ppp_nat.get(region2, loopcalc.year))) {
                    this.gdp += enerGeneral.this.pg.gdp_ppp_nat.get(region2, loopcalc.year);
                }
                if (Float.isNaN(enerGeneral.this.pg.pop_nat.get(region2, loopcalc.year))) continue;
                this.pop += enerGeneral.this.pg.pop_nat.get(region2, loopcalc.year);
            }
            if (loopcalc.year == 2020) {
                this.gdporig = this.gdp;
            }
            this.disco = enerGeneral.this.regdisco.istrue() && loopcalc.year > 2010 ? -((float)Math.log(this.gdpold / this.gdp)) : -((float)Math.log((100.0 - enerGeneral.this.discount.getval()) / 100.0));
        }
    }
}

