/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.energy;

import java.awt.Color;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.dataholder;
import jcm.core.itf.hasColor;
import jcm.core.ob.infob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.mod.energy.enerGeneral;

public class enerData
extends module
implements dataholder {
    static eregion[] WEOregions = new eregion[]{eregion.Brazil, eregion.Latin_America, eregion.Africa, eregion.Middle_East, eregion.India, eregion.China, eregion.Non_OECD_Asia, eregion.Russia, eregion.Caspian, eregion.East_Europe_Eurasia, eregion.Japan, eregion.OECD_Pacific, eregion.European_Union, eregion.OECD_Europe, eregion.United_States, eregion.OECD_North_America, eregion.International_Bunkers};
    static eregion[] worldregions = new eregion[]{eregion.Brazil, eregion.Other_Latin_America, eregion.Africa, eregion.Middle_East, eregion.India, eregion.China, eregion.Other_Asia, eregion.Russia, eregion.Caspian, eregion.Other_East_Europe, eregion.Japan, eregion.Aust_NewZ_Korea, eregion.European_Union, eregion.Other_OECD_Europe, eregion.United_States, eregion.Canada_Mexico, eregion.International_Bunkers};
    static eregion[] modelregions = new eregion[]{eregion.World, eregion.Brazil, eregion.Other_Latin_America, eregion.Africa, eregion.Middle_East, eregion.India, eregion.China, eregion.Other_Asia, eregion.Russia, eregion.Caspian, eregion.Other_East_Europe, eregion.Japan, eregion.Aust_NewZ_Korea, eregion.European_Union, eregion.Other_OECD_Europe, eregion.United_States, eregion.Canada_Mexico};
    static eregion[] worldsum = new eregion[]{eregion.Latin_America, eregion.Africa, eregion.Middle_East, eregion.Non_OECD_Asia, eregion.East_Europe_Eurasia, eregion.OECD_Pacific, eregion.OECD_Europe, eregion.OECD_North_America, eregion.International_Bunkers};
    static eregion[][] otherregions = new eregion[][]{{eregion.Other_Latin_America, eregion.Latin_America, eregion.Brazil}, {eregion.Other_Asia, eregion.Non_OECD_Asia, eregion.India, eregion.China}, {eregion.Other_East_Europe, eregion.East_Europe_Eurasia, eregion.Russia, eregion.Caspian}, {eregion.Aust_NewZ_Korea, eregion.OECD_Pacific, eregion.Japan}, {eregion.Other_OECD_Europe, eregion.OECD_Europe, eregion.European_Union}, {eregion.Canada_Mexico, eregion.OECD_North_America, eregion.United_States}};
    static eregion[][] invest_info_regions = new eregion[][]{{eregion.European_Union, eregion.Other_OECD_Europe}, {eregion.United_States, eregion.Canada_Mexico}, {eregion.Japan, eregion.Aust_NewZ_Korea}, {eregion.Russia, eregion.Caspian, eregion.Other_East_Europe}, {eregion.China, eregion.Other_Asia, eregion.Brazil, eregion.Other_Latin_America}, {eregion.India, eregion.Africa, eregion.Middle_East}};
    static sub_sector[] totsecs = new sub_sector[]{sub_sector.TPED, sub_sector.TFC, sub_sector.Total_generation, sub_sector.Total_capacity, sub_sector.Total_CO2};
    static sub_sector[] bigsecs = new sub_sector[]{sub_sector.Power_generation, sub_sector.Other_energy_sector, sub_sector.Industry, sub_sector.Transport, sub_sector.Buildings, sub_sector.Other};
    static source[][] invsources = new source[][]{{source.Coal, source.Coal_Subcritical, source.Coal_Supercritical, source.Coal_Ultrasupercritical, source.IGCC}, {source.Gas, source.CCGT, source.Gas_Turbine}, {source.Biomass_and_waste, source.Biomass_Power_Plant}, {source.Hydro, source.Hydropower_Large_Scale, source.Hydropower_Small_Scale}, {source.Wind, source.Wind_Onshore, source.Wind_Offshore}, {source.Solar_PV, source.Solar_Photovoltaics_Large_Scale, source.Solar_Photovoltaics_Buildings}};
    static EnumSet<source> fuels = EnumSet.of(source.Coal, source.Oil, source.Gas, source.Biofuels, source.Other_fuels);
    static EnumSet<source> thermal = EnumSet.of(source.Coal, source.Oil, source.Gas, source.Biomass_and_waste);
    static EnumSet<source> renewables = EnumSet.of(source.Nuclear, new source[]{source.Hydro, source.Wind, source.Solar_PV, source.CSP, source.Marine, source.Geothermal});
    static EnumSet<source> transformers = EnumSet.of(source.Electricity);
    static EnumSet<source> electricity_sources = renewables.clone();
    static source[] primary;
    static source[] secondary;
    static WEO_scenario[] futscen;
    static boolean loadeddata;
    static boolean fixedcolors;
    static boolean changeplots;
    public param<info_type> ch_type = new param(new Object[]{"Type", info_type.values(), info_type.Energy_Demand}){

        @Override
        public void precalc() {
            try {
                enerData.this.ch_sector.menulist = regmap.get(eregion.European_Union).get(enerData.this.ch_type.chosen).keySet().toArray(new sub_sector[0]);
                enerData.this.ch_sector.chosen = ((sub_sector[])enerData.this.ch_sector.menulist)[0];
                enerData.this.ch_sector.precalc();
            }
            catch (Exception exception) {
                report.deb("!! Error changing type " + enerData.this.ch_type.chosen);
                exception.printStackTrace();
            }
        }
    };
    public param<sub_sector> ch_sector = new param(new Object[]{"Sector", sub_sector.values(), sub_sector.TPED}){

        @Override
        public void precalc() {
            try {
                enerData.this.ch_source.menulist = regmap.get(eregion.European_Union).get(enerData.this.ch_type.chosen).get(enerData.this.ch_sector.chosen).keySet().toArray(new source[0]);
                enerData.this.ch_source.chosen = ((source[])enerData.this.ch_source.menulist)[0];
                changeplots = true;
            }
            catch (Exception exception) {
                report.deb("!! Error changing sector " + enerData.this.ch_sector.chosen);
                exception.printStackTrace();
            }
        }
    };
    public param<source> ch_source = new param("Source", source.values(), source.Total);
    public curveset regplot = new curveset("Regions", "", 1990, 2035, 5);
    public curveset scenplot = new curveset("Scenarios", "", 1990, 2035, 5);
    public curveset sourceplot = new curveset("Sources", "", 1990, 2035, 5);
    public curveset sectorplot = new curveset("Sectors", "", 1990, 2035, 5);
    static String[] tots;
    static String oldmsg;
    static String msg;
    static Map<eregion, Map<info_type, Map<sub_sector, Map<source, Map<WEO_scenario, int[]>>>>> regmap;
    static Map<eregion, Map<source, float[]>> potentialmap;

    @Override
    public void initsetup() {
        if (!loadeddata) {
            enerData.getdata();
        }
    }

    @Override
    public void setinteractions() {
        this.setaffectedby(this.gm(enerGeneral.class));
    }

    @Override
    public void precalc() {
        int n;
        enerGeneral enerGeneral2 = this.gm(enerGeneral.class);
        WEO_scenario wEO_scenario = (WEO_scenario)enerGeneral2.WEOscenario.chosen;
        eregion eregion2 = (eregion)enerGeneral2.ch_reg.chosen;
        info_type info_type2 = (info_type)((Object)this.ch_type.chosen);
        sub_sector sub_sector2 = (sub_sector)this.ch_sector.chosen;
        source source2 = (source)this.ch_source.chosen;
        if (changeplots) {
            String object;
            this.regplot.units = object = ((info_type)((Object)this.ch_type.chosen)).units;
            this.scenplot.units = object;
            this.sourceplot.units = object;
            this.sectorplot.units = object;
            this.regplot.unitschanged = true;
            this.scenplot.unitschanged = true;
            this.sourceplot.unitschanged = true;
            this.sectorplot.unitschanged = true;
            this.sectorplot.map.clear();
            this.sourceplot.map.clear();
            changeplots = false;
        }
        for (eregion eregion3 : worldregions) {
            this.setupcurve(this.regplot, eregion3);
            for (n = 1990; n <= 2035; n += 5) {
                this.regplot.set(eregion3, n, enerData.getf(eregion3, info_type2, sub_sector2, source2, wEO_scenario, n));
            }
        }
        for (WEO_scenario wEO_scenario2 : futscen) {
            this.setupcurve(this.scenplot, wEO_scenario2);
            for (n = 1990; n <= 2035; n += 5) {
                this.scenplot.set(wEO_scenario2, n, enerData.getf(eregion2, info_type2, sub_sector2, source2, wEO_scenario2, n));
            }
        }
        for (source source3 : (source[])this.ch_source.menulist) {
            this.setupcurve(this.sourceplot, source3);
            for (n = 1990; n <= 2035; n += 5) {
                this.sourceplot.set(source3, n, enerData.getf(eregion2, info_type2, sub_sector2, source3, wEO_scenario, n));
            }
        }
        for (sub_sector sub_sector3 : (sub_sector[])this.ch_sector.menulist) {
            this.setupcurve(this.sectorplot, sub_sector3);
            for (n = 1990; n <= 2035; n += 5) {
                this.sectorplot.set(sub_sector3, n, enerData.getf(eregion2, info_type2, sub_sector3, source2, wEO_scenario, n));
            }
        }
    }

    void setupcurve(curveset curveset2, hasColor hasColor2) {
        curve curve2 = curveset2.getOrAddCurve(hasColor2);
        String string = hasColor2.toString();
        for (String string2 : tots) {
            if (!string.startsWith(string2)) continue;
            curve.Type cfr_ignored_0 = curve2.type;
            curve2.type = curve.Type.total;
        }
    }

    public static float gettechpot(eregion eregion2, source source2, int n) {
        return potentialmap.get(eregion2).get(source2)[n];
    }

    public static float getf(eregion eregion2, info_type info_type2, sub_sector sub_sector2, source source2, WEO_scenario wEO_scenario, int n) {
        int n2 = enerData.get(eregion2, info_type2, sub_sector2, source2, wEO_scenario, n);
        return n2 == 0 ? Float.NaN : (float)n2;
    }

    /*
     * WARNING - void declaration
     */
    public static int get(eregion eregion2, info_type info_type2, sub_sector sub_sector2, source source2, WEO_scenario wEO_scenario, int n) {
        int n2;
        if (info_type2 == info_type.Invest_costs || info_type2 == info_type.Efficiency) {
            eregion[][] object = invest_info_regions;
            int n3 = object.length;
            for (n2 = 0; n2 < n3; ++n2) {
                eregion[] eregionArray;
                for (eregion eregion3 : eregionArray = object[n2]) {
                    if (eregion2 != eregion3 || eregion2 == eregionArray[0]) continue;
                    return enerData.get(eregionArray[0], info_type2, sub_sector2, source2, wEO_scenario, n);
                }
            }
        } else {
            if (eregion2 == eregion.World) {
                void exception;
                boolean n4 = false;
                for (eregion eregion4 : worldsum) {
                    exception += enerData.get(eregion4, info_type2, sub_sector2, source2, wEO_scenario, n);
                }
                return (int)exception;
            }
            for (eregion[] eregionArray : otherregions) {
                if (eregion2 != eregionArray[0]) continue;
                int n4 = enerData.get(eregionArray[1], info_type2, sub_sector2, source2, wEO_scenario, n);
                for (int i = 2; i < eregionArray.length; ++i) {
                    n4 -= enerData.get(eregionArray[i], info_type2, sub_sector2, source2, wEO_scenario, n);
                }
                return n4;
            }
        }
        try {
            int[] nArray = regmap.get(eregion2).get((Object)info_type2).get(sub_sector2).get(source2).get(wEO_scenario);
            int[] nArray2 = regmap.get(eregion2).get((Object)info_type2).get(sub_sector2).get(source2).get(WEO_scenario.history);
            if (info_type2 == info_type.Invest_costs || info_type2 == info_type.Efficiency) {
                if (nArray == null || n < 2009) {
                    return nArray2[0];
                }
                if (n >= 2009 && n < 2020) {
                    return (nArray2[0] * (2020 - n) + nArray[0] * (n - 2009)) / 11;
                }
                if (n >= 2020 && n <= 2035) {
                    return (nArray[0] * (2035 - n) + nArray[1] * (n - 2020)) / 15;
                }
            } else {
                if (wEO_scenario.i(n) >= 0) {
                    return nArray[wEO_scenario.i(n)];
                }
                if (n >= 1990 && n < 2008) {
                    return nArray2[0] == 0 ? nArray2[1] : (nArray2[0] * (2008 - n) + nArray2[1] * (n - 1990)) / 18;
                }
                if (n >= 2008 && n <= 2015) {
                    return (nArray2[1] * (2015 - n) + nArray2[2] * (n - 2008)) / 7;
                }
                if (n == 2025 && (wEO_scenario == WEO_scenario.S450_Scenario || wEO_scenario == WEO_scenario.Current_Policies)) {
                    return (nArray[0] + nArray[1]) / 2;
                }
                if (n > 2015 && n < 2035) {
                    n2 = n % 5;
                    int n5 = n - n2;
                    return (enerData.get(eregion2, info_type2, sub_sector2, source2, wEO_scenario, n5) * (5 - n2) + enerData.get(eregion2, info_type2, sub_sector2, source2, wEO_scenario, n5 + 5) * n2) / 5;
                }
            }
            throw new RuntimeException("Check Year");
        }
        catch (Exception exception) {
            msg = "No data: \t" + eregion2 + " \t" + (Object)((Object)info_type2) + " \t" + sub_sector2 + " \t" + source2 + " \t" + wEO_scenario + " \t";
            if (oldmsg.startsWith(msg)) {
                System.out.print(" " + n);
                return 0;
            }
            oldmsg = msg;
            report.deb(msg + n);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void getdata() {
        enerData.reporttime("start load Energy Data");
        String string = "";
        try {
            void var15_42;
            EnumMap<WEO_scenario, int[]> enumMap;
            String[][] stringArray;
            Map<sub_sector, Object> map2 = null;
            EnumMap<source, EnumMap<WEO_scenario, int[]>> enumMap2 = null;
            int[] nArray = new int[14];
            for (eregion eregionArray : WEOregions) {
                EnumMap enumMap3 = new EnumMap(info_type.class);
                regmap.put(eregionArray, enumMap3);
                String[][] stringArray4 = stringArray = fileio.loadtab("data/energy/" + eregionArray + ".txt", "\t");
                int n = stringArray4.length;
                block3: for (int eregionArray2 = 0; eregionArray2 < n; ++eregionArray2) {
                    void var15_35;
                    void var15_33;
                    Enum enum_;
                    void var18_54;
                    String[] stringArray2 = stringArray4[eregionArray2];
                    if (stringArray2.length == 0 || (string = stringArray2[0]).equals("History") || string.equals("1990")) continue;
                    for (info_type info_type2 : info_type.values()) {
                        if (!string.startsWith(info_type2.name())) continue;
                        map2 = new EnumMap(sub_sector.class);
                        enumMap3.put(info_type2, map2);
                        continue block3;
                    }
                    Object var15_32 = null;
                    Enum[] enumArray = sub_sector.values();
                    int n2 = enumArray.length;
                    boolean bl = false;
                    while (var18_54 < n2) {
                        enum_ = enumArray[var18_54];
                        if (string.equals(enum_.toString())) {
                            if (enum_ == sub_sector.Transport && enumMap3.get((Object)info_type.CO2_emissions) == map2) continue block3;
                            enumMap2 = new EnumMap<source, EnumMap<WEO_scenario, int[]>>(source.class);
                            source source2 = source.Total;
                            map2.put((sub_sector)enum_, enumMap2);
                        }
                        ++var18_54;
                    }
                    if (var15_33 == null) {
                        void var18_56;
                        enumArray = source.values();
                        n2 = enumArray.length;
                        boolean bl2 = false;
                        while (var18_56 < n2) {
                            enum_ = enumArray[var18_56];
                            if (string.equals(enum_.name())) {
                                Enum enum_2 = enum_;
                            }
                            ++var18_56;
                        }
                    }
                    if (var15_35 == null) {
                        report.deb("\n EnergyData can't process row: " + string + " of " + eregionArray);
                        continue;
                    }
                    enumMap = new EnumMap<WEO_scenario, int[]>(WEO_scenario.class);
                    enumMap2.put((source)var15_35, enumMap);
                    for (int i = 1; i < 14; ++i) {
                        nArray[i] = stringArray2[i].equals("-") ? 0 : Integer.parseInt(stringArray2[i]);
                    }
                    enumMap.put(WEO_scenario.history, new int[]{nArray[1], nArray[2], nArray[3]});
                    enumMap.put(WEO_scenario.New_Policies, new int[]{nArray[4], nArray[5], nArray[6], nArray[7]});
                    enumMap.put(WEO_scenario.Current_Policies, new int[]{nArray[8], nArray[9], nArray[10]});
                    enumMap.put(WEO_scenario.S450_Scenario, new int[]{nArray[11], nArray[12], nArray[13]});
                }
            }
            int n = 0;
            nArray = new int[16];
            source source2 = null;
            eregion enum_ = null;
            for (eregion[] eregionArray : invest_info_regions) {
                map2 = new EnumMap(sub_sector.class);
                map2.put(sub_sector.Capital_costs, new EnumMap(source.class));
                map2.put(sub_sector.O_and_M_costs, new EnumMap(source.class));
                regmap.get(eregionArray[0]).put(info_type.Invest_costs, map2);
                map2 = new EnumMap(sub_sector.class);
                map2.put(sub_sector.Efficiency_Generation, new EnumMap(source.class));
                map2.put(sub_sector.Capacity_Factor, new EnumMap(source.class));
                regmap.get(eregionArray[0]).put(info_type.Efficiency, map2);
            }
            stringArray = fileio.loadtab("data/energy/Investments.txt", "\t");
            boolean bl = false;
            block9: for (String[] stringArray2 : stringArray) {
                void var15_40;
                boolean bl3;
                block33: {
                    if (++n <= 3) continue;
                    string = stringArray2[0];
                    for (source source3 : source.values()) {
                        if (!string.equals(source3.toString())) continue;
                        source2 = source3;
                        continue block9;
                    }
                    if (string.startsWith("SWITCH")) {
                        bl3 = true;
                        continue;
                    }
                    for (eregion eregion2 : eregion.values()) {
                        if (!string.equals(eregion2.toString())) continue;
                        enum_ = eregion2;
                        break block33;
                    }
                    if (string.equals("Europe")) {
                        enum_ = eregion.European_Union;
                    } else if (string.equals("US")) {
                        enum_ = eregion.United_States;
                    } else {
                        report.deb("\n EnergyData can't process investments row: " + string + " of " + source2);
                        continue;
                    }
                }
                boolean bl4 = true;
                while (var15_40 < stringArray2.length) {
                    nArray[var15_40] = stringArray2[var15_40].equals("-") ? 0 : (stringArray2[var15_40].contains(".") ? 0 : Integer.parseInt(stringArray2[var15_40].replace("%", "")));
                    ++var15_40;
                }
                map2 = regmap.get(enum_).get((Object)info_type.Invest_costs);
                enumMap = new EnumMap(WEO_scenario.class);
                ((Map)map2.get(sub_sector.Capital_costs)).put(source2, enumMap);
                enumMap.put(WEO_scenario.history, new int[]{nArray[1]});
                enumMap.put(WEO_scenario.New_Policies, new int[]{nArray[2], nArray[3]});
                enumMap.put(WEO_scenario.S450_Scenario, new int[]{nArray[4], nArray[5]});
                enumMap = new EnumMap(WEO_scenario.class);
                ((Map)map2.get(sub_sector.O_and_M_costs)).put(source2, enumMap);
                enumMap.put(WEO_scenario.history, new int[]{nArray[6]});
                enumMap.put(WEO_scenario.New_Policies, new int[]{nArray[7], nArray[8]});
                enumMap.put(WEO_scenario.S450_Scenario, new int[]{nArray[9], nArray[10]});
                if (bl3 && nArray.length < 12) {
                    regmap.get(enum_).put(info_type.Efficiency, regmap.get(eregion.European_Union).get((Object)info_type.Efficiency));
                    continue;
                }
                map2 = regmap.get(enum_).get((Object)info_type.Efficiency);
                enumMap = new EnumMap(WEO_scenario.class);
                ((Map)map2.get(sub_sector.Efficiency_Generation)).put(source2, enumMap);
                enumMap.put(WEO_scenario.history, new int[]{nArray[11]});
                if (bl3) {
                    int[] nArray2;
                    enumMap = new EnumMap(WEO_scenario.class);
                    ((Map)map2.get(sub_sector.Capacity_Factor)).put(source2, enumMap);
                    enumMap.put(WEO_scenario.history, new int[]{nArray[12]});
                    if (stringArray2.length > 14) {
                        int[] nArray3 = new int[2];
                        nArray3[0] = nArray[13];
                        nArray2 = nArray3;
                        nArray3[1] = nArray[14];
                    } else {
                        int[] nArray4 = new int[2];
                        nArray4[0] = nArray[12];
                        nArray2 = nArray4;
                        nArray4[1] = nArray[12];
                    }
                    enumMap.put(WEO_scenario.New_Policies, nArray2);
                    continue;
                }
                ((Map)map2.get(sub_sector.Efficiency_Generation)).put(source2, enumMap);
                enumMap.put(WEO_scenario.New_Policies, new int[]{nArray[12], nArray[13]});
                enumMap.put(WEO_scenario.S450_Scenario, new int[]{nArray[14], nArray[15]});
            }
            stringArray = fileio.loadtab("data/energy/Renewable_Potentials.txt", "\t");
            n = 0;
            String[][] stringArray3 = null;
            float[] fArray = new float[12];
            String[][] stringArray4 = stringArray;
            int n3 = stringArray4.length;
            boolean bl5 = false;
            while (var15_42 < n3) {
                String[] stringArray5 = stringArray4[var15_42];
                ++n;
                if (stringArray5.length == 0) break;
                if (n != 1) {
                    if (n == 2) {
                        stringArray3 = new source[stringArray5.length / 2];
                        int n4 = 0;
                        for (String string2 : stringArray5) {
                            stringArray3[n4 / 2] = source.valueOf(string2.split("-")[0]);
                            ++n4;
                        }
                    } else {
                        void var18_62;
                        string = stringArray5[0];
                        for (int i = 1; i < stringArray5.length; ++i) {
                            fArray[i - 1] = Float.parseFloat(stringArray5[i]);
                        }
                        enum_ = eregion.valueOf(string);
                        EnumMap<source, float[]> enumMap3 = new EnumMap<source, float[]>(source.class);
                        potentialmap.put(enum_, enumMap3);
                        boolean bl6 = false;
                        while (var18_62 < stringArray3.length) {
                            enumMap3.put((source)stringArray3[var18_62], new float[]{fArray[var18_62 * 2], fArray[var18_62 * 2 + true]});
                            ++var18_62;
                        }
                    }
                }
                ++var15_42;
            }
        }
        catch (Exception exception) {
            report.deb("Error loading energy data: " + string + exception);
            exception.printStackTrace();
        }
        enerData.reporttime("finished load Energy Data");
        loadeddata = true;
    }

    static float calcemit(source source2) {
        return 0.001f * (source2 == source.Coal ? 1000.0f : (source2 == source.Oil ? 780.0f : (source2 == source.Gas ? 450.0f : (source2 == source.Biomass_and_waste ? 25.0f : (source2 == source.Nuclear ? 65.0f : (source2 == source.Geothermal ? 38.0f : (source2 == source.Hydro ? 10.0f : (source2 == source.Wind ? 10.0f : (source2 == source.Marine ? 10.0f : (source2 == source.Solar_PV ? 32.0f : (source2 == source.CSP ? 15.0f : 0.0f)))))))))));
    }

    static float fuelcost(source source2) {
        return 8760.0f * (source2 == source.Coal ? 0.017198548f : (source2 == source.Oil ? 0.04606408f : (source2 == source.Gas ? 0.026512437f : (source2 == source.Nuclear ? 0.015f : (source2 == source.Biomass_and_waste ? 0.02f : 0.0f)))));
    }

    static <T> T[] add(T[] TArray, T[] TArray2) {
        int n;
        Object[] objectArray = new Object[TArray.length + TArray2.length];
        for (n = 0; n < TArray.length; ++n) {
            objectArray[n] = TArray[n];
        }
        for (n = 0; n < TArray2.length; ++n) {
            objectArray[n + TArray.length] = TArray2[n];
        }
        return objectArray;
    }

    static {
        electricity_sources.addAll(thermal);
        primary = new source[]{source.Coal, source.Oil, source.Gas, source.Nuclear, source.Hydro, source.Biomass_and_waste, source.Other_renewables};
        secondary = new source[]{source.Electricity, source.Heat, source.Biofuels, source.Other_fuels};
        futscen = new WEO_scenario[]{WEO_scenario.Current_Policies, WEO_scenario.New_Policies, WEO_scenario.S450_Scenario};
        loadeddata = false;
        fixedcolors = false;
        changeplots = false;
        tots = new String[]{"Total", "TPED", "TFC"};
        oldmsg = "";
        regmap = new EnumMap<eregion, Map<info_type, Map<sub_sector, Map<source, Map<WEO_scenario, int[]>>>>>(eregion.class);
        potentialmap = new EnumMap<eregion, Map<source, float[]>>(eregion.class);
    }

    public static enum WEO_scenario implements hasColor
    {
        Current_Policies(colfont.dkred, 2020, 2030, 2035),
        New_Policies(colfont.blue, 2020, 2025, 2030, 2035),
        S450_Scenario(colfont.dkgreen, 2020, 2030, 2035),
        history(colfont.black, 1990, 2008, 2015);

        int[] years;
        Color color;

        private WEO_scenario(Color color, int ... nArray) {
            this.color = color;
            this.years = nArray;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        int i(int n) {
            for (int i = 0; i < this.years.length; ++i) {
                if (this.years[i] != n) continue;
                return i;
            }
            return -1;
        }
    }

    static enum source implements ismod
    {
        Total(colfont.black),
        Coal(colfont.dkgrey),
        Oil(colfont.brown),
        Gas(colfont.grey),
        Other_fuels(colfont.dkorange),
        Biomass_and_waste(colfont.dkgreen),
        Biofuels(colfont.dkgreen),
        Biomass(colfont.dkgreen),
        Nuclear(colfont.pink),
        Hydro(colfont.ltblue),
        Wind(colfont.ltgreen),
        Geothermal(colfont.red),
        Solar(colfont.yellow),
        Solar_PV(colfont.yellow),
        CSP(colfont.olive),
        Marine(colfont.dkblue),
        Other_renewables(colfont.cyan),
        Electricity(colfont.cream),
        Heat(colfont.orange),
        Coal_Subcritical,
        Coal_Supercritical,
        Coal_Ultrasupercritical,
        IGCC,
        CCGT,
        Gas_Turbine,
        CCGT_CHP,
        Fuel_Cell,
        Coal_Ultrasupercritical_CCS,
        IGCC_CCS,
        CCGT_CCS,
        Biomass_Power_Plant,
        Biogas_DG_Industry,
        Biomass_Cofiring,
        Biomass_CHP_Medium,
        Biomass_CHP_Small,
        Biomass_Waste_Incineration_CHP,
        Hydropower_Large_Scale,
        Hydropower_Small_Scale,
        Solar_Photovoltaics_Large_Scale,
        Solar_Photovoltaics_Buildings,
        Wind_Onshore,
        Wind_Offshore;

        Color color;

        private source(Color color) {
            this.color = color;
        }

        private source() {
            this.color = infob.rcol();
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    static enum service {
        Heat_Cool,
        Gadgets,
        Housing,
        Mobility,
        Food,
        Consumables;

    }

    static enum energy_intensive_product {
        Steel,
        Cement,
        Metals;

    }

    static enum sub_sector implements ismod
    {
        TPED(colfont.dkorange),
        TFC(colfont.dkred),
        Total_generation(colfont.dkgrey),
        Total_capacity(colfont.dkgrey),
        Total_CO2(colfont.black),
        Power_generation(colfont.dkgrey),
        Other_energy_sector(colfont.dkblue),
        Industry(colfont.brown),
        Transport(colfont.red),
        Buildings(colfont.dkgreen),
        Other(colfont.purple),
        Capital_costs,
        O_and_M_costs,
        Efficiency_Generation,
        Capacity_Factor;

        Color color;

        private sub_sector(Color color) {
            this.color = color;
        }

        private sub_sector() {
            this.color = infob.rcol();
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    static enum info_type {
        Energy_Demand("mega&ton&oil_equivalent"),
        Electricity_Generation("tera&watt&hours"),
        Electrical_capacity("giga&watt"),
        CO2_emissions("mega&ton&CO2"),
        Invest_costs("dollar&(2009)&per&kilo&watt"),
        Efficiency("%");

        String units;

        private info_type(String string2) {
            this.units = string2;
        }
    }

    static enum eregion implements hasColor
    {
        World(new Object[0]),
        Brazil(new Object[0]),
        Latin_America(new Object[0]),
        Africa(new Object[0]),
        Middle_East(colfont.grey, "MEA"),
        India(new Object[0]),
        China(new Object[0]),
        Non_OECD_Asia(new Object[0]),
        Russia(new Object[0]),
        Caspian(colfont.cream, "STA"),
        East_Europe_Eurasia(new Object[0]),
        Japan(new Object[0]),
        OECD_Pacific(new Object[0]),
        European_Union(colfont.orange, "EU27"),
        OECD_Europe(new Object[0]),
        United_States(new Object[0]),
        OECD_North_America(new Object[0]),
        Other_Latin_America(colfont.dkgreen, "IEAOLA"),
        Other_Asia(colfont.ltblue, "IEAOA"),
        Other_East_Europe(colfont.dkorange, "IEAOEE"),
        Aust_NewZ_Korea(colfont.pink, "IEAANK"),
        Other_OECD_Europe(colfont.yellow, "EUO"),
        Canada_Mexico(colfont.purple, "IEACAMX"),
        International_Bunkers(colfont.dkgrey);

        Color color;
        region jcmreg;

        private eregion(Object ... objectArray) {
            String string2 = this.toString().replace("_", " ");
            for (Object object : objectArray) {
                if (object instanceof String) {
                    string2 = (String)object;
                }
                if (!(object instanceof Color)) continue;
                this.color = (Color)object;
            }
            this.jcmreg = regman.allreg.findreg(string2);
            if (this.color == null) {
                this.color = this.jcmreg != null ? this.jcmreg.color : infob.rcol();
            }
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    static interface ismod
    extends hasColor {
    }
}

