/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.energy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jcm.core.cur.curveset;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.mod.energy.enerData;
import jcm.mod.energy.enerGeneral;

public class electricity
extends module {
    public curveset electric_capacity = new curveset("generation_capacity", "giga&Watt", 2010, 2050);
    public curveset electric_production = new curveset("electricity_production", "tera&Watt_hours", 2010, 2050);
    public curveset electric_CO2 = new curveset("CO2_electricity", "mega&ton&CO2", 2010, 2050);
    public curveset totcostplot = new curveset("costs_electricity", "mega&dollar", 2010, 2050);
    public param depreciation = new param("depreciation", "%", 4, 0, 10);
    public param lifetime = new param("lifetime", "years", 40, 0, 80);
    public param maxexpsec = new param("max_expand_sector", "%", 20, 0, 100);
    public param maxexptot = new param("max_expand_total", "%", 20, 0, 100);
    public param appeffgeo = new param("apply efficiency geothermal", true);
    public param method = new param(new Object[]{"Algorithm", methods.values(), methods.price_driven});
    public param usetechpot = new param(new Object[]{"renewable Technical Potentials", techpotopts.values(), techpotopts.midtp});
    static float convcapgen = 8.76f;
    static float convMtoe_to_TWh = 11.84f;
    static float gwyrtoexaj = 0.031536f;
    public Map<enerData.eregion, elecsec> rmap = new EnumMap<enerData.eregion, elecsec>(enerData.eregion.class);
    enerGeneral ea;

    @Override
    public void initsetup() {
        this.ea = this.gm(enerGeneral.class);
        this.follows(this.ea);
        for (enerData.eregion eregion2 : enerData.modelregions) {
            this.rmap.put(eregion2, new elecsec(eregion2));
        }
    }

    void calcworld() {
        for (enerData.source source2 : enerData.electricity_sources) {
            mod mod2 = this.rmap.get((Object)enerData.eregion.World).elec_map.get(source2);
            mod2.capacity = 0.0f;
            mod2.supply = 0.0f;
            mod2.co2emit = 0.0f;
            mod2.totcostnet = 0.0f;
            for (enerData.eregion eregion2 : enerData.modelregions) {
                if (eregion2 == enerData.eregion.World) continue;
                mod mod3 = this.rmap.get((Object)eregion2).elec_map.get(source2);
                mod2.capacity += mod3.capacity * mod3.capfac;
                mod2.supply += mod3.supply;
                mod2.co2emit += mod3.co2emit;
                mod2.totcostnet += mod3.totcostnet;
            }
        }
    }

    void fillplots() {
        for (mod mod2 : this.rmap.get(this.ea.ch_reg.chosen).elec_suppliers) {
            this.electric_capacity.set(mod2.name, year, mod2.capacity * (this.ea.ch_reg.chosen == enerData.eregion.World ? 1.0f : mod2.capfac));
            this.electric_production.set(mod2.name, year, mod2.supply);
            this.electric_CO2.set(mod2.name, year, mod2.co2emit);
            this.totcostplot.set(mod2.name, year, mod2.totcostnet);
        }
    }

    class mod {
        enerData.ismod name;
        boolean renewable;
        boolean available;
        float capacity;
        float capfac;
        float efficiency;
        float supply;
        float demand;
        float fuelcost;
        float opcost;
        float runcostgross;
        float runcostnet;
        float invcost;
        float totinvcost;
        float totcostnet;
        float emit_kgperkwh;
        float co2emit;
        float tphi = 0.0f;
        float tplo = 0.0f;
        float invcostold;
        float invcostrate;

        mod(enerData.ismod ismod2) {
            this.name = ismod2;
            for (enerData.source source2 : enerData.renewables) {
                if (source2 != this.name) continue;
                this.renewable = true;
            }
        }

        void calccosts() {
            enerData.source source2 = (enerData.source)this.name;
            this.emit_kgperkwh = enerData.calcemit(source2);
            this.fuelcost = electricity.this.ea.fu.fuelprice(source2, loopcalc.year);
            this.totcostnet = 0.0f;
            if (loopcalc.year <= 2035) {
                block13: {
                    this.opcost = 0.0f;
                    this.invcost = 0.0f;
                    this.capfac = 0.0f;
                    this.efficiency = 0.0f;
                    if (source2 == enerData.source.Oil) {
                        source2 = enerData.source.Gas;
                    }
                    for (enerData.source[] sourceArray : enerData.invsources) {
                        int n;
                        if (source2 != sourceArray[0]) continue;
                        for (n = 1; n < sourceArray.length; ++n) {
                            this.opcost += (float)electricity.this.ea.data(new Object[]{enerData.info_type.Invest_costs, enerData.sub_sector.O_and_M_costs, sourceArray[n]});
                            this.invcost += (float)electricity.this.ea.data(new Object[]{enerData.info_type.Invest_costs, enerData.sub_sector.Capital_costs, sourceArray[n]});
                            if (this.renewable) {
                                this.capfac += (float)electricity.this.ea.data(new Object[]{enerData.info_type.Efficiency, enerData.sub_sector.Capacity_Factor, sourceArray[n]});
                            }
                            this.efficiency += (float)electricity.this.ea.data(new Object[]{enerData.info_type.Efficiency, enerData.sub_sector.Efficiency_Generation, sourceArray[n]});
                        }
                        n = sourceArray.length - 1;
                        this.opcost /= (float)n;
                        this.invcost /= (float)n;
                        this.capfac /= (float)n;
                        this.efficiency /= (float)n;
                        break block13;
                    }
                    this.opcost = electricity.this.ea.data(new Object[]{enerData.info_type.Invest_costs, enerData.sub_sector.O_and_M_costs, source2});
                    this.invcost = electricity.this.ea.data(new Object[]{enerData.info_type.Invest_costs, enerData.sub_sector.Capital_costs, source2});
                    if (this.renewable) {
                        this.capfac += (float)electricity.this.ea.data(new Object[]{enerData.info_type.Efficiency, enerData.sub_sector.Capacity_Factor, source2});
                    }
                    this.efficiency += (float)electricity.this.ea.data(new Object[]{enerData.info_type.Efficiency, enerData.sub_sector.Efficiency_Generation, source2});
                }
                this.efficiency /= 100.0f;
                this.capfac /= 100.0f;
                if (electricity.this.appeffgeo.istrue() && (source2 == enerData.source.Geothermal || source2 == enerData.source.CSP)) {
                    this.capfac *= this.efficiency;
                }
            }
            if (electricity.this.usetechpot.chosen != techpotopts.ignoretp && this.tphi > 0.0f) {
                float f = electricity.this.usetechpot.chosen == techpotopts.hightp ? this.tphi : (electricity.this.usetechpot.chosen == techpotopts.midtp ? (this.tphi + this.tplo * 2.0f) / 3.0f : this.tplo);
                float f2 = f / (f - this.capacity * gwyrtoexaj);
                if (f2 < 0.0f) {
                    f2 = Float.POSITIVE_INFINITY;
                }
                this.invcost *= f2;
            }
            if (loopcalc.year == 2020) {
                this.invcostold = this.invcost;
            }
            if (loopcalc.year == 2035) {
                this.invcostrate = (this.invcost - this.invcostold) / 15.0f;
                this.invcostold = this.invcost;
            }
            if (loopcalc.year > 2035) {
                this.invcost = this.invcostold + this.invcostrate * (float)(loopcalc.year - 2035);
            }
            if (!this.renewable) {
                this.capfac = 0.85f;
            }
            this.runcostnet = (this.fuelcost / this.efficiency + this.opcost) / this.capfac;
            this.runcostgross = this.runcostnet + (float)electricity.this.ea.carbonprice.getval() * this.emit_kgperkwh * 8.76f;
            this.available = !Float.isNaN(this.runcostgross) && !Float.isInfinite(this.runcostgross);
        }
    }

    class elecsec {
        List<mod> elec_suppliers = new ArrayList<mod>();
        Map<enerData.source, mod> elec_map = new EnumMap<enerData.source, mod>(enerData.source.class);
        mod tot_elec = new mod(enerData.source.Electricity);
        enerData.eregion myreg;
        enerGeneral.ensec en;
        float demorig;
        float demandpergdp;
        float intfac;
        float gap;
        mod me;
        Comparator inv_cost = new Comparator<mod>(){

            @Override
            public int compare(mod mod2, mod mod3) {
                return (int)(mod2.totinvcost - mod3.totinvcost);
            }
        };
        Comparator run_cost = new Comparator<mod>(){

            @Override
            public int compare(mod mod2, mod mod3) {
                return (int)(mod2.runcostgross - mod3.runcostgross);
            }
        };

        elecsec(enerData.eregion eregion2) {
            this.myreg = eregion2;
            for (enerData.source source2 : enerData.electricity_sources) {
                mod mod2 = new mod(source2);
                this.elec_suppliers.add(mod2);
                this.elec_map.put(source2, mod2);
            }
        }

        void init() {
            this.en = electricity.this.ea.enmap.get(this.myreg);
            for (mod mod2 : this.elec_suppliers) {
                electricity.this.ea.data(mod2.name);
                mod2.capacity = electricity.this.ea.data(new Object[]{enerData.info_type.Electrical_capacity, enerData.sub_sector.Total_capacity, mod2.name});
                mod2.supply = electricity.this.ea.data(new Object[]{enerData.info_type.Electricity_Generation, enerData.sub_sector.Total_generation, mod2.name});
            }
        }

        void adjust() {
            this.intfac = (1.0f - (float)Math.exp((double)(-this.en.disco) * electricity.this.lifetime.getval())) / this.en.disco;
            this.setdemand();
            for (mod mod2 : this.elec_suppliers) {
                mod2.capacity = (float)((double)mod2.capacity * ((100.0 - electricity.this.depreciation.getval()) / 100.0));
            }
            for (mod mod2 : this.elec_suppliers) {
                mod2.calccosts();
                mod2.totinvcost = mod2.invcost / mod2.capfac + mod2.runcostgross * this.intfac;
            }
            this.supply();
            this.invest();
        }

        void setdemand() {
            if (loopcalc.year <= 2035) {
                this.tot_elec.demand = convMtoe_to_TWh * (float)(electricity.this.ea.data(new Object[]{enerData.info_type.Energy_Demand, enerData.sub_sector.Other_energy_sector, enerData.source.Electricity}) + electricity.this.ea.data(new Object[]{enerData.info_type.Energy_Demand, enerData.sub_sector.TFC, enerData.source.Electricity}));
            }
            if (loopcalc.year > 2035) {
                this.tot_elec.demand += this.demandpergdp * (this.en.gdp - this.en.gdpold);
            }
            if (loopcalc.year == 2020) {
                this.demorig = this.tot_elec.demand;
            }
            if (loopcalc.year == 2035) {
                this.demandpergdp = (this.tot_elec.demand - this.demorig) / (this.en.gdp - this.en.gdporig);
            }
        }

        void supply() {
            Collections.sort(this.elec_suppliers, this.run_cost);
            this.tot_elec.supply = 0.0f;
            this.gap = 0.0f;
            this.me = null;
            for (mod mod2 : this.elec_suppliers) {
                mod2.supply = 0.0f;
            }
            for (mod mod2 : this.elec_suppliers) {
                this.gap = this.tot_elec.demand - this.tot_elec.supply;
                if (this.gap <= 0.0f) break;
                if (!mod2.available) continue;
                mod2.supply = Math.min(this.gap, mod2.capacity * mod2.capfac * convcapgen);
                mod2.totcostnet = mod2.runcostnet * mod2.supply / convcapgen;
                this.me = mod2;
                this.tot_elec.supply += mod2.supply;
            }
        }

        void invest() {
            this.tot_elec.capacity = 0.0f;
            for (mod mod2 : this.elec_suppliers) {
                this.tot_elec.capacity += mod2.capacity;
            }
            float f = this.tot_elec.capacity / 50.0f;
            float f2 = this.tot_elec.capacity * (float)electricity.this.maxexptot.getval() / 100.0f;
            Collections.sort(this.elec_suppliers, this.inv_cost);
            if (electricity.this.method.chosen == methods.price_driven) {
                float f3 = 0.5f;
                float f4 = this.me.runcostgross + (this.gap <= 0.0f ? 0.0f : this.me.runcostgross * this.gap / (this.tot_elec.demand * (float)electricity.this.ea.demelasticity.getval()));
                for (mod mod3 : this.elec_suppliers) {
                    if (mod3.totinvcost > f4 * this.intfac) break;
                    if (!mod3.available || mod3.capfac <= 0.0f) continue;
                    float f5 = Math.min((f + mod3.capacity) * convcapgen * mod3.capfac * (float)electricity.this.maxexpsec.getval() / 100.0f, f2);
                    float f6 = f5 / convcapgen / mod3.capfac;
                    mod3.capacity += f6;
                    f2 -= f6;
                    mod3.totcostnet += mod3.invcost * f6;
                }
            }
            if (electricity.this.method.chosen == methods.meet_demand || electricity.this.method.chosen == methods.surplus) {
                int n = 0;
                while (n < this.elec_suppliers.size()) {
                    mod mod4 = this.elec_suppliers.get(n);
                    if (!mod4.available) {
                        ++n;
                        continue;
                    }
                    if (electricity.this.method.chosen == methods.meet_demand && this.gap <= 0.0f || electricity.this.method.chosen == methods.surplus && this.gap <= 0.0f && mod4.totinvcost >= this.me.runcostgross * this.intfac) break;
                    float f7 = Math.min((f + mod4.capacity) * convcapgen * mod4.capfac * (float)electricity.this.maxexpsec.getval() / 100.0f, electricity.this.method.chosen == methods.surplus ? f2 : this.gap);
                    float f8 = f7 / convcapgen / mod4.capfac;
                    mod4.capacity += f8;
                    f2 -= f8;
                    mod4.totcostnet += mod4.invcost * f8;
                    if (this.gap > 0.0f) {
                        mod4.supply += f7;
                        this.gap -= f7;
                        mod4.totcostnet += mod4.runcostnet * f7 / convcapgen;
                    }
                    ++n;
                }
            }
            for (mod mod5 : this.elec_suppliers) {
                mod5.co2emit = mod5.supply * mod5.emit_kgperkwh;
            }
        }

        void gettp(enerData.eregion eregion2) {
            for (enerData.source source2 : new enerData.source[]{enerData.source.Biofuels, enerData.source.Hydro, enerData.source.Wind, enerData.source.Solar, enerData.source.Marine, enerData.source.Geothermal}) {
                enerData.source source3 = source2 == enerData.source.Solar ? enerData.source.Solar_PV : (source2 == enerData.source.Biofuels ? enerData.source.Biomass_and_waste : source2);
                this.elec_map.get((Object)source3).tplo = enerData.gettechpot(eregion2, source2, 0);
                this.elec_map.get((Object)source3).tphi = enerData.gettechpot(eregion2, source2, 1);
            }
        }
    }

    static enum demandopts {

    }

    static enum techpotopts {
        ignoretp,
        hightp,
        midtp,
        lowtp;

    }

    static enum methods {
        meet_demand,
        price_driven,
        surplus;

    }
}

