/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.awt.Color;
import java.util.EnumMap;
import java.util.EnumSet;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;

public class udebclimod
extends module {
    static cp[] ar4p = new cp[]{cp.rfco2double, cp.climsens_effective, cp.climsens_gcm, cp.transientclimateresponse, cp.heatdiffusivity, cp.landoceantempratio};
    static cp[] tarp = new cp[]{cp.rfco2double, cp.climsens, cp.heatdiffusivity, cp.landoceantempratio, cp.zeroupwelltemp, cp.knorthsouth, cp.klandocean};
    static cp[] sarp = new cp[]{cp.rfco2double, cp.climsens, cp.heatdiffusivity, cp.landoceantempratio, cp.zeroupwelltemp, cp.knorthsouth, cp.klandocean, cp.mixlaydepth, cp.polarsinktempratio, cp.seaice};
    EnumMap<cp, param> gp = new EnumMap(cp.class);
    public param<gcmset> climodtype = new param(new Object[]{"climodtype", gcmset.values(), gcmset.all_GCMs}){

        @Override
        public void precalc() {
            udebclimod.this.climod.setlist((gcm[])((gcmset)((Object)this.chosen)).gcmlist());
        }
    };
    public param<gcm> climod;
    public param varupwell;
    public param<csopts> csopt;
    public static final int nhl = 39;
    public static final int nhb = 40;
    public double[][] hiq;
    public double[][] hiqi;
    public double[][] hiq99;
    public double[][] hpropf;
    public double[][] hrML;
    public double[][] shicML;
    public double[][] rhicML;
    public double[][] hrsl;
    public double[] frac;
    double fracl;
    double fraco;
    double[][] khi;
    double[] khir;
    public double tstart;
    public double kls;
    public double kos;
    public double klo;
    public double kns;
    public double nstd;
    public double nstdold;
    public double dqin;
    public double qpt;
    public double sl;
    public double cice;
    double[] qin;
    double[] qinbase;
    double[] qinold;
    double[] qinold99;
    double[] mlt;
    public double[] spaceflux;
    double totrf99;
    double nstd99;
    double nstdold99;
    double dt;
    double hu;
    double pi;
    double diffu;
    double dml;
    double rvu;
    double rv;
    double rjff;
    double polsink;
    double mlbaserate;
    double hiquc;
    double reftemp;
    double[] dl;
    double[] vec;
    double[][] rate;
    public double[][] hiqstart;
    Matrix M;
    Matrix U;
    Matrix[] MV;
    Matrix[] MVI;
    double[][][] upwellstep;
    int startyear;
    int tstep;
    double guess;
    double nit;
    double ciqr;
    double diff;
    public double sealevteinit;

    public udebclimod() {
        this.climod = new param(new Object[]{"climodmenu", ((gcmset)((Object)this.climodtype.chosen)).gcmlist(), gcm.AR4_average, complexity.simplest}){

            @Override
            public void precalc() {
                gcm gcm2 = (gcm)((Object)this.chosen);
                for (cp cp2 : cp.values()) {
                    if (cp2 == cp.climsens) continue;
                    udebclimod.this.gp.get((Object)cp2).putval(gcm2.val.containsKey((Object)cp2) ? gcm2.val.get((Object)cp2) : cp2.def);
                }
                if (udebclimod.this.csopt.chosen == csopts.user_cs) {
                    // empty if block
                }
                if (udebclimod.this.csopt.chosen == csopts.use_effective_cs && gcm2.val.containsKey((Object)cp.climsens_effective)) {
                    udebclimod.this.gp.get((Object)cp.climsens).putval(gcm2.val.get((Object)cp.climsens_effective));
                }
                if (udebclimod.this.csopt.chosen == csopts.use_gcm_cs && gcm2.val.containsKey((Object)cp.climsens_gcm)) {
                    udebclimod.this.gp.get((Object)cp.climsens).putval(gcm2.val.get((Object)cp.climsens_gcm));
                }
                if ((udebclimod.this.csopt.chosen == csopts.use_gcm_cs || udebclimod.this.csopt.chosen == csopts.use_effective_cs) && gcm2.val.containsKey((Object)cp.climsens)) {
                    udebclimod.this.gp.get((Object)cp.climsens).putval(gcm2.val.get((Object)cp.climsens));
                }
                udebclimod.this.setupfluxes();
                udebclimod.this.gm(sealevel.class).seticecaptomod((gcm)((Object)this.chosen));
            }
        };
        this.varupwell = new param(new Object[]{"tufbopt", true, colfont.magenta, complexity.expert});
        this.csopt = new param(new Object[]{"cs_source", csopts.values(), csopts.user_cs, colfont.dkred, complexity.expert}){

            @Override
            public void precalc() {
                udebclimod.this.climod.precalc();
            }
        };
        this.hiq = this.hbox();
        this.hiqi = this.hbox();
        this.hiq99 = this.hbox();
        this.hpropf = this.hbox();
        this.hrML = this.hbox();
        this.shicML = this.hbox();
        this.rhicML = this.hbox();
        this.hrsl = this.hbox();
        this.frac = new double[]{0.199, 0.301, 0.406, 0.094};
        this.fracl = this.frac[0] + this.frac[3];
        this.fraco = 1.0 - this.fracl;
        this.khi = new double[4][4];
        this.khir = new double[4];
        this.tstart = 18.17;
        this.qin = new double[2];
        this.qinbase = new double[2];
        this.qinold = new double[2];
        this.qinold99 = new double[2];
        this.mlt = new double[2];
        this.spaceflux = new double[2];
        this.reftemp = 0.0;
        this.hiqstart = new double[2][40];
        this.MV = new Matrix[2];
        this.MVI = new Matrix[2];
        this.upwellstep = new double[2][40][40];
    }

    @Override
    public void initsetup() {
        this.makeparams();
        this.gp.get((Object)cp.rfco2double).setaffects(this.gm(radfor.class));
    }

    @Override
    public void setinteractions() {
        this.setaffectedby((interacob)this.gp.get((Object)cp.zeroupwelltemp), this.varupwell.istrue());
        this.setaffectedby((interacob)this.gp.get((Object)cp.upwellreducefrac), this.varupwell.istrue());
        this.setaffectedby((interacob)this.gp.get((Object)cp.upwellbaserate), this.varupwell.istrue());
    }

    public double val(cp cp2) {
        return this.gp.get((Object)cp2).getval();
    }

    void test() {
        udebclimod udebclimod2 = this.gm(udebclimod.class);
    }

    void makeparams() {
        gcm gcm2 = (gcm)((Object)this.climod.chosen);
        for (cp cp2 : cp.values()) {
            param param2 = new param(new Object[]{cp2.lab, cp2.units, gcm2.val.containsKey((Object)cp2) ? gcm2.val.get((Object)cp2) : Double.valueOf(cp2.def), cp2.min, cp2.max, cp2.co, cp2.cx});
            this.gp.put(cp2, param2);
            param2.priority -= 0.2;
            this.allparam.add(param2);
            param2.setaffects(this);
            param2.owner = this;
            this.addOb(param2);
            param2.setaffectedby(this.climod);
        }
    }

    @Override
    public void precalc() {
        if (!this.climod.changed) {
            this.setupfluxes();
        }
    }

    double[][] hbox() {
        return new double[2][40];
    }

    public void setupfluxes() {
        int n;
        int n2;
        int n3;
        double d;
        this.dt = 1.0;
        this.dml = this.val(cp.mixlaydepth);
        this.dl = new double[39];
        for (int i = 0; i < 39; ++i) {
            this.dl[i] = (i < 20 ? 49.0 : 196.0) * 0.8717948717948718;
        }
        this.diffu = this.val(cp.heatdiffusivity) * 3.1536E7 / 10000.0;
        this.hu = this.val(cp.upwellbaserate);
        this.pi = this.val(cp.polarsinktempratio);
        double d2 = 0.1300101471334348;
        this.qpt = d2 * this.dml;
        this.klo = this.val(cp.klandocean);
        this.kns = this.val(cp.knorthsouth);
        double d3 = this.val(cp.landoceantempratio);
        this.cice = this.val(cp.seaice);
        double d4 = 1.0;
        double d5 = -99.0;
        this.kos = 0.9;
        do {
            this.kls = this.val(cp.rfco2double) / this.val(cp.climsens) * (d3 * this.fracl + this.fraco) / (d3 * this.fracl) - this.kos * this.fraco / (d3 * this.fracl);
            this.khi = new Matrix(new double[][]{{this.frac[0] * this.kls + this.klo, -this.klo, 0.0, 0.0}, {-this.klo, this.frac[1] * this.kos + this.klo + this.kns, -this.kns, 0.0}, {0.0, -this.kns, this.frac[2] * this.kos + this.klo + this.kns, -this.klo}, {0.0, 0.0, -this.klo, this.frac[3] * this.kls + this.klo}}, 4, 4).inverse().getArray();
            for (n3 = 0; n3 < 4; ++n3) {
                this.khir[n3] = 0.0;
                for (n2 = 0; n2 < 4; ++n2) {
                    double[] dArray = this.khi[n3];
                    int n4 = n2;
                    dArray[n4] = dArray[n4] * this.frac[n2];
                    int n5 = n3;
                    this.khir[n5] = this.khir[n5] + this.khi[n3][n2];
                }
            }
            d = (this.frac[0] * this.khir[0] + this.frac[3] * this.khir[3]) / this.fracl / ((this.frac[1] * this.khir[1] + this.frac[2] * this.khir[2]) / this.fraco);
            double d6 = d5 == -99.0 ? 1.0 : this.kos + (d3 - d) * (this.kos - d5) / (d - d4);
            d5 = this.kos;
            this.kos = d6;
            d4 = d;
        } while (Math.abs(d3 - d) > 1.0E-4);
        this.rate = new double[40][40];
        for (n3 = 0; n3 < 40; ++n3) {
            for (n2 = 0; n2 < 40; ++n2) {
                this.rate[n3][n2] = 0.0;
            }
        }
        n3 = 1;
        while (n3 < 39) {
            this.rvu = (2.0 * this.diffu - this.hu * this.dl[n3]) / (this.dl[n3 - 1] * (this.dl[n3 - 1] + this.dl[n3]));
            this.rv = (2.0 * this.diffu + this.hu * this.dl[n3 - 1]) / (this.dl[n3] * (this.dl[n3 - 1] + this.dl[n3]));
            double[] dArray = this.rate[n3];
            int n6 = n3 - 1;
            dArray[n6] = dArray[n6] + this.rvu;
            double[] dArray2 = this.rate[n3 - 1];
            int n7 = n3 - 1;
            dArray2[n7] = dArray2[n7] - this.rvu;
            double[] dArray3 = this.rate[n3 - 1];
            int n8 = n3;
            dArray3[n8] = dArray3[n8] + this.rv;
            double[] dArray4 = this.rate[n3];
            int n9 = n3++;
            dArray4[n9] = dArray4[n9] - this.rv;
        }
        this.rvu = 8.0 * this.diffu / (3.0 * this.dl[0] * this.dml) - this.hu / this.dml;
        this.rv = 3.0 * this.diffu / (this.dl[0] * this.dl[0]);
        this.rjff = this.diffu / (3.0 * this.dl[0] * this.dl[0]);
        double[] dArray = this.rate[0];
        dArray[39] = dArray[39] + this.rvu;
        double[] dArray5 = this.rate[39];
        dArray5[39] = dArray5[39] - this.rvu;
        double[] dArray6 = this.rate[39];
        dArray6[0] = dArray6[0] + this.rv;
        double[] dArray7 = this.rate[0];
        dArray7[0] = dArray7[0] - this.rv;
        double[] dArray8 = this.rate[0];
        dArray8[1] = dArray8[1] + this.rjff;
        double[] dArray9 = this.rate[39];
        dArray9[1] = dArray9[1] - this.rjff;
        this.polsink = this.pi * this.hu / this.dml;
        double[] dArray10 = this.rate[38];
        dArray10[39] = dArray10[39] + this.polsink;
        double[] dArray11 = this.rate[39];
        dArray11[39] = dArray11[39] - this.polsink;
        this.mlbaserate = this.rate[39][39];
        this.M = new Matrix(this.rate, 40, 40);
        if (this.varupwell.istrue()) {
            double[][] dArray12 = new double[40][40];
            for (n2 = 0; n2 < 40; ++n2) {
                for (int i = 0; i < 40; ++i) {
                    dArray12[n2][i] = 0.0;
                }
            }
            n2 = 1;
            while (n2 < 39) {
                this.rvu = -this.hu * this.dl[n2] / (this.dl[n2 - 1] * (this.dl[n2 - 1] + this.dl[n2]));
                this.rv = this.hu * this.dl[n2 - 1] / (this.dl[n2] * (this.dl[n2 - 1] + this.dl[n2]));
                double[] dArray13 = dArray12[n2];
                int n10 = n2 - 1;
                dArray13[n10] = dArray13[n10] + this.rvu;
                double[] dArray14 = dArray12[n2 - 1];
                int n11 = n2 - 1;
                dArray14[n11] = dArray14[n11] - this.rvu;
                double[] dArray15 = dArray12[n2 - 1];
                int n12 = n2;
                dArray15[n12] = dArray15[n12] + this.rv;
                double[] dArray16 = dArray12[n2];
                int n13 = n2++;
                dArray16[n13] = dArray16[n13] - this.rv;
            }
            this.rvu = -this.hu / this.dml;
            double[] dArray17 = dArray12[0];
            dArray17[39] = dArray17[39] + this.rvu;
            double[] dArray18 = dArray12[39];
            dArray18[39] = dArray18[39] - this.rvu;
            this.polsink = this.pi * this.hu / this.dml;
            double[] dArray19 = dArray12[38];
            dArray19[39] = dArray19[39] + this.polsink;
            double[] dArray20 = dArray12[39];
            dArray20[39] = dArray20[39] - this.polsink;
            this.U = new Matrix(dArray12, 40, 40);
        }
        double d7 = this.tstart * this.qpt;
        Matrix matrix = this.M.getMatrix(0, 38, 0, 38).inverse().times(this.M.getMatrix(0, 38, 39, 39)).times(-d7);
        double[] dArray21 = matrix.transpose().getArray()[0];
        double[] dArray22 = new double[40];
        dArray22[39] = this.tstart;
        for (int i = 0; i < 39; ++i) {
            dArray22[i] = dArray21[i] / (d2 * this.dl[i]);
        }
        double[] dArray23 = new double[40];
        double d8 = 5071.5;
        dArray23[39] = 101325.0 + d8 * this.dml;
        dArray23[0] = dArray23[39] + d8 * (this.dml + this.dl[0]);
        for (n = 1; n < 39; ++n) {
            dArray23[n] = dArray23[n - 1] + d8 * (this.dl[n - 1] + this.dl[n]);
        }
        this.vec = new double[40];
        for (n = 0; n < 40; ++n) {
            this.vec[n] = 1.0 / d2 * (1.0E-4 * (0.5 + 0.12 * dArray22[n] - 8.0E-4 * dArray22[n] * dArray22[n] + 2.8 * (1.0 - 0.027 * dArray22[n]) * (dArray23[n] * 1.0E-8 - 0.24 * dArray23[n] * dArray23[n] * 1.0E-16)));
        }
        double[] dArray24 = new double[40];
        double[] dArray25 = new double[40];
        double[] dArray26 = new double[40];
        double[] dArray27 = new double[40];
        for (int i = 0; i < 2; ++i) {
            int n14;
            int n15;
            this.spaceflux[i] = 1.0 / this.qpt * this.cice * (this.kos + this.klo / this.frac[i + 1] * (this.kls * this.frac[i * 3] / (this.kls * this.frac[i * 3] + this.klo)));
            this.M.set(39, 39, this.mlbaserate - this.spaceflux[i]);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(this.M);
            this.MV[i] = eigenvalueDecomposition.getV();
            this.MVI[i] = this.MV[i].inverse();
            for (n15 = 0; n15 < 40; ++n15) {
                this.hiqstart[i][n15] = 0.0;
                for (n14 = 0; n14 < 40; ++n14) {
                    double[] dArray28 = this.hiqstart[i];
                    int n16 = n15;
                    dArray28[n16] = dArray28[n16] + this.MVI[i].getArray()[n15][n14] * (n14 < 39 ? dArray21[n14] : d7);
                }
            }
            dArray24 = eigenvalueDecomposition.getRealEigenvalues();
            for (n15 = 0; n15 < 40; ++n15) {
                this.hpropf[i][n15] = Math.exp(dArray24[n15] * this.dt);
                if (Math.abs(dArray24[n15]) < 1.0E-6) {
                    dArray25[n15] = this.dt;
                    dArray26[n15] = this.dt / 2.0;
                    continue;
                }
                dArray25[n15] = (this.hpropf[i][n15] - 1.0) / dArray24[n15];
                dArray26[n15] = (dArray25[n15] - this.dt) / (dArray24[n15] * this.dt);
            }
            this.hrML[i] = this.MV[i].getArray()[39];
            dArray27 = this.MVI[i].transpose().getArray()[39];
            for (n15 = 0; n15 < 40; ++n15) {
                this.rhicML[i][n15] = dArray26[n15] * dArray27[n15];
                this.shicML[i][n15] = dArray25[n15] * dArray27[n15];
            }
            n15 = 0;
            while (n15 < 40) {
                for (n14 = 1; n14 < 40; ++n14) {
                    double[] dArray29 = this.hrsl[i];
                    int n17 = n15;
                    dArray29[n17] = dArray29[n17] + this.MV[i].getArray()[n14][n15];
                }
                double[] dArray30 = this.hrsl[i];
                int n18 = n15;
                dArray30[n18] = dArray30[n18] * this.vec[n15];
                double[] dArray31 = this.hrsl[i];
                int n19 = n15++;
                dArray31[n19] = dArray31[n19] * (this.frac[i + 1] / (this.frac[1] + this.frac[2]));
            }
            if (!this.varupwell.istrue()) continue;
            this.upwellstep[i] = this.MVI[i].times(this.U.times(this.MV[i])).getArray();
            for (n15 = 0; n15 < 40; ++n15) {
                for (n14 = 0; n14 < 40; ++n14) {
                    double[] dArray32 = this.upwellstep[i][n15];
                    int n20 = n14;
                    dArray32[n20] = dArray32[n20] * (dArray25[n14] / this.val(cp.zeroupwelltemp));
                }
            }
        }
        dArray24 = null;
        dArray26 = null;
        dArray25 = null;
        dArray27 = null;
    }

    @Override
    public void startstate(int n) {
        this.startyear = n;
        if (n == 1750) {
            this.nstd = 0.0;
            this.nstdold = 0.0;
            for (int i = 0; i < 2; ++i) {
                this.qinold[i] = this.spaceflux[i] * this.qpt * this.tstart;
                for (int j = 0; j < 40; ++j) {
                    this.hiq[i][j] = this.hiqstart[i][j];
                }
            }
        } else {
            n = 2000;
            this.nstd = this.nstd99;
            this.nstdold = this.nstdold99;
            this.qinold[0] = this.qinold99[0];
            this.qinold[1] = this.qinold99[1];
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 40; ++j) {
                    this.hiq[i][j] = this.hiq99[i][j];
                }
            }
        }
    }

    @Override
    public void save99() {
        for (int i = 0; i < 2; ++i) {
            this.nstd99 = this.nstd;
            this.nstdold99 = this.nstdold;
            this.qinold99[i] = this.qinold[i];
            for (int j = 0; j < 40; ++j) {
                this.hiq99[i][j] = this.hiq[i][j];
            }
        }
    }

    public float adjust(float[] fArray) {
        int n;
        int n2;
        this.nstdold = this.nstd = (this.guess = this.nstd + (this.nstd - this.nstdold));
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < 40; ++n) {
                this.hiq[n2][n] = this.hpropf[n2][n] * this.hiq[n2][n] + this.shicML[n2][n] * this.qinold[n2];
            }
            this.qinbase[n2] = fArray[n2 + 1];
            int n3 = n2;
            this.qinbase[n3] = this.qinbase[n3] + (double)fArray[n2 * 3] * (this.frac[n2 * 3] / this.frac[n2 + 1]) * this.klo / (this.kls * this.frac[n2 * 3] + this.klo);
            int n4 = n2;
            this.qinbase[n4] = this.qinbase[n4] + this.spaceflux[n2] * this.qpt * this.tstart;
        }
        this.nit = 0.0;
        do {
            n2 = 0;
            while (n2 < 2) {
                this.qin[n2] = this.qinbase[n2] + (n2 == 0 ? -1.0 : 1.0) * this.nstd * this.kns / this.frac[n2 + 1];
                this.dqin = this.qin[n2] - this.qinold[n2];
                this.mlt[n2] = 0.0;
                for (n = 0; n < 40; ++n) {
                    this.hiqi[n2][n] = this.hiq[n2][n] + this.rhicML[n2][n] * this.dqin;
                    int n5 = n2;
                    this.mlt[n5] = this.mlt[n5] + this.hrML[n2][n] * this.hiqi[n2][n];
                }
                int n6 = n2++;
                this.mlt[n6] = this.mlt[n6] / this.qpt;
            }
            this.diff = (this.mlt[0] - this.mlt[1]) * this.cice - this.nstd;
            this.nstd += this.diff;
            this.nit += 1.0;
        } while (Math.abs(this.diff) > 0.001 && this.nit < 10.0);
        this.hiq = this.hiqi;
        this.qinold = this.qin;
        n2 = 0;
        while (n2 < 2) {
            int n7 = n2++;
            this.mlt[n7] = this.mlt[n7] - this.tstart;
        }
        curve[] curveArray = this.gm(glotemp.class).boxtempqt;
        curveArray[0].set(year, (float)((this.mlt[0] * this.cice * this.klo + this.frac[0] * (double)fArray[0]) / (this.kls * this.frac[0] + this.klo)));
        curveArray[3].set(year, (float)((this.mlt[1] * this.cice * this.klo + this.frac[3] * (double)fArray[3]) / (this.kls * this.frac[3] + this.klo)));
        curveArray[1].set(year, (float)(this.mlt[0] * this.cice));
        curveArray[2].set(year, (float)(this.mlt[1] * this.cice));
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            f += (float)((double)curveArray[i].get(year) * this.frac[i]);
        }
        return f;
    }

    float thermalexpansion() {
        float f = 0.0f;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 40; ++j) {
                f = (float)((double)f + this.hrsl[i][j] * this.hiq[i][j]);
            }
        }
        if (year == gsy) {
            this.sealevteinit = f;
        }
        f = (float)((double)f - this.sealevteinit);
        return f;
    }

    void tempupwellfb(double d) {
        if (this.varupwell.istrue()) {
            if (d > this.val(cp.zeroupwelltemp)) {
                d = this.val(cp.zeroupwelltemp);
            }
            for (int i = 0; i < 2; ++i) {
                int n = 0;
                while (n < 40) {
                    this.hiquc = 0.0;
                    for (int j = 0; j < 40; ++j) {
                        this.hiquc += this.hiq[i][j] * this.upwellstep[i][n][j];
                    }
                    double[] dArray = this.hiq[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] - this.hiquc * d * this.val(cp.upwellreducefrac);
                }
            }
        }
    }

    static enum csopts {
        use_effective_cs,
        use_gcm_cs,
        user_cs;

    }

    public static enum gcmset {
        AR4(EnumSet.range(gcm.AR4_average, gcm.HadGEM1)),
        AR4_selection(EnumSet.of(gcm.HadGEM1, new gcm[]{gcm.MIROC3_2_MED, gcm.ECHAM5_MPIOM, gcm.HadCM3, gcm.CSIRO_Mk3, gcm.GISS_EH})),
        TAR(EnumSet.range(gcm.GFDL_TAR, gcm.DOE)),
        SAR(EnumSet.of(gcm.IPCCSAR)),
        all_GCMs(EnumSet.allOf(gcm.class));

        public EnumSet<gcm> gcms;

        private gcmset(EnumSet<gcm> enumSet) {
            this.gcms = enumSet;
        }

        gcm[] gcmlist() {
            return this.gcms.toArray(new gcm[this.gcms.size()]);
        }
    }

    public static enum gcm {
        AR4_average(3.642, 2.925, 3.211, 1.763, 1.899, 1.391),
        CCS_M3(3.95, 2.37, 2.7, 1.5, 1.73, 1.18),
        CGC_M31_T47(3.32, 3.02, 3.4, 1.9, 1.57, 1.58),
        CNRM_CM3(3.71, 2.45, 2.45, 1.6, 1.21, 1.1),
        CSIRO_Mk3(3.47, 2.21, 3.1, 1.4, 2.03, 1.33),
        ECHAM5_MPIOM(4.01, 3.86, 3.4, 2.2, 1.22, 1.41),
        ECHO_G(3.71, 3.01, 3.2, 1.7, 2.01, 1.65),
        FGOALS_g1(3.71, 1.97, 2.3, 1.2, 4.57, 1.64),
        GFDL_CM2(3.5, 2.35, 2.9, 1.6, 1.42, 1.47),
        GFDL_CM2_1(3.5, 2.28, 3.4, 1.5, 2.23, 1.58),
        GISS_EH(4.06, 3.04, 2.7, 1.6, 2.35, 1.21),
        GISS_ER(4.06, 2.57, 2.7, 1.5, 4.42, 1.44),
        INM_CM3(3.71, 2.28, 2.1, 1.6, 0.79, 1.1),
        IPSL_CM4(3.48, 3.83, 4.4, 2.1, 1.94, 1.26),
        MIROC3_2_HI(3.14, 5.87, 4.3, 2.6, 1.18, 1.15),
        MIROC3_2_MED(3.09, 3.93, 4.0, 2.1, 2.29, 1.58),
        MRI_CGCM_232(3.47, 2.97, 3.2, 2.2, 1.22, 1.45),
        PCM(3.71, 1.88, 2.1, 1.3, 1.57, 1.45),
        HadCM3(3.81, 3.06, 3.3, 2.0, 1.01, 1.65),
        HadGEM1(3.78, 2.63, 4.4, 1.9, 1.32, 1.2),
        GFDL_TAR(tarp, 3.71, 4.2, 2.3, 1.2, 8.0, 1.0, 1.0),
        CSIRO_TAR(tarp, 3.45, 3.7, 1.6, 1.2, 5.0, 1.0, 1.0),
        HadCM3_TAR(tarp, 3.74, 3.0, 1.9, 1.4, 25.0, 0.5, 0.5),
        HadCM2(tarp, 3.47, 2.5, 1.7, 1.4, 12.0, 0.5, 0.5),
        ECHAM4(tarp, 3.8, 2.6, 9.0, 1.4, 20.0, 0.5, 0.5),
        CSM(tarp, 3.6, 1.9, 2.3, 1.4, 9999.0, 0.5, 0.5),
        DOE(tarp, 3.6, 1.7, 2.3, 1.4, 14.0, 0.5, 0.5),
        IPCCSAR(sarp, 4.37, 2.5, 1.0, 1.3, 7.0, 1.0, 1.0, 90.0, 0.2, 1.0);

        EnumMap<cp, Double> val = new EnumMap(cp.class);

        private gcm(double ... dArray) {
            this(ar4p, dArray);
        }

        private gcm(cp[] cpArray, double ... dArray) {
            int n2 = 0;
            for (cp cp2 : cpArray) {
                this.val.put(cp2, dArray[n2]);
                ++n2;
            }
        }
    }

    public static enum cp {
        rfco2double("rfco2d", "w&per&m2", 3.71, 3.0, 5.0, colfont.black, complexity.normal),
        climsens("climsens", "degc", 3.0, 1.5, 7.5, colfont.red, complexity.simplest),
        climsens_gcm("cs_gcm", "degc", 3.21, 1.5, 7.5, colfont.red, complexity.expert),
        climsens_effective("cs_effective", "degc", 2.925, 1.5, 7.5, colfont.dkred, complexity.expert),
        transientclimateresponse("tcr", "degc", 1.8, 1.0, 3.0, colfont.purple, complexity.experimental),
        heatdiffusivity("teddydiff", "cm2&per&s", 1.9, 0.05, 4.0, colfont.dkblue, complexity.normal),
        landoceantempratio("lotr", "", 1.4, 0.7, 2.1, colfont.orange, complexity.expert),
        zeroupwelltemp("tnoupwell", "degc", 8.0, 0.0, 30.0, colfont.lilac, complexity.expert),
        knorthsouth("kns", "", 1.0, 0.0, 4.0, colfont.dkgreen, complexity.expert),
        klandocean("klo", "", 1.0, 0.0, 2.0, colfont.yellowgreen, complexity.expert),
        mixlaydepth("tmixlay", "metres", 60.0, 1.0, 120.0, colfont.grey, complexity.expert),
        polarsinktempratio("psi", "", 0.2, 0.0, 1.0, colfont.blue, complexity.expert),
        seaice("seaice", "", 1.25, 0.8, 1.6, colfont.cyan, complexity.expert),
        upwellreducefrac("uwredfrac", "", 0.3, 0.0, 1.0, colfont.dkpurple, complexity.expert),
        upwellbaserate("uwbaserate", "m&per&yr", 4.0, 0.0, 8.0, colfont.pink, complexity.expert);

        String lab;
        String units;
        double def;
        double min;
        double max;
        Color co;
        complexity cx;

        private cp(String string2, String string3, double d, double d2, double d3, Color color, complexity complexity2) {
            this.lab = string2;
            this.units = string3;
            this.def = d;
            this.min = d2;
            this.max = d3;
            this.co = color;
            this.cx = complexity2;
        }
    }
}

