/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.cli.histtemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.cli.udebclimod;

public class glotemp
extends module {
    public static param baseyear = new param("baseyear", "", 1850, 1760, 2000, colfont.blue);
    public static param baserange = new param(new Object[]{"baseyearrange", "", 15, 0, 25, colfont.blue, complexity.expert});
    public boolean usehisttempdata = false;
    public double error = 0.0;
    public curve avchange = new curve(new Object[]{"tempavfrom1750", colfont.brown, complexity.experimental});
    public curve avchangeby = new curve(new Object[]{"tempav", colfont.brown, complexity.simplest});
    public curve tempnl = new curve(new Object[]{"tempnl", colfont.red, complexity.expert});
    public curve tempno = new curve(new Object[]{"tempno", colfont.blue, complexity.expert});
    public curve tempso = new curve(new Object[]{"tempso", colfont.cyan, complexity.expert});
    public curve tempsl = new curve(new Object[]{"tempsl", colfont.orange, complexity.expert});
    public curveset temp = new curveset(new Object[]{this.avchange, this.avchangeby, histtemp.temptrend, histtemp.proxytemp, histtemp.tempdataGISS, histtemp.tempdataCRU, "glotempcurves", "degcbase", complexity.simplest});
    public curveset boxtemp = new curveset(this.tempnl, this.tempno, this.tempsl, this.tempso, "Box Temperature", "degcbase");
    public double offset = 0.0;
    public double oldoffset = 1.0;
    float[] boxoffset = new float[4];
    curve[] boxtempqt = new curve[]{this.tempnl, this.tempno, this.tempso, this.tempsl};

    @Override
    public void setinteractions() {
        this.follows(this.gm(radfor.class));
        this.follows(this.gm(histtemp.class));
        this.setaffectedby(this.gm(udebclimod.class));
    }

    @Override
    public void initsetup() {
        this.temp.associate(baseyear);
        this.boxtemp.associate(baseyear);
    }

    @Override
    public void startstate(int n) {
        this.gm(udebclimod.class).startstate(n);
    }

    @Override
    public void save99() {
        this.gm(udebclimod.class).save99();
    }

    @Override
    public void precalc() {
        if (baserange.getval() + baseyear.getval() > 2005.0) {
            baseyear.set(2005.0 - baserange.getval());
        }
    }

    @Override
    public void calcstep() {
        udebclimod udebclimod2 = this.gm(udebclimod.class);
        radfor radfor2 = this.gm(radfor.class);
        this.avchange.set(year, udebclimod2.adjust(new float[]{radfor2.splitrf[0].get(year), radfor2.splitrf[1].get(year), radfor2.splitrf[2].get(year), radfor2.splitrf[3].get(year)}));
        udebclimod2.tempupwellfb(this.avchange.get(year));
        if ((double)year == (double)((int)baseyear.getval()) + baserange.getval()) {
            this.calcoffset();
        }
        this.gm(sealevel.class).thermexp.set(year, udebclimod2.thermalexpansion());
    }

    @Override
    public void postcalc() {
        this.applyoffset();
        this.calcerror();
    }

    public void calcoffset() {
        int n;
        this.oldoffset = this.offset;
        this.offset = 0.0;
        for (n = 0; n < 4; ++n) {
            this.boxoffset[n] = 0.0f;
        }
        n = (int)baserange.getval();
        int n2 = 1 + n * 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)baseyear.getval() + i - n;
            if (n3 < gsy) {
                n3 = gsy;
            }
            this.offset += (double)(this.avchange.get(n3) / (float)n2);
            for (int j = 0; j < 4; ++j) {
                int n4 = j;
                this.boxoffset[n4] = this.boxoffset[n4] + this.boxtempqt[j].get(n3) / (float)n2;
            }
        }
    }

    void applyoffset() {
        for (int i = 0; i <= gey; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.boxtempqt[j].set(i, this.boxtempqt[j].get(i) - this.boxoffset[j]);
            }
            this.avchangeby.set(i, (float)((double)this.avchange.get(i) - this.offset));
        }
    }

    double gettemprise(int n) {
        if (this.usehisttempdata && year < 2007) {
            float f = 0.0f;
            for (int i = 1848; i < 1853; ++i) {
                f += histtemp.proxytemp.get(i) / 5.0f;
            }
            float f2 = (year < 1850 ? histtemp.proxytemp.get(year) : histtemp.tempdataCRU.get(year)) - f;
            return (double)f2 * (n == 0 ? 1.356 : 0.847);
        }
        return year > 1750 ? (double)(this.boxtempqt[n].get(year - 1) + this.boxtempqt[3 - n].get(year - 1) + (loop.calcfutureonly && year <= 2000 || !this.changed ? this.boxoffset[n] + this.boxoffset[3 - n] : 0.0f)) / 2.0 : 0.0;
    }

    public double getoceantemprise() {
        return this.gettemprise(1);
    }

    public double getlandtemprise() {
        return this.gettemprise(0);
    }

    public void calcerror() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = gsy; i < 2007; ++i) {
            float f5;
            float f6;
            float f7 = this.avchangeby.get(i);
            if (i < 1850) {
                f6 = histtemp.proxytemp.get(i);
                f5 = 0.5f;
            } else {
                f6 = histtemp.tempdataCRU.get(i);
                f5 = 0.05f + 0.0015f * (float)(i < 1950 ? 1950 - i : 0);
            }
            f += (f7 - f6) * (f7 - f6) / f5;
            f3 += f7 / f5;
            f2 += f6 / f5;
            f4 += 1.0f / f5;
        }
        this.error = Math.pow(f / f4 - (f3 / f4 - f2 / f4) * (f3 / f4 - f2 / f4), 0.5);
    }
}

