/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.carbon;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.berncarbon;
import jcm.mod.cli.udebclimod;
import jcm.mod.obj.globco2emit;

public class carboncycle
extends module {
    public param accccarbon = new param(new Object[]{"accccarbon", false, complexity.expert});
    public static curve co2atppmdata = new curve("atco2data", colfont.grey, 1750, 2015);
    public static curve atincdata = new curve(new Object[]{"atincdat", curve.Type.total, colfont.dkgrey, 1751, 2015, complexity.expert});
    public static curve atincdatatrend = new curve(new Object[]{"atincdat trend", curve.Type.total, colfont.grey, 1751, 2013});
    public curve totemit = new curve(new Object[]{"totemit", colfont.brown, complexity.simplest, curve.Type.total});
    public curve fossil = new curve("fossilemit", colfont.red);
    public curve lucf = new curve("lucemit", colfont.orange);
    public curve totsink = new curve(new Object[]{"totsink", colfont.cyan, complexity.simplest, curve.Type.total});
    public curve ocsink = new curve("oceansink", colfont.blue);
    public curve tbsink = new curve("landsink", colfont.green);
    public curve atinc = new curve(new Object[]{"atincmod", colfont.black, curve.Type.total});
    public curve co2atppm = new curve(new Object[]{"atco2calc", colfont.black, complexity.simplest});
    public curve co2rf = new curve("co2rf", colfont.black);
    public curveset sosi = new curveset(new Object[]{this.fossil, this.lucf, this.totemit, this.atinc, atincdata, atincdatatrend, this.ocsink, this.tbsink, this.totsink, "atco2flux", "mega&ton&carbon&/&yr", complexity.simplest});
    public curveset conc = new curveset(new Object[]{this.co2atppm, co2atppmdata, "atco2conc", "ppm", complexity.simplest});
    public static final double ppmpmtc = 4.71E-4;
    public static final double atppmprein = 278.0;
    public double error;
    float[] acccfrac = new float[]{0.152f, 0.253f, 0.279f, 0.316f};
    float[] accctau = new float[]{9999999.0f, 171.0f, 18.0f, 2.57f};
    public float[] acccbox = new float[4];

    @Override
    public void initsetup() {
        this.follows(this.gm(globco2emit.class));
        carboncycle.fillconcdata();
    }

    @Override
    public void setinteractions() {
        this.setaffectedby((interacob)this.gm(berncarbon.class), !this.accccarbon.istrue());
    }

    @Override
    public void startstate(int n) {
        this.gm(berncarbon.class).startstate(n);
    }

    @Override
    public void save99() {
        this.gm(berncarbon.class).save99();
    }

    @Override
    public void calcstep() {
        if (this.accccarbon.istrue()) {
            if (year == gsy) {
                for (int i = 0; i < 4; ++i) {
                    this.acccbox[i] = 0.0f;
                }
            }
            this.co2atppm.set(year, 278.0f + this.acccmod(this.acccbox, this.totemit.get(year)));
            this.ocsink.set(year, 0.0f);
            this.tbsink.set(year, 0.0f);
            this.totsink.set(year, year > gsy ? (float)((double)(this.co2atppm.get(year) - this.co2atppm.get(year - 1)) / 4.71E-4) - this.totemit.get(year) : 0.0f);
        } else {
            float[] fArray = this.gm(berncarbon.class).addemit(this.totemit.get(year));
            this.co2atppm.set(year, fArray[0]);
            this.tbsink.set(year, -fArray[1]);
            this.ocsink.set(year, -fArray[2]);
            this.totsink.set(year, this.ocsink.get(year) + this.tbsink.get(year));
            if (year > 1750) {
                this.atinc.set(year, (float)((double)(this.co2atppm.get(year) - this.co2atppm.get(year - 1)) / 4.71E-4));
            }
        }
        this.co2rf();
    }

    @Override
    public void postcalc() {
        this.calcerror();
    }

    public void inverseluc() {
        this.co2atppm.set(co2atppmdata.get());
        this.totemit.set(year, this.inverseco2(co2atppmdata.get(year)));
        this.lucf.set(year, (float)((4.0 * (double)this.lucf.get(year - 1) + (double)(this.totemit.get(year) - this.fossil.get(year))) / 5.0));
    }

    public float inverseco2(double d) {
        return this.inverseco2(d, 1);
    }

    public float inverseco2(double d, int n) {
        double d2 = this.totsink.get(year - 1) + (this.totsink.get(year - 1) - this.totsink.get(year - (1 + n))) / (float)n;
        if (d2 / (double)this.totsink.get(year - 1) < 0.0) {
            d2 = 0.0;
        }
        return (float)((d - (double)this.co2atppm.get(year - 1)) / 4.71E-4 - d2);
    }

    void co2rf() {
        this.co2rf.set(year, (float)(this.gm(udebclimod.class).val(udebclimod.cp.rfco2double) * Math.log((double)this.co2atppm.get(year) / 278.0) / Math.log(2.0)));
    }

    public void calcerror() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 1; i < fsyfos - gsy + 1; ++i) {
            float f5 = this.atinc.get(year);
            float f6 = atincdata.get(year);
            float f7 = i > 200 ? 0.1f : 0.5f;
            f += Math.abs((f5 - f6) / f7);
            f3 += f5 / f7;
            f2 += f6 / f7;
            f4 += 1.0f / f7;
        }
        this.error = f / f4;
    }

    static void fillconcdata() {
        int n;
        int n2;
        double[] dArray = new double[]{316.0, 316.91, 317.63, 318.46, 319.02, 319.52, 320.09, 321.34, 322.13, 323.11, 324.6, 325.65, 326.32, 327.52, 329.61, 330.29, 331.16, 332.18, 333.88, 335.52, 336.89, 338.67, 339.95, 341.09, 342.75, 344.44, 345.86, 347.14, 348.99, 351.44, 352.94, 354.19, 355.62, 356.36, 357.1, 358.86, 360.9, 362.58, 363.84, 366.58, 368.3, 369.47, 371.04, 373.08, 375.61, 377.43, 379.76, 381.85, 383.71, 385.57, 387.35};
        double[] dArray2 = new double[]{367.63, 368.91, 370.69, 373.1, 375.19, 376.94, 379.26, 381.01, 383.07, 384.82, 386.74, 388.92, 390.71, 393.34, 395.89, 397.88};
        double[] dArray3 = new double[]{282.2, 282.3, 282.3, 282.4, 282.4, 282.5, 282.5, 282.6, 282.6, 282.7, 282.7, 282.7, 282.8, 282.8, 282.9, 282.9, 282.9, 283.0, 283.0, 283.1, 283.1, 283.1, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.1, 283.1, 283.1, 283.1, 283.1, 283.0, 283.0, 283.0, 283.0, 282.9, 282.9, 282.8, 282.8, 282.8, 282.7, 282.7, 282.7, 282.6, 282.5, 282.5, 282.4, 282.3, 282.2, 282.1, 282.0, 282.0, 281.9, 281.8, 281.7, 281.6, 281.5, 281.3, 281.2, 281.1, 280.9, 280.8, 280.6, 280.5, 280.4, 280.2, 280.0, 279.9, 279.7, 279.5, 279.3, 279.2, 279.0, 278.8, 278.6, 278.5, 278.3, 278.2, 278.0, 277.8, 277.6, 277.5, 277.3, 277.1, 276.9, 276.8, 276.7, 276.5, 276.4, 276.3, 276.1, 276.0, 275.9, 275.8, 275.7, 275.7, 275.6, 275.5, 275.5, 275.5, 275.4, 275.4, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.4, 275.4, 275.4, 275.4, 275.5, 275.5, 275.5, 275.6, 275.7, 275.7, 275.8, 275.8, 275.9, 275.9, 276.0, 276.0, 276.1, 276.1, 276.1, 276.2, 276.2, 276.3, 276.3, 276.3, 276.3, 276.4, 276.4, 276.4, 276.4, 276.4, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.5, 276.5, 276.5, 276.5, 276.5, 276.6, 276.6, 276.6, 276.6, 276.6, 276.7, 276.7, 276.7, 276.7, 276.7, 276.8, 276.8, 276.8, 276.8, 276.8, 276.9, 276.9, 276.9, 276.9, 276.9, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 277.0, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 277.0, 277.0, 277.0, 277.1, 277.1, 277.1, 277.2, 277.3, 277.3, 277.4, 277.5, 277.6, 277.7, 277.8, 277.8, 277.9, 278.0, 278.1, 278.2, 278.3, 278.5, 278.6, 278.7, 278.9, 279.0, 279.1, 279.3, 279.5, 279.6, 279.8, 279.9, 280.1, 280.2, 280.4, 280.5, 280.7, 280.8, 281.0, 281.1, 281.3, 281.4, 281.6, 281.8, 281.9, 282.0, 282.2, 282.3, 282.4, 282.6, 282.7, 282.8, 282.9, 283.0, 283.1, 283.2, 283.3, 283.4, 283.5, 283.6, 283.7, 283.7, 283.8, 283.9, 283.9, 283.9, 284.0, 284.0, 284.0, 284.1, 284.1, 284.2, 284.2, 284.2, 284.2, 284.3, 284.3, 284.3, 284.3, 284.3, 284.4, 284.4, 284.4, 284.4, 284.4, 284.5, 284.5, 284.5, 284.5, 284.5, 284.6, 284.6, 284.6, 284.6, 284.7, 284.7, 284.7, 284.8, 284.9, 284.9, 285.0, 285.1, 285.2, 285.3, 285.4, 285.5, 285.6, 285.7, 285.8, 285.9, 286.0, 286.2, 286.3, 286.5, 286.6, 286.8, 287.0, 287.2, 287.4, 287.6, 287.8, 288.0, 288.2, 288.4, 288.7, 288.9, 289.1, 289.4, 289.7, 289.9, 290.2, 290.5, 290.8, 291.1, 291.4, 291.7, 292.0, 292.3, 292.6, 292.9, 293.1, 293.4, 293.7, 294.0, 294.3, 294.6, 294.9, 295.2, 295.5, 295.8, 296.1, 296.4, 296.7, 297.0, 297.3, 297.6, 297.9, 298.2, 298.5, 298.9, 299.2, 299.6, 299.9, 300.2, 300.5, 300.9, 301.2, 301.5, 301.8, 302.2, 302.5, 302.9, 303.2, 303.5, 303.9, 304.2, 304.6, 304.9, 305.2, 305.6, 305.9, 306.2, 306.5, 306.8, 307.1, 307.4, 307.7, 308.0, 308.3, 308.5, 308.8, 309.1, 309.3, 309.5, 309.8, 310.0, 310.2, 310.5, 310.8, 311.0, 311.3, 311.7, 312.0, 312.4, 312.8, 313.2, 313.6, 314.1, 314.6, 315.1, 315.7, 315.8, 316.8, 317.5, 318.3, 318.8, 319.4, 319.9, 321.2, 322.0, 322.9, 324.5, 325.5, 326.2, 327.3, 329.5, 330.1, 331.0, 332.0, 333.7, 335.3, 336.7, 338.5, 339.8, 341.0, 342.6, 344.3, 345.7, 347.0, 348.8, 351.3, 352.8, 354.0, 355.5, 356.3, 357.0, 358.9, 360.9, 362.7, 363.8};
        for (n2 = 1750; n2 < 1959; ++n2) {
            co2atppmdata.set(n2, (float)dArray3[n2 - 1500]);
        }
        for (n2 = 1959; n2 < 2010; ++n2) {
            co2atppmdata.set(n2, (float)dArray[n2 - 1959]);
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < 10; ++i) {
            f = (float)((double)f + dArray[i + 2000 - 1959]);
            f2 = (float)((double)f2 + dArray2[i]);
        }
        float f3 = (f2 - f) / 10.0f;
        for (n = 0; n < 6; ++n) {
            co2atppmdata.set(2010 + n, (float)dArray2[10 + n] - f3);
        }
        for (n = 1751; n < 2016; ++n) {
            atincdata.set(n, (float)((double)(co2atppmdata.get(n) - co2atppmdata.get(n - 1)) / 4.71E-4));
        }
        for (n = 1753; n < 2014; ++n) {
            atincdatatrend.set(n, (float)((double)((co2atppmdata.get(n + 2) - co2atppmdata.get(n - 3)) * 0.2f) / 4.71E-4));
        }
    }

    public float acccmod(float[] fArray, float f) {
        int n;
        for (n = 0; n < 4; ++n) {
            int n2 = n;
            fArray[n2] = fArray[n2] + this.acccfrac[n] * f * 4.71E-4f;
        }
        for (n = 1; n < 4; ++n) {
            int n3 = n;
            fArray[n3] = (float)((double)fArray[n3] * Math.exp(-1.0 / (double)this.accctau[n]));
        }
        float f2 = 0.0f;
        for (int i = 0; i < 4; ++i) {
            f2 += fArray[i];
        }
        return f2;
    }
}

