/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.carbon;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;

public class carbonatechemistry
extends module {
    public curve pH = new curve("pH", colfont.dkgreen);
    public curve bicarbonate = new curve("HCO3-", colfont.blue);
    public curve carbonate = new curve("CO3(2-)", colfont.dkblue);
    public curve co2aq = new curve("CO2aq", colfont.cyan);
    public curve totc02 = new curve("TCO2", colfont.black);
    public curveset conc = new curveset(this.co2aq, this.bicarbonate, this.carbonate, this.totc02, "concentrations", "molar");
    public curveset pHset = new curveset(this.pH, "pH", "- log10 [H+]");
    String[] chemoptions = new String[]{"realb", "realj", "hildaz0z1", "cubicfit", "linear-carbonate"};
    complexity[] chemcomplex = new complexity[]{complexity.experimental, complexity.normal, complexity.expert, complexity.expert, complexity.normal};
    public param<String> carbchem = new param(new Object[]{"carbchemmenu", this.chemoptions, "realj", this.chemcomplex});
    public param chemfeedback = new param("chemfbopt", true);
    public param gasex = new param(new Object[]{"asgasex", "mol&per&m2&per&ppm&per&yr", colfont.orange, 0.06, 0, 0.12, complexity.expert});
    double askodml;
    double talk;
    double totb;
    double[] oafdml;
    double[] askoaf;
    double[] alpha;
    double[] gamma;
    double[] cubfitf;
    double[] totc0;
    double[] calk;
    double[] hyd;
    double[] k1;
    double[] k2;
    double[] kb;
    double[] kw;
    double[] k0;
    double[] octemp;
    double[] saflin;
    double[] saflin0;
    double dml = 75.0;
    double ocarea = 3.616E14;
    double hfrac = 0.16;

    @Override
    public void setinteractions() {
        this.setaffectedby((interacob)this.chemfeedback, ((String)this.carbchem.chosen).startsWith("real"));
        this.setaffectedby(glotemp.class, this.chemfeedback.istrue() && ((String)this.carbchem.chosen).startsWith("real"));
    }

    public void setupchemistry() {
        double d = this.gasex.getval();
        this.askodml = 1000.0 * d / this.dml;
        this.oafdml = new double[2];
        this.oafdml[0] = 1.0E15 / (12.0 * this.ocarea * (1.0 - this.hfrac) * this.dml);
        this.oafdml[1] = 1.0E15 / (12.0 * this.ocarea * this.hfrac * this.dml);
        this.askoaf = new double[2];
        this.askoaf[0] = 1.2E-11 * d * this.ocarea * (1.0 - this.hfrac);
        this.askoaf[1] = 1.2E-11 * d * this.ocarea * this.hfrac;
        this.alpha = new double[2];
        this.alpha[0] = 4.71E-4 * this.askoaf[0];
        this.alpha[1] = 4.71E-4 * this.askoaf[1];
        this.hyd = new double[2];
        this.hyd[0] = 1.0E-8;
        this.hyd[1] = 1.0E-8;
        this.calk = new double[2];
        this.calk[0] = this.talk - 0.001;
        this.calk[1] = this.talk - 0.001;
        this.saflin = new double[2];
        this.saflin0 = new double[2];
        this.gamma = new double[2];
        this.cubfitf = new double[2];
        this.k0 = new double[2];
        this.k1 = new double[2];
        this.k2 = new double[2];
        this.kb = new double[2];
        this.kw = new double[2];
        this.octemp = new double[2];
        this.octemp[0] = 21.37;
        this.octemp[1] = 1.38;
        this.talk = 0.0024;
        this.totb = 4.16E-4;
        this.totc0 = new double[2];
        this.totc0[0] = this.totc0(this.octemp[0]);
        this.totc0[1] = this.totc0(this.octemp[1]);
        this.saflin[0] = this.saflin(this.octemp[0]);
        this.saflin[1] = this.saflin(this.octemp[1]);
        this.saflin0[0] = this.saflin[0];
        this.saflin0[1] = this.saflin[1];
        this.chemconsts(this.octemp[0], 0);
        this.chemconsts(this.octemp[1], 1);
    }

    void temperaturefeedback() {
        if (this.chemfeedback.istrue()) {
            double d = this.gm(glotemp.class).getoceantemprise();
            this.chemconsts(this.octemp[0] + d, 0);
            this.chemconsts(this.octemp[1] + d, 1);
        }
    }

    double z0(double d) {
        return 1.7561 - 0.031618 * d + 4.444E-4 * d * d;
    }

    double z1(double d) {
        return 0.004096 - 7.7086E-5 * d + 6.1E-7 * d * d;
    }

    double k0(double d) {
        return Math.exp(-60.2409 + 9345.17 / d + 23.3585 * Math.log(d / 100.0) + 35.0 * (0.023517 - 2.3656E-4 * d + 4.7036E-7 * d * d));
    }

    double kb(double d) {
        return Math.exp(-(28559.7 / d) + 1016.43 - 181.498 * Math.log(d) + 0.314173 * d);
    }

    double k1(double d) {
        return Math.exp(-(2331.08 / d) - 1.5529413 * Math.log(d) + 3.18181);
    }

    double k2(double d) {
        return Math.exp(-(3493.43 / d) - 0.2005743 * Math.log(d) - 7.69056);
    }

    double kw(double d) {
        return Math.exp(-(13145.2 / d) - 17.4432 * Math.log(d) + 113.0395);
    }

    double totc0(double d) {
        return 0.002221 - 9.5E-6 * d;
    }

    double saflin(double d) {
        return this.askodml * (1.68 - 0.036 * d + 6.0E-4 * d * d);
    }

    double cubfitf(double d) {
        return this.askodml * (80.0 - 3.5 * d + 0.05 * d * d) / 1000000.0;
    }

    float calcpK(double d) {
        return (float)(-Math.log(d) / Math.log(10.0));
    }

    void chemconsts(double d, int n) {
        if (this.carbchem.chosen == "hildaz0z1") {
            this.saflin[n] = this.z0(d) * this.askodml;
            this.gamma[n] = this.z1(d) * this.oafdml[n];
        }
        if (this.carbchem.chosen == "saflin") {
            this.saflin[n] = this.saflin(d);
        }
        if (this.carbchem.chosen == "cubicfit") {
            this.saflin[n] = this.saflin(d);
            this.cubfitf[n] = this.cubfitf(d) * this.oafdml[n] * this.oafdml[n];
        }
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            double d2 = d + 273.15;
            this.k0[n] = this.k0(d2);
            this.k1[n] = this.k1(d2);
            this.k2[n] = this.k2(d2);
            this.kb[n] = this.kb(d2);
            this.kw[n] = this.kw(d2);
        }
    }

    double safnonlin(double d, int n) {
        if (this.carbchem.chosen != "realb" && this.carbchem.chosen != "realj") {
            this.pH.set(Float.NaN);
            this.carbonate.set(Float.NaN);
            this.bicarbonate.set(Float.NaN);
            this.co2aq.set(Float.NaN);
            this.totc02.set(Float.NaN);
        }
        if (this.carbchem.chosen == "hildaz0z1") {
            return this.saflin[n] * this.gamma[n] * d * d / (1.0 - this.gamma[n] * d) + (this.chemfeedback.istrue() ? d * (this.saflin[n] - this.saflin0[n]) : 0.0);
        }
        if (this.carbchem.chosen == "cubicfit") {
            return this.cubfitf[n] * d * d * d + (this.chemfeedback.istrue() ? d * (this.saflin[n] - this.saflin0[n]) : 0.0);
        }
        if (this.carbchem.chosen == "linear") {
            return this.chemfeedback.istrue() ? d * (this.saflin[n] - this.saflin0[n]) : 0.0;
        }
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            double d2;
            double d3;
            double d4;
            double d5 = this.totc0[n] + d * this.oafdml[n] / 1000000.0;
            int n2 = 0;
            if (this.carbchem.chosen == "realb") {
                do {
                    d4 = this.hyd[n];
                    this.calk[n] = this.talk - this.totb * this.kb[n] / (this.hyd[n] + this.kb[n]) - this.kw[n] / this.hyd[n] + this.hyd[n];
                    d3 = (d5 - this.calk[n]) * (d5 - this.calk[n]) - 4.0 * this.calk[n] * (this.calk[n] - 2.0 * d5) * this.k2[n] / this.k1[n];
                    this.hyd[n] = this.k1[n] / (2.0 * this.calk[n]) * (d5 - this.calk[n] + Math.pow(d3, 0.5));
                } while (Math.abs(1.0 - d4 / this.hyd[n]) > 1.0E-5 && ++n2 < 10);
            } else {
                d4 = 6.0;
                d3 = -0.5;
                d2 = 0.0;
                do {
                    ++n2;
                    this.hyd[n] = Math.pow(10.0, -d4);
                    double d6 = (this.k1[n] / this.hyd[n] + 2.0 * this.k1[n] * this.k2[n] / (this.hyd[n] * this.hyd[n])) / (1.0 + this.k1[n] / this.hyd[n] + this.k1[n] * this.k2[n] / (this.hyd[n] * this.hyd[n])) * d5;
                    double d7 = this.talk - d6 - this.kb[n] * this.totb / (this.hyd[n] + this.kb[n]) - this.kw[n] / this.hyd[n] + this.hyd[n];
                    d2 = d7;
                    d4 += (d3 *= d7 / (d2 - d7));
                } while (Math.abs(d3) > 1.0E-5 && n2 < 10);
            }
            d4 = d5 * (this.hyd[n] * this.hyd[n]) / (this.hyd[n] * this.hyd[n] + this.k1[n] * this.hyd[n] + this.k1[n] * this.k2[n]);
            d3 = this.k1[n] * d4 / this.hyd[n];
            d2 = d5 - d4 - d3;
            this.pH.set(this.calcpK(this.hyd[n]));
            this.carbonate.set((float)d2);
            this.bicarbonate.set((float)d3);
            this.co2aq.set((float)d4);
            this.totc02.set((float)d5);
            return this.askoaf[n] * (1000000.0 * d4 / this.k0[n] - 278.0) - this.saflin[n] * d;
        }
        return 0.0;
    }
}

