/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.carbon;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jcm.core.complexity;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carbonatechemistry;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;

public class berncarbon
extends module {
    public param diffufac = new param("ceddydiff", "", colfont.blue, 1, 0, 2);
    public param sidemix = new param(new Object[]{"csidemix", "", colfont.yellow, 1.858736059479554, 0, 5, complexity.expert});
    public param upwell = new param(new Object[]{"cupwell", "m&per&yr", colfont.red, 0.44, 0, 1, complexity.expert});
    public param hlmix = new param(new Object[]{"chighlat", "m&per&yr", colfont.cyan, 38, 0, 70, complexity.expert});
    public param beta = new param("fertbeta", "", colfont.green, 0.5, 0, 0.6);
    public param fbchfut = new param(new Object[]{"fertn change only in future", false, complexity.experimental});
    public param respq10 = new param("resp_q10", "", colfont.brown, 1.4, 0.5, 2.5);
    static final double ocdepth = 3725.0;
    static final double ocarea = 3.616E14;
    static final double dml = 75.0;
    static final double hfrac = 0.16;
    static final double lhf = 5.25;
    int steps = 1;
    double dt = 1.0 / (double)this.steps;
    public static final int ncl = 34;
    public static final int ncb = 43;
    double[] dl = new double[34];
    double[] diffu = new double[34];
    Matrix MV;
    public double[] cpropf = this.cbox();
    public double[] ciq = this.cbox();
    public double[] ciqi = this.cbox();
    public double[] ciq99 = this.cbox();
    public double[] crBIO = this.cbox();
    public double[] crOC = this.cbox();
    public double[] crAT = this.cbox();
    public double[] crLS = this.cbox();
    public double[] crHS = this.cbox();
    public double[] scicAT = this.cbox();
    public double[] scicLS = this.cbox();
    public double[] scicHS = this.cbox();
    public double[] scicNP = this.cbox();
    public double[] rcicAT = this.cbox();
    public double[] rcicLS = this.cbox();
    public double[] rcicHS = this.cbox();
    public double[] rcicNP = this.cbox();
    public double[] crSO = this.cbox();
    public double[] scicSO = this.cbox();
    public double[] rcicSO = this.cbox();
    public double[] crHU = this.cbox();
    public double[] scicHU = this.cbox();
    public double[] rcicHU = this.cbox();
    public double totemit;
    public double oldtotemit;
    public double oldatinc;
    public double atinc;
    public double oldlsinc;
    public double lsinc;
    public double oldhsinc;
    public double hsinc;
    public double oldnpinc;
    public double npinc;
    public double at;
    public double ls;
    public double hs;
    public double oldls;
    public double oldhs;
    public double tb;
    public double oldtb;
    public double oc;
    public double oldoc;
    public double dat;
    public double dls;
    public double dhs;
    public double dnp;
    double atinc99;
    double lsinc99;
    double hsinc99;
    double npinc99;
    double totemit99;
    double dls99;
    double dhs99;
    double dnp99;
    double atppmy = 278.0;
    double guess;
    double nit;
    double ncit;
    double oldnit = 1.0;
    double ciqr;
    double diff;
    double wit;
    double check;
    String err = "";
    public double soinc;
    public double huinc;
    public double oldsoinc;
    public double soinc99;
    public double huinc99;
    public double oldhuinc;
    public double so;
    public double hu;
    public double oldso;
    public double oldhu;
    public double dso;
    public double dhu;
    public double dso99;
    public double dhu99;
    double nplin;
    double betab;

    @Override
    public void setinteractions() {
        this.setaffectedby(carbonatechemistry.class);
        this.setaffectedby(glotemp.class, this.respq10.getval() != 1.0);
    }

    @Override
    public void precalc() {
        this.setupfluxes();
    }

    double[] cbox() {
        return new double[43];
    }

    void setupfluxes() {
        double d;
        double d2;
        double d3 = 60000.0 * this.beta.getval();
        this.gm(carboncycle.class);
        double d4 = d3 * 4.71E-4;
        this.gm(carboncycle.class);
        this.nplin = d4 / 278.0;
        double d5 = 0.0;
        double d6 = this.upwell.getval();
        double d7 = this.hlmix.getval();
        double d8 = this.sidemix.getval() / 1000.0;
        for (int i = 0; i < 34; ++i) {
            double d9 = this.dl[i] = i < 20 ? 49.0 : 196.0;
            if (i > 0) {
                d5 += this.dl[i];
            }
            this.diffu[i] = this.diffufac.getval() * (465.0 + 7096.0 * Math.exp(-d5 / 253.0));
        }
        double[][] dArray = new double[43][43];
        for (int i = 0; i < 43; ++i) {
            for (int j = 0; j < 43; ++j) {
                dArray[i][j] = 0.0;
            }
        }
        int n = 1;
        while (n < 34) {
            double d10 = (2.0 * this.diffu[n] - d6 * this.dl[n]) / (this.dl[n - 1] * (this.dl[n - 1] + this.dl[n]));
            d2 = (2.0 * this.diffu[n] + d6 * this.dl[n - 1]) / (this.dl[n] * (this.dl[n - 1] + this.dl[n]));
            d = d8 * 5.25 * this.dl[n] / 3725.0;
            double[] dArray2 = dArray[n];
            int n2 = n - 1;
            dArray2[n2] = dArray2[n2] + d10;
            double[] dArray3 = dArray[n - 1];
            int n3 = n - 1;
            dArray3[n3] = dArray3[n3] - d10;
            double[] dArray4 = dArray[n - 1];
            int n4 = n;
            dArray4[n4] = dArray4[n4] + d2;
            double[] dArray5 = dArray[n];
            int n5 = n;
            dArray5[n5] = dArray5[n5] - d2;
            double[] dArray6 = dArray[n];
            dArray6[36] = dArray6[36] + d;
            double[] dArray7 = dArray[36];
            dArray7[36] = dArray7[36] - d;
            double[] dArray8 = dArray[36];
            int n6 = n;
            dArray8[n6] = dArray8[n6] + d8;
            double[] dArray9 = dArray[n];
            int n7 = n++;
            dArray9[n7] = dArray9[n7] - d8;
        }
        double d11 = 8.0 * this.diffu[0] / (3.0 * this.dl[0] * 75.0) - d6 / 75.0;
        d2 = 3.0 * this.diffu[0] / (this.dl[0] * this.dl[0]);
        double d12 = this.diffu[0] / (3.0 * this.dl[0] * this.dl[0]);
        double[] dArray10 = dArray[0];
        dArray10[34] = dArray10[34] + d11;
        double[] dArray11 = dArray[34];
        dArray11[34] = dArray11[34] - d11;
        double[] dArray12 = dArray[34];
        dArray12[0] = dArray12[0] + d2;
        double[] dArray13 = dArray[0];
        dArray13[0] = dArray13[0] - d2;
        double[] dArray14 = dArray[0];
        dArray14[1] = dArray14[1] + d12;
        double[] dArray15 = dArray[34];
        dArray15[1] = dArray15[1] - d12;
        d = d8 * 5.25 * this.dl[0] / 3725.0;
        double[] dArray16 = dArray[0];
        dArray16[36] = dArray16[36] + d;
        double[] dArray17 = dArray[36];
        dArray17[36] = dArray17[36] - d;
        double[] dArray18 = dArray[36];
        dArray18[0] = dArray18[0] + d8;
        double[] dArray19 = dArray[0];
        dArray19[0] = dArray19[0] - d8;
        double[] dArray20 = dArray[34];
        dArray20[35] = dArray20[35] + d8 * 5.25 * 75.0 / 3725.0;
        double[] dArray21 = dArray[35];
        dArray21[35] = dArray21[35] - d8 * 5.25 * 75.0 / 3725.0;
        double[] dArray22 = dArray[35];
        dArray22[34] = dArray22[34] + (d8 + d6 / 75.0);
        double[] dArray23 = dArray[34];
        dArray23[34] = dArray23[34] - (d8 + d6 / 75.0);
        double[] dArray24 = dArray[33];
        dArray24[36] = dArray24[36] + d6 * 5.25 / 3725.0;
        double[] dArray25 = dArray[36];
        dArray25[36] = dArray25[36] - d6 * 5.25 / 3725.0;
        double[] dArray26 = dArray[35];
        dArray26[36] = dArray26[36] + d7 / 3725.0;
        double[] dArray27 = dArray[36];
        dArray27[36] = dArray27[36] - d7 / 3725.0;
        double[] dArray28 = dArray[36];
        dArray28[35] = dArray28[35] + (d7 + d6 / 5.25) / 75.0;
        double[] dArray29 = dArray[35];
        dArray29[35] = dArray29[35] - (d7 + d6 / 5.25) / 75.0;
        this.gm(carbonatechemistry.class).setupchemistry();
        double[] dArray30 = this.gm(carbonatechemistry.class).saflin;
        double[] dArray31 = this.gm(carbonatechemistry.class).alpha;
        double[] dArray32 = dArray[37];
        dArray32[34] = dArray32[34] + dArray30[0];
        double[] dArray33 = dArray[34];
        dArray33[34] = dArray33[34] - dArray30[0];
        double[] dArray34 = dArray[37];
        dArray34[35] = dArray34[35] + dArray30[1];
        double[] dArray35 = dArray[35];
        dArray35[35] = dArray35[35] - dArray30[1];
        double[] dArray36 = dArray[34];
        dArray36[37] = dArray36[37] + dArray31[0];
        double[] dArray37 = dArray[37];
        dArray37[37] = dArray37[37] - dArray31[0];
        double[] dArray38 = dArray[35];
        dArray38[37] = dArray38[37] + dArray31[1];
        double[] dArray39 = dArray[37];
        dArray39[37] = dArray39[37] - dArray31[1];
        double[] dArray40 = dArray[41];
        dArray40[39] = dArray40[39] + 0.01;
        double[] dArray41 = dArray[39];
        dArray41[39] = dArray41[39] - 0.01;
        double[] dArray42 = dArray[41];
        dArray42[40] = dArray42[40] + 0.08333;
        double[] dArray43 = dArray[40];
        dArray43[40] = dArray43[40] - 0.08333;
        double[] dArray44 = dArray[40];
        dArray44[39] = dArray44[39] + 0.04;
        double[] dArray45 = dArray[39];
        dArray45[39] = dArray45[39] - 0.04;
        double[] dArray46 = dArray[40];
        dArray46[38] = dArray46[38] + 0.35;
        double[] dArray47 = dArray[38];
        dArray47[38] = dArray47[38] - 0.35;
        double[] dArray48 = dArray[39];
        dArray48[42] = dArray48[42] + 0.41667;
        double[] dArray49 = dArray[42];
        dArray49[42] = dArray49[42] - 0.41667;
        double[] dArray50 = dArray[38];
        dArray50[42] = dArray50[42] + 0.58333;
        double[] dArray51 = dArray[42];
        dArray51[42] = dArray51[42] - 0.58333;
        double[] dArray52 = dArray[37];
        dArray52[40] = dArray52[40] + 0.375;
        double[] dArray53 = dArray[40];
        dArray53[40] = dArray53[40] - 0.375;
        double[] dArray54 = dArray[37];
        dArray54[41] = dArray54[41] + 0.01;
        double[] dArray55 = dArray[41];
        dArray55[41] = dArray55[41] - 0.01;
        double[] dArray56 = dArray[42];
        dArray56[37] = dArray56[37] + this.nplin;
        double[] dArray57 = dArray[37];
        dArray57[37] = dArray57[37] - this.nplin;
        double[] dArray58 = this.cbox();
        double[] dArray59 = this.cbox();
        double[] dArray60 = this.cbox();
        double[] dArray61 = this.cbox();
        double[] dArray62 = this.cbox();
        double[] dArray63 = this.cbox();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(new Matrix(dArray, 43, 43));
        this.MV = eigenvalueDecomposition.getV();
        Matrix matrix = this.MV.inverse().transpose();
        this.crLS = this.MV.getArray()[34];
        this.crHS = this.MV.getArray()[35];
        this.crAT = this.MV.getArray()[37];
        this.crSO = this.MV.getArray()[40];
        this.crHU = this.MV.getArray()[41];
        this.crBIO = new double[43];
        this.crOC = new double[43];
        for (int i = 0; i < 43; ++i) {
            int n8;
            this.crBIO[i] = 0.0;
            for (n8 = 0; n8 < 5; ++n8) {
                int n9 = i;
                this.crBIO[n9] = this.crBIO[n9] + this.MV.getArray()[38 + n8][i];
            }
            this.crOC[i] = 0.0;
            for (n8 = 0; n8 < 37; ++n8) {
                int n10 = i;
                this.crOC[n10] = this.crOC[n10] + this.MV.getArray()[n8][i];
            }
        }
        dArray59 = matrix.getArray()[34];
        dArray60 = matrix.getArray()[35];
        dArray58 = matrix.getArray()[37];
        dArray61 = matrix.getArray()[42];
        dArray62 = matrix.getArray()[40];
        dArray63 = matrix.getArray()[41];
        double[] dArray64 = eigenvalueDecomposition.getRealEigenvalues();
        for (int i = 0; i < 43; ++i) {
            double d13;
            double d14;
            this.cpropf[i] = Math.exp(dArray64[i] * this.dt);
            if (Math.abs(dArray64[i]) < 1.0E-6) {
                d14 = this.dt;
                d13 = this.dt / 2.0;
            } else {
                d14 = (this.cpropf[i] - 1.0) / dArray64[i];
                d13 = (d14 - this.dt) / (dArray64[i] * this.dt);
            }
            String string = "ok here " + i;
            this.scicLS[i] = d14 * dArray59[i];
            this.scicHS[i] = d14 * dArray60[i];
            this.scicAT[i] = d14 * dArray58[i];
            this.scicNP[i] = d14 * dArray61[i];
            this.rcicLS[i] = d13 * dArray59[i];
            this.rcicHS[i] = d13 * dArray60[i];
            this.rcicAT[i] = d13 * dArray58[i];
            this.rcicNP[i] = d13 * dArray61[i];
            this.scicSO[i] = d14 * dArray62[i];
            this.scicHU[i] = d14 * dArray63[i];
            this.rcicSO[i] = d13 * dArray62[i];
            this.rcicHU[i] = d13 * dArray63[i];
        }
        eigenvalueDecomposition = null;
        matrix = null;
        dArray64 = null;
        dArray = null;
    }

    @Override
    public void startstate(int n) {
        int n2;
        this.at = 0.0;
        this.ls = 0.0;
        this.hs = 0.0;
        this.oldls = 0.0;
        this.oldhs = 0.0;
        this.oc = 0.0;
        this.tb = 0.0;
        this.so = 0.0;
        this.hu = 0.0;
        if (n == 1750) {
            for (n2 = 0; n2 < 43; ++n2) {
                this.ciq[n2] = 0.0;
            }
            this.atinc = 0.0;
            this.lsinc = 0.0;
            this.hsinc = 0.0;
            this.npinc = 0.0;
            this.oldtotemit = 0.0;
            this.dls = 0.0;
            this.dhs = 0.0;
            this.dnp = 0.0;
            this.soinc = 0.0;
            this.huinc = 0.0;
            this.dso = 0.0;
            this.dhu = 0.0;
        } else {
            for (n2 = 0; n2 < 43; ++n2) {
                this.ciq[n2] = this.ciq99[n2];
            }
            this.atinc = this.atinc99;
            this.lsinc = this.lsinc99;
            this.hsinc = this.hsinc99;
            this.npinc = this.npinc99;
            this.oldtotemit = this.totemit99;
            this.dls = this.dls99;
            this.dhs = this.dhs99;
            this.dnp = this.dnp99;
            this.soinc = this.soinc99;
            this.huinc = this.huinc99;
            this.dso = this.dso99;
            this.dhu = this.dhu99;
        }
        this.oldatinc = this.atinc;
        this.oldlsinc = this.lsinc;
        this.oldhsinc = this.hsinc;
        this.oldnpinc = this.npinc;
        this.oldsoinc = this.soinc;
        this.oldhuinc = this.huinc;
        for (n2 = 0; n2 < 43; ++n2) {
            this.ciqi[n2] = this.ciq[n2];
        }
        this.tb = 0.0;
        this.oc = 0.0;
        for (n2 = 0; n2 < 43; ++n2) {
            this.tb += this.ciq[n2] * this.crBIO[n2];
            this.oc += this.ciq[n2] * this.crOC[n2];
        }
    }

    float[] addemit(float f) {
        int n;
        this.totemit = f;
        this.gm(carbonatechemistry.class).temperaturefeedback();
        double d = 1.0 - Math.pow(this.respq10.getval(), this.gm(glotemp.class).getlandtemprise() / 10.0);
        for (n = 0; n < this.steps; ++n) {
            int n2;
            for (n2 = 0; n2 < 43; ++n2) {
                this.ciq[n2] = this.cpropf[n2] * this.ciq[n2] + this.scicAT[n2] * this.atinc + this.scicLS[n2] * this.lsinc + this.scicHS[n2] * this.hsinc + this.scicNP[n2] * this.npinc + this.scicSO[n2] * this.soinc + this.scicHU[n2] * this.huinc;
            }
            this.oldls = this.ls;
            this.oldhs = this.hs;
            this.oldso = this.so;
            this.oldhu = this.hu;
            this.nit = 0.0;
            do {
                this.dat = (double)f - this.oldtotemit - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
                this.wit = this.nit == 0.0 ? 1.0 : 0.3;
                this.at = 0.0;
                this.ls = 0.0;
                this.hs = 0.0;
                this.so = 0.0;
                this.hu = 0.0;
                for (n2 = 0; n2 < 43; ++n2) {
                    this.ciqr = this.rcicAT[n2] * this.dat + this.rcicLS[n2] * this.dls + this.rcicHS[n2] * this.dhs + this.rcicNP[n2] * this.dnp + this.rcicSO[n2] * this.dso + this.rcicHU[n2] * this.dhu;
                    this.ciqi[n2] = this.wit * (this.ciq[n2] + this.ciqr) + (1.0 - this.wit) * this.ciqi[n2];
                    this.at += this.crAT[n2] * this.ciqi[n2];
                    this.ls += this.crLS[n2] * this.ciqi[n2];
                    this.hs += this.crHS[n2] * this.ciqi[n2];
                    this.so += this.crSO[n2] * this.ciqi[n2];
                    this.hu += this.crHU[n2] * this.ciqi[n2];
                }
                this.lsinc = -this.gm(carbonatechemistry.class).safnonlin(this.ls, 0);
                this.hsinc = -this.gm(carbonatechemistry.class).safnonlin(this.hs, 1);
                this.betab = this.fbchfut.istrue() && year < 2000 ? this.beta.getdef() : this.beta.getval();
                this.gm(carboncycle.class);
                this.gm(carboncycle.class);
                this.npinc = 60000.0 * this.betab * Math.log(this.at * 4.71E-4 / 278.0 + 1.0) - this.at * this.nplin;
                this.soinc = (this.so * 0.375 + 45000.0) * d;
                this.huinc = (this.hu * 0.01 + 15000.0) * d;
                this.atinc = (double)f - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
                this.guess = this.dls + this.dhs + this.dnp + this.dso + this.dhu;
                this.dls = this.lsinc - this.oldlsinc;
                this.dhs = this.hsinc - this.oldhsinc;
                this.dnp = this.npinc - this.oldnpinc;
                this.dso = this.soinc - this.oldsoinc;
                this.dhu = this.huinc - this.oldhuinc;
                this.check = this.dls + this.dhs + this.dnp + this.dso + this.dhu;
                this.nit += 1.0;
            } while (Math.abs(this.guess - this.check) > 10.0 && this.nit < 10.0);
            for (n2 = 0; n2 < 43; ++n2) {
                this.ciq[n2] = this.ciqi[n2];
            }
            this.oldatinc = this.atinc;
            this.oldlsinc = this.lsinc;
            this.oldhsinc = this.hsinc;
            this.oldnpinc = this.npinc;
            this.oldsoinc = this.soinc;
            this.oldhuinc = this.huinc;
            this.oldtotemit = f;
        }
        this.oldtb = this.tb;
        this.tb = 0.0;
        this.oldoc = this.oc;
        this.oc = 0.0;
        for (n = 0; n < 43; ++n) {
            this.tb += this.ciq[n] * this.crBIO[n];
            this.oc += this.ciq[n] * this.crOC[n];
        }
        this.gm(carboncycle.class);
        this.gm(carboncycle.class);
        this.atppmy = 278.0 + 4.71E-4 * this.at;
        return new float[]{(float)this.atppmy, (float)(this.tb - this.oldtb), (float)(this.oc - this.oldoc)};
    }

    @Override
    public void save99() {
        this.atinc99 = this.atinc;
        this.lsinc99 = this.lsinc;
        this.hsinc99 = this.hsinc;
        this.npinc99 = this.npinc;
        this.soinc99 = this.soinc;
        this.huinc99 = this.huinc;
        this.dso99 = this.dso;
        this.dhu99 = this.dhu;
        this.totemit99 = this.totemit;
        this.dls99 = this.dls;
        this.dhs99 = this.dhs;
        this.dnp99 = this.dnp;
        for (int i = 0; i < 43; ++i) {
            this.ciq99[i] = this.ciq[i];
        }
    }
}

