/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jcm.core.cur.curveset;
import jcm.core.itf.menuFiller;
import jcm.core.loop;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;

public class scaleview
extends JPanel
implements MouseInputListener,
menuFiller {
    param sp;
    float fac = (float)colfont.normalfont.getSize() / 12.0f;
    double origmin;
    double origmax;
    Component aboveleft;
    int lw = 0;
    int w;
    int h;
    boolean isyear = false;
    public double origin;
    public double dp;
    public double oldmax;
    public double oldmin;
    int ep;
    int op;
    boolean dragorigin = false;

    public scaleview() {
    }

    public scaleview(param param2) {
        this.sp = param2;
        param2.units.checkunitfac(param2.max() - param2.min());
        if (param2.units.allowfac) {
            param2.units.checkunitcancel();
        }
        param2.units.units = param2.units.units.replace("per&person", "per&capita");
        this.origmin = param2.min;
        this.origmax = param2.max;
        param.Type cfr_ignored_0 = param2.type;
        this.origin = param2.type == param.Type.Xscale ? 2000.0 : 0.0;
        this.setBackground(Color.white);
        param.Type cfr_ignored_1 = param2.type;
        if (param2.type == param.Type.Xscale && param2.units.units.equals("year")) {
            this.isyear = true;
        }
        param.Type cfr_ignored_2 = param2.type;
        this.setPreferredSize(param2.type == param.Type.Xscale ? new Dimension(0, this.isyear ? (int)(24.0f * this.fac) : (int)(45.0f * this.fac)) : new Dimension((int)(45.0f * this.fac), 0));
        this.setToolTipText(labman.getTitle(param2.getstate()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        param.Type cfr_ignored_3 = param2.type;
        this.setCursor(new Cursor(param2.type == param.Type.Xscale ? 11 : 8));
        new jcmMenu(this);
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        jcmMenu2.add(new jcmAction("Restore Original"){

            @Override
            public void act() {
                scaleview.this.restore();
            }
        });
    }

    public void restore() {
        this.sp.min = this.origmin;
        this.sp.max = this.origmax;
        this.sp.changed = true;
        loop.golater("Scale Restore");
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.getdim();
        lookandfeel.setAntiAlias(graphics);
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            graphics.drawLine(this.lw, 0, this.lw + this.w, 0);
        }
        param.Type cfr_ignored_1 = this.sp.type;
        if (this.sp.type == param.Type.Yscale) {
            graphics.drawLine(this.w - 1, 0, this.w - 1, this.h);
        }
        if (lookandfeel.bigscales.istrue()) {
            graphics.setFont(colfont.normalfont);
        } else {
            graphics.setFont(colfont.smallfont);
        }
        this.drawnums(graphics);
        if (lookandfeel.bigscales.istrue()) {
            graphics.setFont(colfont.bigfont);
        } else {
            graphics.setFont(colfont.normalfont);
        }
        param.Type cfr_ignored_2 = this.sp.type;
        if (this.sp.type == param.Type.Xscale && !this.isyear) {
            graphics.drawString(labman.getTitle(this.sp.units.units), 40, this.h - 4);
        }
        param.Type cfr_ignored_3 = this.sp.type;
        if (this.sp.type == param.Type.Yscale) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate((int)(12.0f * this.fac), 20 + this.h / 2);
            graphics2D.rotate(-1.5707963267948966);
            graphics.drawString(labman.getTitle(this.sp.units.units), -this.h / 3, 0);
        }
        graphics.setFont(colfont.normalfont);
    }

    void drawnums(Graphics graphics) {
        graphics.setColor(Color.black);
        double d = this.sp.units.scales / 5.0;
        double d2 = d * (double)((int)Math.ceil((double)this.sp.min() / d));
        if (this.sp.units.scales != 0.0) {
            for (double d3 = d2; d3 <= (double)this.sp.max(); d3 += d) {
                int n = this.pixel(d3);
                String string = this.sp.units.round(d3);
                int n2 = this.sw(graphics, string);
                param.Type cfr_ignored_0 = this.sp.type;
                if (this.sp.type == param.Type.Xscale) {
                    if (this.w > 8 && Math.abs(Math.abs(d3) - this.sp.units.scales * (double)((int)(0.5 + Math.abs(d3) / this.sp.units.scales))) < (double)0.01f) {
                        graphics.drawLine(n, 0, n, 6);
                        graphics.drawString(string, n - n2 / 2, this.isyear ? this.h - 4 : this.h / 2 - 4);
                    } else {
                        graphics.drawLine(n, 0, n, 3);
                    }
                }
                param.Type cfr_ignored_1 = this.sp.type;
                if (this.sp.type != param.Type.Yscale) continue;
                if (this.w > 8 && Math.abs(Math.abs(d3) - this.sp.units.scales * (double)((int)(0.5 + Math.abs(d3) / this.sp.units.scales))) < (double)0.01f) {
                    graphics.drawLine(this.w - 6, n, this.w, n);
                    graphics.drawString(string, this.w - (n2 + 5), n + 4);
                    continue;
                }
                graphics.drawLine(this.w - 3, n, this.w, n);
            }
        } else {
            report.deb("sp.units.scales=0");
        }
    }

    void getdim() {
        param.Type cfr_ignored_0 = this.sp.type;
        this.lw = this.sp.type == param.Type.Xscale && this.aboveleft != null ? this.aboveleft.getWidth() : 0;
        this.w = this.getWidth() - this.lw;
        this.h = this.getHeight();
    }

    int pixel(double d) {
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            return (int)((double)this.lw + (double)this.w * (d - (double)this.sp.min()) / (double)this.sp.range());
        }
        return this.h - (int)((double)this.h * (d - (double)this.sp.min()) / (double)this.sp.range());
    }

    double real(int n) {
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            return this.sp.min() + (float)(n - this.lw) * this.sp.range() / (float)this.w;
        }
        return this.sp.min() + (float)(this.h - n) * this.sp.range() / (float)this.h;
    }

    public int sw(Graphics graphics, String string) {
        return colfont.sw(graphics, string);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            param.Type cfr_ignored_0 = this.sp.type;
            int n = this.ep = this.sp.type == param.Type.Xscale ? mouseEvent.getX() : mouseEvent.getY();
            if (this.dragorigin) {
                param.Type cfr_ignored_1 = this.sp.type;
                this.dp = (double)((float)(this.ep - this.op) * this.sp.range()) / (double)(this.sp.type == param.Type.Xscale ? -this.w : this.h);
                this.sp.max += this.dp;
                this.sp.min += this.dp;
            } else {
                this.dp = ((double)this.op - (double)this.pixel(this.sp.min)) / ((double)this.ep - (double)this.pixel(this.sp.min));
                if (this.dp < (double)0.8f) {
                    this.dp = 0.8f;
                }
                this.sp.max = this.origin + ((double)this.sp.max() - this.origin) * this.dp;
                this.sp.min = this.origin + ((double)this.sp.min() - this.origin) * this.dp;
            }
            this.op = this.ep;
            this.sp.changed = true;
            loop.gonow(false);
            this.setToolTipText(labman.getTitle(this.sp.getstate()));
            this.sp.units.checkunitfac(this.sp.max() - this.sp.min());
            this.sp.units.checkunitcancel();
            this.repaint();
        }
        catch (Exception exception) {
            report.deb("Mouse Dragging Scale => " + exception);
            this.sp.max = this.oldmax;
            this.sp.min = this.oldmin;
            this.sp.changed = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        param.Type cfr_ignored_0 = this.sp.type;
        this.op = this.sp.type == param.Type.Xscale ? mouseEvent.getX() : mouseEvent.getY();
        boolean bl = this.dragorigin = mouseEvent.getClickCount() > 1;
        if (this.dragorigin) {
            this.origin = this.real(this.op);
        }
        this.oldmax = this.sp.max;
        this.oldmin = this.sp.min;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragorigin = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void changeunits(curveset curveset2) {
        this.sp.units.units = curveset2.units;
        this.sp.units.scales = 1.0;
        this.sp.units.scaleu = 1.0;
        this.sp.units.checkunitfac(this.sp.max() - this.sp.min());
        this.sp.units.checkunitcancel();
        this.repaint();
        curveset2.unitschanged = false;
        System.out.println("units changed!");
    }
}

