/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.gui.plot.colormap;

public class qtsetcolormap
implements colormap {
    curveset qq;
    param year;
    double min;
    double max;
    boolean hasresetscale = true;
    float scalar = 1.0f;

    qtsetcolormap(curveset curveset2) {
        this.qq = curveset2;
        this.year = new param("mapyear", 2000, curveset2.sy, curveset2.ey, "");
    }

    @Override
    public float getValue(region region2) {
        return this.scalar * this.qq.get(region2, (int)this.year.val);
    }

    @Override
    public String getMapInfo(region region2) {
        return "" + (float)((int)this.scalar) * this.qq.get(region2, (int)this.year.val) * 100.0f / 100.0f;
    }

    @Override
    public double getmin() {
        return this.min;
    }

    @Override
    public double getrange() {
        if (this.max - this.min < 10.0) {
            this.scalar = 1000.0f;
            this.resetscale();
        }
        return this.max - this.min;
    }

    @Override
    public void resetscale() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        for (curve curve2 : this.qq.mapwithouttotal().values()) {
            float f = this.scalar * curve2.get((int)this.year.val);
            this.min = Math.min(this.min, (double)f);
            this.max = Math.max(this.max, (double)f);
        }
        this.hasresetscale = true;
    }

    @Override
    public boolean hasresetscale() {
        if (this.hasresetscale) {
            this.hasresetscale = false;
            return true;
        }
        return false;
    }
}

