/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jcm.core.cur.curveset;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.par.param;
import jcm.core.reg.mapprojection;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.showpan;
import jcm.gui.plot.colormap;
import jcm.gui.plot.colorscale;
import jcm.gui.plot.qtsetcolormap;
import jcm.mod.obj.regset;

public class mapplot
extends JPanel {
    public param startlon = new param("mapstartlongitude", "degrees", 349, 0, 360);
    public param projection = mapprojection.getparam();
    public param<region> regions;
    interacob source;
    colormap cm;
    colorscale cols;
    JPanel intpan;
    boolean ownregions = false;

    mapprojection getprojection() {
        return (mapprojection)this.projection.chosen;
    }

    public mapplot(interacob interacob2) {
        this.source = interacob2;
        if (this.source instanceof colormap) {
            this.cm = (colormap)((Object)this.source);
        }
        this.setName(labman.getTitle(this.source.getNameWithWorld() + "&map"));
        if (this.source instanceof param) {
            this.regions = (param)this.source;
        }
        if (this.source instanceof curveset) {
            this.cm = new qtsetcolormap((curveset)this.source);
            this.regions = this.source.getworld().gm(regset.class).regions;
        }
        if (this.regions == null) {
            this.regions = regman.makeregionparam("mapregions", "ALL");
            this.ownregions = true;
        }
        this.setToolTipText(this.getName());
        this.setPreferredSize(new Dimension(400, 300));
        this.setCursor(new Cursor(1));
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.projection.getMenuItem());
        jMenuBar.add(this.regions.getMenuItem());
        this.intpan = new JPanel();
        this.intpan.setLayout(new BorderLayout());
        if (this.cm != null) {
            report.deb("making colorscale from " + this.cm);
            this.cm.resetscale();
            this.cols = new colorscale(this.cm);
            jMenuBar.add(this.cols.reset);
            this.intpan.add((Component)this.cols, "South");
            if (this.cm instanceof qtsetcolormap) {
                jMenuBar.add(((qtsetcolormap)this.cm).year.getComponent(new Object[0]));
            }
        }
        this.add((Component)jMenuBar, "North");
        map map2 = new map();
        this.intpan.add(map2);
        this.add(this.intpan);
        map2.ready = true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        report.deb("map addNotify - will call loop");
        loop.golater("Map Shown");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (showpan.moulist.carrying != this) {
            this.projection.disposeLater();
            this.startlon.disposeLater();
            if (this.ownregions) {
                this.regions.disposeLater();
            }
        }
        loop.golater("Map Removed");
    }

    class map
    extends JPanel
    implements MouseInputListener,
    plotlink,
    menuFiller {
        boolean firsttime = true;
        boolean ready = false;
        boolean inside = false;
        Map<region, Set<Polygon>> plotpoly = new HashMap<region, Set<Polygon>>();
        Map<region, Color> plotcolor = new HashMap<region, Color>();
        int ow = 0;
        int oh = 0;
        double mx;
        double oldmx;
        double my;
        JLabel info = new JLabel();
        region insidereg;

        map() {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.add(this.info);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            new jcmMenu(this);
            register.addlink(this, mapplot.this.regions, mapplot.this.projection, mapplot.this.startlon, mapplot.this.source);
            if (mapplot.this.cm != null) {
                register.addlink(this, mapplot.this.cols.sp);
                report.deb("map linked to sp");
            }
            if (mapplot.this.cm != null && mapplot.this.cm instanceof qtsetcolormap) {
                register.addlink(this, ((qtsetcolormap)mapplot.this.cm).year);
            }
            loop.gonow();
        }

        @Override
        public void doplot() {
            if (this.ready) {
                if (this.firsttime) {
                    mapplot.this.cols.resetAction.act();
                }
                this.makepolys();
                this.repaint();
            }
        }

        @Override
        public boolean isShowing() {
            return !this.ready || super.isShowing();
        }

        void makepolys() {
            boolean bl;
            int n = this.getWidth();
            int n2 = this.getHeight();
            List<region> list = ((region)mapplot.this.regions.chosen).reg;
            boolean bl2 = n != this.ow || n2 != this.oh || mapplot.this.startlon.changed || mapplot.this.projection.changed;
            boolean bl3 = this.firsttime || mapplot.this.regions.changed;
            boolean bl4 = bl = mapplot.this.cm != null && (mapplot.this.cols.sp.changed || bl3 || mapplot.this.source.changed || mapplot.this.cm instanceof qtsetcolormap && ((qtsetcolormap)mapplot.this.cm).year.changed);
            if (bl2) {
                mapplot.this.getprojection().setsize(0, 0, n, n2, (int)mapplot.this.startlon.val);
            }
            this.ow = n;
            this.oh = n2;
            if (bl3) {
                ((region)mapplot.this.regions.chosen).makepolys();
                for (region object : list) {
                    object.makepolys();
                }
                this.plotpoly.clear();
                for (region region2 : list) {
                    this.plotpoly.put(region2, new HashSet());
                }
                this.plotcolor.clear();
            }
            if (bl3 || bl2) {
                Iterator<region> iterator = mapplot.this.getprojection();
                for (region region3 : list) {
                    this.plotpoly.get(region3).clear();
                }
                for (region region3 : list) {
                    for (Polygon polygon : region3.polyset) {
                        this.plotpoly.get(region3).add(((mapprojection)((Object)iterator)).translate(polygon));
                    }
                }
            }
            if (bl) {
                for (region region4 : list) {
                    this.plotcolor.put(region4, mapplot.this.cols.getColor(mapplot.this.cm.getValue(region4)));
                }
            }
            this.firsttime = false;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            lookandfeel.setAntiAlias(graphics);
            this.makepolys();
            region region2 = (region)mapplot.this.regions.chosen;
            for (region region3 : region2.reg) {
                graphics.setColor(mapplot.this.cm != null ? this.plotcolor.get(region3) : region3.getColor());
                for (Polygon polygon : this.plotpoly.get(region3)) {
                    try {
                        graphics.fillPolygon(polygon);
                    }
                    catch (Exception exception) {
                        report.deb(exception, "mapplot problem plotting " + region3.name);
                    }
                }
            }
            for (region region3 : region2.reg) {
                graphics.setColor(mapplot.this.cm != null ? Color.black : region3.getColor().darker());
                for (Polygon polygon : this.plotpoly.get(region3)) {
                    try {
                        graphics.drawPolygon(polygon);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.findpos(mouseEvent);
            if (this.inside) {
                mapplot.this.startlon.val = (int)(((double)((int)mapplot.this.startlon.val) + (this.mx - this.oldmx) + 360.0) % 360.0);
                mapplot.this.startlon.respond(true);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.findpos(mouseEvent);
            if (this.inside) {
                this.writepos();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.findpos(mouseEvent);
            if (this.inside) {
                this.oldmx = this.mx;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void fillMenu(jcmMenu jcmMenu2) {
            jcmMenu2.add(imagesaver.copyaction(mapplot.this.intpan));
            jcmMenu2.add(imagesaver.saveimagemenu(mapplot.this.intpan, "JCM-map"));
            jcmMenu2.add(showpan.pan("Show doc", docview.class, "mapplot"));
        }

        void findpos(MouseEvent mouseEvent) {
            this.findpos(mouseEvent.getX(), mouseEvent.getY());
        }

        void findpos(int n, int n2) {
            Point point = mapplot.this.getprojection().translateback(n, n2);
            this.mx = point.x;
            this.my = point.y;
            this.inside = this.my < 90.0 && this.my > -90.0 && this.mx < 180.0 && this.mx > -180.0;
            this.insidereg = this.findreg(n, n2);
            this.info.setLocation(n + 4, n2 + 4);
        }

        public region findreg(int n, int n2) {
            for (region region2 : ((region)mapplot.this.regions.chosen).reg) {
                if (!region2.contains(mapplot.this.getprojection().translateback(n, n2))) continue;
                return region2;
            }
            return null;
        }

        public void writepos() {
            this.info.setText(this.inside ? this.latlon() + " " + (this.insidereg != null ? this.insidereg.getName() + (mapplot.this.cm != null ? " " + mapplot.this.cm.getMapInfo(this.insidereg) : "") : "") : "");
            this.info.setSize(this.info.getPreferredSize());
        }

        public String latlon() {
            return (int)Math.abs(this.my) + (this.my > 0.0 ? " N" : " S") + " " + (int)Math.abs(this.mx) + (this.mx > 0.0 ? " E" : " W");
        }
    }
}

