/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.plot.arrow;
import jcm.gui.plot.backImage;
import jcm.gui.plot.baseplot;

public class lineplot
extends baseplot {
    boolean stacked = false;
    boolean showarrows = true;
    public int[] labyear = new int[]{1990, 2020};
    Set<arrow> arrows;
    EnumMap<curve.linestyle, BasicStroke> strokes = new EnumMap(curve.linestyle.class);
    public static int thin = 250;

    public lineplot(curveset curveset2) {
        this(new Object[]{curveset2});
    }

    public lineplot(Object[] objectArray) {
        for (Object object : objectArray) {
            if (object.toString().contains("stacked")) {
                this.stacked = true;
            }
            if (object instanceof curveset) {
                this.qq = (curveset)object;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(object.toString())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setup();
        if (this.stacked && !hidelegend) {
            this.legend.stacked = true;
        }
    }

    @Override
    void extrasavesetup(List list) {
        if (this.stacked) {
            list.add("stacked");
        }
    }

    @Override
    void makescales() {
        this.xscale = this.qq.getxscale();
        this.yscale = this.qq.getyscale(this.stacked);
    }

    @Override
    void makeplot() {
        this.plot = new lineplotmainpan();
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        curve.Type cfr_ignored_0 = this.qq.type;
        if (this.qq.type != curve.Type.ratio) {
            curve.Type cfr_ignored_1 = this.qq.type;
            if (this.qq.type != curve.Type.ratefrac) {
                jcmMenu2.add(new jcmAction("Stack Curves", complexity.simplest){

                    @Override
                    public void act() {
                        lineplot.this.changestack();
                    }
                });
                if (this.arrows != null) {
                    jcmMenu2.add(new jcmAction("Remove/Show Arrows", complexity.simplest){

                        @Override
                        public void act() {
                            lineplot.this.changearrows();
                        }
                    });
                }
                jcmMenu2.addSeparator();
            }
        }
        super.fillMenu(jcmMenu2);
    }

    void changestack() {
        boolean bl = this.stacked = !this.stacked;
        if (!hidelegend) {
            this.legend.stacked = this.stacked;
        }
        this.yscale.max = this.qq.getmax(this.stacked);
        this.yscale.units.checkunitfac(this.yscale.max() - this.yscale.min());
        this.ysv.repaint();
        this.doplot();
    }

    void changearrows() {
        this.showarrows = !this.showarrows;
        this.doplot();
    }

    class lineplotmainpan
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        backImage b;
        arrow dragarrow = null;

        public lineplotmainpan() {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.add(lineplot.this.info);
            lineplot.this.info.setOpaque(true);
            this.setOpaque(true);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setCursor(new Cursor(1));
            if (lineplot.this.qq.assocparams != null) {
                lineplot.this.arrows = new HashSet<arrow>(lineplot.this.qq.assocparams.size());
                for (param param2 : lineplot.this.qq.assocparams) {
                    lineplot.this.arrows.add(new arrow(param2, lineplot.this.xscale, lineplot.this.yscale, this));
                }
            }
        }

        @Override
        public void validate() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            Object object;
            super.paintComponent(graphics);
            lookandfeel.setAntiAlias(graphics);
            graphics.setFont(colfont.smallfont);
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            float f = (float)this.getWidth() / lineplot.this.xscale.range();
            float f2 = (float)(-this.getHeight()) / lineplot.this.yscale.range();
            float f3 = f / f2;
            graphics2D.scale(f2, f2);
            graphics2D.translate(-lineplot.this.xscale.min() * f3, -lineplot.this.yscale.max());
            float f4 = Math.abs(lineplot.this.yscale.range() / (float)thin);
            try {
                lineplot.this.strokes.put(curve.linestyle.line, new BasicStroke(Math.abs(lineplot.this.yscale.range()) / (float)thin));
                lineplot.this.strokes.put(curve.linestyle.dotted, new BasicStroke(f4, 1, 1, f4 / 2.0f, new float[]{f4 * 1.0f, f4 * 4.0f}, 0.0f));
                lineplot.this.strokes.put(curve.linestyle.dashed, new BasicStroke(f4, 1, 1, f4 / 2.0f, new float[]{f4 * 4.0f, f4 * 3.0f}, 0.0f));
                lineplot.this.strokes.put(curve.linestyle.dotdash, new BasicStroke(f4, 1, 1, f4 / 2.0f, new float[]{f4 * 1.0f, f4 * 4.0f, f4 * 4.0f, f4 * 3.0f}, 0.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphics2D.setStroke(lineplot.this.strokes.get((Object)curve.linestyle.line));
            if (lineplot.this.stacked) {
                int n3 = (int)lineplot.this.xscale.min();
                int n4 = (int)lineplot.this.xscale.max();
                object = lineplot.this.qq.map.values().iterator().next();
                n2 = (int)Math.max((float)((curve)object).xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                if (n2 < 1) {
                    n2 = 1;
                }
                if (n4 > ((curve)object).ey) {
                    n4 = ((curve)object).ey;
                }
                if (n3 < ((curve)object).sy) {
                    n3 = ((curve)object).sy;
                }
                if (n2 > 1) {
                    n3 += (((curve)object).sy - n3) % n2;
                    n4 += (((curve)object).ey - n4) % n2;
                }
                n = (n4 - n3) / n2;
                float[] fArray = new float[1 + n];
                float[] fArray2 = new float[1 + n];
                GeneralPath generalPath = new GeneralPath();
                GeneralPath generalPath2 = new GeneralPath();
                generalPath.moveTo((float)n3 * f3, 0.0f);
                generalPath2.moveTo((float)n3 * f3, 0.0f);
                generalPath.lineTo((float)lineplot.this.qq.ey * f3, 0.0f);
                generalPath2.lineTo((float)lineplot.this.qq.ey * f3, 0.0f);
                int n5 = n3;
                int n6 = 0;
                while (n5 <= n4) {
                    fArray[n6] = 0.0f;
                    fArray2[n6] = 0.0f;
                    n5 += n2;
                    ++n6;
                }
                n5 = 1;
                n6 = 1;
                for (curve curve2 : lineplot.this.qq.mapwithouttotal().values()) {
                    if (!curve2.checkcomplexity()) continue;
                    try {
                        int n7;
                        n5 = n5 == 0 ? 1 : 0;
                        GeneralPath generalPath3 = generalPath;
                        Object object2 = generalPath2;
                        n6 = 1;
                        int n8 = n5 != 0 ? n3 : n4;
                        int n9 = n7 = n5 != 0 ? 0 : n;
                        while (n5 != 0 ? n8 <= n4 : n8 >= n3) {
                            float f5 = curve2.gotdata(n8) ? curve2.get(n8) : 0.0f;
                            int n10 = n7;
                            fArray[n10] = fArray[n10] + (f5 > 0.0f ? f5 : 0.0f);
                            int n11 = n7;
                            fArray2[n11] = fArray2[n11] + (f5 < 0.0f ? f5 : 0.0f);
                            generalPath3.lineTo((float)n8 * f3, fArray[n7]);
                            ((Path2D.Float)object2).lineTo((float)n8 * f3, fArray2[n7]);
                            if (n6 != 0) {
                                generalPath = new GeneralPath();
                                generalPath2 = new GeneralPath();
                                generalPath.moveTo((float)n8 * f3, fArray[n7]);
                                generalPath2.moveTo((float)n8 * f3, fArray2[n7]);
                                n6 = 0;
                            } else {
                                generalPath.lineTo((float)n8 * f3, fArray[n7]);
                                generalPath2.lineTo((float)n8 * f3, fArray2[n7]);
                            }
                            n8 += n5 != 0 ? n2 : -n2;
                            n7 += n5 != 0 ? 1 : -1;
                        }
                        graphics2D.setColor(curve2.color);
                        graphics2D.fill(generalPath3);
                        graphics2D.fill((Shape)object2);
                    }
                    catch (Exception exception) {
                        report.deb("! lineplot => " + exception + " for curve " + curve2.name);
                    }
                }
            } else {
                for (curve curve3 : lineplot.this.qq.map.values()) {
                    if (!curve3.checkcomplexity()) continue;
                    graphics2D.setStroke(lineplot.this.strokes.get((Object)curve3.style));
                    object = new GeneralPath();
                    n2 = 0;
                    n = (int)Math.max((float)curve3.xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                    if (n < 1) {
                        n = 1;
                    }
                    for (int i = (int)lineplot.this.xscale.min(); i <= (int)lineplot.this.xscale.max(); i += n) {
                        if (!curve3.gotdata(i)) {
                            n2 = 0;
                        }
                        if (curve3.gotdata(i) && n2 == 0) {
                            ((Path2D.Float)object).moveTo((float)i * f3, curve3.get(i));
                            n2 = 1;
                        }
                        if (!curve3.gotdata(i) || n2 == 0) continue;
                        ((Path2D.Float)object).lineTo((float)i * f3, curve3.get(i));
                    }
                    graphics2D.setColor(curve3.color);
                    try {
                        graphics2D.draw((Shape)object);
                    }
                    catch (Throwable throwable) {}
                }
            }
            graphics2D.setTransform(affineTransform);
            if (lineplot.this.labels && !lineplot.this.stacked) {
                for (curve curve4 : lineplot.this.qq.map.values()) {
                    if (!curve4.checkcomplexity()) continue;
                    object = labman.getShort(curve4.name);
                    n2 = colfont.sw(graphics, (String)object);
                    n = colfont.sh(graphics);
                    int n12 = colfont.sd(graphics);
                    graphics2D.setColor(curve4.color);
                    for (int n5 : lineplot.this.labyear) {
                        int n13 = (int)(((float)n5 - lineplot.this.xscale.min()) * (float)this.getWidth() / lineplot.this.xscale.range()) - n2 / 2;
                        int n14 = this.getHeight() - (int)((curve4.get(n5) - lineplot.this.yscale.min()) * (float)this.getHeight() / lineplot.this.yscale.range()) + n / 2 - n12;
                        graphics.drawString((String)object, n13, n14);
                    }
                }
            }
            lineplot.this.ready = true;
            if (lineplot.this.showarrows && lineplot.this.arrows != null) {
                for (arrow arrow2 : lineplot.this.arrows) {
                    if (!arrow2.checkenabled()) continue;
                    try {
                        arrow2.getpos();
                        arrow2.draw(graphics);
                    }
                    catch (Throwable throwable) {
                        report.deb(throwable, "arrow drawing error" + arrow2 + " " + throwable);
                    }
                }
            }
            if (this.dragarrow == null) {
                lineplot.this.info.repaint();
            }
            graphics2D.dispose();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            try {
                if (lineplot.this.showarrows && lineplot.this.arrows != null) {
                    for (arrow arrow2 : lineplot.this.arrows) {
                        if (!arrow2.checkenabled() || !arrow2.poly.contains(mouseEvent.getPoint())) continue;
                        lineplot.this.info.setText(arrow2.getinfo());
                        break;
                    }
                }
                Object object = null;
                float f = lineplot.this.xscale.min() + lineplot.this.xscale.range() * (float)mouseEvent.getX() / (float)this.getWidth();
                float f2 = lineplot.this.yscale.max() - lineplot.this.yscale.range() * (float)mouseEvent.getY() / (float)this.getHeight();
                float f3 = 0.0f;
                int n = (int)((double)f + 0.5);
                if (f > lineplot.this.xscale.min() && f < lineplot.this.xscale.max() && f2 > lineplot.this.yscale.min() && f2 < lineplot.this.yscale.max()) {
                    int n2 = Math.min(mouseEvent.getX() + 4, this.getWidth() - lineplot.this.info.getWidth() - 4);
                    lineplot.this.info.setLocation(n2, mouseEvent.getY() + 4);
                    if (lineplot.this.stacked) {
                        float f4 = 0.0f;
                        for (curve curve2 : lineplot.this.qq.mapwithouttotal().values()) {
                            if (!curve2.checkcomplexity()) continue;
                            f3 = curve2.get(n);
                            if (Math.signum(f2) == Math.signum(f3)) {
                                f4 += f3;
                                object = curve2;
                            }
                            if (!(Math.abs(f4) > Math.abs(f2))) {
                                object = null;
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (curve curve3 : lineplot.this.qq.map.values()) {
                            if (!curve3.checkcomplexity()) continue;
                            float f5 = curve3.get(n);
                            float f6 = Math.abs(f5 - f2);
                            float f7 = object == null ? lineplot.this.yscale.range() / 20.0f : Math.abs(f3 - f2);
                            if (!(f6 < f7)) continue;
                            object = curve3;
                            f3 = f5;
                        }
                    }
                    lineplot.this.info.setText((object == null ? "" : "<html>" + ((infob)object).hashcolor() + labman.getTitle(((curve)object).name) + " </font>") + n + ": " + lineplot.this.yscale.units.round(object == null ? f2 : f3, 2));
                }
                lineplot.this.info.setSize(lineplot.this.info.getPreferredSize());
            }
            catch (Throwable throwable) {
                report.deb(throwable, "lineplot mouse moved error");
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragarrow != null) {
                this.dragarrow.move(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.dragarrow == null && lineplot.this.showarrows && lineplot.this.arrows != null) {
                for (arrow arrow2 : lineplot.this.arrows) {
                    if (!arrow2.poly.contains(mouseEvent.getPoint())) continue;
                    this.dragarrow = arrow2;
                    lineplot.this.info.setSize(0, 0);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragarrow = null;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            lineplot.this.info.setText("");
            lineplot.this.info.setSize(new Dimension(0, 0));
        }
    }
}

