/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.register;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;

public class histoplot
extends baseplot {
    public param year;
    public boolean highonleft = true;
    paramValueChooser yc;
    List regs = new ArrayList();
    curveset qqx;
    curveset qqy;
    curvar qqv;
    Comparator comp = new Comparator(){

        public int compare(Object object, Object object2) {
            return (histoplot.this.highonleft ? -1 : 1) * (histoplot.this.calcratio(object) > histoplot.this.calcratio(object2) ? 1 : (histoplot.this.calcratio(object) < histoplot.this.calcratio(object2) ? -1 : 0));
        }
    };

    public histoplot(curveset curveset2) {
        this(new Object[]{curveset2});
    }

    public histoplot(Object[] objectArray) {
        for (Object object : objectArray) {
            if (object instanceof curvar) {
                this.qqv = (curvar)object;
                this.qq = this.qqv;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(object.toString())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.qqy = this.qqv.linkqq.get(0);
        this.qqx = this.qqv.linkqq.get(1);
        double d = Math.max(this.qqy.sy, this.qqx.sy);
        double d2 = Math.min(this.qqy.ey, this.qqx.ey);
        this.year = new param("year", 2002, d, d2, "year");
        register.addlink(this, this.year);
        this.setup();
        this.sort();
        this.yc = new paramValueChooser(this.year, new Object[0]);
        this.plot.add((Component)this.yc, "North");
    }

    public void hidechooser() {
        this.plot.remove(this.yc);
    }

    @Override
    void makeplot() {
        this.plot = new histo();
    }

    @Override
    public void doplot() {
        this.sort();
        super.repaint();
    }

    @Override
    void makescales() {
        for (Object object : this.qqx.mapwithouttotal().keySet()) {
            this.regs.add(object);
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (Object e : this.regs) {
            f += this.qqx.getOrAddCurve(e).get((int)this.year.val);
            float f3 = this.calcratiotot(e);
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        this.yscale = new param(new Object[]{param.Type.Yscale, "Yscale", this.qqy.units + "&per&" + this.qqx.units, 0, 0, Float.valueOf(f2)});
        this.xscale = new param(new Object[]{param.Type.Xscale, "Xscale", this.qqx.units, 0, 0, Float.valueOf(f)});
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        jcmMenu2.add(makederiv.makeDerivMenu(curve.Type.extra, this.qq));
        jcmMenu2.addSeparator();
        super.fillMenu(jcmMenu2);
    }

    float calcratio(Object object) {
        return this.calcratio(object, this.qqy);
    }

    float calcratio(Object object, curveset curveset2) {
        float f = this.qqx.getOrAddCurve(object).get((int)this.year.val);
        if (f <= 0.0f) {
            return 0.0f;
        }
        return curveset2.getOrAddCurve(object).get((int)this.year.val) / f;
    }

    float calcratiotot(Object object) {
        float f = 0.0f;
        for (curveset curveset2 : this.qqv.linkqq) {
            if (curveset2 == this.qqx) continue;
            f += this.calcratio(object, curveset2);
        }
        return f;
    }

    void sort() {
        Collections.sort(this.regs, this.comp);
    }

    class histo
    extends JPanel
    implements MouseMotionListener {
        public histo() {
            this.addMouseMotionListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            lookandfeel.setAntiAlias(graphics);
            graphics.setFont(colfont.normalfont);
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            float f = -histoplot.this.xscale.min() * (float)n / histoplot.this.xscale.range();
            for (Object e : histoplot.this.regs) {
                if (e instanceof infob) {
                    graphics.setColor(((infob)e).getColor());
                }
                float f2 = histoplot.this.qqx.getOrAddCurve(e).get((int)histoplot.this.year.val) * (float)n / histoplot.this.xscale.range();
                float f3 = n2;
                for (curveset curveset2 : histoplot.this.qqv.linkqq) {
                    if (curveset2 == histoplot.this.qqx) continue;
                    float f4 = (int)(histoplot.this.calcratio(e, curveset2) * (float)n2 / histoplot.this.yscale.max());
                    if (f4 < 0.0f) {
                        graphics.setColor(Color.white);
                        graphics.fillRect((int)f + 1, (int)f3 + 1, (int)f2 - 2, (int)(-f4) - 1);
                    } else {
                        graphics.fillRect((int)f, (int)(f3 - f4) - 1, (int)f2, (int)f4 - 1);
                    }
                    graphics.setColor(histoplot.this.variant(graphics.getColor()));
                    f3 -= f4;
                }
                if (histoplot.this.labels) {
                    if (e instanceof infob) {
                        graphics.setColor(((infob)e).getColor());
                    }
                    String string = labman.getShort(e instanceof infob ? ((infob)e).name : e.toString());
                    graphics.setFont(colfont.smallfont);
                    int n3 = colfont.sw(graphics, string);
                    int n4 = colfont.sh(graphics);
                    int n5 = colfont.sd(graphics);
                    int n6 = (int)(f + f2 / 2.0f - (float)(n3 / 2));
                    int n7 = (int)(f3 - (float)n4 - 4.0f);
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.translate(f + f2 / 2.0f, f3 - 4.0f);
                    graphics2D.rotate(-1.5707963267948966);
                    graphics2D.drawString(string, 0, n4 / 2 - n5);
                    graphics2D.dispose();
                }
                f += f2;
            }
            histoplot.this.ready = true;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            float f = 0.0f;
            for (Object e : histoplot.this.regs) {
                float f2 = histoplot.this.qqx.getOrAddCurve(e).get((int)histoplot.this.year.val) * (float)this.getSize().width / histoplot.this.xscale.max();
                if (f + f2 > (float)mouseEvent.getX() && e instanceof infob) {
                    String string = "<html>" + ((infob)e).hashcolor() + ((infob)e).getName();
                    for (curveset curveset2 : histoplot.this.qqv.linkqq) {
                        if (curveset2 == histoplot.this.qqx) continue;
                        string = string + " " + histoplot.this.calcratio(e, curveset2);
                    }
                    this.setToolTipText(string);
                    return;
                }
                f += f2;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

