/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.plot.jcmTM;

public class datable
extends JScrollPane
implements plotlink {
    jcmTM tm;
    boolean ready = false;

    public datable(final curveset curveset2) {
        this.setName(labman.getTitle(curveset2.getNameWithWorld()));
        this.setToolTipText(this.getName());
        register.addlink(this, curveset2);
        loop.gonow();
        this.tm = new jcmTM(curveset2);
        JTable jTable = new JTable(this.tm);
        jTable.setColumnSelectionAllowed(true);
        this.setcolor(jTable, 0, Color.black);
        int n = 1;
        for (curve curve2 : curveset2.map.values()) {
            this.setcolor(jTable, n, curve2.color);
            ++n;
        }
        jTable.setAutoResizeMode(0);
        this.setViewportView(jTable);
        new jcmMenu(jTable, new menuFiller(){

            @Override
            public void fillMenu(jcmMenu jcmMenu2) {
                jcmMenu2.add(datable.savetablemenu(curveset2));
                jcmMenu2.addSeparator();
                curveset2.fillMenu(jcmMenu2);
            }
        });
        this.ready = true;
    }

    void setcolor(JTable jTable, int n, final Color color) {
        jTable.getColumnModel().getColumn(n).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                this.setForeground(datable.this.darken(color));
                super.setValue(object);
            }
        });
    }

    boolean ispale(Color color) {
        return color.getRed() + color.getGreen() + color.getBlue() > 650;
    }

    Color inverse(Color color) {
        return new Color(390 - color.getRed(), 390 - color.getGreen(), 390 - color.getBlue());
    }

    Color darken(Color color) {
        return color.getRed() + color.getGreen() + color.getBlue() < 650 ? color : new Color(color.getRed() - 100, color.getGreen() - 100, color.getBlue() - 100);
    }

    @Override
    public void doplot() {
        try {
            this.tm.fireTableDataChanged();
            this.repaint();
        }
        catch (Exception exception) {
            report.deb(exception, "table plot problem");
        }
    }

    @Override
    public boolean isShowing() {
        return !this.ready || super.isShowing();
    }

    static jcmMenu savetablemenu(final curveset curveset2) {
        jcmMenu jcmMenu2 = new jcmMenu(new Object[]{"Save table"});
        for (final String string : new String[]{"csv", "tab"}) {
            jcmMenu2.add(new jcmAction(string){

                @Override
                public void act() {
                    fileio fileio2 = new fileio("tables", curveset2.name, string, "Save Table", "save");
                    datable.savetable(fileio2, curveset2, string);
                }
            });
        }
        return jcmMenu2;
    }

    public static void savetable(File file, curveset curveset2, String string) {
        datable.savetable(new fileio(file), curveset2, string);
    }

    static void savetable(fileio fileio2, curveset curveset2, String string) {
        if (fileio2.os != null) {
            try {
                jcmTM jcmTM2 = new jcmTM(curveset2);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileio2.os);
                int n = jcmTM2.getRowCount();
                int n2 = jcmTM2.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    String string2 = "";
                    for (int j = 0; j < n2; ++j) {
                        string2 = string2 + jcmTM2.getValueAt(i, j) + (string == "csv" ? ", " : "\t");
                    }
                    outputStreamWriter.write(string2 + "\n");
                    if (i % 50 != 0) continue;
                    outputStreamWriter.flush();
                }
                outputStreamWriter.flush();
                outputStreamWriter.close();
                report.log("Saved " + fileio2.fullname + " OK");
            }
            catch (IOException iOException) {
                report.deb(iOException, "savetable error");
                iOException.printStackTrace();
            }
        }
    }
}

