/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.event.MouseInputListener;
import jcm.core.ob.interacob;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.plot.colormap;
import jcm.gui.plot.scaleview;
import jcm.mod.regimp.mapdata;

public class colorscale
extends scaleview
implements MouseInputListener {
    colormap cm;
    JButton reset;
    jcmAction resetAction;
    static int r;
    static int g;
    static int b;
    public static Color[] c;

    public colorscale(colormap colormap2) {
        this.cm = colormap2;
        this.cm.resetscale();
        this.sp = new param(new Object[]{param.Type.Xscale, "Xscale", "", 0, this.cm.getmin(), this.cm.getrange() + this.cm.getmin()}){

            @Override
            public void precalc() {
                report.deb("sp precalc");
                if (colorscale.this.cm.hasresetscale()) {
                    colorscale.this.resetcols();
                }
            }
        };
        this.resetAction = new jcmAction("Reset Colors"){

            @Override
            public void act() {
                colorscale.this.cm.resetscale();
                colorscale.this.resetcols();
                colorscale.this.sp.changed = true;
                colorscale.this.sp.respond(true);
            }
        };
        this.reset = new JButton(this.resetAction);
        this.origin = this.cm.getmin() + this.cm.getrange() / 2.0;
        this.setBackground(colfont.white);
        this.setPreferredSize(new Dimension(400, 32));
        this.setToolTipText(labman.getTitle(this.sp.getstate()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(11));
        if (this.cm instanceof interacob) {
            this.sp.setaffectedby((interacob)((Object)this.cm));
        }
    }

    public void resetcols() {
        this.sp.min = this.cm.getmin();
        this.sp.max = this.cm.getrange() + this.cm.getmin();
        this.origin = this.cm.getmin() + this.cm.getrange() / 2.0;
        this.sp.units.checkunitfac(this.sp.range());
        this.repaint();
        report.deb("sp adjusted " + this.sp.min + "-" + this.sp.max);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        lookandfeel.setAntiAlias(graphics);
        this.lw = 20;
        this.w = this.getWidth() - 2 * this.lw;
        this.h = this.getHeight();
        graphics.clearRect(0, 0, this.w + 2 * this.lw, this.h);
        for (int i = 0; i <= this.w; ++i) {
            float f = this.sp.min() + (float)i * this.sp.range() / (float)this.w;
            graphics.setColor(this.getColor(f));
            graphics.drawLine(i + this.lw, 0, i + this.lw, this.h / 2);
        }
        graphics.setFont(colfont.normalfont);
        this.drawnums(graphics);
    }

    public float sptocm(float f) {
        return (float)(this.cm.getmin() + (double)(f - this.sp.min()) * this.cm.getrange() / (double)this.sp.range());
    }

    public Color getColor(float f) {
        return colorscale.getColor(f, this.sp.min(), this.sp.range());
    }

    public static void makerainbow() {
        for (int i = 0; i < 256; ++i) {
            b = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 43) / 256.0));
            g = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 128) / 256.0));
            r = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 213) / 256.0));
            colorscale.c[i] = new Color(r, g, b);
        }
    }

    public static Color getColor(double d, double d2, double d3) {
        if (mapdata.dud((float)d)) {
            return colfont.white;
        }
        int n = (int)(256.0 * (d - (d2 - (double)0.1f * d3)) / (d3 * (double)1.2f) + 4096.0) % 256;
        if (n > 0) {
            return c[n];
        }
        return colfont.white;
    }

    static {
        c = new Color[256];
        colorscale.makerainbow();
    }
}

