/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curveset;
import jcm.core.itf.hasSetupInfo;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.register;
import jcm.gui.doc.labman;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.showpan;
import jcm.gui.plot.backImage;
import jcm.gui.plot.legend;
import jcm.gui.plot.lineplot;
import jcm.gui.plot.scaleview;

public abstract class baseplot
extends JSplitPane
implements plotlink,
menuFiller,
hasSetupInfo {
    JPanel plot;
    public legend legend;
    jcmMenu popup;
    JLabel info = new JLabel();
    public param xscale;
    public param yscale;
    scaleview xsv;
    scaleview ysv;
    curveset qq;
    List<Float> scalesetup = new ArrayList<Float>(5);
    boolean ready = false;
    public boolean labels = false;
    public static boolean hidelegend = false;

    void setup() {
        register.addlink(this, this.qq);
        loop.gonow();
        if (this.qq instanceof curvar) {
            ((curvar)this.qq).refreshregs();
        }
        if (!hidelegend) {
            this.legend = new legend(this.qq, this);
        }
        this.setname();
        this.makescales();
        this.restorescalesetup();
        this.makescaleviews();
        this.makeplot();
        this.setlayout();
        this.setcolor();
        this.setToolTipText(this.getToolTip());
        jcmMenu jcmMenu2 = new jcmMenu(this.plot, this);
        jcmMenu2.addFiller(this.qq);
        register.addlink(this, complexity.defaultcomplexity);
        register.addlink(this, lookandfeel.fontSize);
        register.addlink(this, lookandfeel.bigscales);
        register.addlink(this, lookandfeel.antiAlias);
        this.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        backImage.paint(this.qq, this, graphics, this.getWidth(), this.getHeight());
    }

    void makeplot() {
    }

    @Override
    public void savesetup() {
        List list = register.getargs(this);
        list.clear();
        list.add(this.qq);
        list.add(Float.valueOf(this.xscale.min()));
        list.add(Float.valueOf(this.xscale.max()));
        list.add(Float.valueOf(this.yscale.min()));
        list.add(Float.valueOf(this.yscale.max()));
        list.add(this.plot.getWidth());
        this.extrasavesetup(list);
    }

    void extrasavesetup(List list) {
    }

    void restorescalesetup() {
        if (this.scalesetup.size() > 3) {
            this.xscale.min = this.scalesetup.get(0).floatValue();
            this.xscale.max = this.scalesetup.get(1).floatValue();
            this.yscale.min = this.scalesetup.get(2).floatValue();
            this.yscale.max = this.scalesetup.get(3).floatValue();
        }
    }

    String getlabcode() {
        String string = this instanceof lineplot ? "" : this.getClass().getSimpleName() + "&";
        string = string + this.qq.getNameWithWorld();
        return string;
    }

    String getToolTip() {
        return labman.getTitle(this.getlabcode());
    }

    void setname() {
        this.setName(labman.getShort(this.getlabcode()));
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        jcmMenu2.add(imagesaver.copyaction(this));
        jcmMenu2.add(imagesaver.saveimagemenu(this, this.qq.name));
        jcmMenu2.add(new jcmAction("Labels", complexity.normal){

            @Override
            public void act() {
                baseplot.this.labels = !baseplot.this.labels;
                baseplot.this.doplot();
            }
        });
        jcmMenu2.addSeparator();
    }

    abstract void makescales();

    void makescaleviews() {
        this.ysv = new scaleview(this.yscale);
        this.xsv = new scaleview(this.xscale);
        register.addlink(this, this.xscale, this.yscale);
    }

    @Override
    public void doplot() {
        if (this.ready) {
            this.plot.repaint();
        }
        if (this.ready && this.qq.unitschanged) {
            this.ysv.changeunits(this.qq);
        }
        if (this.ready && loop.changeTreeStruc && !hidelegend) {
            this.legend.makelabs(true);
        }
        if (this.ready && loop.changeTreeStruc) {
            this.savesetup();
        }
    }

    @Override
    public boolean isShowing() {
        return !this.ready || super.isShowing();
    }

    void setlayout() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.ysv.setMinimumSize(new Dimension(40, 0));
        this.xsv.setMinimumSize(new Dimension(0, 20));
        this.xsv.aboveleft = this.ysv;
        this.plot.setMinimumSize(new Dimension(60, 60));
        this.plot.setPreferredSize(new Dimension(400, 400));
        jPanel.add((Component)this.ysv, "West");
        jPanel.add((Component)this.plot, "Center");
        jPanel.add((Component)this.xsv, "South");
        this.setOrientation(1);
        this.setLeftComponent(jPanel);
        if (!hidelegend) {
            this.setRightComponent(this.legend);
            this.setBorder(null);
            this.legend.setBorder(null);
            jPanel.setBorder(null);
            this.setResizeWeight(0.85);
            this.setDividerSize(4);
        }
        if (hidelegend) {
            this.setRightComponent(null);
            this.setBorder(null);
            jPanel.setBorder(null);
            this.setResizeWeight(1.0);
            this.setDividerSize(0);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (showpan.moulist.carrying != this) {
            this.xscale.disposeLater();
            this.yscale.disposeLater();
        }
        loop.golater("Plot Removed");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        loop.golater("Plot Shown");
    }

    void setcolor() {
        Color color = Color.white;
        if (this.qq.owner instanceof module) {
            color = this.brighter(((module)this.qq.owner).world.color);
        }
        this.setBackground(color);
        this.info.setBackground(color);
        this.plot.setBackground(color);
        this.ysv.setBackground(color);
        this.xsv.setBackground(color);
        if (!hidelegend) {
            this.legend.setBackground(color);
        }
        this.setOpaque(true);
        this.plot.setOpaque(true);
        this.ysv.setOpaque(true);
        this.xsv.setOpaque(true);
        if (!hidelegend) {
            this.legend.setOpaque(true);
        }
    }

    Color brighter(Color color) {
        if (color.equals(Color.black)) {
            return Color.white;
        }
        return new Color(255 - (255 - color.getRed()) / 8, 255 - (255 - color.getGreen()) / 8, 255 - (255 - color.getBlue()) / 8);
    }

    Color variant(Color color) {
        return new Color(this.vary(color.getRed()), this.vary(color.getGreen()), this.vary(color.getBlue()));
    }

    int vary(int n) {
        if (n < 127) {
            return (int)((double)n * 1.5);
        }
        return (int)((double)n * 0.67);
    }
}

