/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.nav.showpan;

public class backImage {
    public static Map<String, String> alias = new HashMap<String, String>();
    public static Map<String, SoftReference<BufferedImage>> orig = new HashMap<String, SoftReference<BufferedImage>>();
    public static Map<Object, SoftReference<BufferedImage>> conv = new WeakHashMap<Object, SoftReference<BufferedImage>>();
    public static Map<JComponent, Boolean> origopaque = new WeakHashMap<JComponent, Boolean>();
    public static param usebackim = new param(new Object[]{"BackImage", false}){

        @Override
        public void respond() {
            SwingUtilities.updateComponentTreeUI(showpan.mf);
            showpan.mf.repaint();
        }
    };

    public static BufferedImage getImage(Object object, int n, int n2) {
        BufferedImage bufferedImage = null;
        if (conv.containsKey(object)) {
            bufferedImage = conv.get(object).get();
        }
        if (bufferedImage != null) {
            return bufferedImage;
        }
        if (bufferedImage == null || bufferedImage.getWidth() != n || bufferedImage.getHeight() != n2) {
            String string = backImage.getFileName(object);
            if (string == null) {
                return null;
            }
            BufferedImage bufferedImage2 = null;
            if (orig.containsKey(string)) {
                bufferedImage2 = orig.get(string).get();
            }
            if (bufferedImage2 == null && (bufferedImage2 = backImage.loadImage(string)) != null) {
                orig.put(string, new SoftReference<BufferedImage>(bufferedImage2));
            }
            if (bufferedImage2 != null) {
                bufferedImage = backImage.convert(bufferedImage2, n, n2);
                conv.put(object, new SoftReference<BufferedImage>(bufferedImage));
                return bufferedImage;
            }
        }
        return null;
    }

    public static String getFileName(Object object) {
        if (object instanceof String) {
            return alias.get(object.toString());
        }
        if (object instanceof infob) {
            infob infob2 = (infob)object;
            if (alias.containsKey(infob2.name)) {
                return alias.get(infob2.name);
            }
            if (infob2.owner != infob2) {
                return backImage.getFileName(infob2.owner);
            }
        }
        return null;
    }

    public static BufferedImage loadImage(String string) {
        try {
            URL uRL = fileio.getURL("backpic/" + string);
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            report.deb("can't get background for " + string);
            return null;
        }
    }

    public static BufferedImage convert(BufferedImage bufferedImage, int n, int n2) {
        float f = bufferedImage.getWidth();
        float f2 = bufferedImage.getHeight();
        float f3 = Math.min(f / (float)n, f2 / (float)n2);
        int n3 = (int)(f3 * (float)n);
        int n4 = (int)(f3 * (float)n2);
        int n5 = (int)(f - (float)n3) / 2;
        int n6 = (int)(f2 - (float)n4) / 2;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.33f));
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, n5, n6, n5 + n3, n6 + n4, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static void setOpaque(JComponent jComponent, boolean bl) {
        if (bl && origopaque.containsKey(jComponent)) {
            jComponent.setOpaque(origopaque.get(jComponent));
        } else {
            origopaque.put(jComponent, jComponent.isOpaque());
            jComponent.setOpaque(false);
        }
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            backImage.setOpaque((JComponent)component, bl);
        }
    }

    public static void paint(Object object, JComponent jComponent, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage;
        backImage.setOpaque(jComponent, usebackim.isfalse());
        if (usebackim.istrue() && (bufferedImage = backImage.getImage(object, n, n2)) != null) {
            try {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
            catch (Exception exception) {
                report.deb(exception, "backimage");
            }
        }
    }

    static {
        try {
            String[][] stringArray;
            String[][] stringArray2 = stringArray = fileio.loadtab("backpic/backpics.txt", ",");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray3;
                for (String string : stringArray3 = stringArray2[i]) {
                    alias.put(string, stringArray3[0]);
                }
            }
        }
        catch (Exception exception) {
            report.deb("Problem loading backpics.txt");
        }
    }
}

